
//
// (c) 2006-2009 devolo AG, Aachen (Germany)
//

#ifndef _DLAN_DLANDEVICE_H_
#define _DLAN_DLANDEVICE_H_

#include <list>
#include <string>
#include "macaddress.h"

class CDlanDevice
{
public:

  enum teType { eHP1, eTurbo, eThunderbolt };

  CDlanDevice(const CMACAddress& addr, teType type, const std::string& ver, const std::string& mft) :
    m_addr(addr), 
    m_eType(type), 
    m_strVersion(ver), 
    m_strMftString(mft) {}

  CDlanDevice(const CDlanDevice& o) :
    m_addr(o.m_addr), 
    m_eType(o.m_eType), 
    m_strVersion(o.m_strVersion), 
    m_strMftString(o.m_strMftString) {}

  CDlanDevice& operator=(const CDlanDevice& rhs)
  { 
    m_addr = rhs.m_addr; 
    m_eType = rhs.m_eType; 
    m_strVersion = rhs.m_strVersion; 
    m_strMftString = rhs.m_strMftString; 
    return *this; 
  }

  bool operator==(const CDlanDevice& rhs) const 
  { 
    return
      (m_addr == rhs.m_addr) && 
      (m_eType == rhs.m_eType) &&
      (m_strVersion == rhs.m_strVersion) &&
      (m_strMftString == rhs.m_strMftString);
  }

  bool operator!=(const CDlanDevice& rhs) const { return !operator==(rhs); }

  const CMACAddress& GetAddress() const { return m_addr; }
  teType GetType() const { return m_eType; }
  const std::string& GetVersion() const { return m_strVersion; }
  const std::string& GetManufacturingString() const { return m_strMftString; }

private:

  CMACAddress m_addr;
  teType m_eType;
  std::string m_strVersion;
  std::string m_strMftString;
};


class CDlanRemoteDevice : public CDlanDevice
{
public:

  CDlanRemoteDevice(const CMACAddress& addr, teType type, const std::string& ver, const std::string& mft, double tx, double rx) :
    CDlanDevice(addr, type, ver, mft), 
    m_fTxRate(tx), 
    m_fRxRate(rx) {}

  CDlanRemoteDevice(const CDlanRemoteDevice& o) :
    CDlanDevice(o), 
    m_fTxRate(o.m_fTxRate), 
    m_fRxRate(o.m_fRxRate) {}

  CDlanRemoteDevice& operator=(const CDlanRemoteDevice& rhs) 
  { 
    CDlanDevice::operator=(rhs); 
    m_fTxRate = rhs.m_fTxRate; 
    m_fRxRate = rhs.m_fRxRate; 
    return *this;
  }

  bool operator==(const CDlanRemoteDevice& rhs) const 
  {
    return 
      CDlanDevice::operator==(rhs) && 
      (m_fTxRate == rhs.m_fTxRate) && 
      (m_fRxRate == rhs.m_fRxRate); 
  }

  bool operator!=(const CDlanRemoteDevice& rhs) const { return !operator==(rhs); }

  double GetTxRate() const { return m_fTxRate; }
  double GetRxRate() const { return m_fRxRate; }

private:

  double m_fTxRate;
  double m_fRxRate;
};


typedef std::list<CDlanRemoteDevice> CDlanRemoteDeviceList;


class CDlanLocalDevice : public CDlanDevice
{
public:

  CDlanLocalDevice(const CMACAddress& nic, const CMACAddress& addr, teType type, const std::string& ver, const std::string& mft, 
    const CMACAddress& cco, const CDlanRemoteDeviceList& remotes = CDlanRemoteDeviceList()) :
    CDlanDevice(addr, type, ver, mft),
    m_addrNIC(nic),
    m_addrCCo(cco),
    m_remoteDeviceList(remotes) {}

  CDlanLocalDevice(
    const CDlanLocalDevice& o) :
    CDlanDevice(o),
    m_addrNIC(o.m_addrNIC),
    m_addrCCo(o.m_addrCCo),
    m_remoteDeviceList(o.m_remoteDeviceList) {}

  CDlanLocalDevice& operator=(const CDlanLocalDevice& rhs) 
  { 
    CDlanDevice::operator=(rhs); 
    m_addrNIC = rhs.m_addrNIC; 
    m_addrCCo = rhs.m_addrCCo; 
    m_remoteDeviceList = rhs.m_remoteDeviceList; 
    return *this; 
  }

  bool operator==(const CDlanLocalDevice& rhs) const 
  { 
    return 
      CDlanDevice::operator==(rhs) && 
      (m_addrNIC == rhs.m_addrNIC) && 
      (m_addrCCo == rhs.m_addrCCo) && 
      (m_remoteDeviceList == rhs.m_remoteDeviceList);
  }

  bool operator!=(const CDlanLocalDevice& rhs) const { return !operator==(rhs); }

  bool UpdateRemoteDevice(const CDlanRemoteDevice& remoteDevice);
  bool RemoveRemoteDevice(const CMACAddress& remoteDeviceAddr);

  const CMACAddress& GetNICAddress() const { return m_addrNIC; }
  const CMACAddress& GetCCoAddress() const { return m_addrCCo; }
  const CDlanRemoteDeviceList& GetRemoteDevices() const { return m_remoteDeviceList; }

private:

  CMACAddress m_addrNIC, m_addrCCo;
  CDlanRemoteDeviceList m_remoteDeviceList;
};


typedef std::list<CDlanLocalDevice> CDlanLocalDeviceList;


#endif
