
//
// (c) 2006-2009 devolo AG, Aachen (Germany)
//

#ifndef _DLAN_DLANMONITOR_H_
#define _DLAN_DLANMONITOR_H_

#include <climits>
#include <map>
#include <queue>
#include <set>
#include "dlandevice.h"
#include "hpmmes.h"
#include "packetdispatcher.h"
#include "packetinterface.h"
#include "packettask.h"

class IDlanMonitorObserver
{
public:
  virtual void OnUpdate() = 0;
};

struct CDlanAgingTimes
{
  int LocalVanishedAge;
  int RemoteRefreshAge;
  int RemoteVanishedAge;
};

const CDlanAgingTimes dlanDefaultAging = { 60, 60, 120 };

class CDlanMonitor : public IPacketTask, 
  private HomePlugMMEs::CDispatcher, private HomePlugAvMMEs::CDispatcher
{
public:

  enum Mode
  {
    eMonitorLocalHP1 = 0x01,
    eMonitorHP1 = eMonitorLocalHP1 | 0x02,
    eMonitorLocalTurbo = 0x04,
    eMonitorTurbo = eMonitorLocalTurbo | 0x08,
    eMonitorLocalThunderbolt = 0x10,
    eMonitorThunderbolt = eMonitorLocalThunderbolt | 0x20,
    eMonitorAll = eMonitorHP1 | eMonitorTurbo | eMonitorThunderbolt
  };

  CDlanMonitor(IPacketInterface& ifc, Mode mode = eMonitorAll, const CDlanAgingTimes &aging = dlanDefaultAging) :
    m_ulTick(0), m_eMode(mode), m_ifc(ifc), m_pObserver(0), m_agingTimes(aging) { InitReceiver(); }
  CDlanMonitor(IPacketInterface& ifc, IDlanMonitorObserver& obs, Mode mode = eMonitorAll, const CDlanAgingTimes &aging = dlanDefaultAging) :
    m_ulTick(0), m_eMode(mode), m_ifc(ifc), m_pObserver(&obs), m_agingTimes(aging) { InitReceiver(); }
  virtual ~CDlanMonitor();

  virtual IPacketReceiver& GetReceiver() { return m_receiver; }
  virtual unsigned long Drumbeat();
  virtual bool Complete() { return false; }
  virtual bool Successful() { return false; }
  const CDlanLocalDeviceList& GetLocalDevices() const { return m_listLocalDevices; }
  void RemoveFromDeviceLists(const CMACAddress& addrDevice);
  void RemoveFromDeviceLists(const std::set<CMACAddress>& setDevices);

private:

  enum
  {
    eTickInterval = 250,
    eDelayedSendingInterval = 20
  };

  struct LocalDevice
  {
    LocalDevice(CDlanLocalDeviceList::iterator it) : iAge(0), itPublicDevice(it) {}
    int iAge;
    CDlanLocalDeviceList::iterator itPublicDevice;
    std::map<CMACAddress,int> mapRemoteDeviceAges, mapMftStrAges;
  };

  struct NetworkInfoResponse
  { 
    NetworkInfoResponse() {}
    NetworkInfoResponse(const CMACAddress& c, const std::list<HomePlugAvMMEs::ThunderNetworkInfo::StationInfo>& s) : ccoAddr(c), stations(s) {}
    CMACAddress ccoAddr;
    std::list<HomePlugAvMMEs::ThunderNetworkInfo::StationInfo> stations;
  };

  struct NetwAdapter
  {
    NetwAdapter() : iTick(0), iFastBroadcastCnt(5) {}
    int iTick, iFastBroadcastCnt;
    std::set<CMACAddress> setParamsAndStatsResponses;
    std::set<CMACAddress> setRemoteTurboResponses;
    std::set<CMACAddress> setDevicesToTrigger;
    std::map<CMACAddress,std::string> mapGetVersionResponses;
    std::map<CMACAddress,std::string> mapGetMftStrResponses;
    std::map<CMACAddress,NetworkInfoResponse> mapNetworkInfoResponses;
    std::map<CMACAddress,LocalDevice> mapLocalDevices;
    std::queue<IPacket*> queuePendingPackets;
  };

  unsigned long m_ulTick;
  Mode m_eMode;
  IPacketInterface& m_ifc;
  IDlanMonitorObserver* m_pObserver;
  CPacketReceiverAndDispatcher m_receiver;
  CDlanLocalDeviceList m_listLocalDevices;
  std::map<CMACAddress,NetwAdapter> m_mapNICs;
  CDlanAgingTimes m_agingTimes;

  void OnUpdate() { if(m_pObserver) m_pObserver->OnUpdate(); }
  void InitReceiver();
  void UpdateAdapters(bool&, const std::set<CMACAddress>& = std::set<CMACAddress>());
  void RemoveDevices(bool&, bool, const std::set<CMACAddress>& = std::set<CMACAddress>());
  void TickAdapters();
  void SendQueuedPackets(bool&);
  void SendLocalDeviceBroadcasts(std::map<CMACAddress,NetwAdapter>::iterator);
  void SendRemoteDeviceBroadcasts(std::map<CMACAddress,NetwAdapter>::iterator);
  void TriggerUnknownDevices(std::map<CMACAddress,NetwAdapter>::iterator);
  void ClearUnknownDevices(std::map<CMACAddress,NetwAdapter>::iterator);
  LocalDevice& UpdateLocalDevice(std::map<CMACAddress,NetwAdapter>::iterator, const CMACAddress&, bool,
    CDlanDevice::teType, bool, const std::string&, bool, const std::string&, bool, const CMACAddress&, bool, bool&);
  void UpdateRemoteDevice(LocalDevice&, const CMACAddress&, bool,
    CDlanDevice::teType, bool, const std::string&, bool, const std::string&, bool, double, double, bool, bool&);

  virtual void OnParamsAndStatsResponse(const CMACAddress&, const HomePlugMMEs::ParamsAndStats::CResponse&);
  virtual void OnInt51NetStatResponse(const CMACAddress&, const HomePlugMMEs::Int51NetStat::CResponse&);
  virtual void OnTurboDeviceDescriptionResponse(const CMACAddress&, const HomePlugMMEs::TurboDeviceDescription::CResponse&);
  virtual void OnTurboChannelCapacitiesResponse(const CMACAddress&, const HomePlugMMEs::TurboChannelCapacities::CResponse&);

  virtual void OnThunderGetVersionConfirm(const CMACAddress&, const HomePlugAvMMEs::ThunderGetVersion::CConfirm&);
  virtual void OnThunderNetworkInfoConfirm(const CMACAddress&, const HomePlugAvMMEs::ThunderNetworkInfo::CConfirm&);
  virtual void OnThunderGetManufacturingStringConfirm(const CMACAddress&, const HomePlugAvMMEs::ThunderGetManufacturingString::CConfirm&);
};

#endif // _DLAN_DLANMONITOR_H_
