﻿var m_strSearchText;
var m_strApiKey;
var m_strSecret;
var m_strFrob;
var m_strToken;
var m_strSkinPath;
var m_nPhotosPrePage = 50;

var m_nPhotoSetsPrePage = 12;
var m_nPhotoSetsInHeight = 3;
var m_nPhotoSetsInWidth = 4;


var m_nCurrentPageIndex = 1;
var m_nTotalPageNum = 1;

var m_strSortOption = "relevance";

var m_nAvoidDownloadLicensesID =[6];

var m_nLicenseName = new Array(10);
var m_nLicenseID = new Array(10);
var m_nLicenseURL = new Array(10);

var m_nDownloadSize = 5;
var m_nDownloadSizeName = "Original";

var m_strToolTipsFileName = "File name";
var m_strToolTipsFileUserName = "User name";
var m_strToolTipsFileDescription = "Description";

var m_strNonce = "";
var m_nNonceTime = 1;

var m_strOAuth1Token = "";
var m_strOAuth1Secret = "";
var m_strOAuthVerifier = "";
var m_strIsLogin = "";
var m_strSign = "1";

function setSign(strSign)
{
    m_strSign = strSign;
}

function setIsLogin(strIsLogin)
{
    m_strIsLogin = strIsLogin;
}

function setOAuth1Token(strOAuth1Token)
{
    m_strOAuth1Token = strOAuth1Token;
}

function setOAuth1Secret(strOAuth1Secret)
{
    m_strOAuth1Secret = strOAuth1Secret;
}

function setOAuthVerifier(strOAuthVerifier)
{
    m_strOAuthVerifier = strOAuthVerifier;
}

function getSignature(sSecretKey, sParameter)
{ 
   sParameter = sParameter.replace('?','');
   var aParameter = sParameter.split('&');
   aParameter.sort();
   var sSignature = sSecretKey;
   for(var i=0,j=aParameter.length;i<j;i++)
   { 
       var sName = aParameter[i].split('=')[0];
       var sValue = aParameter[i].split('=')[1];
       sSignature += sName + sValue;
   };
   return MD5(sSignature);
}; 

function setToolTipsFileName(strToolTipsFileName)
{
	m_strToolTipsFileName = strToolTipsFileName;
}

function setToolTipsFileUserName(strToolTipsFileUserName)
{
	m_strToolTipsFileUserName = strToolTipsFileUserName;
}

function setToolTipsFileDescription(strToolTipsFileDescription)
{
	m_strToolTipsFileDescription = strToolTipsFileDescription;
}

function SetSortMethod(nIndex)
{
	if(nIndex == 0)
		m_strSortOption = "relevance";
	if(nIndex == 1)
		m_strSortOption = "date-posted-asc";
	if(nIndex == 2)
		m_strSortOption = "interestingness-asc";
}

function SetDownloadSize(nSize)
{
	m_nDownloadSize = nSize;
	if(m_nDownloadSize==0)
		m_nDownloadSizeName = "Square";
	if(m_nDownloadSize==1)
		m_nDownloadSizeName = "Thumbnail";
	if(m_nDownloadSize==2)
		m_nDownloadSizeName = "Small";
	if(m_nDownloadSize==3)
		m_nDownloadSizeName = "Medium";
	if(m_nDownloadSize==4)
		m_nDownloadSizeName = "Large";
	if(m_nDownloadSize==5)
		m_nDownloadSizeName = "Original";
}

function utf8(wide) {
  var c, s;
  var enc = "";
  var i = 0;
  while(i<wide.length) {
    c= wide.charCodeAt(i++);
    // handle UTF-16 surrogates
    if (c>=0xDC00 && c<0xE000) continue;
    if (c>=0xD800 && c<0xDC00) {
      if (i>=wide.length) continue;
      s= wide.charCodeAt(i++);
      if (s<0xDC00 || c>=0xDE00) continue;
      c= ((c-0xD800)<<10)+(s-0xDC00)+0x10000;
    }
    // output value
    if (c<0x80) enc += String.fromCharCode(c);
    else if (c<0x800) enc += String.fromCharCode(0xC0+(c>>6),0x80+(c&0x3F));
    else if (c<0x10000) enc += String.fromCharCode(0xE0+(c>>12),0x80+(c>>6&0x3F),0x80+(c&0x3F));
    else enc += String.fromCharCode(0xF0+(c>>18),0x80+(c>>12&0x3F),0x80+(c>>6&0x3F),0x80+(c&0x3F));
  }
  return enc;
}

var hexchars = "0123456789ABCDEF";

function toHex(n) {
  return hexchars.charAt(n>>4)+hexchars.charAt(n & 0xF);
}

var okURIchars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-";

function encodeURIComponentNew(s) {
  var s = utf8(s);
  var c;
  var enc = "";
  for (var i= 0; i<s.length; i++) {
    if (okURIchars.indexOf(s.charAt(i))==-1)
      enc += "%"+toHex(s.charCodeAt(i));
    else
      enc += s.charAt(i);
  }
  return enc;
}

function URLEncode(fld)
{
 if (fld == "") return false;
 var encodedField = "";
 var s = fld;
 if (typeof encodeURIComponent == "function")
 {
  // Use javascript built-in function
  // IE 5.5+ and Netscape 6+ and Mozilla
  encodedField = encodeURIComponent(s);
 }
 else 
 {
  // Need to mimic the javascript version
  // Netscape 4 and IE 4 and IE 5.0
  encodedField = encodeURIComponentNew(s);
 }
 
 return encodedField;
}

function SetAPIKey(strApiKey)
{
	m_strApiKey = strApiKey;
}

function SetSkinPath(strSKinPath)
{
	m_strSkinPath = strSKinPath;
}

function SetSecret(strSecret)
{
	m_strSecret = strSecret;
}

function SetFrob(strFrob)
{
	m_strFrob= strFrob;
}

function SetToken(strToken)
{
	m_strToken= strToken;
}

function Search(strText,npage) 
{
    //Use API: flickr.photos.search
    //http://www.flickr.com/services/api/flickr.photos.search.html
    //This method does not require authentication.

	m_nCurrentPageIndex = npage;
	updateTableWH();
	var strTextEncoded = URLEncode(strText);
	m_strSearchText = strText;
	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			// Get the data from the server's response
			//document.getElementById("txtHint").innerHTML=xmlHttp.responseText;				
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "extras=license,owner_name" +
	    "&format=json" + 
	    "&license=1,2,4,5" +
	    "&method=flickr.photos.search" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0"+
	    "&page=" + npage +
	    "&per_page="+m_nPhotosPrePage +
	    "&sort=" + m_strSortOption +
	    "&text=" + strTextEncoded;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?extras=license,owner_name" +
	    "&format=json" +
	    "&license=1,2,4,5" +	    
	    "&method=flickr.photos.search" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&page=" + npage +	    
	    "&per_page="+m_nPhotosPrePage +
    	    "&sort=" + m_strSortOption +
	    "&text=" + strTextEncoded;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest"+
		"?api_key=" + m_strApiKey +
		"&extras=license,owner_name" +
		"&format=json" +
		"&license=1,2,4,5" +
		"&method=flickr.photos.search" +
		"&page=" + npage +	    
		"&per_page="+m_nPhotosPrePage +
    		"&sort=" + m_strSortOption +
		"&text=" + strTextEncoded;
	}
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function GetLicenseInfo()
{
    //Use API:flickr.photos.licenses.getInfo
    //http://www.flickr.com/services/api/flickr.photos.licenses.getInfo.html
    //This method does not require authentication.

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 
	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.photos.licenses.getInfo" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0";
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.photos.licenses.getInfo" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign;

	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest"+
		"?api_key=" + m_strApiKey +
		"&format=json" +
		"&method=flickr.photos.licenses.getInfo";
	}

	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
	
}

function GetUserProfile()
{
    //Use API:flickr.urls.getUserProfile
    //http://www.flickr.com/services/api/flickr.urls.getUserProfile.html
    //This method does not require authentication.
    //But PDR will only call this function when user login flickr, so it always goes with OAuth.
    
	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.urls.getUserProfile" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0";
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.urls.getUserProfile" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign;

	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}
	
function GetPhotoSetList(user_id)
{
    //Use API:flickr.photosets.getList
    //http://www.flickr.com/services/api/flickr.photosets.getList.html
    //This method does not require authentication.
    //But PDR will only call this function when user login flickr, so it always goes with OAuth.

    if (m_bGetNotInSetInfo) 
        {
            GetNotInSets(1);
            return;
        }

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.photosets.getList" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0";
	if(user_id)
	    strBaseParameter = strBaseParameter + "&user_id=" + user_id;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.photosets.getList" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign;
	if(user_id)
	    strSrc = strSrc + "&user_id=" + user_id;	
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);	
}

function GetHotTagList(option)
{
    //Use API:flickr.tags.getHotList
    //http://www.flickr.com/services/api/flickr.tags.getHotList.html
    //This method does not require authentication.

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 
	
	var strPeriod = "period";
	var strPeriodOption;
	if(option==0)
	{
		strPeriod+="day"
		strPeriodOption = "day";
	}
	if(option==1)
	{
		strPeriod+="week"
		strPeriodOption = "week";
	}
		
	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "count=100" +
	    "&format=json" + 
	    "&method=flickr.tags.getHotList" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&period=" + strPeriodOption;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?count=100" +
	    "&format=json" +
	    "&method=flickr.tags.getHotList" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&period=" + strPeriodOption;

	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest"+
		"?api_key=" + m_strApiKey +
		"&count=100" +
		"&format=json" +
		"&method=flickr.tags.getHotList" +
		"&period=" + strPeriodOption;
	}

	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
	
}
	
function FlickrLogin()
{
    //Follow this
    //http://www.flickr.com/services/api/auth.oauth.html

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
		    var strNav;
		    var ref = "Oauth1:"+xmlHttp.responseText;
		    location = ref;
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("http://www.flickr.com/services/oauth/request_token");
	var strBaseParameter = 
	    "oauth_callback=http%3A%2F%2Fwww.flickr.com" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_version=1.0";
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;

	var strKey = m_strSecret + "&";
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);


	var strSrc = "http://www.flickr.com/services/oauth/request_token" +
	    "?oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_callback=http%3A%2F%2Fwww.flickr.com" +
	    "&oauth_signature=" + strSign;
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function ExchangeToken()
{
    //Follow this
    //http://www.flickr.com/services/api/auth.oauth.html

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
		    var strNav;
		    var ref = "Oauth3:"+xmlHttp.responseText;
		    location = ref;
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("http://www.flickr.com/services/oauth/access_token");
	var strBaseParameter = 
	    "oauth_callback=http%3A%2F%2Fwww.flickr.com" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token + 	    
	    "&oauth_verifier=" + m_strOAuthVerifier +
	    "&oauth_version=1.0";
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "http://www.flickr.com/services/oauth/access_token" +
	    "?oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" + 
	    "&oauth_verifier=" + m_strOAuthVerifier +	    
	    "&oauth_callback=http%3A%2F%2Fwww.flickr.com" +
	    "&oauth_signature=" + strSign;
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function GetContactList(nPage,nPer_page)
{
    //Use API:flickr.contacts.getList
    //http://www.flickr.com/services/api/flickr.contacts.getList.html
    //This method requires authentication with 'read' permission
    //So it always goes with OAuth

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			// Get the data from the server's response
			//document.getElementById("txtHint").innerHTML=xmlHttp.responseText;				
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.contacts.getList" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&page=" + nPage +
	    "&per_page=" + nPer_page;

	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.contacts.getList" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
    	    "&page=" + nPage +
	    "&per_page=" + nPer_page;
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function getPeopleInfo(nsid)
{
    //Use API:flickr.people.getInfo
    //http://www.flickr.com/services/api/flickr.people.getInfo.html
    //This method does not require authentication.

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.people.getInfo" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&user_id=" + nsid;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.people.getInfo" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&user_id=" + nsid;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest" +
	    "?api_key=" + m_strApiKey +
	    "&format=json" +
	    "&method=flickr.people.getInfo" +	    
	    "&user_id=" + nsid;
	}
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
	
}

function getPersonInfo(nsid)
{
    //Use API:flickr.people.getInfo
    //http://www.flickr.com/services/api/flickr.people.getInfo.html
    //This method does not require authentication.

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 
	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.people.getInfo" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&user_id=" + nsid;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.people.getInfo" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&user_id=" + nsid;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest" +
	    "?api_key=" + m_strApiKey +
	    "&format=json" +
	    "&method=flickr.people.getInfo" +	    
	    "&user_id=" + nsid;
	}	
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function GetPhotoSizes(photo_id)
{
    //Use API:flickr.photos.getSizes
    //http://www.flickr.com/services/api/flickr.photos.getSizes.html
    //This method does not require authentication.

	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.photos.getSizes" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" + 
	    "&photo_id="+photo_id;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.photos.getSizes" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign + 
	    "&photo_id="+photo_id;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest" +
	    "?api_key=" + m_strApiKey +
	    "&format=json" +
	    "&method=flickr.photos.getSizes" +
	    "&photo_id=" + photo_id;
	}
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function GetPhotosBySetID(photoset_id,page)
{
    //Use API:flickr.photosets.getPhotos
    //http://www.flickr.com/services/api/flickr.photosets.getPhotos.html
    //This method does not require authentication.

        updateTableWH();
	m_StrPhotoset_id = photoset_id;
	m_nCurrentPageIndex = page;
	var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 
	
	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "?extras=license,owner_name" +
	    "&format=json" + 
	    "&media=photo" +
	    "&method=flickr.photosets.getPhotos" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&page=" + page +
	    "&per_page="+m_nPhotosPrePage +
	    "&photoset_id="+photoset_id;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?extras=license,owner_name" +
	    "&format=json" +
    	    "&media=photo" +
	    "&method=flickr.photosets.getPhotos" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&page=" + page +
	    "&per_page=" + m_nPhotosPrePage +	    
	    "&photoset_id=" + photoset_id;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest" +
	    "?api_key=" + m_strApiKey +
	    "&extras=license,owner_name" +
	    "&format=json" +
    	    "&media=photo" +
	    "&method=flickr.photosets.getPhotos" +
	    "&page=" + page +
	    "&per_page=" + m_nPhotosPrePage +	    
	    "&photoset_id=" + photoset_id;	    
	}	    
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function OpenToLicensePage(LicenseID)
{
	var bFind = false;
	var strURL;
	for(var i = 0;i<m_nLicenseName.length;i++)
	{
		if(m_nLicenseID[i]==LicenseID)
		{
			bFind = true;
			strURL = m_nLicenseURL[i];
		}
	}
	if(bFind == true)
	{
		if(strURL!="")
			window.open(strURL);			
	}
}

function GetLicenseDescription(LicenseID)
{

	var bFind = false;
	var strURL;
	for(var i = 0;i<m_nLicenseName.length;i++)
	{
		if(m_nLicenseID[i]==LicenseID)
		{
			return m_nLicenseName[i];
		}
	}
}


function GoToHome()
{
	var strURL="http://www.flickr.com/signup/";
	window.open(strURL);
}

function GetPhotoInfo(photo_id)
{
    //Use API:flickr.photos.getInfo
    //http://www.flickr.com/services/api/flickr.photos.getInfo.html
    //This method does not require authentication.

        var xmlHttp;
	try
	{    // Firefox, Opera 8.0+, Safari 
		xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{    // Internet Explorer    
		try
		{      
			xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");      
		}
		catch (e)
		{      
			try
			{        
				xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");        
			}
			catch (e)
			{
				alert("Your browser does not support AJAX!");
				return false;        
			}      
		}    
	}
	
	//define async response handler
	xmlHttp.onreadystatechange=function()
	{
		if(xmlHttp.readyState==4)
		{
			if(xmlHttp.responseText)
				var myObject = eval('(' + xmlHttp.responseText + ')');
		}
	} 

	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
	    "format=json" + 
	    "&method=flickr.photos.getInfo" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&photo_id"+photo_id;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?format=json" +
	    "&method=flickr.photos.getInfo" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&photo_id"+photo_id;
	if(!m_strIsLogin)
	{
	    strSrc = "https://api.flickr.com/services/rest" +
	    "?api_key=" + m_strApiKey +
	    "&format=json" +
	    "&method=flickr.photos.getInfo" +
	    "&photo_id"+photo_id;
	}
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);
}

function ShowPhotoInfo(photo)
{
	var strTips = "";
	strTips = m_strToolTipsFileUserName+":"+photo.owner.username;
	if(photo.title._content)
		strTips = strTips+"\n"+m_strToolTipsFileName+photo.title._content;
	if(photo.description && photo.description._contentn)
		strTips = strTips + "\n"+m_strToolTipsFileDescription+":"+photo.description._contentn;
		
	var SpaceID = "image"+photo.id;
	
	var image_cell = document.getElementById(SpaceID);
	if(image_cell)
	{
		image_cell.setAttribute('description', strTips);
		image_cell.setAttribute('title', strTips);
	}
}

function GetNotInSets(page) 
{
    //Use API:flickr.photos.getNotInSet
    //http://www.flickr.com/services/api/flickr.photos.getNotInSet.html
    //This method requires authentication with 'read' permission.
    //So it always goes with OAuth

    updateTableWH();
    m_nCurrentPageIndex = page;
    var xmlHttp;
    try {    // Firefox, Opera 8.0+, Safari 
        xmlHttp = new XMLHttpRequest();
    }
    catch (e) {    // Internet Explorer    
        try {
            xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch (e) {
            try {
                xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
            }
            catch (e) {
                alert("Your browser does not support AJAX!");
                return false;
            }
        }
    }

    //define async response handler
    xmlHttp.onreadystatechange = function() {
        if (xmlHttp.readyState == 4) {
            if (xmlHttp.responseText)
                var myObject = eval('(' + xmlHttp.responseText + ')');
        }
    }
	var timestamp = Math.round(new Date().getTime() / 1000);
	m_nNonceTime++;
	m_strNonce = MD5(m_nNonceTime + "Nonce: " +  timestamp).substring(0,10);

	var strBaseAddress = encodeURIComponent("https://api.flickr.com/services/rest");
	var strBaseParameter = 
//	    "extras=license,owner_name" +
	    "&format=json" + 
	    "&media=photo" + 
	    "&method=flickr.photos.getNotInSet" +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_timestamp=" + timestamp +
	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_version=1.0" +
	    "&page=" + page + 
	    "&per_page=" + m_nPhotosPrePage;
	strBaseParameter = encodeURIComponent(strBaseParameter);
	strBaseParameter = "extras%3Dlicense%252Cowner_name" + strBaseParameter;
	var strBaseString = "POST&" + strBaseAddress + "&" + strBaseParameter;
	var strKey = m_strSecret + "&" + m_strOAuth1Secret;
	var strRef = "Sign:" + strKey + "@" + strBaseString;
	location = strRef;
	var strSign = encodeURIComponent(m_strSign);

	var strSrc = "https://api.flickr.com/services/rest" +
	    "?extras=license,owner_name" +
	    "&format=json" +
    	    "&media=photo" + 
	    "&method=flickr.photos.getNotInSet" +	    
	    "&oauth_nonce=" + m_strNonce + 
	    "&oauth_timestamp=" + timestamp +
    	    "&oauth_token=" + m_strOAuth1Token +
	    "&oauth_consumer_key=" + m_strApiKey +
	    "&oauth_signature_method=HMAC-SHA1" +
	    "&oauth_version=1.0" + 
	    "&oauth_signature=" + strSign +
	    "&page=" + page + 
	    "&per_page=" + m_nPhotosPrePage;
	xmlHttp.open("POST", strSrc, true);
	xmlHttp.send(null);    
}
