/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.secure.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClient;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientAdapter;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientListener;
import com.aelitis.azureus.core.clientmessageservice.secure.SecureMessageServiceClientMessage;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientHelper;
import com.aelitis.azureus.core.clientmessageservice.secure.impl.SecureMessageServiceClientMessageImpl;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public class SecureMessageServiceClientImpl
implements SecureMessageServiceClient {
    public static final int STATUS_OK = 0;
    public static final int STATUS_LOGON_FAIL = 1;
    public static final int STATUS_INVALID_SEQUENCE = 2;
    public static final int STATUS_FAILED = 3;
    public static final int STATUS_ABORT = 4;
    public static final String SERVICE_NAME = "SecureMsgServ";
    private static final long MIN_RETRY_PERIOD = 300000L;
    private static final long MAX_RETRY_PERIOD = 0x6DDD00L;
    private String host;
    private int port;
    private int timeout_secs;
    private RSAPublicKey public_key;
    private SecureMessageServiceClientAdapter adapter;
    private long retry_millis = 300000L;
    private int connect_failure_count = 0;
    private AEMonitor message_mon;
    private AESemaphore message_sem;
    private String last_failed_user_pw = "";
    private long last_failed_user_pw_time;
    private List messages = new ArrayList();
    private List listeners = new ArrayList();

    public SecureMessageServiceClientImpl(String _host, int _port, int _timeout_secs, RSAPublicKey _key, SecureMessageServiceClientAdapter _adapter) {
        this.host = _host;
        this.port = _port;
        this.timeout_secs = _timeout_secs;
        this.public_key = _key;
        this.adapter = _adapter;
        this.message_mon = new AEMonitor("SecureService:messages");
        this.message_sem = new AESemaphore("SecureService:messages");
        new AEThread("SecureService::messageSender", true){

            public void runSupport() {
                while (true) {
                    long time = SecureMessageServiceClientImpl.this.retry_millis;
                    if (SecureMessageServiceClientImpl.this.connect_failure_count > 0) {
                        for (int i = 0; i < SecureMessageServiceClientImpl.this.connect_failure_count; ++i) {
                            if ((time += time) <= 0x6DDD00L) continue;
                            time = 0x6DDD00L;
                            break;
                        }
                    }
                    SecureMessageServiceClientImpl.this.message_sem.reserve(time);
                    try {
                        SecureMessageServiceClientImpl.this.sendMessagesSupport();
                        continue;
                    }
                    catch (Throwable e) {
                        SecureMessageServiceClientImpl.this.adapter.log("Request processing failed", e);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public void sendMessages() {
        this.message_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void sendMessagesSupport() {
        block50: {
            Object v0;
            ArrayList outstanding_messages;
            long now;
            String user = this.adapter.getUser();
            byte[] password = this.adapter.getPassword();
            String user_password = user + "/" + new String(password);
            if (user.length() == 0) {
                this.adapter.authenticationFailed();
                return;
            }
            if (user_password.equals(this.last_failed_user_pw) && (now = SystemTime.getCurrentTime()) > this.last_failed_user_pw_time && now - this.last_failed_user_pw_time < 60000L) {
                this.adapter.authenticationFailed();
                return;
            }
            try {
                this.message_mon.enter();
                outstanding_messages = new ArrayList(this.messages);
                Object var7_6 = null;
                this.message_mon.exit();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.message_mon.exit();
                throw throwable;
            }
            if (outstanding_messages.size() == 0) {
                return;
            }
            ArrayList<SecureMessageServiceClientMessageImpl> complete_messages = new ArrayList<SecureMessageServiceClientMessageImpl>();
            boolean failed = false;
            Iterator it = outstanding_messages.iterator();
            while (it.hasNext() && !failed) {
                SecureMessageServiceClientMessageImpl message = (SecureMessageServiceClientMessageImpl)it.next();
                boolean retry = true;
                int retry_count = 0;
                while (retry && !failed) {
                    Throwable e4222;
                    Object var23_28;
                    boolean got_reply;
                    ClientMessageService message_service;
                    block47: {
                        block46: {
                            Iterator l_it;
                            retry = false;
                            message_service = null;
                            got_reply = false;
                            HashMap<String, Object> content = new HashMap<String, Object>();
                            long sequence = this.adapter.getMessageSequence();
                            content.put("user", user);
                            content.put("password", password);
                            content.put("seq", new Long(sequence));
                            content.put("request", message.getRequest());
                            this.last_failed_user_pw = "";
                            message_service = SecureMessageServiceClientHelper.getServerService(this.host, this.port, this.timeout_secs, SERVICE_NAME, this.public_key);
                            message_service.sendMessage(content);
                            Map reply = message_service.receiveMessage();
                            got_reply = true;
                            long status = (Long)reply.get("status");
                            Long new_retry = (Long)reply.get("retry");
                            if (new_retry != null) {
                                this.retry_millis = new_retry;
                                if (this.retry_millis < 300000L) {
                                    this.retry_millis = 300000L;
                                }
                                this.adapter.log("Server requested retry period of " + this.retry_millis / 1000L + " seconds");
                            } else {
                                this.retry_millis = 300000L;
                            }
                            if (status == 0L) {
                                message.setReply((Map)reply.get("reply"));
                                this.adapter.log("Request successfully sent: " + message.getRequest() + "->" + message.getReply());
                                this.adapter.setMessageSequence(sequence + 1L);
                                this.adapter.serverOK();
                                l_it = this.listeners.iterator();
                                while (l_it.hasNext()) {
                                    try {
                                        ((SecureMessageServiceClientListener)l_it.next()).complete(message);
                                    }
                                    catch (Throwable e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                complete_messages.add(message);
                                break block46;
                            }
                            if (status == 1L) {
                                this.last_failed_user_pw = user_password;
                                this.last_failed_user_pw_time = SystemTime.getCurrentTime();
                                this.adapter.serverOK();
                                this.adapter.authenticationFailed();
                                failed = true;
                                break block46;
                            }
                            if (status == 2L) {
                                if (retry_count == 1) {
                                    this.adapter.serverFailed(new Exception("Sequence resynchronisation failed"));
                                    failed = true;
                                } else {
                                    ++retry_count;
                                    retry = true;
                                    long expected_sequence = (Long)reply.get("seq");
                                    this.adapter.log("Sequence resynchronise: local = " + sequence + ", remote = " + expected_sequence);
                                    this.adapter.setMessageSequence(expected_sequence);
                                }
                                break block46;
                            }
                            if (status == 3L) {
                                this.adapter.serverFailed(new Exception(new String((byte[])reply.get("error"))));
                                failed = true;
                                break block46;
                            }
                            this.adapter.serverFailed(new Exception("Server requested abort"));
                            l_it = this.listeners.iterator();
                            while (l_it.hasNext()) {
                                try {
                                    ((SecureMessageServiceClientListener)l_it.next()).aborted(message, new String((byte[])reply.get("error")));
                                }
                                catch (Throwable e3) {
                                    e3.printStackTrace();
                                }
                            }
                            complete_messages.add(message);
                        }
                        var23_28 = null;
                        if (got_reply) {
                            this.connect_failure_count = 0;
                            break block47;
                        }
                        ++this.connect_failure_count;
                        if (this.connect_failure_count <= 1) break block47;
                        try {
                            this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                        }
                        catch (Throwable e4222) {
                            e4222.printStackTrace();
                        }
                    }
                    if (message_service == null) continue;
                    message_service.close();
                    {
                        continue;
                        catch (Throwable e5) {
                            this.adapter.serverFailed(e5);
                            failed = true;
                            var23_28 = null;
                            if (got_reply) {
                                this.connect_failure_count = 0;
                            } else {
                                ++this.connect_failure_count;
                                if (this.connect_failure_count > 1) {
                                    try {
                                        this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                    }
                                    catch (Throwable e4222) {
                                        e4222.printStackTrace();
                                    }
                                }
                            }
                            if (message_service == null) continue;
                            message_service.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var23_28 = null;
                        if (got_reply) {
                            this.connect_failure_count = 0;
                        } else {
                            ++this.connect_failure_count;
                            if (this.connect_failure_count > 1) {
                                try {
                                    this.adapter.log("Failed to contact server " + this.connect_failure_count + " times in a row");
                                }
                                catch (Throwable e4222) {
                                    e4222.printStackTrace();
                                }
                            }
                        }
                        if (message_service != null) {
                            message_service.close();
                        }
                        throw throwable;
                    }
                }
            }
            Object var26_31 = null;
            try {
                this.message_mon.enter();
                this.messages.removeAll(complete_messages);
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var28_37 = v0;
            this.message_mon.exit();
            {
                break block50;
                catch (Throwable e) {
                    Object v1;
                    this.adapter.serverFailed(e);
                    Object var26_32 = null;
                    try {
                        this.message_mon.enter();
                        this.messages.removeAll(complete_messages);
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var28_38 = v1;
                    this.message_mon.exit();
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var26_33 = null;
                try {
                    this.message_mon.enter();
                    this.messages.removeAll(complete_messages);
                    v2 = null;
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var28_39 = v2;
                this.message_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureMessageServiceClientMessage sendMessage(Map request2, Object data, String description) {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessageImpl res = new SecureMessageServiceClientMessageImpl(this, request2, data, description);
            this.messages.add(res);
            this.message_sem.release();
            SecureMessageServiceClientMessageImpl secureMessageServiceClientMessageImpl = res;
            Object var7_6 = null;
            this.message_mon.exit();
            return secureMessageServiceClientMessageImpl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.message_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(SecureMessageServiceClientMessage message) {
        boolean inform = false;
        try {
            this.message_mon.enter();
            if (this.messages.remove(message)) {
                inform = true;
            }
            Object var4_3 = null;
            this.message_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.message_mon.exit();
            throw throwable;
        }
        if (inform) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((SecureMessageServiceClientListener)it.next()).cancelled(message);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureMessageServiceClientMessage[] getMessages() {
        try {
            this.message_mon.enter();
            SecureMessageServiceClientMessage[] secureMessageServiceClientMessageArray = this.messages.toArray(new SecureMessageServiceClientMessage[this.messages.size()]);
            Object var3_2 = null;
            this.message_mon.exit();
            return secureMessageServiceClientMessageArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.message_mon.exit();
            throw throwable;
        }
    }

    public void addListener(SecureMessageServiceClientListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SecureMessageServiceClientListener l) {
        this.listeners.remove(l);
    }
}

