/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.DeviceMediaRendererImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceiTunes
extends DeviceMediaRendererImpl
implements DeviceMediaRenderer {
    private static final String UID = "a5d7869e-1ab9-6098-fef9-88476d988455";
    private static final Object ERRROR_KEY_ITUNES = new Object();
    private static final Object COPY_PENDING_KEY = new Object();
    private static final int INSTALL_CHECK_PERIOD = 60000;
    private static final int RUNNING_CHECK_PERIOD = 30000;
    private static final int DEVICE_CHECK_PERIOD = 10000;
    private static final int INSTALL_CHECK_TICKS = 12;
    private static final int RUNNING_CHECK_TICKS = 6;
    private static final int DEVICE_CHECK_TICKS = 2;
    private static final Object COPY_ERROR_KEY = new Object();
    private PluginInterface itunes;
    private volatile boolean is_installed;
    private volatile boolean is_running;
    private boolean copy_outstanding;
    private boolean copy_outstanding_set;
    private AEThread2 copy_thread;
    private AESemaphore copy_sem = new AESemaphore("Device:copy");
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);
    private long last_update_fail;
    private int consec_fails;
    private volatile boolean manual_copy_activated;

    protected DeviceiTunes(DeviceManagerImpl _manager, PluginInterface _itunes) {
        super(_manager, UID, "iTunes", true);
        this.itunes = _itunes;
    }

    protected DeviceiTunes(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceiTunes)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceiTunes other = (DeviceiTunes)_other;
        this.itunes = other.itunes;
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
        if (this.getPersistentBooleanProperty("copy_outstanding", false)) {
            this.setCopyOutstanding();
        }
        this.addListener(new TranscodeTargetListener(){

            public void fileAdded(TranscodeFile file) {
                if (file.isComplete() && !file.isCopiedToDevice()) {
                    DeviceiTunes.this.setCopyOutstanding();
                }
            }

            public void fileChanged(TranscodeFile file, int type, Object data) {
                if (file.isComplete() && !file.isCopiedToDevice()) {
                    DeviceiTunes.this.setCopyOutstanding();
                }
            }

            public void fileRemoved(TranscodeFile file) {
                DeviceiTunes.this.copy_sem.release();
            }
        });
    }

    @Override
    protected String getDeviceClassification() {
        return "apple.";
    }

    @Override
    public int getRendererSpecies() {
        return 3;
    }

    @Override
    public InetAddress getAddress() {
        return null;
    }

    @Override
    public boolean canRemove() {
        return false;
    }

    @Override
    public boolean isLivenessDetectable() {
        return true;
    }

    @Override
    public URL getWikiURL() {
        try {
            return new URL(MessageText.getString("device.wiki.itunes"));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    @Override
    protected void updateStatus(int tick_count) {
        super.updateStatus(tick_count);
        this.updateStatusSupport(tick_count);
        if (this.is_installed && this.is_running) {
            this.alive();
        } else {
            this.dead();
        }
    }

    protected void updateStatusSupport(int tick_count) {
        if (this.itunes == null) {
            return;
        }
        if (!this.is_installed && tick_count % 12 == 0) {
            this.updateiTunesStatus();
            return;
        }
        if (!this.is_running && tick_count % 6 == 0) {
            this.updateiTunesStatus();
            return;
        }
        if (tick_count % 2 == 0) {
            this.updateiTunesStatus();
        }
    }

    protected void updateiTunesStatus() {
        if (this.getManager().isClosing()) {
            return;
        }
        IPCInterface ipc = this.itunes.getIPC();
        try {
            Map properties = (Map)ipc.invoke("getProperties", new Object[0]);
            this.is_installed = (Boolean)properties.get("installed");
            boolean was_running = this.is_running;
            this.is_running = (Boolean)properties.get("running");
            if (this.is_running && !was_running) {
                this.copy_sem.release();
            }
            if (!this.is_installed && !this.is_running) {
                this.last_update_fail = 0L;
            }
            String info = null;
            if (this.getCopyToDevicePending() > 0) {
                if (!this.is_installed) {
                    info = MessageText.getString("device.itunes.install");
                } else if (!this.is_running && !this.getAutoStartDevice()) {
                    info = MessageText.getString("device.itunes.start");
                }
            }
            this.setInfo(ERRROR_KEY_ITUNES, info);
            Throwable error = (Throwable)properties.get("error");
            if (error != null) {
                throw error;
            }
            this.last_update_fail = 0L;
            this.consec_fails = 0;
            this.setError(ERRROR_KEY_ITUNES, null);
        }
        catch (Throwable e) {
            long now = SystemTime.getMonotonousTime();
            ++this.consec_fails;
            if (this.last_update_fail == 0L) {
                this.last_update_fail = now;
            } else if (now - this.last_update_fail > 60000L && this.consec_fails >= 3) {
                this.setError(ERRROR_KEY_ITUNES, MessageText.getString("device.itunes.install_problem"));
            }
            this.log("iTunes IPC failed", e);
        }
    }

    @Override
    public boolean canCopyToDevice() {
        return true;
    }

    @Override
    public boolean getAutoCopyToDevice() {
        return this.getPersistentBooleanProperty("auto_copy", true);
    }

    @Override
    public void setAutoCopyToDevice(boolean auto) {
        this.setPersistentBooleanProperty("auto_copy", auto);
        this.setCopyOutstanding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCopyToDevicePending() {
        DeviceiTunes deviceiTunes = this;
        synchronized (deviceiTunes) {
            if (!this.copy_outstanding) {
                return 0;
            }
        }
        TranscodeFileImpl[] files = this.getFiles();
        int result = 0;
        for (TranscodeFileImpl file : files) {
            if (!file.isComplete() || file.isCopiedToDevice()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void manualCopy() throws DeviceManagerException {
        if (this.getAutoCopyToDevice()) {
            throw new DeviceManagerException("Operation prohibited - auto copy enabled");
        }
        this.manual_copy_activated = true;
        this.setCopyOutstanding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCopyOutstanding() {
        DeviceiTunes deviceiTunes = this;
        synchronized (deviceiTunes) {
            this.copy_outstanding_set = true;
            if (this.copy_thread == null) {
                this.copy_thread = new AEThread2("Device:copier", true){

                    public void run() {
                        DeviceiTunes.this.performCopy();
                    }
                };
                this.copy_thread.start();
            }
            this.copy_sem.release();
        }
    }

    @Override
    public boolean canAutoStartDevice() {
        return true;
    }

    @Override
    public boolean getAutoStartDevice() {
        return this.getPersistentBooleanProperty("auto_start", true);
    }

    @Override
    public void setAutoStartDevice(boolean auto) {
        this.setPersistentBooleanProperty("auto_start", auto);
        if (auto) {
            this.copy_sem.release();
        }
    }

    @Override
    public boolean canAssociate() {
        return false;
    }

    @Override
    public boolean canRestrictAccess() {
        return false;
    }

    @Override
    public void associate(DeviceManager.UnassociatedDevice assoc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void performCopy() {
        var1_1 = this;
        synchronized (var1_1) {
            this.copy_outstanding = true;
            this.async_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    DeviceiTunes.this.setPersistentBooleanProperty("copy_outstanding", true);
                }
            });
        }
        block13: while (true) {
            if (this.copy_sem.reserve(60000L)) {
                while (this.copy_sem.reserveIfAvailable()) {
                }
            }
            if (!this.getAutoCopyToDevice()) {
                if (this.manual_copy_activated) {
                    this.manual_copy_activated = false;
                } else {
                    files = this.getFiles();
                    to_copy = 0;
                    for (TranscodeFileImpl file : files) {
                        if (!file.isComplete() || file.isCopiedToDevice()) continue;
                        ++to_copy;
                    }
                    if (to_copy == 0) {
                        this.setInfo(DeviceiTunes.COPY_PENDING_KEY, null);
                        continue;
                    }
                    str = MessageText.getString("devices.info.copypending3", new String[]{String.valueOf(to_copy)});
                    this.setInfo(DeviceiTunes.COPY_PENDING_KEY, str);
                    continue;
                }
            }
            this.setInfo(DeviceiTunes.COPY_PENDING_KEY, null);
            auto_start = this.getAutoStartDevice();
            to_copy = this;
            synchronized (to_copy) {
                if (!(this.itunes != null && (this.is_running || auto_start && this.is_installed))) {
                    if (!this.copy_outstanding && !this.copy_outstanding_set) {
                        this.copy_thread = null;
                        break;
                    }
                    continue;
                }
                this.copy_outstanding_set = false;
            }
            files = this.getFiles();
            to_copy = new ArrayList<TranscodeFileImpl>();
            borked_exist = false;
            for (TranscodeFileImpl file : files) {
                if (!file.isComplete() || file.isCopiedToDevice()) continue;
                if (file.getCopyToDeviceFails() < 3L) {
                    to_copy.add(file);
                    continue;
                }
                borked_exist = true;
            }
            if (borked_exist) {
                this.setError(DeviceiTunes.COPY_ERROR_KEY, MessageText.getString("device.error.copyfail2"));
            }
            arr$ /* !! */  = this;
            synchronized (arr$ /* !! */ ) {
                if (to_copy.size() == 0 && !this.copy_outstanding_set && !borked_exist) {
                    this.copy_outstanding = false;
                    this.async_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            DeviceiTunes.this.setError(COPY_ERROR_KEY, null);
                            DeviceiTunes.this.setPersistentBooleanProperty("copy_outstanding", false);
                        }
                    });
                    this.copy_thread = null;
                    break;
                }
            }
            i$ = to_copy.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block13;
                transcode_file = (TranscodeFileImpl)i$.next();
                try {
                    file = transcode_file.getTargetFile().getFile();
                    try {
                        ipc = this.itunes.getIPC();
                        if (!this.is_running) {
                            this.log("Auto-starting iTunes");
                        }
                        if ((error = (Throwable)(result = (Map)ipc.invoke("addFileToLibrary", new Object[]{file})).get("error")) != null) {
                            throw error;
                        }
                        this.is_running = true;
                        this.log("Added file '" + file + ": " + result);
                        transcode_file.setCopiedToDevice(true);
                    }
                    catch (Throwable e) {
                        transcode_file.setCopyToDeviceFailed();
                        this.log("Failed to copy file " + file, e);
                    }
                }
                catch (TranscodeException e) {}
            }
            break;
        }
    }

    @Override
    public boolean isBrowsable() {
        return false;
    }

    @Override
    public Device.browseLocation[] getBrowseLocations() {
        return null;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        if (this.itunes == null) {
            this.addDP(dp, "devices.comp.missing", "<null>");
        } else {
            this.updateiTunesStatus();
            this.addDP(dp, "devices.installed", this.is_installed);
            this.addDP(dp, "MyTrackerView.status.started", this.is_running);
            this.addDP(dp, "devices.copy.pending", this.copy_outstanding);
            this.addDP(dp, "devices.auto.start", this.getAutoStartDevice());
        }
    }

    @Override
    public String getStatus() {
        if (this.is_running) {
            return MessageText.getString("device.itunes.status.running");
        }
        if (this.is_installed) {
            return MessageText.getString("device.itunes.status.notrunning");
        }
        return MessageText.getString("device.itunes.status.notinstalled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            writer.println("itunes=" + this.itunes + ", installed=" + this.is_installed + ", running=" + this.is_running + ", auto_start=" + this.getAutoStartDevice());
            writer.println("copy_os=" + this.copy_outstanding + ", last_fail=" + new SimpleDateFormat().format(new Date(this.last_update_fail)));
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }
}

