/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeProviderAdapter;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeProviderJob;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import com.aelitis.azureus.core.devices.impl.TranscodePipeFileSource;
import com.aelitis.azureus.core.devices.impl.TranscodePipeStreamSource;
import com.aelitis.azureus.core.devices.impl.TranscodeProfileImpl;
import com.aelitis.azureus.core.download.DiskManagerFileInfoURL;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class TranscodeProviderVuze
implements TranscodeProvider {
    private static final String PROFILE_PREFIX = "vuzexcode:";
    private TranscodeManagerImpl manager;
    private PluginInterface plugin_interface;
    private volatile TranscodeProfile[] profiles;
    private Map<String, TranscodeProfile[]> profile_classification_map = new HashMap<String, TranscodeProfile[]>();

    protected TranscodeProviderVuze(TranscodeManagerImpl _manager, PluginInterface _plugin_interface) {
        this.manager = _manager;
        this.update(_plugin_interface);
    }

    public int getID() {
        return 1;
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    protected void update(PluginInterface pi) {
        this.plugin_interface = pi;
        try {
            this.plugin_interface.getIPC().invoke("addProfileListChangedListener", new Object[]{new AERunnable(){

                public void runSupport() {
                    TranscodeProviderVuze.this.resetProfiles();
                }
            }});
        }
        catch (IPCException iPCException) {
            // empty catch block
        }
        this.resetProfiles();
    }

    public String getName() {
        return this.plugin_interface.getPluginName() + ": version=" + this.plugin_interface.getPluginVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetProfiles() {
        Map<String, TranscodeProfile[]> map = this.profile_classification_map;
        synchronized (map) {
            this.profile_classification_map.clear();
            this.profiles = null;
        }
    }

    public TranscodeProfile[] getProfiles() {
        if (this.profiles != null) {
            return this.profiles;
        }
        try {
            Map profiles_map = (Map)this.plugin_interface.getIPC().invoke("getProfiles", new Object[0]);
            TranscodeProfile[] res = new TranscodeProfile[profiles_map.size()];
            int index = 0;
            for (Map.Entry entry : profiles_map.entrySet()) {
                res[index++] = new TranscodeProfileImpl(this.manager, 1, PROFILE_PREFIX + (String)entry.getKey(), (String)entry.getKey(), (Map)entry.getValue());
            }
            this.profiles = res;
            return res;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new TranscodeProfile[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeProfile[] getProfiles(String classification_prefix) {
        TranscodeProfile[] res;
        classification_prefix = classification_prefix.toLowerCase();
        TranscodeProfile[] profs = this.getProfiles();
        Map<String, TranscodeProfile[]> map = this.profile_classification_map;
        synchronized (map) {
            res = this.profile_classification_map.get(classification_prefix);
            if (res != null) {
                return res;
            }
        }
        ArrayList<TranscodeProfile> c_profiles = new ArrayList<TranscodeProfile>();
        for (TranscodeProfile p : profs) {
            String c = p.getDeviceClassification();
            if (c == null) {
                this.manager.log("Device classification missing for " + p.getName());
                continue;
            }
            if (!c.toLowerCase().startsWith(classification_prefix)) continue;
            c_profiles.add(p);
        }
        res = c_profiles.toArray(new TranscodeProfile[c_profiles.size()]);
        Map<String, TranscodeProfile[]> map2 = this.profile_classification_map;
        synchronized (map2) {
            if (profs == this.profiles) {
                this.profile_classification_map.put(classification_prefix, res);
            }
        }
        return res;
    }

    public TranscodeProfile getProfile(String UID) {
        TranscodeProfile[] profiles;
        for (TranscodeProfile profile : profiles = this.getProfiles()) {
            if (!profile.getUID().equals(UID)) continue;
            return profile;
        }
        return null;
    }

    public TranscodeProfile addProfile(File file) throws TranscodeException {
        try {
            String uid = PROFILE_PREFIX + (String)this.plugin_interface.getIPC().invoke("addProfile", new Object[]{file});
            this.resetProfiles();
            return this.getProfile(uid);
        }
        catch (Throwable e) {
            throw new TranscodeException("Failed to add profile", e);
        }
    }

    public TranscodeProviderAnalysis analyse(final TranscodeProviderAdapter _adapter, DiskManagerFileInfo input, TranscodeProfile profile) throws TranscodeException {
        try {
            File file;
            URL source_url = null;
            File source_file = null;
            long input_length = input.getLength();
            if (input_length > 0L && input_length == input.getDownloaded() && (file = input.getFile()).exists() && file.length() == input_length) {
                source_file = file;
            }
            TranscodePipe pipe = null;
            if (source_file == null) {
                if (input instanceof DiskManagerFileInfoURL) {
                    source_url = ((DiskManagerFileInfoURL)input).getURL();
                } else {
                    for (int i = 0; i < 10; ++i) {
                        PluginInterface av_pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
                        if (av_pi == null) {
                            throw new TranscodeException("Media Server plugin not found");
                        }
                        IPCInterface av_ipc = av_pi.getIPC();
                        String url_str = (String)av_ipc.invoke("getContentURL", new Object[]{input});
                        if (url_str != null && url_str.length() > 0) {
                            source_url = new URL(url_str);
                            pipe = new TranscodePipeStreamSource(source_url.getHost(), source_url.getPort());
                            source_url = UrlUtils.setHost(source_url, "127.0.0.1");
                            source_url = UrlUtils.setPort(source_url, pipe.getPort());
                        }
                        if (source_url != null) break;
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Throwable e) {
                            break;
                        }
                    }
                }
            }
            if (source_file == null && source_url == null) {
                throw new TranscodeException("File doesn't exist");
            }
            final TranscodePipe f_pipe = pipe;
            try {
                final IPCInterface ipc = this.plugin_interface.getIPC();
                final Object analysis_context = source_url != null ? ipc.invoke("analyseContent", new Object[]{source_url, profile.getName()}) : ipc.invoke("analyseContent", new Object[]{source_file, profile.getName()});
                final HashMap result = new HashMap();
                TranscodeProviderAnalysisImpl analysis = new TranscodeProviderAnalysisImpl(){

                    @Override
                    public void cancel() {
                        try {
                            ipc.invoke("cancelAnalysis", new Object[]{analysis_context});
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }

                    @Override
                    public boolean foundVideoStream() {
                        return this.getLongProperty(3) > 0L;
                    }

                    @Override
                    public boolean getBooleanProperty(int property) {
                        if (property == 1) {
                            return this.getBooleanProperty("xcode_required", true);
                        }
                        Debug.out("Unknown property: " + property);
                        return false;
                    }

                    @Override
                    public void setBooleanProperty(int property, boolean value) {
                        if (property == 5) {
                            result.put("force_xcode", value);
                        } else {
                            Debug.out("Unknown property: " + property);
                        }
                    }

                    @Override
                    public long getLongProperty(int property) {
                        if (property == 2) {
                            long duration = this.getLongProperty("duration_millis", 0L);
                            long audio_duration = this.getLongProperty("audio_duration_millis", 0L);
                            if (duration <= 0L && audio_duration > 0L) {
                                duration = audio_duration;
                            }
                            if (audio_duration > 0L && audio_duration < duration) {
                                duration = audio_duration;
                            }
                            return duration;
                        }
                        if (property == 3) {
                            return this.getLongProperty("video_width", 0L);
                        }
                        if (property == 4) {
                            return this.getLongProperty("video_height", 0L);
                        }
                        if (property == 6) {
                            return this.getLongProperty("source_size", 0L);
                        }
                        if (property == 7) {
                            return this.getLongProperty("estimated_transcoded_size", 0L);
                        }
                        Debug.out("Unknown property: " + property);
                        return 0L;
                    }

                    protected boolean getBooleanProperty(String name, boolean def) {
                        Boolean b = (Boolean)result.get(name);
                        if (b != null) {
                            return b;
                        }
                        return def;
                    }

                    protected long getLongProperty(String name, long def) {
                        Long l = (Long)result.get(name);
                        if (l != null) {
                            return l;
                        }
                        return def;
                    }

                    @Override
                    public Map<String, Object> getResult() {
                        return result;
                    }
                };
                new AEThread2("analysisStatus", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block10: {
                            try {
                                try {
                                    Map status;
                                    long state;
                                    while ((state = ((Long)(status = (Map)ipc.invoke("getAnalysisStatus", new Object[]{analysis_context})).get("state")).longValue()) == 0L) {
                                        Thread.sleep(50L);
                                    }
                                    if (state == 1L) {
                                        _adapter.failed(new TranscodeException("Analysis cancelled"));
                                    } else if (state == 2L) {
                                        _adapter.failed(new TranscodeException("Analysis failed", (Throwable)status.get("error")));
                                    } else {
                                        result.putAll((Map)status.get("result"));
                                        _adapter.complete();
                                    }
                                }
                                catch (Throwable e) {
                                    _adapter.failed(new TranscodeException("Failed to get status", e));
                                }
                                Object var5_4 = null;
                                if (f_pipe == null) break block10;
                                f_pipe.destroy();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (f_pipe != null) {
                                    f_pipe.destroy();
                                }
                                throw throwable;
                            }
                            {
                            }
                        }
                    }
                }.start();
                return analysis;
            }
            catch (Throwable e) {
                if (pipe != null) {
                    pipe.destroy();
                }
                throw e;
            }
        }
        catch (TranscodeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TranscodeException("analysis failed", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TranscodeProviderJob transcode(final TranscodeProviderAdapter _adapter, TranscodeProviderAnalysis analysis, boolean direct_input, DiskManagerFileInfo input, TranscodeProfile profile, URL output) throws TranscodeException {
        try {
            PluginInterface av_pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
            if (av_pi == null) {
                throw new TranscodeException("Media Server plugin not found");
            }
            final TranscodeProviderJob[] xcode_job = new TranscodeProviderJob[]{null};
            URL source_url = null;
            TranscodePipe pipe = null;
            if (direct_input) {
                File file;
                if (input instanceof DiskManagerFileInfoURL) {
                    ((DiskManagerFileInfoURL)input).download();
                }
                if (input.getDownloaded() == input.getLength() && (file = input.getFile()).exists() && file.length() == input.getLength()) {
                    source_url = file.toURI().toURL();
                }
                if (source_url == null) {
                    this.manager.log("Failed to use direct input as source file doesn't exist/incomplete");
                }
            }
            if (source_url == null) {
                if (input instanceof DiskManagerFileInfoURL) {
                    source_url = ((DiskManagerFileInfoURL)input).getURL();
                } else {
                    IPCInterface av_ipc = av_pi.getIPC();
                    String url_str = (String)av_ipc.invoke("getContentURL", new Object[]{input});
                    if (url_str == null || url_str.length() == 0) {
                        File source_file = input.getFile();
                        if (!source_file.exists()) throw new TranscodeException("Source file doesn't exist");
                        pipe = new TranscodePipeFileSource(source_file, new TranscodePipe.errorListener(){

                            public void error(Throwable e) {
                                _adapter.failed(new TranscodeException("File access error", e));
                                if (xcode_job[0] != null) {
                                    xcode_job[0].cancel();
                                }
                            }
                        });
                        source_url = new URL("http://127.0.0.1:" + pipe.getPort() + "/");
                    } else {
                        source_url = new URL(url_str);
                        pipe = new TranscodePipeStreamSource(source_url.getHost(), source_url.getPort());
                        source_url = UrlUtils.setHost(source_url, "127.0.0.1");
                        source_url = UrlUtils.setPort(source_url, pipe.getPort());
                    }
                }
            }
            final TranscodePipe f_pipe = pipe;
            try {
                Object context2;
                TranscodeProviderAdapter adapter;
                final IPCInterface ipc = this.plugin_interface.getIPC();
                if (output.getProtocol().equals("tcp")) {
                    adapter = _adapter;
                    context2 = ipc.invoke("transcodeToTCP", new Object[]{((TranscodeProviderAnalysisImpl)analysis).getResult(), source_url, profile.getName(), output.getPort()});
                } else {
                    final File file = new File(output.toURI());
                    File parent_dir = file.getParentFile();
                    if (parent_dir.exists()) {
                        if (!parent_dir.canWrite()) {
                            throw new TranscodeException("Folder '" + parent_dir.getAbsolutePath() + "' isn't writable");
                        }
                    } else if (!parent_dir.mkdirs()) {
                        throw new TranscodeException("Failed to create folder '" + parent_dir.getAbsolutePath() + "'");
                    }
                    adapter = new TranscodeProviderAdapter(){

                        public void updateProgress(int percent, int eta_secs, int width, int height) {
                            _adapter.updateProgress(percent, eta_secs, width, height);
                        }

                        public void streamStats(long connect_rate, long write_speed) {
                            _adapter.streamStats(connect_rate, write_speed);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void failed(TranscodeException error) {
                            try {
                                file.delete();
                                Object var3_2 = null;
                                _adapter.failed(error);
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                _adapter.failed(error);
                                throw throwable;
                            }
                        }

                        public void complete() {
                            _adapter.complete();
                        }
                    };
                    context2 = ipc.invoke("transcodeToFile", new Object[]{((TranscodeProviderAnalysisImpl)analysis).getResult(), source_url, profile.getName(), file});
                }
                new AEThread2("xcodeStatus", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block11: {
                            try {
                                boolean in_progress = true;
                                while (in_progress) {
                                    in_progress = false;
                                    if (f_pipe != null) {
                                        adapter.streamStats(f_pipe.getConnectionRate(), f_pipe.getWriteSpeed());
                                    }
                                    try {
                                        Map status = (Map)ipc.invoke("getTranscodeStatus", new Object[]{context2});
                                        long state = (Long)status.get("state");
                                        if (state == 0L) {
                                            int percent = (Integer)status.get("percent");
                                            Integer i_eta = (Integer)status.get("eta_secs");
                                            int eta = i_eta == null ? -1 : i_eta;
                                            Integer i_width = (Integer)status.get("new_width");
                                            int width = i_width == null ? 0 : i_width;
                                            Integer i_height = (Integer)status.get("new_height");
                                            int height = i_height == null ? 0 : i_height;
                                            adapter.updateProgress(percent, eta, width, height);
                                            if (percent == 100) {
                                                adapter.complete();
                                                continue;
                                            }
                                            in_progress = true;
                                            Thread.sleep(1000L);
                                            continue;
                                        }
                                        if (state == 1L) {
                                            adapter.failed(new TranscodeException("Transcode cancelled"));
                                            continue;
                                        }
                                        Boolean perm_fail = (Boolean)status.get("error_is_perm");
                                        TranscodeException error = new TranscodeException("Transcode failed", (Throwable)status.get("error"));
                                        if (perm_fail != null && perm_fail.booleanValue()) {
                                            error.setDisableRetry(true);
                                        }
                                        adapter.failed(error);
                                    }
                                    catch (Throwable e) {
                                        adapter.failed(new TranscodeException("Failed to get status", e));
                                    }
                                }
                                Object var13_13 = null;
                                if (f_pipe == null) break block11;
                                f_pipe.destroy();
                            }
                            catch (Throwable throwable) {
                                Object var13_14 = null;
                                if (f_pipe != null) {
                                    f_pipe.destroy();
                                }
                                throw throwable;
                            }
                            {
                            }
                        }
                    }
                }.start();
                xcode_job[0] = new TranscodeProviderJob(){

                    public void pause() {
                        if (f_pipe != null) {
                            f_pipe.pause();
                        }
                    }

                    public void resume() {
                        if (f_pipe != null) {
                            f_pipe.resume();
                        }
                    }

                    public void cancel() {
                        try {
                            ipc.invoke("cancelTranscode", new Object[]{context2});
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }

                    public void setMaxBytesPerSecond(int max) {
                        if (f_pipe != null) {
                            f_pipe.setMaxBytesPerSecond(max);
                        }
                    }
                };
                return xcode_job[0];
            }
            catch (Throwable e) {
                if (pipe == null) throw e;
                pipe.destroy();
                throw e;
            }
        }
        catch (TranscodeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TranscodeException("transcode failed", e);
        }
    }

    public File getAssetDirectory() {
        File file = this.plugin_interface.getPluginconfig().getPluginUserFile("assets");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected void destroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TranscodeProviderAnalysisImpl
    extends TranscodeProviderAnalysis {
        public Map<String, Object> getResult();
    }
}

