/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht;

import com.aelitis.azureus.core.dht.DHTListener;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DHT {
    public static final String PR_CONTACTS_PER_NODE = "EntriesPerNode";
    public static final String PR_NODE_SPLIT_FACTOR = "NodeSplitFactor";
    public static final String PR_SEARCH_CONCURRENCY = "SearchConcurrency";
    public static final String PR_LOOKUP_CONCURRENCY = "LookupConcurrency";
    public static final String PR_MAX_REPLACEMENTS_PER_NODE = "ReplacementsPerNode";
    public static final String PR_CACHE_AT_CLOSEST_N = "CacheClosestN";
    public static final String PR_ORIGINAL_REPUBLISH_INTERVAL = "OriginalRepublishInterval";
    public static final String PR_CACHE_REPUBLISH_INTERVAL = "CacheRepublishInterval";
    public static final String PR_ENCODE_KEYS = "EncodeKeys";
    public static final String PR_ENABLE_RANDOM_LOOKUP = "EnableRandomLookup";
    public static final short FLAG_NONE = 0;
    public static final short FLAG_SINGLE_VALUE = 0;
    public static final short FLAG_DOWNLOADING = 1;
    public static final short FLAG_SEEDING = 2;
    public static final short FLAG_MULTI_VALUE = 4;
    public static final short FLAG_STATS = 8;
    public static final short FLAG_ANON = 16;
    public static final short FLAG_PRECIOUS = 32;
    public static final short FLAG_BRIDGED = 64;
    public static final short FLAG_PUT_AND_FORGET = 256;
    public static final short FLAG_OBFUSCATE_LOOKUP = 512;
    public static final short FLAG_LOOKUP_FOR_STORE = 1024;
    public static final short FLAG_HIGH_PRIORITY = 2048;
    public static final int MAX_VALUE_SIZE = 512;
    public static final byte REP_FACT_NONE = 0;
    public static final byte REP_FACT_DEFAULT = -1;
    public static final byte DT_NONE = 1;
    public static final byte DT_FREQUENCY = 2;
    public static final byte DT_SIZE = 3;
    public static final String[] DT_STRINGS = new String[]{"", "None", "Freq", "Size"};
    public static final int NW_MAIN = 0;
    public static final int NW_CVS = 1;
    public static final int NW_MAIN_V6 = 3;

    public void put(byte[] var1, String var2, byte[] var3, short var4, DHTOperationListener var5);

    public void put(byte[] var1, String var2, byte[] var3, short var4, boolean var5, DHTOperationListener var6);

    public void put(byte[] var1, String var2, byte[] var3, short var4, byte var5, boolean var6, DHTOperationListener var7);

    public void put(byte[] var1, String var2, byte[] var3, short var4, byte var5, byte var6, boolean var7, DHTOperationListener var8);

    public DHTTransportValue getLocalValue(byte[] var1);

    public List<DHTTransportValue> getStoredValues(byte[] var1);

    public void get(byte[] var1, String var2, short var3, int var4, long var5, boolean var7, boolean var8, DHTOperationListener var9);

    public byte[] remove(byte[] var1, String var2, DHTOperationListener var3);

    public byte[] remove(DHTTransportContact[] var1, byte[] var2, String var3, DHTOperationListener var4);

    public boolean isDiversified(byte[] var1);

    public int getIntProperty(String var1);

    public DHTTransport getTransport();

    public DHTRouter getRouter();

    public DHTControl getControl();

    public DHTDB getDataBase();

    public DHTNATPuncher getNATPuncher();

    public DHTStorageAdapter getStorageAdapter();

    public void exportState(DataOutputStream var1, int var2) throws IOException;

    public void importState(DataInputStream var1) throws IOException;

    public void integrate(boolean var1);

    public void setSuspended(boolean var1);

    public void destroy();

    public boolean isSleeping();

    public void setLogging(boolean var1);

    public DHTLogger getLogger();

    public void print(boolean var1);

    public void addListener(DHTListener var1);

    public void removeListener(DHTListener var1);
}

