/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskAccessControllerInstance {
    private final int aggregation_request_limit;
    private final int aggregation_byte_limit;
    private String name;
    private boolean enable_aggregation;
    private boolean invert_threads = !COConfigurationManager.getBooleanParameter("diskmanager.perf.queue.torrent.bias");
    private int max_threads;
    private int max_mb_queued;
    private groupSemaphore max_mb_sem;
    private long request_bytes_queued;
    private long requests_queued;
    private long total_requests;
    private long total_single_requests_made;
    private long total_aggregated_requests_made;
    private long total_bytes;
    private long total_single_bytes;
    private long total_aggregated_bytes;
    private long io_time;
    private long io_count;
    private requestDispatcher[] dispatchers;
    private long last_check = 0L;
    private Map torrent_dispatcher_map = new HashMap();
    private static final int REQUEST_NUM_LOG_CHUNK = 100;
    private static final int REQUEST_BYTE_LOG_CHUNK = 0x100000;
    private int next_request_num_log = 100;
    private long next_request_byte_log = 0x100000L;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };

    public DiskAccessControllerInstance(String _name, boolean _enable_aggregation, int _aggregation_request_limit, int _aggregation_byte_limit, int _max_threads, int _max_mb) {
        this.name = _name;
        this.enable_aggregation = _enable_aggregation;
        this.aggregation_request_limit = _aggregation_request_limit;
        this.aggregation_byte_limit = _aggregation_byte_limit;
        this.max_mb_queued = _max_mb;
        this.max_mb_sem = new groupSemaphore(this.max_mb_queued);
        this.max_threads = _max_threads;
        this.dispatchers = new requestDispatcher[this.invert_threads ? 1 : this.max_threads];
        for (int i = 0; i < this.dispatchers.length; ++i) {
            this.dispatchers[i] = new requestDispatcher(i);
        }
    }

    protected String getName() {
        return this.name;
    }

    protected long getBlockCount() {
        return this.max_mb_sem.getBlockCount();
    }

    protected long getQueueSize() {
        return this.requests_queued;
    }

    protected long getQueuedBytes() {
        return this.request_bytes_queued;
    }

    protected long getTotalRequests() {
        return this.total_requests;
    }

    protected long getTotalSingleRequests() {
        return this.total_single_requests_made;
    }

    protected long getTotalAggregatedRequests() {
        return this.total_aggregated_requests_made;
    }

    public long getTotalBytes() {
        return this.total_bytes;
    }

    public long getTotalSingleBytes() {
        return this.total_single_bytes;
    }

    public long getTotalAggregatedBytes() {
        return this.total_aggregated_bytes;
    }

    public long getIOTime() {
        return this.io_time;
    }

    public long getIOCount() {
        return this.io_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(DiskAccessRequestImpl request2) {
        requestDispatcher dispatcher;
        if (this.dispatchers.length == 1) {
            dispatcher = this.dispatchers[0];
        } else {
            Map map = this.torrent_dispatcher_map;
            synchronized (map) {
                TOTorrent torrent;
                long now = System.currentTimeMillis();
                boolean check = false;
                if (now - this.last_check > 60000L || now < this.last_check) {
                    check = true;
                    this.last_check = now;
                }
                if (check) {
                    Iterator it = this.torrent_dispatcher_map.values().iterator();
                    while (it.hasNext()) {
                        requestDispatcher d = (requestDispatcher)it.next();
                        long last_active = d.getLastRequestTime();
                        if (now - last_active > 60000L) {
                            it.remove();
                            continue;
                        }
                        if (now >= last_active) continue;
                        d.setLastRequestTime(now);
                    }
                }
                if ((dispatcher = (requestDispatcher)this.torrent_dispatcher_map.get(torrent = request2.getFile().getTorrentFile().getTorrent())) == null) {
                    int min_index = 0;
                    int min_size = Integer.MAX_VALUE;
                    for (int i = 0; i < this.dispatchers.length; ++i) {
                        int size = this.dispatchers[i].size();
                        if (size == 0) {
                            min_index = i;
                            break;
                        }
                        if (size >= min_size) continue;
                        min_size = size;
                        min_index = i;
                    }
                    dispatcher = this.dispatchers[min_index];
                    this.torrent_dispatcher_map.put(torrent, dispatcher);
                }
                dispatcher.setLastRequestTime(now);
            }
        }
        dispatcher.queue(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued += (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = new_mb - old_mb;
            if (mb_diff > this.max_mb_queued) {
                this.max_mb_sem.releaseGroup(mb_diff - this.max_mb_queued);
                this.max_mb_queued = mb_diff;
            }
            ++this.requests_queued;
            if (this.requests_queued >= (long)this.next_request_num_log) {
                this.next_request_num_log += 100;
            }
            if (this.request_bytes_queued >= this.next_request_byte_log) {
                this.next_request_byte_log += 0x100000L;
            }
        }
        if (mb_diff > 0) {
            this.max_mb_sem.reserveGroup(mb_diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.torrent_dispatcher_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued -= (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = old_mb - new_mb;
            --this.requests_queued;
        }
        if (mb_diff > 0) {
            this.max_mb_sem.releaseGroup(mb_diff);
        }
    }

    protected String getString() {
        return this.name + ",agg=" + this.enable_aggregation + ",max_t=" + this.max_threads + ",max_mb=" + this.max_mb_queued + ",q_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.request_bytes_queued) + ",q_req=" + this.requests_queued + ",t_req=" + this.total_requests + ",t_byte=" + DisplayFormatters.formatByteCountToKiBEtc(this.total_bytes) + ",io=" + this.io_count;
    }

    public static void main(String[] args) {
        final groupSemaphore sem = new groupSemaphore(9);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                public void run() {
                    int count = 0;
                    while (true) {
                        int group = RandomUtils.generateRandomIntUpto(10);
                        System.out.println(Thread.currentThread().getName() + " reserving " + group);
                        sem.reserveGroup(group);
                        try {
                            Thread.sleep(5 + RandomUtils.generateRandomIntUpto(5));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        sem.releaseGroup(group);
                        if (++count % 100 != 0) continue;
                        System.out.println(Thread.currentThread().getName() + ": " + count + " ops");
                    }
                }
            }.start();
        }
    }

    protected static class groupSemaphore {
        private int value;
        private List waiters = new LinkedList();
        private long blocks;

        protected groupSemaphore(int _value) {
            this.value = _value;
        }

        protected long getBlockCount() {
            return this.blocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reserveGroup(int num) {
            mutableInteger wait;
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (num <= this.value && this.waiters.size() == 0) {
                    this.value -= num;
                    return;
                }
                ++this.blocks;
                wait = new mutableInteger(num - this.value);
                this.value = 0;
                this.waiters.add(wait);
            }
            wait.reserve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseGroup(int num) {
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (this.waiters.size() == 0) {
                    this.value += num;
                } else {
                    while (this.waiters.size() > 0) {
                        mutableInteger wait = (mutableInteger)this.waiters.get(0);
                        int wait_num = wait.getValue();
                        if (wait_num <= num) {
                            wait.release();
                            this.waiters.remove(0);
                            num -= wait_num;
                            continue;
                        }
                        wait.setValue(wait_num - num);
                        num = 0;
                        break;
                    }
                    this.value = num;
                }
            }
        }

        protected static class mutableInteger {
            private int i;
            private boolean released;

            protected mutableInteger(int _i) {
                this.i = _i;
            }

            protected int getValue() {
                return this.i;
            }

            protected void setValue(int _i) {
                this.i = _i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void release() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    this.released = true;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void reserve() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    if (this.released) {
                        return;
                    }
                    try {
                        int spurious_count = 0;
                        while (true) {
                            this.wait();
                            if (!this.released) {
                                if (++spurious_count > 1024) {
                                    Debug.out("DAC::mutableInteger: spurious wakeup limit exceeded");
                                    throw new RuntimeException("die die die");
                                }
                                Debug.out("DAC::mutableInteger: spurious wakeup, ignoring");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Semaphore: operation interrupted");
                    }
                }
            }
        }
    }

    protected class requestDispatcher {
        private int index;
        private AEThread2[] threads;
        private int active_threads;
        private LinkedList requests;
        private Map request_map;
        private long last_request_map_tidy;
        private AESemaphore request_sem;
        private AESemaphore schedule_sem;
        private long last_request_time;

        protected requestDispatcher(int _index) {
            this.threads = new AEThread2[DiskAccessControllerInstance.this.invert_threads ? DiskAccessControllerInstance.this.max_threads : 1];
            this.requests = new LinkedList();
            this.request_map = new HashMap();
            this.request_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:request");
            this.schedule_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher:schedule", 1);
            this.index = _index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue(DiskAccessRequestImpl request2) {
            if (tls.get() != null) {
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance.this.total_requests++;
                    DiskAccessControllerInstance.this.total_single_requests_made++;
                    DiskAccessControllerInstance.this.total_bytes += request2.getSize();
                    DiskAccessControllerInstance.this.total_single_bytes += request2.getSize();
                }
                try {
                    request2.runRequest();
                }
                catch (Throwable e) {
                    DiskAccessControllerInstance.this.io_count++;
                    Debug.printStackTrace(e);
                }
            } else {
                DiskAccessControllerInstance.this.getSpaceAllowance(request2);
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    DiskAccessControllerInstance.this.total_requests++;
                    DiskAccessControllerInstance.this.total_bytes += request2.getSize();
                    boolean added = false;
                    int priority = request2.getPriority();
                    if (priority >= 0) {
                        int pos = 0;
                        for (DiskAccessRequestImpl r : this.requests) {
                            if (r.getPriority() < priority) {
                                this.requests.add(pos, request2);
                                added = true;
                                break;
                            }
                            ++pos;
                        }
                    }
                    if (!added) {
                        this.requests.add(request2);
                    }
                    if (DiskAccessControllerInstance.this.enable_aggregation) {
                        HashMap<Long, DiskAccessRequestImpl> m = (HashMap<Long, DiskAccessRequestImpl>)this.request_map.get(request2.getFile());
                        if (m == null) {
                            m = new HashMap<Long, DiskAccessRequestImpl>();
                            this.request_map.put(request2.getFile(), m);
                        }
                        m.put(new Long(request2.getOffset()), request2);
                        long now = SystemTime.getCurrentTime();
                        if (now < this.last_request_map_tidy || now - this.last_request_map_tidy > 30000L) {
                            this.last_request_map_tidy = now;
                            Iterator it = this.request_map.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                if (((HashMap)entry.getValue()).size() != 0 || ((CacheFile)entry.getKey()).isOpen()) continue;
                                it.remove();
                            }
                        }
                    }
                    this.request_sem.release();
                    this.requestQueued();
                }
            }
        }

        protected long getLastRequestTime() {
            return this.last_request_time;
        }

        protected void setLastRequestTime(long l) {
            this.last_request_time = l;
        }

        protected int size() {
            return this.requests.size();
        }

        protected void requestQueued() {
            if (this.active_threads < this.threads.length && (this.active_threads == 0 || this.requests.size() > 32)) {
                for (int i = 0; i < this.threads.length; ++i) {
                    if (this.threads[i] != null) continue;
                    ++this.active_threads;
                    final int thread_index = i;
                    this.threads[thread_index] = new AEThread2("DiskAccessController:dispatch(" + DiskAccessControllerInstance.this.getName() + ")[" + this.index + "/" + thread_index + "]", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            tls.set(this);
                            block20: while (true) {
                                ArrayList<DiskAccessRequestImpl> aggregated;
                                DiskAccessRequestImpl request2;
                                block37: {
                                    request2 = null;
                                    aggregated = null;
                                    try {
                                        if (DiskAccessControllerInstance.this.invert_threads) {
                                            requestDispatcher.this.schedule_sem.reserve();
                                        }
                                        if (!requestDispatcher.this.request_sem.reserve(30000L)) break block37;
                                        LinkedList linkedList = requestDispatcher.this.requests;
                                        synchronized (linkedList) {
                                            request2 = (DiskAccessRequestImpl)requestDispatcher.this.requests.remove(0);
                                            if (DiskAccessControllerInstance.this.enable_aggregation) {
                                                CacheFile file = request2.getFile();
                                                HashMap file_map = (HashMap)requestDispatcher.this.request_map.get(file);
                                                if (file_map == null) {
                                                    file_map = new HashMap();
                                                }
                                                file_map.remove(new Long(request2.getOffset()));
                                                if (request2.getPriority() < 0 && !request2.isCancelled()) {
                                                    DiskAccessRequestImpl current = request2;
                                                    long aggregated_bytes = 0L;
                                                    try {
                                                        while (true) {
                                                            int current_size = current.getSize();
                                                            long end = current.getOffset() + (long)current_size;
                                                            DiskAccessRequestImpl next = (DiskAccessRequestImpl)file_map.remove(new Long(end));
                                                            if (next == null || next.isCancelled()) break;
                                                            if (!next.canBeAggregatedWith(request2)) {
                                                                break;
                                                            }
                                                            requestDispatcher.this.requests.remove(next);
                                                            if (!requestDispatcher.this.request_sem.reserve(30000L)) {
                                                                Debug.out("shouldn't happen");
                                                            }
                                                            if (aggregated == null) {
                                                                aggregated = new ArrayList<DiskAccessRequestImpl>(8);
                                                                aggregated.add(current);
                                                                aggregated_bytes += (long)current_size;
                                                            }
                                                            aggregated.add(next);
                                                            aggregated_bytes += (long)next.getSize();
                                                            if (aggregated.size() > DiskAccessControllerInstance.this.aggregation_request_limit) break;
                                                            if (aggregated_bytes >= (long)DiskAccessControllerInstance.this.aggregation_byte_limit) {
                                                                break;
                                                            }
                                                            current = next;
                                                        }
                                                    }
                                                    finally {
                                                        if (aggregated != null) {
                                                            DiskAccessControllerInstance.this.total_aggregated_requests_made++;
                                                        } else {
                                                            DiskAccessControllerInstance.this.total_single_requests_made++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        if (DiskAccessControllerInstance.this.invert_threads) {
                                            requestDispatcher.this.schedule_sem.release();
                                        }
                                    }
                                }
                                try {
                                    long io_start = SystemTime.getHighPrecisionCounter();
                                    if (aggregated != null) {
                                        DiskAccessRequestImpl[] requests = aggregated.toArray(new DiskAccessRequestImpl[aggregated.size()]);
                                        try {
                                            DiskAccessRequestImpl.runAggregated(request2, requests);
                                        }
                                        finally {
                                            long io_end = SystemTime.getHighPrecisionCounter();
                                            DiskAccessControllerInstance.this.io_time += io_end - io_start;
                                            DiskAccessControllerInstance.this.io_count++;
                                            int i = 0;
                                            while (true) {
                                                if (i >= requests.length) continue block20;
                                                DiskAccessRequestImpl r = requests[i];
                                                DiskAccessControllerInstance.this.total_aggregated_bytes += r.getSize();
                                                DiskAccessControllerInstance.this.releaseSpaceAllowance(r);
                                                ++i;
                                            }
                                        }
                                    }
                                    if (request2 != null) {
                                        try {
                                            request2.runRequest();
                                            continue;
                                        }
                                        finally {
                                            long io_end = SystemTime.getHighPrecisionCounter();
                                            DiskAccessControllerInstance.this.io_time += io_end - io_start;
                                            DiskAccessControllerInstance.this.io_count++;
                                            DiskAccessControllerInstance.this.total_single_bytes += request2.getSize();
                                            DiskAccessControllerInstance.this.releaseSpaceAllowance(request2);
                                            continue;
                                        }
                                    }
                                    LinkedList linkedList = requestDispatcher.this.requests;
                                    synchronized (linkedList) {
                                        if (requestDispatcher.this.requests.size() == 0) {
                                            ((requestDispatcher)requestDispatcher.this).threads[thread_index] = null;
                                            requestDispatcher.this.active_threads--;
                                            break;
                                        }
                                        continue;
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    continue;
                                }
                                break;
                            }
                        }
                    };
                    this.threads[thread_index].start();
                    break;
                }
            }
        }
    }
}

