/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;

public class CacheFileManagerStatsImpl
implements CacheFileManagerStats {
    protected CacheFileManagerImpl manager;
    protected Average cache_read_average = Average.getInstance(1000, 10);
    protected Average cache_write_average = Average.getInstance(1000, 10);
    protected Average file_read_average = Average.getInstance(1000, 10);
    protected Average file_write_average = Average.getInstance(1000, 5);
    protected long last_cache_read;
    protected long last_cache_write;
    protected long last_file_read;
    protected long last_file_write;
    protected AEMonitor this_mon = new AEMonitor("CacheFileManagerStats");

    protected CacheFileManagerStatsImpl(CacheFileManagerImpl _manager) {
        this.manager = _manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        try {
            this.this_mon.enter();
            long cache_read = this.manager.getBytesReadFromCache();
            long cache_read_diff = cache_read - this.last_cache_read;
            this.last_cache_read = cache_read;
            this.cache_read_average.addValue(cache_read_diff);
            long cache_write = this.manager.getBytesWrittenToCache();
            long cache_write_diff = cache_write - this.last_cache_write;
            this.last_cache_write = cache_write;
            this.cache_write_average.addValue(cache_write_diff);
            long file_read = this.manager.getBytesReadFromFile();
            long file_read_diff = file_read - this.last_file_read;
            this.last_file_read = file_read;
            this.file_read_average.addValue(file_read_diff);
            long file_write = this.manager.getBytesWrittenToFile();
            long file_write_diff = file_write - this.last_file_write;
            this.last_file_write = file_write;
            this.file_write_average.addValue(file_write_diff);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public long getSize() {
        return this.manager.getCacheSize();
    }

    public long getUsedSize() {
        return this.manager.getCacheUsed();
    }

    public long getBytesWrittenToCache() {
        return this.manager.getBytesWrittenToCache();
    }

    public long getBytesWrittenToFile() {
        return this.manager.getBytesWrittenToFile();
    }

    public long getBytesReadFromCache() {
        return this.manager.getBytesReadFromCache();
    }

    public long getBytesReadFromFile() {
        return this.manager.getBytesReadFromFile();
    }

    public long getAverageBytesWrittenToCache() {
        return this.cache_write_average.getAverage();
    }

    public long getAverageBytesWrittenToFile() {
        return this.file_write_average.getAverage();
    }

    public long getAverageBytesReadFromCache() {
        return this.cache_read_average.getAverage();
    }

    public long getAverageBytesReadFromFile() {
        return this.file_read_average.getAverage();
    }

    public long getCacheReadCount() {
        return this.manager.getCacheReadCount();
    }

    public long getCacheWriteCount() {
        return this.manager.getCacheWriteCount();
    }

    public long getFileReadCount() {
        return this.manager.getFileReadCount();
    }

    public long getFileWriteCount() {
        return this.manager.getFileWriteCount();
    }

    public boolean[] getBytesInCache(TOTorrent torrent, long[] absoluteOffsets, long[] lengths) {
        return this.manager.getBytesInCache(torrent, absoluteOffsets, lengths);
    }
}

