/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManager;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileLimited;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileUnlimited;
import com.aelitis.azureus.core.util.LinkFileMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected LinkedHashMap map;
    protected AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected HashMap<Object, LinkFileMap> links = new HashMap();
    protected AEMonitor links_mon = new AEMonitor("FMFileManager:Links");
    protected boolean limited;
    protected int limit_size;
    protected AESemaphore close_queue_sem;
    protected List close_queue;
    protected AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List files;
    protected AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return fMFileManagerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList();
            AEThread t = new AEThread("FMFileManager::closeQueueDispatcher"){

                public void runSupport() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected LinkFileMap getLinksEntry(TOTorrent torrent) {
        Object links_key;
        try {
            links_key = torrent.getHashWrapper();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            links_key = "";
        }
        LinkFileMap links_entry = this.links.get(links_key);
        if (links_entry == null) {
            links_entry = new LinkFileMap();
            this.links.put(links_key, links_entry);
        }
        return links_entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLinks(TOTorrent torrent, LinkFileMap new_links) {
        try {
            this.links_mon.enter();
            LinkFileMap links_entry = this.getLinksEntry(torrent);
            Iterator<LinkFileMap.Entry> it = new_links.entryIterator();
            while (it.hasNext()) {
                LinkFileMap.Entry entry = it.next();
                int index = entry.getIndex();
                File source = entry.getFromFile();
                File target = entry.getToFile();
                if (target != null && !source.equals(target)) {
                    if (index >= 0) {
                        links_entry.put(index, source, target);
                        continue;
                    }
                    links_entry.putMigration(source, target);
                    continue;
                }
                links_entry.remove(index, source);
            }
            Object var10_9 = null;
            this.links_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.links_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileLink(TOTorrent torrent, int file_index, File file) {
        try {
            this.links_mon.enter();
            LinkFileMap links_entry = this.getLinksEntry(torrent);
            LinkFileMap.Entry entry = links_entry.getEntry(file_index, file);
            File res = null;
            res = entry == null ? file : (file.equals(entry.getFromFile()) ? entry.getToFile() : file);
            File file2 = res;
            Object var9_8 = null;
            this.links_mon.exit();
            return file2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.links_mon.exit();
            throw throwable;
        }
    }

    public FMFile createFile(FMFileOwner owner, File file, int type) throws FMFileManagerException {
        FMFileImpl res = this.limited ? new FMFileLimited(owner, this, file, type) : new FMFileUnlimited(owner, this, file, type);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSlot(FMFileLimited file) {
        FMFileLimited oldest_file = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator it = this.map.keySet().iterator();
                oldest_file = (FMFileLimited)it.next();
                it.remove();
            }
            this.map.put(file, file);
            Object var5_4 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.map_mon.exit();
            throw throwable;
        }
        if (oldest_file != null) {
            this.closeFile(oldest_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            this.map.remove(file);
            Object var3_2 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.map_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usedSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(file)) {
                this.map.put(file, file);
            }
            Object var3_2 = null;
            this.map_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.map_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFile(FMFileLimited file) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(file);
            Object var3_2 = null;
            this.close_queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.close_queue_mon.exit();
            throw throwable;
        }
        this.close_queue_sem.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQueueDispatch() {
        while (true) {
            Object var3_4;
            this.close_queue_sem.reserve();
            FMFileLimited file = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    file = (FMFileLimited)this.close_queue.remove(0);
                }
                var3_4 = null;
                this.close_queue_mon.exit();
            }
            catch (Throwable throwable) {
                var3_4 = null;
                this.close_queue_mon.exit();
                throw throwable;
            }
            if (file == null) continue;
            try {
                file.close(false);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter writer) {
        writer.println("FMFileManager slots");
        try {
            writer.indent();
            try {
                this.map_mon.enter();
                for (FMFileLimited file : this.map.keySet()) {
                    writer.println(file.getString());
                }
                Object var5_4 = null;
                this.map_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.map_mon.exit();
                throw throwable;
            }
            Object var7_7 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            writer.exdent();
            throw throwable;
        }
    }

    protected static void generateEvidence(IndentWriter writer) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(writer);
    }

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }
}

