/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.regex;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeLimitedTask;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.json.simple.JSONObject;

public class RegexEngine
extends WebEngine {
    private static final String variablePattern = "\\$\\{[^}]+\\}";
    private static final Pattern patternVariable = Pattern.compile("\\$\\{[^}]+\\}");
    private String pattern_str;
    private Pattern[] patterns = new Pattern[0];

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new RegexEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        return new RegexEngine(meta_search, id, last_updated, rank_bias, name, map);
    }

    public RegexEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String resultPattern, String timeZone, boolean automaticDateFormat, String userDateFormat, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 1, id, last_updated, rank_bias, name, searchURLFormat, timeZone, automaticDateFormat, userDateFormat, mappings, needs_auth, auth_method, login_url, required_cookies);
        this.init(resultPattern);
        this.setSource(2);
        this.setSelectionState(2);
    }

    protected RegexEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        String resultPattern = ImportExportUtils.importString(map, "regex.pattern");
        this.init(resultPattern);
    }

    protected RegexEngine(MetaSearchImpl meta_search, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, 1, id, last_updated, rank_bias, name, map);
        String resultPattern = ImportExportUtils.importString(map, "regexp");
        resultPattern = URLDecoder.decode(resultPattern, "UTF-8");
        this.init(resultPattern);
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        ImportExportUtils.exportString(res, "regex.pattern", this.pattern_str);
        super.exportToBencodedMap(res, generic);
        return res;
    }

    protected void exportToJSONObject(JSONObject res) throws IOException {
        res.put("regexp", UrlUtils.encode(this.pattern_str));
        super.exportToJSONObject(res);
    }

    protected void init(String resultPattern) {
        this.pattern_str = resultPattern.trim();
        this.patterns = this.pattern_str.length() == 0 ? new Pattern[0] : new Pattern[]{Pattern.compile(this.pattern_str), Pattern.compile(this.pattern_str, 40)};
    }

    protected Result[] searchSupport(final SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, final int o_absolute_max_matches, String headers, final ResultListener listener) throws SearchException {
        this.debugStart();
        final WebEngine.pageDetails page_details = this.getWebPageContent(searchParameters, searchContext, headers, false);
        final String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        this.debugLog("pattern: " + this.pattern_str);
        try {
            TimeLimitedTask task2 = new TimeLimitedTask("MetaSearch:regexpr", 30000, 4, new TimeLimitedTask.task(){

                public Object run() throws Exception {
                    int max_matches = o_absolute_max_matches;
                    if (max_matches < 0 || max_matches > 1024) {
                        max_matches = 1024;
                    }
                    String searchQuery = null;
                    for (int i = 0; i < searchParameters.length; ++i) {
                        if (!searchParameters[i].getMatchPattern().equals("s")) continue;
                        searchQuery = searchParameters[i].getValue();
                    }
                    FieldMapping[] mappings = RegexEngine.this.getMappings();
                    try {
                        ArrayList<WebResult> results = new ArrayList<WebResult>();
                        for (int pat_num = 0; pat_num < RegexEngine.this.patterns.length && results.size() <= 0; ++pat_num) {
                            Pattern pattern = RegexEngine.this.patterns[pat_num];
                            Matcher m = pattern.matcher(page);
                            while (m.find() && (max_matches < 0 || --max_matches >= 0)) {
                                if (listener != null) {
                                    String[] groups = new String[m.groupCount()];
                                    for (int i = 0; i < groups.length; ++i) {
                                        groups[i] = m.group(i + 1);
                                    }
                                    listener.matchFound(RegexEngine.this, groups);
                                }
                                RegexEngine.this.debugLog("Found match:");
                                WebResult result = new WebResult(RegexEngine.this, RegexEngine.this.getRootPage(), RegexEngine.this.getBasePage(), RegexEngine.this.getDateParser(), searchQuery);
                                int fields_matched = 0;
                                block29: for (int i = 0; i < mappings.length; ++i) {
                                    String fieldFrom = mappings[i].getName();
                                    String fieldContent = null;
                                    Matcher matcher = patternVariable.matcher(fieldFrom);
                                    if (matcher.find()) {
                                        fieldContent = fieldFrom;
                                        do {
                                            String key = matcher.group();
                                            key = key.substring(2, key.length() - 1);
                                            try {
                                                int groupNo = Integer.parseInt(key);
                                                fieldContent = fieldContent.replaceFirst(RegexEngine.variablePattern, m.group(groupNo));
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        } while (matcher.find());
                                    } else {
                                        try {
                                            int groupNo = Integer.parseInt(fieldFrom);
                                            fieldContent = m.group(groupNo);
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    if (fieldContent == null) continue;
                                    int fieldTo = mappings[i].getField();
                                    RegexEngine.this.debugLog("    " + fieldTo + "=" + fieldContent);
                                    ++fields_matched;
                                    switch (fieldTo) {
                                        case 1: {
                                            result.setNameFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 3: {
                                            result.setSizeFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 4: {
                                            result.setNbPeersFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 5: {
                                            result.setNbSeedsFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 6: {
                                            result.setCategoryFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 2: {
                                            result.setPublishedDateFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 103: {
                                            result.setCDPLink(fieldContent);
                                            continue block29;
                                        }
                                        case 102: {
                                            result.setTorrentLink(fieldContent);
                                            continue block29;
                                        }
                                        case 104: {
                                            result.setPlayLink(fieldContent);
                                            continue block29;
                                        }
                                        case 105: {
                                            result.setDownloadButtonLink(fieldContent);
                                            continue block29;
                                        }
                                        case 7: {
                                            result.setCommentsFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 10: {
                                            result.setVotesFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 11: {
                                            result.setNbSuperSeedsFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 12: {
                                            result.setPrivateFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 13: {
                                            result.setDrmKey(fieldContent);
                                            continue block29;
                                        }
                                        case 14: {
                                            result.setVotesDownFromHTML(fieldContent);
                                            continue block29;
                                        }
                                        case 200: {
                                            result.setHash(fieldContent);
                                            continue block29;
                                        }
                                        default: {
                                            --fields_matched;
                                        }
                                    }
                                }
                                if (fields_matched <= 0) continue;
                                results.add(result);
                            }
                        }
                        if (results.size() == 0 && RegexEngine.this.isNeedsAuth() && page_details.getInitialURL().getProtocol().equalsIgnoreCase("http") && page_details.getFinalURL().getProtocol().equalsIgnoreCase("https")) {
                            throw new SearchLoginException("login possibly required");
                        }
                        return results.toArray(new Result[results.size()]);
                    }
                    catch (Throwable e) {
                        RegexEngine.this.log("Failed process result", e);
                        if (e instanceof SearchException) {
                            throw (SearchException)e;
                        }
                        throw new SearchException(e);
                    }
                }
            });
            Result[] res = (Result[])task2.run();
            this.debugLog("success: found " + res.length + " results");
            return res;
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("Regex matching failed", e);
        }
    }
}

