/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ReadController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private static boolean AGGRESIVE_READ = false;
    private volatile ArrayList<RateControlledEntity> normal_priority_entities = new ArrayList();
    private volatile ArrayList<RateControlledEntity> high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("ReadController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private long loop_count;
    private long wait_count;
    private long non_progress_count;
    private long progress_count;
    private long entity_check_count;
    private long last_entity_check_count;
    private final EventWaiter read_waiter = new EventWaiter();
    private int entity_count;

    public ReadController() {
        AEThread read_processor_thread = new AEThread("ReadController:ReadProcessor"){

            public void runSupport() {
                ReadController.this.readProcessorLoop();
            }
        };
        read_processor_thread.setDaemon(true);
        read_processor_thread.setPriority(9);
        read_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.read.control.loop.count");
        types.add("net.read.control.np.count");
        types.add("net.read.control.p.count");
        types.add("net.read.control.wait.count");
        types.add("net.read.control.entity.count");
        types.add("net.read.control.con.count");
        types.add("net.read.control.ready.con.count");
        AzureusCoreStats.registerProvider(types, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter writer) {
                writer.println("Read Controller");
                try {
                    RateControlledEntity entity;
                    int i;
                    writer.indent();
                    ArrayList ref = ReadController.this.normal_priority_entities;
                    writer.println("normal - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    ref = ReadController.this.high_priority_entities;
                    writer.println("priority - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    Object var6_5 = null;
                    writer.exdent();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    writer.exdent();
                    throw throwable;
                }
            }
        });
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.read.control.loop.count")) {
            values.put("net.read.control.loop.count", new Long(this.loop_count));
        }
        if (types.contains("net.read.control.np.count")) {
            values.put("net.read.control.np.count", new Long(this.non_progress_count));
        }
        if (types.contains("net.read.control.p.count")) {
            values.put("net.read.control.p.count", new Long(this.progress_count));
        }
        if (types.contains("net.read.control.wait.count")) {
            values.put("net.read.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.read.control.entity.count")) {
            values.put("net.read.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.read.control.con.count") || types.contains("net.read.control.ready.con.count")) {
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            for (int i = 0; i < refs.length; ++i) {
                ArrayList ref = refs[i];
                for (int j = 0; j < ref.size(); ++j) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount(this.read_waiter);
                    ready_connections += entity.getReadyConnectionCount(this.read_waiter);
                }
            }
            values.put("net.read.control.con.count", new Long(connections));
            values.put("net.read.control.ready.con.count", new Long(ready_connections));
        }
    }

    private void readProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            ++this.loop_count;
            try {
                if (check_high_first) {
                    check_high_first = false;
                    if (this.doHighPriorityRead() || this.doNormalPriorityRead() || !this.read_waiter.waitForEvent(this.hasConnections() ? (long)IDLE_SLEEP_TIME : 1000L)) continue;
                    ++this.wait_count;
                    continue;
                }
                check_high_first = true;
                if (this.doNormalPriorityRead() || this.doHighPriorityRead() || !this.read_waiter.waitForEvent(this.hasConnections() ? (long)IDLE_SLEEP_TIME : 1000L)) continue;
                ++this.wait_count;
                continue;
            }
            catch (Throwable t) {
                Debug.out("readProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean hasConnections() {
        if (this.entity_count == 0) {
            return false;
        }
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.read_waiter) <= 0) continue;
            return true;
        }
        ref = this.normal_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.read_waiter) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean doNormalPriorityRead() {
        return this.doRead(this.getNextReadyNormalPriorityEntity());
    }

    private boolean doHighPriorityRead() {
        return this.doRead(this.getNextReadyHighPriorityEntity());
    }

    private boolean doRead(RateControlledEntity ready_entity) {
        if (ready_entity != null) {
            if (AGGRESIVE_READ) {
                if (ready_entity.doProcessing(this.read_waiter, 0) > 0) {
                    ++this.progress_count;
                    return true;
                }
                ++this.non_progress_count;
                if (this.entity_check_count - this.last_entity_check_count >= (long)(this.normal_priority_entities.size() + this.high_priority_entities.size())) {
                    this.last_entity_check_count = this.entity_check_count;
                    if (this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                    return false;
                }
                return true;
            }
            return ready_entity.doProcessing(this.read_waiter, 0) > 0;
        }
        return false;
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            ++this.entity_check_count;
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledEntity entity = ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            ++this.entity_check_count;
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
        this.read_waiter.eventOccurred();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
            Object var4_4 = null;
            this.entities_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.entities_mon.exit();
            throw throwable;
        }
    }

    public int getEntityCount() {
        return this.entity_count;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.read.idle.time", "network.control.read.aggressive"}, new ParameterListener(){

            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.read.idle.time");
                AGGRESIVE_READ = COConfigurationManager.getBooleanParameter("network.control.read.aggressive");
            }
        });
    }
}

