/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.Debug;

public class HTTPNetworkConnectionWebSeed
extends HTTPNetworkConnection {
    private boolean switching;

    protected HTTPNetworkConnectionWebSeed(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer) {
        super(_manager, _connection, _peer);
    }

    protected void decodeHeader(HTTPMessageDecoder decoder, final String header) throws IOException {
        if (this.switching) {
            Debug.out("new header received while paused");
            throw new IOException("Bork");
        }
        if (!this.isSeed()) {
            return;
        }
        PEPeerControl control = this.getPeerControl();
        try {
            int pos = header.indexOf("\r\n");
            String line = header.substring(4, pos);
            pos = line.lastIndexOf(32);
            String url = line.substring(0, pos).trim();
            pos = url.indexOf(63);
            if (pos != -1) {
                url = url.substring(pos + 1);
            }
            StringTokenizer tok = new StringTokenizer(url, "&");
            int piece = -1;
            ArrayList<int[]> ranges = new ArrayList<int[]>();
            while (tok.hasMoreElements()) {
                String token = tok.nextToken();
                pos = token.indexOf(61);
                if (pos == -1) continue;
                String lhs = token.substring(0, pos).toLowerCase(MessageText.LOCALE_ENGLISH);
                String rhs = token.substring(pos + 1);
                if (lhs.equals("info_hash")) {
                    final byte[] old_hash = control.getHash();
                    final byte[] new_hash = URLDecoder.decode(rhs, "ISO-8859-1").getBytes("ISO-8859-1");
                    if (Arrays.equals(new_hash, old_hash)) continue;
                    this.switching = true;
                    decoder.pauseInternally();
                    this.flushRequests(new HTTPNetworkConnection.flushListener(){
                        private boolean triggered;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void flushed() {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                if (this.triggered) {
                                    return;
                                }
                                this.triggered = true;
                            }
                            HTTPNetworkConnectionWebSeed.this.getManager().reRoute(HTTPNetworkConnectionWebSeed.this, old_hash, new_hash, header);
                        }
                    });
                    return;
                }
                if (lhs.equals("piece")) {
                    try {
                        piece = Integer.parseInt(rhs);
                        continue;
                    }
                    catch (Throwable e) {
                        throw new IOException("Invalid piece number '" + rhs + "'");
                    }
                }
                if (!lhs.equals("ranges")) continue;
                StringTokenizer range_tok = new StringTokenizer(rhs, ",");
                while (range_tok.hasMoreTokens()) {
                    String range = range_tok.nextToken();
                    int sep = range.indexOf(45);
                    if (sep == -1) {
                        throw new IOException("Invalid range specification '" + rhs + "'");
                    }
                    try {
                        ranges.add(new int[]{Integer.parseInt(range.substring(0, sep)), Integer.parseInt(range.substring(sep + 1))});
                    }
                    catch (Throwable e) {
                        throw new IOException("Invalid range specification '" + rhs + "'");
                    }
                }
            }
            if (piece == -1) {
                throw new IOException("Piece number not specified");
            }
            boolean keep_alive = header.toLowerCase(MessageText.LOCALE_ENGLISH).indexOf("keep-alive") != -1;
            int this_piece_size = control.getPieceLength(piece);
            if (ranges.size() == 0) {
                ranges.add(new int[]{0, this_piece_size - 1});
            }
            long[] offsets = new long[ranges.size()];
            long[] lengths = new long[ranges.size()];
            long piece_offset = (long)piece * (long)control.getPieceLength(0);
            for (int i = 0; i < ranges.size(); ++i) {
                int[] range = (int[])ranges.get(i);
                int start = range[0];
                int end = range[1];
                if (start < 0 || start >= this_piece_size || end < 0 || end >= this_piece_size || start > end) {
                    throw new IOException("Invalid range specification '" + start + "-" + end + "'");
                }
                offsets[i] = piece_offset + (long)start;
                lengths[i] = end - start + 1;
            }
            this.addRequest(new HTTPNetworkConnection.httpRequest(offsets, lengths, 0L, false, keep_alive));
        }
        catch (Throwable e) {
            Debug.outNoStack("Decode of '" + (header.length() > 128 ? header.substring(0, 128) + "..." : header) + "' - " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Decode failed: " + Debug.getNestedExceptionMessage(e));
        }
    }
}

