/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class UDPSelector {
    private static final int POLL_FREQUENCY = COConfigurationManager.getIntParameter("network.udp.poll.time", 100);
    private List ready_set = new LinkedList();
    private AESemaphore ready_sem = new AESemaphore("UDPSelector");
    private volatile boolean destroyed;

    protected UDPSelector(final UDPConnectionManager manager) {
        new AEThread2("UDPSelector", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean quit = false;
                long last_poll = 0L;
                while (!quit) {
                    Object[] entry;
                    long now;
                    if (UDPSelector.this.destroyed) {
                        quit = true;
                    }
                    if ((now = SystemTime.getCurrentTime()) < last_poll || now - last_poll >= (long)POLL_FREQUENCY) {
                        manager.poll();
                        last_poll = now;
                    }
                    if (!UDPSelector.this.ready_sem.reserve(POLL_FREQUENCY / 2)) continue;
                    List list = UDPSelector.this.ready_set;
                    synchronized (list) {
                        if (UDPSelector.this.ready_set.size() == 0) {
                            continue;
                        }
                        entry = (Object[])UDPSelector.this.ready_set.remove(0);
                    }
                    TransportHelper transport = (TransportHelper)entry[0];
                    TransportHelper.selectListener listener = (TransportHelper.selectListener)entry[1];
                    if (listener == null) {
                        Debug.out("Null listener");
                        continue;
                    }
                    Object attachment = entry[2];
                    try {
                        if (entry.length == 3) {
                            listener.selectSuccess(transport, attachment);
                            continue;
                        }
                        listener.selectFailure(transport, attachment, (Throwable)entry[3]);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        List list = this.ready_set;
        synchronized (list) {
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transport, TransportHelper.selectListener listener, Object attachment) throws IOException {
        boolean removed = false;
        List list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                throw new IOException("Selector has been destroyed");
            }
            Iterator it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                if (entry[1] != listener) continue;
                it.remove();
                removed = true;
                break;
            }
            this.ready_set.add(new Object[]{transport, listener, attachment});
        }
        if (!removed) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready(TransportHelper transport, TransportHelper.selectListener listener, Object attachment, Throwable error) throws IOException {
        boolean removed = false;
        List list = this.ready_set;
        synchronized (list) {
            if (this.destroyed) {
                throw new IOException("Selector has been destroyed");
            }
            Iterator it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                if (entry[1] != listener) continue;
                it.remove();
                removed = true;
                break;
            }
            this.ready_set.add(new Object[]{transport, listener, attachment, error});
        }
        if (!removed) {
            this.ready_sem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel(TransportHelper transport, TransportHelper.selectListener listener) {
        List list = this.ready_set;
        synchronized (list) {
            Iterator it = this.ready_set.iterator();
            while (it.hasNext()) {
                Object[] entry = (Object[])it.next();
                if (entry[0] != transport || entry[1] != listener) continue;
                it.remove();
                break;
            }
        }
    }
}

