/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.ActivationFunction;

public class NeuralNetworkLayer {
    int numberOfNodes;
    double[][] weights;
    double[][] weightChanges;
    double[] neuronValues;
    double[] desiredValues;
    double[] errors;
    double[] biasWeights;
    double[] biasValues;
    double learningRate;
    boolean linearOutput;
    boolean useMomentum;
    double momentumFactor;
    NeuralNetworkLayer parentLayer;
    NeuralNetworkLayer childLayer;
    ActivationFunction activationFunction;

    public NeuralNetworkLayer(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.linearOutput = false;
        this.useMomentum = false;
        this.momentumFactor = 0.9;
    }

    public void initialize(NeuralNetworkLayer parentLayer, NeuralNetworkLayer childLayer) {
        this.neuronValues = new double[this.numberOfNodes];
        this.desiredValues = new double[this.numberOfNodes];
        this.errors = new double[this.numberOfNodes];
        this.parentLayer = parentLayer;
        if (childLayer != null) {
            this.childLayer = childLayer;
            this.weights = new double[this.numberOfNodes][childLayer.getNumberOfNodes()];
            this.weightChanges = new double[this.numberOfNodes][childLayer.getNumberOfNodes()];
            this.biasValues = new double[childLayer.getNumberOfNodes()];
            this.biasWeights = new double[childLayer.getNumberOfNodes()];
            for (int j = 0; j < childLayer.getNumberOfNodes(); ++j) {
                this.biasValues[j] = -1.0;
                this.biasWeights[j] = 0.0;
            }
        }
    }

    public void randomizeWeights() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                this.weights[i][j] = Math.random() * 2.0 - 1.0;
            }
        }
        for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
            this.biasWeights[j] = Math.random() * 2.0 - 1.0;
        }
    }

    public void calculateNeuronValues() {
        if (this.parentLayer != null) {
            for (int j = 0; j < this.numberOfNodes; ++j) {
                double x = 0.0;
                for (int i = 0; i < this.parentLayer.getNumberOfNodes(); ++i) {
                    x += this.parentLayer.neuronValues[i] * this.parentLayer.weights[i][j];
                }
                this.neuronValues[j] = this.childLayer == null && this.linearOutput ? x : this.activationFunction.getValueFor(x += this.parentLayer.biasValues[j] * this.parentLayer.biasWeights[j]);
            }
        }
    }

    public void calculateErrors() {
        if (this.childLayer == null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                this.errors[i] = (this.desiredValues[i] - this.neuronValues[i]) * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
            }
        } else if (this.parentLayer == null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                this.errors[i] = 0.0;
            }
        } else {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                double sum = 0.0;
                for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                    sum += this.childLayer.errors[j] * this.weights[i][j];
                }
                this.errors[i] = sum * this.activationFunction.getDerivedFunctionValueFor(this.neuronValues[i]);
            }
        }
    }

    public void adjustWeights() {
        if (this.childLayer != null) {
            for (int i = 0; i < this.numberOfNodes; ++i) {
                for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                    double dw = this.learningRate * this.childLayer.errors[j] * this.neuronValues[i];
                    if (this.useMomentum) {
                        double[] dArray = this.weights[i];
                        int n = j;
                        dArray[n] = dArray[n] + (dw + this.momentumFactor * this.weightChanges[i][j]);
                        this.weightChanges[i][j] = dw;
                        continue;
                    }
                    double[] dArray = this.weights[i];
                    int n = j;
                    dArray[n] = dArray[n] + dw;
                }
            }
            for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                int n = j;
                this.biasWeights[n] = this.biasWeights[n] + this.learningRate * this.childLayer.errors[j] * this.biasValues[j];
            }
        }
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setMomentum(boolean useMomentum, double factor) {
        this.useMomentum = useMomentum;
        this.momentumFactor = factor;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.childLayer != null) {
            for (int j = 0; j < this.childLayer.getNumberOfNodes(); ++j) {
                sb.append(j);
                sb.append("\t> ");
                for (int i = 0; i < this.numberOfNodes; ++i) {
                    sb.append(i);
                    sb.append(":");
                    sb.append(this.weights[i][j]);
                    sb.append("\t");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

