/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.pairing.PairedNode;
import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairedServiceRequestHandler;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.pairing.PairingTest;
import com.aelitis.azureus.core.pairing.PairingTestListener;
import com.aelitis.azureus.core.pairing.impl.PairingManagerTunnelHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingManagerImpl
implements PairingManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG = false;
    private static final String SERVICE_URL;
    private static final PairingManagerImpl singleton;
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private static final int CONNECT_TEST_PERIOD_MILLIS = 1800000;
    private AzureusCore azureus_core;
    private BooleanParameter param_enable;
    private InfoParameter param_ac_info;
    private InfoParameter param_status_info;
    private InfoParameter param_last_error;
    private HyperlinkParameter param_view;
    private BooleanParameter param_srp_enable;
    private LabelParameter param_srp_state;
    private BooleanParameter param_e_enable;
    private StringParameter param_public_ipv4;
    private StringParameter param_public_ipv6;
    private StringParameter param_host;
    private BooleanParameter param_net_enable;
    private StringParameter param_local_ipv4;
    private StringParameter param_local_ipv6;
    private BooleanParameter param_icon_enable;
    private Map<String, PairedServiceImpl> services = new HashMap<String, PairedServiceImpl>();
    private AESemaphore init_sem = new AESemaphore("PM:init");
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private String local_v4 = "";
    private String local_v6 = "";
    private PairingManagerTunnelHandler tunnel_handler;
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period = 10000;
    private int max_update_period = 3600000;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean must_update_once;
    private boolean update_in_progress;
    private TimerEvent deferred_update_event;
    private long last_update_time = -1L;
    private int consec_update_fails;
    private long qr_version = COConfigurationManager.getLongParameter("pairing.qr.ver", 0L);
    private String last_message;
    private Map<String, Object[]> local_address_checks = new HashMap<String, Object[]>();
    private CopyOnWriteList<PairingManagerListener> listeners = new CopyOnWriteList();
    private UIAdapter ui;
    private int tests_in_progress = 0;

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        AEDiagnostics.addEvidenceGenerator(this);
        try {
            this.ui = (UIAdapter)Class.forName("com.aelitis.azureus.core.pairing.impl.swt.PMSWTImpl").newInstance();
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        final UIManager ui_manager = default_pi.getUIManager();
        BasicPluginConfigModel configModel = ui_manager.createBasicPluginConfigModel("server", "Pairing");
        configModel.addHyperlinkParameter2("ConfigView.label.please.visit.here", MessageText.getString("ConfigView.section.connection.pairing.url"));
        this.param_enable = configModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String access_code = this.readAccessCode();
        this.param_ac_info = configModel.addInfoParameter2("pairing.accesscode", access_code);
        this.param_status_info = configModel.addInfoParameter2("pairing.status.info", "");
        this.param_last_error = configModel.addInfoParameter2("pairing.last.error", "");
        this.param_view = configModel.addHyperlinkParameter2("pairing.view.registered", SERVICE_URL + "/web/view?ac=" + access_code);
        if (access_code.length() == 0) {
            this.param_view.setEnabled(false);
        }
        COConfigurationManager.registerExportedParameter("pairing.enable", this.param_enable.getConfigKeyName());
        COConfigurationManager.registerExportedParameter("pairing.access_code", this.param_ac_info.getConfigKeyName());
        final ActionParameter ap = configModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        ap.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                try {
                    ap.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            ap.setEnabled(true);
                        }
                    });
                }
                catch (Throwable e) {
                    ap.setEnabled(true);
                    String details = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(e)});
                    ui_manager.showMessageBox("pairing.op.fail", "!" + details + "!", 1L);
                }
            }
        });
        LabelParameter param_srp_info = configModel.addLabelParameter2("pairing.srp.info");
        HyperlinkParameter param_srp_link = configModel.addHyperlinkParameter2("label.more.info.here", MessageText.getString("ConfigView.section.connection.pairing.srp.url"));
        this.param_srp_enable = configModel.addBooleanParameter2("pairing.srp.enable", "pairing.srp.enable", false);
        COConfigurationManager.registerExportedParameter("pairing.srp_enable", this.param_srp_enable.getConfigKeyName());
        this.param_srp_state = configModel.addLabelParameter2("");
        this.updateSRPState();
        final ActionParameter param_srp_set = configModel.addActionParameter2("pairing.srp.setpw", "pairing.srp.setpw.doit");
        param_srp_set.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                param_srp_set.setEnabled(false);
                new AEThread2("getpw"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (PairingManagerImpl.this.ui != null) {
                                char[] password = PairingManagerImpl.this.ui.getSRPPassword();
                                if (password != null) {
                                    PairingManagerImpl.this.tunnel_handler.setSRPPassword(password);
                                }
                            } else {
                                Debug.out("No UI available");
                            }
                            Object var3_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            param_srp_set.setEnabled(true);
                            throw throwable;
                        }
                        param_srp_set.setEnabled(true);
                    }
                }.start();
            }
        });
        this.param_srp_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                boolean active = PairingManagerImpl.this.param_srp_enable.getValue();
                PairingManagerImpl.this.tunnel_handler.setActive(active);
                PairingManagerImpl.this.updateSRPState();
            }
        });
        this.param_srp_enable.addEnabledOnSelection(this.param_srp_state);
        this.param_srp_enable.addEnabledOnSelection(param_srp_set);
        configModel.createGroup("pairing.group.srp", new Parameter[]{param_srp_info, param_srp_link, this.param_srp_enable, this.param_srp_state, param_srp_set});
        this.param_net_enable = configModel.addBooleanParameter2("pairing.nets.enable", "pairing.nets.enable", false);
        configModel.createGroup("pairing.group.optional", new Parameter[]{this.param_net_enable});
        LabelParameter param_e_info = configModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = configModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_public_ipv4 = configModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_public_ipv6 = configModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = configModel.addStringParameter2("pairing.host", "pairing.host", "");
        LabelParameter spacer = configModel.addLabelParameter2("blank.resource");
        this.param_local_ipv4 = configModel.addStringParameter2("pairing.local.ipv4", "pairing.local.ipv4", "");
        this.param_local_ipv6 = configModel.addStringParameter2("pairing.local.ipv6", "pairing.local.ipv6", "");
        this.param_public_ipv4.setGenerateIntermediateEvents(false);
        this.param_public_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener change_listener = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                PairingManagerImpl.this.updateNeeded();
                if (param == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(change_listener);
        this.param_e_enable.addListener(change_listener);
        this.param_public_ipv4.addListener(change_listener);
        this.param_public_ipv6.addListener(change_listener);
        this.param_local_ipv4.addListener(change_listener);
        this.param_local_ipv6.addListener(change_listener);
        this.param_host.addListener(change_listener);
        this.param_net_enable.addListener(change_listener);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_host);
        configModel.createGroup("pairing.group.explicit", new Parameter[]{param_e_info, this.param_e_enable, this.param_public_ipv4, this.param_public_ipv6, this.param_host, spacer, this.param_local_ipv4, this.param_local_ipv6});
        this.param_icon_enable = configModel.addBooleanParameter2("pairing.config.icon.show", "pairing.config.icon.show", true);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PairingManagerImpl.this.initialise(core);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore _core) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.azureus_core = _core;
        }
        try {
            this.tunnel_handler = new PairingManagerTunnelHandler(this, this.azureus_core);
            PluginInterface default_pi = PluginInitializer.getDefaultInterface();
            DelayedTask dt = default_pi.getUtilities().createDelayedTask(new Runnable(){

                public void run() {
                    new DelayedEvent("PM:delayinit", 10000L, new AERunnable(){

                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            dt.queue();
            if (this.ui != null) {
                try {
                    this.ui.initialise(default_pi, this.param_icon_enable);
                }
                catch (Throwable e) {
                }
            }
            Object var6_6 = null;
            this.init_sem.releaseForever();
            this.updateSRPState();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.init_sem.releaseForever();
            this.updateSRPState();
            throw throwable;
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.param_enable.setValue(enabled);
    }

    @Override
    public boolean isSRPEnabled() {
        return this.param_srp_enable.getValue();
    }

    @Override
    public void setSRPEnabled(boolean enabled) {
        this.param_srp_enable.setValue(enabled);
    }

    @Override
    public void setGroup(String group) {
        COConfigurationManager.setParameter("pairing.groupcode", group);
        this.updateNeeded();
    }

    @Override
    public String getGroup() {
        return COConfigurationManager.getStringParameter("pairing.groupcode", null);
    }

    @Override
    public List<PairedNode> listGroup() throws PairingException {
        try {
            URL url = new URL(SERVICE_URL + "/remote/listGroup?gc=" + this.getGroup());
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            Map json = JSONUtils.decodeJSON(new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8"));
            List list = (List)json.get("result");
            ArrayList<PairedNode> result = new ArrayList<PairedNode>();
            String my_ac = this.peekAccessCode();
            if (list != null) {
                for (Map m : list) {
                    PairedNodeImpl node = new PairedNodeImpl(m);
                    if (my_ac != null && my_ac.equals(node.getAccessCode())) continue;
                    result.add(node);
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to list group", e);
        }
    }

    @Override
    public List<PairedService> lookupServices(String access_code) throws PairingException {
        try {
            URL url = new URL(SERVICE_URL + "/remote/listBindings?ac=" + access_code + "&jsoncallback=");
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            String reply = new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8");
            reply = reply.substring(1, reply.length() - 1);
            Map json = JSONUtils.decodeJSON(reply);
            Map error = (Map)json.get("error");
            if (error != null) {
                throw new PairingException((String)error.get("msg"));
            }
            List list = (List)json.get("result");
            ArrayList<PairedService> result = new ArrayList<PairedService>();
            if (list != null) {
                for (Map m : list) {
                    result.add(new PairedService2Impl((String)m.get("sid"), m));
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to lookup services", e);
        }
    }

    protected void setStatus(String str) {
        String last_status = this.param_status_info.getValue();
        if (!last_status.equals(str)) {
            this.param_status_info.setValue(str);
            this.fireChanged();
        }
    }

    @Override
    public String getStatus() {
        return this.param_status_info.getValue();
    }

    @Override
    public String getSRPStatus() {
        if (!this.isSRPEnabled()) {
            return "Not enabled";
        }
        if (this.tunnel_handler == null) {
            return "Initialising";
        }
        return this.tunnel_handler.getStatus();
    }

    protected void setLastServerError(String error) {
        String last_error = this.param_last_error.getValue();
        if (error == null) {
            error = "";
        }
        if (!last_error.equals(error)) {
            this.param_last_error.setValue(error);
            if (error.contains("generate a new one")) {
                Logger.log(new LogAlert(true, 1, "The pairing access code is invalid.\n\nCreate a new one via Tools->Options->Connection->Pairing or disable the pairing feature."));
            }
            this.fireChanged();
        }
    }

    @Override
    public String getLastServerError() {
        String last_error = this.param_last_error.getValue();
        if (last_error.length() == 0) {
            last_error = null;
        }
        return last_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActionOutstanding() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (!this.isEnabled()) {
                return false;
            }
            return !this.updates_enabled || this.update_outstanding || this.deferred_update_event != null || this.update_in_progress;
        }
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String ac) {
        COConfigurationManager.setParameter("pairing.accesscode", ac);
        COConfigurationManager.save();
        this.param_ac_info.setValue(ac);
        this.param_view.setHyperlink(SERVICE_URL + "/web/view?ac=" + ac);
        this.param_view.setEnabled(ac.length() > 0);
    }

    private File receiveQR(String ac, Map<String, Object> response) {
        try {
            byte[] bytes = (byte[])response.get("qr_b");
            if (bytes == null) {
                return null;
            }
            long ver = (Long)response.get("qr_v");
            File cache_dir = new File(SystemProperties.getUserPath(), "cache");
            File qr_file = new File(cache_dir, "qr_" + ac + "_" + ver + ".png");
            if (FileUtil.writeBytesAsFile2(qr_file.getAbsolutePath(), bytes)) {
                return qr_file;
            }
            return null;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    @Override
    public File getQRCode() {
        File cache_dir;
        File qr_file;
        String existing = this.readAccessCode();
        if (existing == null) {
            return null;
        }
        if (this.qr_version > 0L && (qr_file = new File(cache_dir = new File(SystemProperties.getUserPath(), "cache"), "qr_" + existing + "_" + this.qr_version + ".png")).exists()) {
            return qr_file;
        }
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        request2.put("ac", existing);
        try {
            Map<String, Object> response = this.sendRequest("get_qr", request2);
            return this.receiveQR(existing, response);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected String allocateAccessCode(boolean updating) throws PairingException {
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        String existing = this.readAccessCode();
        request2.put("ac", existing);
        request2.put("qr", 1L);
        Map<String, Object> response = this.sendRequest("allocate", request2);
        try {
            String code = this.getString(response, "ac");
            this.receiveQR(code, response);
            this.writeAccessCode(code);
            if (!updating) {
                this.updateNeeded();
            }
            this.fireChanged();
            return code;
        }
        catch (Throwable e) {
            throw new PairingException("allocation failed", e);
        }
    }

    @Override
    public String peekAccessCode() {
        return this.readAccessCode();
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String ac = this.readAccessCode();
        if (ac == null || ac.length() == 0) {
            ac = this.allocateAccessCode(false);
        }
        return ac;
    }

    public void getAccessCode(final PairingManagerListener listener) throws PairingException {
        new AEThread2("PM:gac", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PairingManagerImpl.this.getAccessCode();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    listener.somethingChanged(PairingManagerImpl.this);
                    throw throwable;
                }
            }
        }.start();
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String new_code = this.allocateAccessCode(false);
        return new_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String sid, PairedServiceRequestHandler handler) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            if (result == null) {
                result = new PairedServiceImpl(sid, handler);
                this.services.put(sid, result);
            } else {
                result.setHandler(handler);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedServiceImpl getService(String sid) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl service) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String sid = service.getSID();
            if (this.services.remove(sid) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl service) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress current, InetAddress latest, boolean v6) {
        if (v6 ? latest instanceof Inet4Address : latest instanceof Inet6Address) {
            return current;
        }
        if (current == latest) {
            return current;
        }
        if (current == null || latest == null) {
            return latest;
        }
        if (!current.equals(latest)) {
            return latest;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void updateGlobals(boolean is_updating) {
        final long now = SystemTime.getMonotonousTime();
        NetworkAdmin network_admin = NetworkAdmin.getSingleton();
        InetAddress latest_v4 = this.azureus_core.getInstanceManager().getMyInstance().getExternalAddress();
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            Object sem;
            void var17_20;
            HashSet<String> existing_checked;
            InetAddress temp_v4 = this.updateAddress(this.current_v4, latest_v4, false);
            InetAddress latest_v6 = network_admin.getDefaultPublicAddressV6();
            InetAddress temp_v6 = this.updateAddress(this.current_v6, latest_v6, true);
            final TreeSet<String> latest_v4_locals = new TreeSet<String>();
            final TreeSet<String> latest_v6_locals = new TreeSet<String>();
            NetworkAdminNetworkInterface[] interfaces = network_admin.getInterfaces();
            ArrayList<8> to_do = new ArrayList<8>();
            Map<String, Object[]> map = this.local_address_checks;
            synchronized (map) {
                existing_checked = new HashSet<String>(this.local_address_checks.keySet());
            }
            NetworkAdminNetworkInterface[] arr$ = interfaces;
            int len$ = arr$.length;
            boolean bl = false;
            while (var17_20 < len$) {
                NetworkAdminNetworkInterfaceAddress[] addresses;
                NetworkAdminNetworkInterface intf = arr$[var17_20];
                for (NetworkAdminNetworkInterfaceAddress address : addresses = intf.getAddresses()) {
                    boolean run_check;
                    Object[] check;
                    final InetAddress ia = address.getAddress();
                    if (ia.isLoopbackAddress() || !ia.isLinkLocalAddress() && !ia.isSiteLocalAddress()) continue;
                    final String a_str = ia.getHostAddress();
                    existing_checked.remove(a_str);
                    Map<String, Object[]> map2 = this.local_address_checks;
                    synchronized (map2) {
                        check = this.local_address_checks.get(a_str);
                    }
                    boolean bl2 = run_check = check == null || now - (Long)check[0] > 1800000L;
                    if (run_check) {
                        to_do.add(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Socket socket = new Socket();
                                String result = a_str;
                                try {
                                    socket.bind(new InetSocketAddress(ia, 0));
                                    socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                                    result = result + "*";
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        });
                        continue;
                    }
                    if (ia instanceof Inet4Address) {
                        latest_v4_locals.add((String)check[1]);
                        continue;
                    }
                    latest_v6_locals.add((String)check[1]);
                }
                ++var17_20;
            }
            if (to_do.size() > 0) {
                sem = new AESemaphore("PM:check");
                for (final Runnable runnable : to_do) {
                    new AEThread2("PM:check:", true, (AESemaphore)sem){
                        final /* synthetic */ AESemaphore val$sem;
                        {
                            this.val$sem = aESemaphore;
                            super(x0, x1);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                runnable.run();
                                Object var2_1 = null;
                                this.val$sem.release();
                            }
                            catch (Throwable throwable) {
                                Object var2_2 = null;
                                this.val$sem.release();
                                throw throwable;
                            }
                        }
                    }.start();
                }
                for (int i = 0; i < to_do.size(); ++i) {
                    ((AESemaphore)sem).reserve();
                }
            }
            sem = this.local_address_checks;
            synchronized (sem) {
                for (String string : existing_checked) {
                    this.local_address_checks.remove(string);
                }
            }
            String v4_locals_str = this.getString(latest_v4_locals);
            String v6_locals_str = this.getString(latest_v6_locals);
            if (temp_v4 != this.current_v4 || temp_v6 != this.current_v6 || !v4_locals_str.equals(this.local_v4) || !v6_locals_str.equals(this.local_v6)) {
                this.current_v4 = temp_v4;
                this.current_v6 = temp_v6;
                this.local_v4 = v4_locals_str;
                this.local_v6 = v6_locals_str;
                if (!is_updating) {
                    this.updateNeeded();
                }
            }
        }
    }

    protected String getString(Set<String> set) {
        String str = "";
        for (String s : set) {
            str = str + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpdate() {
        block60: {
            PairingManagerImpl pairingManagerImpl;
            block58: {
                long now = SystemTime.getMonotonousTime();
                PairingManagerImpl pairingManagerImpl2 = this;
                synchronized (pairingManagerImpl2) {
                    if (this.deferred_update_event != null) {
                        return;
                    }
                    long time_since_last_update = now - this.last_update_time;
                    if (this.last_update_time > 0L && time_since_last_update < (long)this.min_update_period) {
                        this.deferUpdate((long)this.min_update_period - time_since_last_update);
                        return;
                    }
                    this.update_in_progress = true;
                }
                try {
                    try {
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        boolean is_enabled = this.param_enable.getValue();
                        boolean has_services = false;
                        PairingManagerImpl pairingManagerImpl3 = this;
                        synchronized (pairingManagerImpl3) {
                            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                            payload.put("s", list);
                            if (this.services.size() > 0 && is_enabled) {
                                if (this.global_update_event == null) {
                                    this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                                        private int tick_count;

                                        public void perform(TimerEvent event2) {
                                            ++this.tick_count;
                                            PairingManagerImpl.this.updateGlobals(false);
                                            if (this.tick_count % 1380 == 0) {
                                                PairingManagerImpl.this.updateNeeded();
                                            }
                                        }
                                    });
                                    this.updateGlobals(true);
                                }
                                boolean enable_nets = this.param_net_enable.getValue();
                                for (PairedServiceImpl service : this.services.values()) {
                                    list.add(service.toMap(enable_nets));
                                }
                                has_services = list.size() > 0;
                            } else if (this.global_update_event == null) {
                                if (this.consec_update_fails == 0 && !this.must_update_once) {
                                    this.update_in_progress = false;
                                    this.setStatus(MessageText.getString(is_enabled ? "pairing.status.noservices" : "pairing.status.disabled"));
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 53, 55, 56, 15] lbl41 : MonitorExitStatement: MONITOREXIT : var6_9
                                    Object var26_18 = null;
                                    pairingManagerImpl = this;
                                    break block58;
                                }
                            } else {
                                this.global_update_event.cancel();
                                this.global_update_event = null;
                            }
                            this.last_update_time = now;
                        }
                        String ac = this.readAccessCode();
                        if (ac.length() == 0) {
                            ac = this.allocateAccessCode(true);
                        }
                        payload.put("ac", ac);
                        String gc = this.getGroup();
                        if (gc != null && gc.length() > 0) {
                            payload.put("gc", gc);
                        }
                        if (is_enabled && has_services && this.param_srp_enable.getValue()) {
                            this.tunnel_handler.setActive(true);
                            this.tunnel_handler.updateRegistrationData(payload);
                        } else {
                            this.tunnel_handler.setActive(false);
                        }
                        PairingManagerImpl pairingManagerImpl4 = this;
                        synchronized (pairingManagerImpl4) {
                            block59: {
                                if (this.current_v4 != null) {
                                    payload.put("c_v4", this.current_v4.getHostAddress());
                                }
                                if (this.current_v6 != null) {
                                    payload.put("c_v6", this.current_v6.getHostAddress());
                                }
                                if (this.local_v4.length() > 0) {
                                    payload.put("l_v4", this.local_v4);
                                }
                                if (this.local_v6.length() > 0) {
                                    payload.put("l_v6", this.local_v6);
                                }
                                if (this.param_e_enable.getValue()) {
                                    String l_v6;
                                    String l_v4;
                                    String v6;
                                    String v4;
                                    String host = this.param_host.getValue().trim();
                                    if (host.length() > 0) {
                                        payload.put("e_h", host);
                                    }
                                    if ((v4 = this.param_public_ipv4.getValue().trim()).length() > 0) {
                                        payload.put("e_v4", v4);
                                    }
                                    if ((v6 = this.param_public_ipv6.getValue().trim()).length() > 0) {
                                        payload.put("e_v6", v6);
                                    }
                                    if ((l_v4 = this.param_local_ipv4.getValue().trim()).length() > 0) {
                                        payload.put("e_l_v4", l_v4);
                                    }
                                    if ((l_v6 = this.param_local_ipv6.getValue().trim()).length() > 0) {
                                        payload.put("e_l_v6", l_v6);
                                    }
                                }
                                try {
                                    UPnPPlugin upnp;
                                    PluginInterface pi_upnp = this.azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                                    if (pi_upnp == null || !(upnp = (UPnPPlugin)pi_upnp.getPlugin()).isEnabled()) break block59;
                                    ArrayList upnp_list = new ArrayList();
                                    payload.put("upnp", upnp_list);
                                    UPnPPluginService[] services = upnp.getServices();
                                    HashSet<UPnPRootDevice> devices = new HashSet<UPnPRootDevice>();
                                    for (UPnPPluginService service : services) {
                                        if (upnp_list.size() <= 10) {
                                            UPnPRootDevice root_device = service.getService().getGenericService().getDevice().getRootDevice();
                                            if (devices.contains(root_device)) continue;
                                            devices.add(root_device);
                                            HashMap<String, String> map = new HashMap<String, String>();
                                            upnp_list.add(map);
                                            map.put("i", root_device.getInfo());
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            try {
                                NetworkAdminSocksProxy[] socks_proxies;
                                NetworkAdmin admin = NetworkAdmin.getSingleton();
                                NetworkAdminHTTPProxy http_proxy = admin.getHTTPProxy();
                                if (http_proxy != null) {
                                    payload.put("hp", http_proxy.getName());
                                }
                                if ((socks_proxies = admin.getSocksProxies()).length > 0) {
                                    payload.put("sp", socks_proxies[0].getName());
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            payload.put("_enabled", is_enabled ? 1L : 0L);
                        }
                        this.sendRequest("update", payload);
                        pairingManagerImpl4 = this;
                        synchronized (pairingManagerImpl4) {
                            this.consec_update_fails = 0;
                            this.must_update_once = false;
                            if (this.deferred_update_event == null) {
                                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                            }
                            this.update_in_progress = false;
                            if (this.global_update_event == null) {
                                this.setStatus(MessageText.getString(is_enabled ? "pairing.status.noservices" : "pairing.status.disabled"));
                            } else {
                                this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                            }
                            break block60;
                        }
                    }
                    catch (Throwable e) {
                        PairingManagerImpl pairingManagerImpl5 = this;
                        synchronized (pairingManagerImpl5) {
                            try {
                                ++this.consec_update_fails;
                                long back_off = this.min_update_period;
                                for (int i = 0; i < this.consec_update_fails; ++i) {
                                    if ((back_off *= 2L) <= (long)this.max_update_period) continue;
                                    back_off = this.max_update_period;
                                    break;
                                }
                                this.deferUpdate(back_off);
                                Object var23_35 = null;
                                this.update_in_progress = false;
                            }
                            catch (Throwable throwable) {
                                Object var23_36 = null;
                                this.update_in_progress = false;
                                throw throwable;
                            }
                        }
                        Object var26_20 = null;
                        PairingManagerImpl pairingManagerImpl6 = this;
                        synchronized (pairingManagerImpl6) {
                            if (!this.update_in_progress) return;
                            Debug.out("Something didn't clear update_in_progress!!!!");
                            this.update_in_progress = false;
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var26_21 = null;
                    PairingManagerImpl pairingManagerImpl7 = this;
                    synchronized (pairingManagerImpl7) {
                        if (!this.update_in_progress) throw throwable;
                        Debug.out("Something didn't clear update_in_progress!!!!");
                        this.update_in_progress = false;
                        throw throwable;
                    }
                }
            }
            synchronized (pairingManagerImpl) {
                if (!this.update_in_progress) return;
                Debug.out("Something didn't clear update_in_progress!!!!");
                this.update_in_progress = false;
                return;
            }
        }
        Object var26_19 = null;
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (!this.update_in_progress) return;
            Debug.out("Something didn't clear update_in_progress!!!!");
            this.update_in_progress = false;
            return;
        }
    }

    protected void deferUpdate(long millis) {
        long target = SystemTime.getOffsetTime(millis += 5000L);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", target, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(target))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String command, Map<String, Object> payload) throws PairingException {
        try {
            String error;
            HashMap<String, Map<String, Object>> request2 = new HashMap<String, Map<String, Object>>();
            CryptoManager cman = CryptoManagerFactory.getSingleton();
            String azid = Base32.encode(cman.getSecureID());
            payload.put("_azid", azid);
            try {
                String pk = Base32.encode(cman.getECCHandler().getPublicKey("pairing"));
                payload.put("_pk", pk);
            }
            catch (Throwable e) {
                // empty catch block
            }
            request2.put("req", payload);
            String request_str = Base32.encode(BEncoder.encode(request2));
            String sig = null;
            try {
                sig = Base32.encode(cman.getECCHandler().sign(request_str.getBytes("UTF-8"), "pairing"));
            }
            catch (Throwable e) {
                // empty catch block
            }
            String other_params = "&ver=" + UrlUtils.encode("5.7.3.0") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            if (sig != null) {
                other_params = other_params + "&sig=" + sig;
            }
            URL target = new URL(SERVICE_URL + "/client/" + command + "?request=" + request_str + other_params);
            Properties http_properties = new Properties();
            http_properties.put("URL", target);
            try {
                ClientIDManagerImpl.getSingleton().generateHTTPProperties(null, http_properties);
            }
            catch (ClientIDException e) {
                throw new IOException(e.getMessage());
            }
            target = (URL)http_properties.get("URL");
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setConnectTimeout(30000);
            InputStream is = connection.getInputStream();
            Map<String, Object> response = BDecoder.decode(new BufferedInputStream(is));
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                Long max_retry;
                Long min_retry = (Long)response.get("min_secs");
                if (min_retry != null) {
                    this.min_update_period = min_retry.intValue() * 1000;
                }
                if ((max_retry = (Long)response.get("max_secs")) != null) {
                    this.max_update_period = max_retry.intValue() * 1000;
                }
            }
            final String message = this.getString(response, "message");
            if (!(message == null || this.last_message != null && this.last_message.equals(message))) {
                this.last_message = message;
                try {
                    byte[] message_sig = (byte[])response.get("message_sig");
                    AEVerifier.verifyData(message, message_sig);
                    new AEThread2("PairMsg", true){

                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            if (ui_manager != null) {
                                ui_manager.showMessageBox("pairing.server.warning.title", "!" + message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((error = this.getString(response, "error")) != null) {
                throw new PairingException(error);
            }
            this.setLastServerError(null);
            Map reply = (Map)response.get("rep");
            Long qr_v = (Long)reply.get("qr_v");
            if (qr_v != null && this.qr_version != qr_v) {
                this.qr_version = qr_v;
                COConfigurationManager.setParameter("pairing.qr.ver", this.qr_version);
            }
            return reply;
        }
        catch (Throwable e) {
            this.setLastServerError(Debug.getNestedExceptionMessage(e));
            if (e instanceof PairingException) {
                throw (PairingException)e;
            }
            throw new PairingException("invocation failed", e);
        }
    }

    @Override
    public PairingTest testService(String sid, PairingTestListener listener) throws PairingException {
        return new TestServiceImpl(sid, listener);
    }

    protected void updateSRPState() {
        String text = this.param_srp_enable.getValue() ? (this.tunnel_handler == null ? MessageText.getString("pairing.status.initialising") + "..." : this.tunnel_handler.getStatus()) : MessageText.getString("MyTorrentsView.menu.setSpeed.disabled");
        this.param_srp_state.setLabelText(MessageText.getString("pairing.srp.state", new String[]{text}));
    }

    @Override
    public void setSRPPassword(char[] password) {
        this.init_sem.reserve();
        this.tunnel_handler.setSRPPassword(password);
    }

    @Override
    public boolean handleLocalTunnel(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        this.init_sem.reserve();
        return this.tunnel_handler.handleLocalTunnel(request2, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordRequest(String name, String ip, boolean good) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.tests_in_progress > 0) {
                return;
            }
        }
        if (this.ui != null) {
            try {
                this.ui.recordRequest(name, ip, good);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    protected void fireChanged() {
        for (PairingManagerListener l : this.listeners) {
            try {
                l.somethingChanged(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PairingManagerListener l) {
        this.listeners.remove(l);
    }

    protected String getString(Map<String, Object> map, String name) throws IOException {
        byte[] bytes = (byte[])map.get(name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Pairing Manager");
        try {
            writer.indent();
            if (this.tunnel_handler != null) {
                this.tunnel_handler.generateEvidence(writer);
            }
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    static /* synthetic */ Map access$400(PairingManagerImpl x0) {
        return x0.local_address_checks;
    }

    static {
        String url = System.getProperty("az.pairing.url", "");
        SERVICE_URL = url.length() == 0 ? "https://pair.vuze.com/pairing" : url;
        singleton = new PairingManagerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PairedNodeImpl
    implements PairedNode {
        private Map map;

        protected PairedNodeImpl(Map _map) {
            this.map = _map;
        }

        @Override
        public String getAccessCode() {
            return (String)this.map.get("ac");
        }

        @Override
        public List<InetAddress> getAddresses() {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            this.addAddress(addresses, "c_v4");
            this.addAddress(addresses, "c_v6");
            this.addAddress(addresses, "l_v4");
            this.addAddress(addresses, "l_v6");
            this.addAddress(addresses, "e_v4");
            this.addAddress(addresses, "e_v6");
            this.addAddress(addresses, "e_l_v4");
            this.addAddress(addresses, "e_l_v6");
            this.addAddress(addresses, "e_h");
            return new ArrayList<InetAddress>(addresses);
        }

        private void addAddress(Set<InetAddress> addresses, String key) {
            String str = (String)this.map.get(key);
            if (str != null) {
                String[] bits;
                for (String bit : bits = str.split(",")) {
                    if ((bit = bit.trim()).length() == 0) continue;
                    if (bit.endsWith("*")) {
                        bit = bit.substring(0, bit.length() - 1);
                    }
                    try {
                        addresses.add(InetAddress.getByName(bit));
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public List<PairedService> getServices() {
            Map smap = (Map)this.map.get("services");
            ArrayList<PairedService> services = new ArrayList<PairedService>();
            for (Map.Entry entry : smap.entrySet()) {
                services.add(new PairedService2Impl((String)entry.getKey(), (Map)entry.getValue()));
            }
            return services;
        }
    }

    private class PairedService2Impl
    implements PairedService {
        private String sid;
        private Map map;

        protected PairedService2Impl(String _sid, Map _map) {
            this.sid = _sid;
            this.map = _map;
        }

        public String getSID() {
            return this.sid;
        }

        public PairingConnectionData getConnectionData() {
            return new PairingConnectionData2(this.map);
        }

        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private String sid;
        private Map<String, String> attributes = new HashMap<String, String>();
        private PairedServiceRequestHandler request_handler;

        protected PairedServiceImpl(String _sid, PairedServiceRequestHandler _request_handler) {
            this.sid = _sid;
            this.request_handler = _request_handler;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        protected void setHandler(PairedServiceRequestHandler _h) {
            this.request_handler = _h;
        }

        protected PairedServiceRequestHandler getHandler() {
            return this.request_handler;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String name, String value) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                if (value == null) {
                    this.attributes.remove(name);
                } else {
                    this.attributes.put(name, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAttribute(String name) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                return this.attributes.get(name);
            }
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap(boolean enable_nets) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                result.putAll(this.attributes);
            }
            if (!enable_nets) {
                result.remove("I2P");
                result.remove("Tor");
            }
            return result;
        }
    }

    private class PairingConnectionData2
    implements PairingConnectionData {
        private Map map;

        protected PairingConnectionData2(Map _map) {
            this.map = _map;
        }

        public void setAttribute(String name, String value) {
            throw new RuntimeException("Not supported");
        }

        public String getAttribute(String name) {
            return (String)this.map.get(name);
        }

        public void sync() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class TestServiceImpl
    implements PairingTest {
        private final String sid;
        private final PairingTestListener listener;
        private volatile int outcome = 0;
        private volatile String error_message;
        private volatile boolean cancelled;

        protected TestServiceImpl(String _sid, PairingTestListener _listener) {
            this.sid = _sid;
            this.listener = _listener;
            new AEThread2("PM:test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    try {
                        try {
                            block36: {
                                String access_code;
                                block35: {
                                    access_code = null;
                                    long sid_wait_start = -1L;
                                    do {
                                        if (!PairingManagerImpl.this.isEnabled()) {
                                            throw new Exception("Pairing is disabled");
                                        }
                                        access_code = PairingManagerImpl.this.peekAccessCode();
                                        if (access_code != null && !PairingManagerImpl.this.hasActionOutstanding()) {
                                            if (PairingManagerImpl.this.getService(TestServiceImpl.this.sid) != null) break block35;
                                            long now = SystemTime.getMonotonousTime();
                                            if (sid_wait_start == -1L) {
                                                sid_wait_start = now;
                                            } else if (now - sid_wait_start > 5000L) break block35;
                                        }
                                        Thread.sleep(500L);
                                    } while (!TestServiceImpl.this.cancelled);
                                    TestServiceImpl.this.outcome = 6;
                                    Object var12_6 = null;
                                    try {
                                        TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                        Object var14_10 = null;
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        // MONITORENTER : pairingManagerImpl
                                        PairingManagerImpl.this.tests_in_progress--;
                                        // MONITOREXIT : pairingManagerImpl
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        Object var14_11 = null;
                                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                        // MONITORENTER : pairingManagerImpl
                                        PairingManagerImpl.this.tests_in_progress--;
                                        // MONITOREXIT : pairingManagerImpl
                                        throw throwable;
                                    }
                                }
                                PairedServiceImpl service = PairingManagerImpl.this.getService(TestServiceImpl.this.sid);
                                if (service == null) {
                                    throw new Exception("Service not found");
                                }
                                TestServiceImpl.this.listener.testStarted(TestServiceImpl.this);
                                String other_params = "&ver=" + UrlUtils.encode("5.7.3.0") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
                                URL target = new URL(SERVICE_URL + "/web/test?sid=" + TestServiceImpl.this.sid + "&ac=" + access_code + "&format=bencode" + other_params);
                                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                                connection.setConnectTimeout(10000);
                                try {
                                    PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                    // MONITORENTER : pairingManagerImpl
                                    PairingManagerImpl.this.tests_in_progress++;
                                    // MONITOREXIT : pairingManagerImpl
                                    InputStream is = connection.getInputStream();
                                    Map response = BDecoder.decode(new BufferedInputStream(is));
                                    response = BDecoder.decodeStrings(response);
                                    Long code = (Long)response.get("code");
                                    if (code == null) {
                                        throw new Exception("Code missing from reply");
                                    }
                                    TestServiceImpl.this.error_message = (String)response.get("msg");
                                    if (code == 1L) {
                                        TestServiceImpl.this.outcome = 1;
                                        break block36;
                                    }
                                    if (code == 2L) {
                                        TestServiceImpl.this.outcome = 4;
                                        break block36;
                                    }
                                    if (code == 3L) {
                                        TestServiceImpl.this.outcome = 5;
                                        break block36;
                                    }
                                    if (code == 4L) {
                                        TestServiceImpl.this.outcome = 2;
                                        TestServiceImpl.this.error_message = "Connect timeout";
                                        break block36;
                                    }
                                    if (code == 5L) {
                                        TestServiceImpl.this.outcome = 2;
                                    } else {
                                        TestServiceImpl.this.outcome = 5;
                                        TestServiceImpl.this.error_message = "Unknown response code " + code;
                                    }
                                }
                                catch (SocketTimeoutException e) {
                                    TestServiceImpl.this.outcome = 3;
                                    TestServiceImpl.this.error_message = "Connect timeout";
                                }
                            }
                            Object var12_7 = null;
                        }
                        catch (Throwable e) {
                            TestServiceImpl.this.outcome = 3;
                            TestServiceImpl.this.error_message = Debug.getNestedExceptionMessage(e);
                            Object var12_8 = null;
                            try {}
                            catch (Throwable throwable) {
                                Object var14_15 = null;
                                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                                // MONITORENTER : pairingManagerImpl
                                PairingManagerImpl.this.tests_in_progress--;
                                // MONITOREXIT : pairingManagerImpl
                                throw throwable;
                            }
                            TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                            Object var14_14 = null;
                            PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                            // MONITORENTER : pairingManagerImpl
                            PairingManagerImpl.this.tests_in_progress--;
                            // MONITOREXIT : pairingManagerImpl
                            return;
                        }
                        try {}
                        catch (Throwable throwable) {
                            Object var14_13 = null;
                            PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                            // MONITORENTER : pairingManagerImpl
                            PairingManagerImpl.this.tests_in_progress--;
                            // MONITOREXIT : pairingManagerImpl
                            throw throwable;
                        }
                        TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                        Object var14_12 = null;
                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                        // MONITORENTER : pairingManagerImpl
                        PairingManagerImpl.this.tests_in_progress--;
                        // MONITOREXIT : pairingManagerImpl
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var12_9 = null;
                        try {}
                        catch (Throwable throwable2) {
                            Object var14_17 = null;
                            PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                            // MONITORENTER : pairingManagerImpl
                            PairingManagerImpl.this.tests_in_progress--;
                            // MONITOREXIT : pairingManagerImpl
                            throw throwable2;
                        }
                        TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                        Object var14_16 = null;
                        PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                        // MONITORENTER : pairingManagerImpl
                        PairingManagerImpl.this.tests_in_progress--;
                        // MONITOREXIT : pairingManagerImpl
                        throw throwable;
                    }
                }
            }.start();
        }

        public int getOutcome() {
            return this.outcome;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface UIAdapter {
        public void initialise(PluginInterface var1, BooleanParameter var2);

        public void recordRequest(String var1, String var2, boolean var3);

        public char[] getSRPPassword();
    }
}

