/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.DownloadingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.SeedingUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import org.gudy.azureus2.core3.util.Debug;

public class UnchokerFactory {
    public static final String DEFAULT_MANAGER = "com.aelitis.azureus.core.peermanager.unchoker.UnchokerFactory";
    private static UnchokerFactory factory = UnchokerFactory.getSingleton(null);

    public static UnchokerFactory getSingleton() {
        return factory;
    }

    private static UnchokerFactory getSingleton(String explicit_implementation) {
        String impl = explicit_implementation;
        if (impl == null) {
            impl = System.getProperty(DEFAULT_MANAGER);
        }
        if (impl == null) {
            impl = DEFAULT_MANAGER;
        }
        try {
            Class<?> impl_class = UnchokerFactory.class.getClassLoader().loadClass(impl);
            factory = (UnchokerFactory)impl_class.newInstance();
        }
        catch (Throwable e) {
            Debug.out("Failed to instantiate unchoker factory '" + impl + "'", e);
            factory = new UnchokerFactory();
        }
        return factory;
    }

    public Unchoker getUnchoker(boolean seeding) {
        if (seeding) {
            return new SeedingUnchoker();
        }
        return new DownloadingUnchoker();
    }
}

