/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.uploadslots.UploadHelper;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSession;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSessionPicker;
import com.aelitis.azureus.core.peermanager.uploadslots.UploadSlot;
import java.util.LinkedList;

public class UploadSlotManager {
    private static final int EXPIRE_NORMAL = 1;
    private static final int EXPIRE_OPTIMISTIC = 3;
    private static final int EXPIRE_SEED = 6;
    public static final boolean AUTO_SLOT_ENABLE = false;
    private long last_process_time;
    private static final UploadSlotManager instance = new UploadSlotManager();
    private final UploadSessionPicker picker = new UploadSessionPicker();
    private final UploadSlot[] slots = new UploadSlot[]{new UploadSlot(1), new UploadSlot(0), new UploadSlot(0), new UploadSlot(0)};
    private long current_round = 0L;
    int count = 0;

    public static UploadSlotManager getSingleton() {
        return instance;
    }

    private UploadSlotManager() {
    }

    public void registerHelper(UploadHelper helper) {
    }

    public void deregisterHelper(UploadHelper helper) {
    }

    public void updateHelper(UploadHelper helper) {
    }

    private void process() {
    }

    private UploadSession getNextBestSession(LinkedList best) {
        ++this.count;
        System.out.print("getNextBestSession [" + this.count + "] best.size=" + best.size() + "  ");
        if (!best.isEmpty()) {
            UploadSession session = (UploadSession)best.removeFirst();
            if (!this.isAlreadySlotted(session)) {
                System.out.println("OK found session [" + session.getStatsTrace() + "]");
                return session;
            }
            System.out.println("FAIL already-slotted session [" + session.getStatsTrace() + "]");
            return this.getNextBestSession(best);
        }
        return null;
    }

    private UploadSession pickOptSession() {
        int max = this.picker.getHelperCount();
        for (int i = 0; i < max; ++i) {
            UploadSession session = this.picker.pickNextOptimisticSession();
            if (session == null || this.isAlreadySlotted(session)) continue;
            return session;
        }
        return null;
    }

    private boolean isAlreadySlotted(UploadSession session) {
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSession s = this.slots[i].getSession();
            if (s == null || !s.isSameSession(session)) continue;
            return true;
        }
        return false;
    }

    private void printSlotStats() {
        System.out.println("\nUPLOAD SLOTS [" + this.current_round + "x]:");
        for (int i = 0; i < this.slots.length; ++i) {
            UploadSlot slot = this.slots[i];
            System.out.print("[" + i + "]: ");
            String slot_type = slot.getSlotType() == 0 ? "NORM" : "OPTI";
            long rem = slot.getExpireRound() - this.current_round;
            String remaining = rem < 0L ? "" : " [" + rem + "]rr";
            String ses_trace = slot.getSession() == null ? "EMPTY" : slot.getSession().getStatsTrace();
            System.out.println(slot_type + remaining + " : " + ses_trace);
        }
    }
}

