/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.impl.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.proxy.impl.AEProxySelectorImpl;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class AEProxySelectorSWTImpl {
    private AzureusCore core;
    private AEProxySelectorImpl proxy_selector;
    private UISWTStatusEntry status;
    private Image icon_grey;
    private Image icon_green;
    private Image icon_yellow;
    private Image icon_red;
    private Image last_icon;
    private boolean flag_incoming;
    private long last_bad_peer_update;
    private volatile boolean is_visible;

    public AEProxySelectorSWTImpl(AzureusCore _core, AEProxySelectorImpl _proxy_selector) {
        COConfigurationManager.addAndFireParameterListener("Proxy.SOCKS.ShowIcon.FlagIncoming", new ParameterListener(){

            public void parameterChanged(String name) {
                AEProxySelectorSWTImpl.this.flag_incoming = COConfigurationManager.getBooleanParameter(name);
            }
        });
        this.core = _core;
        this.proxy_selector = _proxy_selector;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        default_pi.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(final UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getUIUpdater().addListener(new UIUpdater.UIUpdaterListener(){

                            public void updateComplete(int count) {
                                AEProxySelectorSWTImpl.this.updateStatus();
                            }
                        });
                    }
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            AEProxySelectorSWTImpl.this.icon_grey = imageLoader.getImage("grayled");
                            AEProxySelectorSWTImpl.this.icon_yellow = imageLoader.getImage("yellowled");
                            AEProxySelectorSWTImpl.this.icon_green = imageLoader.getImage("greenled");
                            AEProxySelectorSWTImpl.this.icon_red = imageLoader.getImage("redled");
                            UISWTInstance ui_instance = (UISWTInstance)instance;
                            AEProxySelectorSWTImpl.this.status = ui_instance.createStatusEntry();
                            AEProxySelectorSWTImpl.this.status.setText("SOCKS");
                            AEProxySelectorSWTImpl.this.status.setImageEnabled(true);
                            AEProxySelectorSWTImpl.this.status.setImage(AEProxySelectorSWTImpl.this.icon_grey);
                            String icon_param = "Proxy.SOCKS.ShowIcon";
                            boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                            boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                            AEProxySelectorSWTImpl.this.is_visible = enable_proxy && enable_socks && COConfigurationManager.getBooleanParameter("Proxy.SOCKS.ShowIcon");
                            AEProxySelectorSWTImpl.this.status.setVisible(AEProxySelectorSWTImpl.this.is_visible);
                            if (AEProxySelectorSWTImpl.this.is_visible) {
                                AEProxySelectorSWTImpl.this.updateStatus();
                            }
                            final MenuItem mi_show = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "pairing.ui.icon.show");
                            mi_show.setStyle(2);
                            mi_show.setData(new Boolean(AEProxySelectorSWTImpl.this.is_visible));
                            mi_show.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    COConfigurationManager.setParameter("Proxy.SOCKS.ShowIcon", false);
                                }
                            });
                            COConfigurationManager.addParameterListener(new String[]{"Enable.Proxy", "Enable.SOCKS", "Proxy.SOCKS.ShowIcon"}, new ParameterListener(){

                                public void parameterChanged(String parameterName) {
                                    boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
                                    boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
                                    AEProxySelectorSWTImpl.this.is_visible = enable_proxy && enable_socks && COConfigurationManager.getBooleanParameter("Proxy.SOCKS.ShowIcon");
                                    AEProxySelectorSWTImpl.this.status.setVisible(AEProxySelectorSWTImpl.this.is_visible);
                                    mi_show.setData(new Boolean(AEProxySelectorSWTImpl.this.is_visible));
                                    if (AEProxySelectorSWTImpl.this.is_visible) {
                                        AEProxySelectorSWTImpl.this.updateStatus();
                                    }
                                }
                            });
                            MenuItem mi_sep = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "");
                            mi_sep.setStyle(4);
                            MenuItem mi_options = default_pi.getUIManager().getMenuManager().addMenuItem(AEProxySelectorSWTImpl.this.status.getMenuContext(), "MainWindow.menu.view.configuration");
                            mi_options.addListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "proxy");
                                    }
                                }
                            });
                            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                                public void entryClicked(UISWTStatusEntry entry) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TransferStatsView");
                                    }
                                }
                            };
                            AEProxySelectorSWTImpl.this.status.setListener(click_listener);
                        }
                    });
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void updateStatus() {
        String tip_key;
        Image icon;
        if (!this.is_visible) {
            return;
        }
        Proxy active_proxy = this.proxy_selector.getActiveProxy();
        long now = SystemTime.getMonotonousTime();
        if (active_proxy == null) {
            icon = this.icon_grey;
            tip_key = "label.inactive";
        } else {
            long last_con = this.proxy_selector.getLastConnectionTime();
            long last_fail = this.proxy_selector.getLastFailTime();
            long con_ago = now - last_con;
            long fail_ago = now - last_fail;
            if (last_fail < 0L) {
                icon = this.icon_green;
                tip_key = "PeerManager.status.ok";
            } else if (fail_ago > 60000L) {
                if (con_ago < fail_ago) {
                    icon = this.icon_green;
                    tip_key = "PeerManager.status.ok";
                } else {
                    icon = this.icon_grey;
                    tip_key = "PeersView.state.pending";
                }
            } else {
                icon = this.icon_yellow;
                tip_key = "label.con_prob";
            }
        }
        if (this.flag_incoming) {
            boolean bad_incoming = false;
            if (now - this.last_bad_peer_update > 15000L) {
                this.last_bad_peer_update = now;
                List<DownloadManager> dms = this.core.getGlobalManager().getDownloadManagers();
                for (DownloadManager dm : dms) {
                    PEPeerManager pm = dm.getPeerManager();
                    if (pm != null && pm.getNbRemoteTCPConnections() + pm.getNbRemoteUDPConnections() + pm.getNbRemoteUTPConnections() > 0) {
                        List<PEPeer> peers = pm.getPeers();
                        for (PEPeer peer : peers) {
                            if (!peer.isIncoming() || peer.isLANLocal()) continue;
                            try {
                                if (InetAddress.getByAddress(HostNameToIPResolver.hostAddressToBytes(peer.getIp())).isLoopbackAddress()) {
                                    continue;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            bad_incoming = true;
                            break;
                        }
                    }
                    if (!bad_incoming) continue;
                    break;
                }
            } else if (this.last_icon == this.icon_red) {
                bad_incoming = true;
            }
            if (bad_incoming) {
                icon = this.icon_red;
                tip_key = "proxy.socks.bad.incoming";
            }
        }
        if (this.last_icon != icon) {
            final Image f_icon = icon;
            final String f_key = tip_key;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    AEProxySelectorSWTImpl.this.last_icon = f_icon;
                    AEProxySelectorSWTImpl.this.status.setImage(f_icon);
                    AEProxySelectorSWTImpl.this.status.setTooltipText(MessageText.getString("proxy.socks.ui.icon.tip", new String[]{MessageText.getString(f_key)}));
                }
            });
        }
    }
}

