/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import org.gudy.bouncycastle.jce.provider.JCEECDHKeyAgreement;

final class CryptoSTSEngineImpl
implements CryptoSTSEngine {
    public static final int VERSION = 1;
    private KeyPair ephemeralKeyPair;
    private PublicKey myPublicKey;
    private PrivateKey myPrivateKey;
    private PublicKey remotePubKey;
    private byte[] sharedSecret;
    private InternalDH ecDH;

    CryptoSTSEngineImpl(PublicKey _myPub, PrivateKey _myPriv) throws CryptoManagerException {
        this.myPublicKey = _myPub;
        this.myPrivateKey = _myPriv;
        this.ephemeralKeyPair = CryptoECCUtils.createKeys();
        try {
            this.ecDH = new InternalDH();
            this.ecDH.init(this.ephemeralKeyPair.getPrivate());
        }
        catch (Exception e) {
            throw new CryptoManagerException("Couldn't initialize crypto handshake", e);
        }
    }

    public void getKeys(ByteBuffer message) throws CryptoManagerException {
        this.getMessage(message, true);
    }

    public void putKeys(ByteBuffer message) throws CryptoManagerException {
        this.putMessage(message, true);
    }

    public void getAuth(ByteBuffer message) throws CryptoManagerException {
        this.getMessage(message, false);
    }

    public void putAuth(ByteBuffer message) throws CryptoManagerException {
        this.putMessage(message, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putMessage(ByteBuffer message, boolean keys) throws CryptoManagerException {
        try {
            int version = this.getInt(message, 255);
            if (version != 1) {
                throw new CryptoManagerException("invalid version (" + version + ")");
            }
            if (keys) {
                if (this.sharedSecret != null) {
                    throw new CryptoManagerException("phase error: keys already received");
                }
                byte[] rawRemoteOtherPubkey = this.getBytes(message, 65535);
                byte[] rawRemoteEphemeralPubkey = this.getBytes(message, 65535);
                byte[] remoteSig = this.getBytes(message, 65535);
                byte[] pad = this.getBytes(message, 65535);
                this.remotePubKey = CryptoECCUtils.rawdataToPubkey(rawRemoteOtherPubkey);
                Signature check = CryptoECCUtils.getSignature(this.remotePubKey);
                check.update(rawRemoteOtherPubkey);
                check.update(rawRemoteEphemeralPubkey);
                if (!check.verify(remoteSig)) throw new CryptoManagerException("Signature check failed");
                this.ecDH.doPhase(CryptoECCUtils.rawdataToPubkey(rawRemoteEphemeralPubkey), true);
                this.sharedSecret = this.ecDH.generateSecret();
                return;
            } else {
                if (this.sharedSecret == null) {
                    throw new CryptoManagerException("phase error: keys not received");
                }
                byte[] IV = this.getBytes(message, 65535);
                byte[] remoteSig = this.getBytes(message, 65535);
                Signature check = CryptoECCUtils.getSignature(this.remotePubKey);
                check.update(IV);
                check.update(this.sharedSecret);
                if (check.verify(remoteSig)) return;
                throw new CryptoManagerException("Signature check failed");
            }
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to generate message");
        }
    }

    public void getMessage(ByteBuffer buffer, boolean keys) throws CryptoManagerException {
        try {
            this.putInt(buffer, 1, 255);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            Signature sig = CryptoECCUtils.getSignature(this.myPrivateKey);
            if (keys) {
                byte[] rawMyPubkey = CryptoECCUtils.keyToRawdata(this.myPublicKey);
                byte[] rawEphemeralPubkey = CryptoECCUtils.keyToRawdata(this.ephemeralKeyPair.getPublic());
                sig.update(rawMyPubkey);
                sig.update(rawEphemeralPubkey);
                byte[] rawSign = sig.sign();
                byte[] pad = new byte[random.nextInt(32)];
                random.nextBytes(pad);
                this.putBytes(buffer, rawMyPubkey, 65535);
                this.putBytes(buffer, rawEphemeralPubkey, 65535);
                this.putBytes(buffer, rawSign, 65535);
                this.putBytes(buffer, pad, 65535);
            } else {
                if (this.sharedSecret == null) {
                    throw new CryptoManagerException("phase error: keys not received");
                }
                byte[] IV = new byte[20 + random.nextInt(32)];
                random.nextBytes(IV);
                sig.update(IV);
                sig.update(this.sharedSecret);
                byte[] rawSig = sig.sign();
                this.putBytes(buffer, IV, 65535);
                this.putBytes(buffer, rawSig, 65535);
            }
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to generate message");
        }
    }

    public byte[] getSharedSecret() throws CryptoManagerException {
        if (this.sharedSecret == null) {
            throw new CryptoManagerException("secret not yet available");
        }
        return this.sharedSecret;
    }

    public byte[] getRemotePublicKey() throws CryptoManagerException {
        if (this.remotePubKey == null) {
            throw new CryptoManagerException("key not yet available");
        }
        return CryptoECCUtils.keyToRawdata(this.remotePubKey);
    }

    protected int getInt(ByteBuffer buffer, int max_size) throws CryptoManagerException {
        try {
            if (max_size < 256) {
                return buffer.get() & 0xFF;
            }
            if (max_size < 65536) {
                return buffer.getShort() & 0xFFFF;
            }
            return buffer.getInt();
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to get int", e);
        }
    }

    protected byte[] getBytes(ByteBuffer buffer, int max_size) throws CryptoManagerException {
        int len = this.getInt(buffer, max_size);
        if (len > max_size) {
            throw new CryptoManagerException("Invalid length");
        }
        try {
            byte[] res = new byte[len];
            buffer.get(res);
            return res;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to get byte[]", e);
        }
    }

    protected void putInt(ByteBuffer buffer, int value, int max_size) throws CryptoManagerException {
        try {
            if (max_size < 256) {
                buffer.put((byte)value);
            } else if (max_size < 65536) {
                buffer.putShort((short)value);
            } else {
                buffer.putInt(value);
            }
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to put int", e);
        }
    }

    protected void putBytes(ByteBuffer buffer, byte[] value, int max_size) throws CryptoManagerException {
        this.putInt(buffer, value.length, max_size);
        try {
            buffer.put(value);
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to put byte[]", e);
        }
    }

    class InternalDH
    extends JCEECDHKeyAgreement.DH {
        InternalDH() {
        }

        public void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(key, null);
        }

        public Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
            return this.engineDoPhase(key, lastPhase);
        }

        public byte[] generateSecret() throws IllegalStateException {
            return this.engineGenerateSecret();
        }
    }
}

