/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProvider;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerAlgorithmProviderPingMap;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;

public class SpeedManagerAlgorithmProviderV2
implements SpeedManagerAlgorithmProvider {
    private SpeedManagerAlgorithmProviderAdapter adapter;
    private SpeedManagerAlgorithmProvider strategy;
    public static final String SETTING_DOWNLOAD_MAX_LIMIT = "SpeedManagerAlgorithmProviderV2.setting.download.max.limit";
    public static final String SETTING_UPLOAD_MAX_LIMIT = "SpeedManagerAlgorithmProviderV2.setting.upload.max.limit";
    public static final String SETTING_UPLOAD_LIMIT_ESTIMATE_TYPE_FROM_UI = "AutoSpeed Network Upload Speed Type (temp)";
    public static final String SETTING_DOWNLOAD_LIMIT_ESTIMATE_TYPE_FROM_UI = "AutoSpeed Network Download Speed Type (temp)";
    public static final String SETTING_DATA_SOURCE_INPUT = "SpeedManagerAlgorithmProviderV2.source.data.input";
    public static final String SETTING_DHT_GOOD_SET_POINT = "SpeedManagerAlgorithmProviderV2.setting.dht.good.setpoint";
    public static final String SETTING_DHT_GOOD_TOLERANCE = "SpeedManagerAlgorithmProviderV2.setting.dht.good.tolerance";
    public static final String SETTING_DHT_BAD_SET_POINT = "SpeedManagerAlgorithmProviderV2.setting.dht.bad.setpoint";
    public static final String SETTING_DHT_BAD_TOLERANCE = "SpeedManagerAlgorithmProviderV2.setting.dht.bad.tolerance";
    public static final String SETTING_WAIT_AFTER_ADJUST = "SpeedManagerAlgorithmProviderV2.setting.wait.after.adjust";
    public static final String SETTING_INTERVALS_BETWEEN_ADJUST = "SpeedManagerAlgorithmProviderV2.intervals.between.adjust";
    public static final String SETTING_V2_BETA_ENABLED = "SpeedManagerAlgorithmProviderV2.setting.beta.enabled";

    public SpeedManagerAlgorithmProviderV2(SpeedManagerAlgorithmProviderAdapter _adapter) {
        this.adapter = _adapter;
        SpeedManagerLogger.setAdapter("v2", this.adapter);
        this.strategy = new SpeedManagerAlgorithmProviderPingMap(_adapter);
    }

    public void destroy() {
        this.strategy.destroy();
    }

    public void reset() {
        this.strategy.reset();
    }

    public void updateStats() {
        this.strategy.updateStats();
    }

    public void pingSourceFound(SpeedManagerPingSource source, boolean is_replacement) {
        this.log("Found ping source: " + source.getAddress());
        this.strategy.pingSourceFound(source, is_replacement);
    }

    public void pingSourceFailed(SpeedManagerPingSource source) {
        this.log("Lost ping source: " + source.getAddress());
        this.strategy.pingSourceFailed(source);
    }

    public void calculate(SpeedManagerPingSource[] sources) {
        String str = "";
        for (int i = 0; i < sources.length; ++i) {
            str = str + (i == 0 ? "" : ",") + sources[i].getAddress() + " -> " + sources[i].getPingTime();
        }
        this.log("ping-data: " + str);
        this.strategy.calculate(sources);
    }

    public int getIdlePingMillis() {
        return this.strategy.getIdlePingMillis();
    }

    public int getCurrentPingMillis() {
        return this.strategy.getCurrentPingMillis();
    }

    public int getMaxPingMillis() {
        return this.strategy.getMaxPingMillis();
    }

    public int getCurrentChokeSpeed() {
        return this.strategy.getCurrentChokeSpeed();
    }

    public int getMaxUploadSpeed() {
        return this.strategy.getMaxUploadSpeed();
    }

    public boolean getAdjustsDownloadLimits() {
        return false;
    }

    protected void log(String str) {
        SpeedManagerLogger.log(str);
    }
}

