/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultFilter;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import com.aelitis.azureus.util.JSONUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class SubscriptionDownloader {
    private SubscriptionManagerImpl manager;
    private SubscriptionImpl subs;

    protected SubscriptionDownloader(SubscriptionManagerImpl _manager, SubscriptionImpl _subs) throws SubscriptionException {
        this.manager = _manager;
        this.subs = _subs;
    }

    protected void download() throws SubscriptionException {
        this.log("Downloading");
        Map map = JSONUtils.decodeJSON(this.subs.getJSON());
        Long engine_id = (Long)map.get("engine_id");
        String search_term = (String)map.get("search_term");
        String networks = (String)map.get("networks");
        Map filters = (Map)map.get("filters");
        Engine engine = this.manager.getEngine(this.subs, map, false);
        if (engine == null) {
            throw new SubscriptionException("Download failed, search engine " + engine_id + " not found");
        }
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        if (search_term != null) {
            sps.add(new SearchParameter("s", search_term));
            this.log("    Using search term '" + search_term + "' for engine " + engine.getString());
        }
        if (networks != null && networks.length() > 0) {
            sps.add(new SearchParameter("n", networks));
        }
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        SubscriptionHistoryImpl history = (SubscriptionHistoryImpl)this.subs.getHistory();
        try {
            HashMap<String, String> context2 = new HashMap<String, String>();
            context2.put("azsrc", "subscription");
            Result[] results = engine.search(parameters, context2, -1, -1, null, null);
            this.log("    Got " + results.length + " results");
            SubscriptionResultFilter result_filter = new SubscriptionResultFilter(filters);
            results = result_filter.filter(results);
            this.log("    Post-filter: " + results.length + " results");
            SubscriptionResultImpl[] s_results = new SubscriptionResultImpl[results.length];
            for (int i = 0; i < results.length; ++i) {
                SubscriptionResultImpl s_result;
                s_results[i] = s_result = new SubscriptionResultImpl(history, results[i]);
            }
            SubscriptionResultImpl[] all_results = history.reconcileResults(engine, s_results);
            this.checkAutoDownload(all_results);
            history.setLastError(null, false);
        }
        catch (Throwable e) {
            this.log("    Download failed", e);
            history.setLastError(Debug.getNestedExceptionMessage(e), e instanceof SearchLoginException);
            throw new SubscriptionException("Search failed", e);
        }
    }

    protected void checkAutoDownload(SubscriptionResultImpl[] results) {
        if (!this.subs.getHistory().isAutoDownload()) {
            return;
        }
        for (int i = 0; i < results.length; ++i) {
            SubscriptionResultImpl result = results[i];
            if (result.isDeleted() || result.getRead()) continue;
            this.manager.getScheduler().download((Subscription)this.subs, result);
        }
    }

    protected void log(String str) {
        this.manager.log(str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log(str, e);
    }
}

