/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.rssgen.RSSGeneratorPlugin;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Date;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.utils.subscriptions.Subscription;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionResult;

public class SubscriptionRSSFeed
implements RSSGeneratorPlugin.Provider {
    private static final String PROVIDER = "subscriptions";
    private SubscriptionManagerImpl manager;
    private PluginInterface plugin_interface;
    private RSSGeneratorPlugin generator;

    protected SubscriptionRSSFeed(SubscriptionManagerImpl _manager, PluginInterface _plugin_interface) {
        this.manager = _manager;
        this.plugin_interface = _plugin_interface;
        this.generator = RSSGeneratorPlugin.getSingleton();
        if (this.generator != null) {
            RSSGeneratorPlugin.registerProvider(PROVIDER, this);
        }
    }

    public boolean isEnabled() {
        return this.manager.isRSSPublishEnabled();
    }

    public String getFeedURL() {
        return this.generator == null ? "Feature Disabled" : this.generator.getURL() + PROVIDER;
    }

    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        InetSocketAddress local_address = request2.getLocalAddress();
        if (local_address == null) {
            return false;
        }
        URL url = request2.getAbsoluteURL();
        String path = url.getPath();
        path = path.substring(PROVIDER.length() + 1);
        try {
            SubscriptionManager sman = this.plugin_interface.getUtilities().getSubscriptionManager();
            Subscription[] subs = sman.getSubscriptions();
            OutputStream os = response.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            if (path.length() <= 1) {
                response.setContentType("text/html; charset=UTF-8");
                pw.println("<HTML><HEAD><TITLE>Vuze Subscription Feeds</TITLE></HEAD><BODY>");
                for (Subscription s : subs) {
                    if (s.isSearchTemplate()) continue;
                    String name = s.getName();
                    pw.println("<LI><A href=\"subscriptions/" + s.getID() + "\">" + name + "</A></LI>");
                }
                pw.println("</BODY></HTML>");
            } else {
                String id = path.substring(1);
                Subscription subscription = null;
                for (Subscription s : subs) {
                    if (!s.getID().equals(id)) continue;
                    subscription = s;
                    break;
                }
                if (subscription == null) {
                    response.setReplyStatus(404);
                    return true;
                }
                URL feed_url = url;
                String host = (String)request2.getHeaders().get("host");
                if (host != null) {
                    int pos = host.indexOf(58);
                    if (pos != -1) {
                        host = host.substring(0, pos);
                    }
                    feed_url = UrlUtils.setHost(url, host);
                }
                response.setContentType("application/xml");
                pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                pw.println("<rss version=\"2.0\" xmlns:vuze=\"http://www.vuze.com\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:atom=\"http://www.w3.org/2005/Atom\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">");
                pw.println("<channel>");
                String channel_title = "Vuze Subscription: " + this.escape(subscription.getName());
                pw.println("<title>" + channel_title + "</title>");
                pw.println("<link>http://vuze.com</link>");
                pw.println("<atom:link href=\"" + this.escape(feed_url.toExternalForm()) + "\" rel=\"self\" type=\"application/rss+xml\" />");
                pw.println("<description>Vuze RSS Feed for subscription " + this.escape(subscription.getName()) + "</description>");
                pw.println("<itunes:image href=\"http://www.vuze.com/img/vuze_icon_128.png\"/>");
                pw.println("<image><url>http://www.vuze.com/img/vuze_icon_128.png</url><title>" + channel_title + "</title><link>http://vuze.com</link></image>");
                SubscriptionResult[] results = subscription.getResults();
                String feed_date_key = "subscriptions.feed_date." + subscription.getID();
                long feed_date = COConfigurationManager.getLongParameter(feed_date_key);
                boolean new_date = false;
                for (SubscriptionResult result : results) {
                    Date date = (Date)result.getProperty(2);
                    long millis = date.getTime();
                    if (millis <= feed_date) continue;
                    feed_date = millis;
                    new_date = true;
                }
                if (new_date) {
                    COConfigurationManager.setParameter(feed_date_key, feed_date);
                }
                pw.println("<pubDate>" + TimeFormatter.getHTTPDate(feed_date) + "</pubDate>");
                for (SubscriptionResult result : results) {
                    try {
                        Long rank;
                        Long peers;
                        Long seeds;
                        String uid;
                        pw.println("<item>");
                        String name = (String)result.getProperty(1);
                        pw.println("<title>" + this.escape(name) + "</title>");
                        Date date = (Date)result.getProperty(2);
                        if (date != null) {
                            pw.println("<pubDate>" + TimeFormatter.getHTTPDate(date.getTime()) + "</pubDate>");
                        }
                        if ((uid = (String)result.getProperty(20)) != null) {
                            pw.println("<guid isPermaLink=\"false\">" + this.escape(uid) + "</guid>");
                        }
                        String link = (String)result.getProperty(12);
                        Long size = (Long)result.getProperty(3);
                        if (link != null) {
                            pw.println("<link>" + this.escape(link) + "</link>");
                            if (size != null) {
                                pw.println("<media:content fileSize=\"" + size + "\" url=\"" + this.escape(link) + "\"/>");
                            }
                        }
                        if (size != null) {
                            pw.println("<vuze:size>" + size + "</vuze:size>");
                        }
                        if ((seeds = (Long)result.getProperty(5)) != null) {
                            pw.println("<vuze:seeds>" + seeds + "</vuze:seeds>");
                        }
                        if ((peers = (Long)result.getProperty(4)) != null) {
                            pw.println("<vuze:peers>" + peers + "</vuze:peers>");
                        }
                        if ((rank = (Long)result.getProperty(17)) != null) {
                            pw.println("<vuze:rank>" + rank + "</vuze:rank>");
                        }
                        pw.println("</item>");
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                pw.println("</channel>");
                pw.println("</rss>");
            }
            pw.flush();
        }
        catch (Throwable e) {
            Debug.out(e);
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
        return true;
    }

    protected String escape(String str) {
        return XUXmlWriter.escapeXML(str);
    }

    protected String escapeMultiline(String str) {
        return XUXmlWriter.escapeXML(str.replaceAll("[\r\n]+", "<BR>"));
    }
}

