/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.TaggableResolver;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.tag.impl.TagManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagTypeBase
implements TagType,
TagListener {
    protected static final String AT_COLOR_ID = "col.rgb";
    private int tag_type;
    private int tag_type_features;
    private String tag_type_name;
    private static final int TTL_ADD = 1;
    private static final int TTL_CHANGE = 2;
    private static final int TTL_REMOVE = 3;
    private static final int TTL_TYPE_CHANGE = 4;
    private static TagManagerImpl manager = TagManagerImpl.getSingleton();
    private ListenerManager<TagTypeListener> tt_listeners = ListenerManager.createManager("TagTypeListeners", new ListenerManagerDispatcher<TagTypeListener>(){

        @Override
        public void dispatch(TagTypeListener listener, int type, Object value) {
            if (type == 1) {
                listener.tagAdded((Tag)value);
            } else if (type == 2) {
                listener.tagChanged((Tag)value);
            } else if (type == 3) {
                listener.tagRemoved((Tag)value);
            } else if (type == 4) {
                listener.tagTypeChanged(TagTypeBase.this);
            }
        }
    });
    private Map<Taggable, List<TagListener>> tag_listeners = new HashMap<Taggable, List<TagListener>>();

    protected TagTypeBase(int _tag_type, int _tag_features, String _tag_name) {
        this.tag_type = _tag_type;
        this.tag_type_features = _tag_features;
        this.tag_type_name = _tag_name;
    }

    protected void addTagType() {
        if (manager.isEnabled()) {
            manager.addTagType(this);
        }
    }

    @Override
    public TagManagerImpl getTagManager() {
        return manager;
    }

    protected Taggable resolveTaggable(String id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTaggable(TaggableResolver resolver, Taggable taggable) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            this.tag_listeners.remove(taggable);
        }
    }

    @Override
    public int getTagType() {
        return this.tag_type;
    }

    @Override
    public String getTagTypeName(boolean localize) {
        if (localize) {
            if (this.tag_type_name.startsWith("tag.")) {
                return MessageText.getString(this.tag_type_name);
            }
            return this.tag_type_name;
        }
        if (this.tag_type_name.startsWith("tag.")) {
            return this.tag_type_name;
        }
        return "!" + this.tag_type_name + "!";
    }

    @Override
    public boolean isTagTypeAuto() {
        return true;
    }

    @Override
    public boolean isTagTypePersistent() {
        return false;
    }

    @Override
    public long getTagTypeFeatures() {
        return this.tag_type_features;
    }

    @Override
    public boolean hasTagTypeFeature(long feature) {
        return ((long)this.tag_type_features & feature) != 0L;
    }

    protected void fireChanged() {
        this.tt_listeners.dispatch(4, null);
    }

    @Override
    public Tag createTag(String name, boolean auto_add) throws TagException {
        throw new TagException("Not supported");
    }

    @Override
    public void addTag(Tag t) {
        ((TagBase)t).initialized();
        this.tt_listeners.dispatch(1, t);
    }

    @Override
    public void removeTag(Tag t) {
        ((TagBase)t).destroy();
        this.tt_listeners.dispatch(3, t);
        manager.removeConfig(t);
    }

    @Override
    public int[] getColorDefault() {
        return null;
    }

    protected void sync() {
        List<Tag> tags = this.getTags();
        for (Tag t : tags) {
            ((TagBase)t).sync();
        }
    }

    protected void closing() {
        List<Tag> tags = this.getTags();
        for (Tag t : tags) {
            ((TagBase)t).closing();
        }
    }

    @Override
    public Tag getTag(int tag_id) {
        for (Tag t : this.getTags()) {
            if (t.getTagID() != tag_id) continue;
            return t;
        }
        return null;
    }

    @Override
    public Tag getTag(String tag_name, boolean is_localized) {
        for (Tag t : this.getTags()) {
            if (!t.getTagName(is_localized).equals(tag_name)) continue;
            return t;
        }
        return null;
    }

    @Override
    public List<Tag> getTagsForTaggable(Taggable taggable) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        int taggable_type = taggable.getTaggableType();
        for (Tag t : this.getTags()) {
            if (t.getTaggableTypes() != taggable_type || !t.hasTaggable(taggable)) continue;
            result.add(t);
        }
        return result;
    }

    protected void fireChanged(Tag t) {
        this.tt_listeners.dispatch(2, t);
    }

    @Override
    public void removeTagType() {
        manager.removeTagType(this);
    }

    @Override
    public void addTagTypeListener(TagTypeListener listener, boolean fire_for_existing) {
        this.tt_listeners.addListener(listener);
        if (fire_for_existing) {
            for (Tag t : this.getTags()) {
                listener.tagAdded(t);
            }
        }
    }

    @Override
    public void removeTagTypeListener(TagTypeListener listener) {
        this.tt_listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        List<TagListener> listeners;
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            listeners = this.tag_listeners.get(tagged);
        }
        if (listeners != null) {
            for (TagListener l : listeners) {
                try {
                    l.taggableAdded(tag, tagged);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        manager.taggableAdded(this, tag, tagged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableSync(Tag tag) {
        ArrayList<List<TagListener>> all_listeners = new ArrayList<List<TagListener>>();
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            all_listeners.addAll(this.tag_listeners.values());
        }
        for (List list : all_listeners) {
            for (TagListener listener : list) {
                try {
                    listener.taggableSync(tag);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        List<TagListener> listeners;
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            listeners = this.tag_listeners.get(tagged);
        }
        if (listeners != null) {
            for (TagListener l : listeners) {
                try {
                    l.taggableRemoved(tag, tagged);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        manager.taggableRemoved(this, tag, tagged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTagListener(Taggable taggable, TagListener listener) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            List<TagListener> listeners = this.tag_listeners.get(taggable);
            listeners = listeners == null ? new ArrayList<TagListener>() : new ArrayList<TagListener>(listeners);
            listeners.add(listener);
            this.tag_listeners.put(taggable, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTagListener(Taggable taggable, TagListener listener) {
        Map<Taggable, List<TagListener>> map = this.tag_listeners;
        synchronized (map) {
            List<TagListener> listeners = this.tag_listeners.get(taggable);
            if (listeners != null) {
                listeners = new ArrayList<TagListener>(listeners);
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    this.tag_listeners.remove(taggable);
                } else {
                    this.tag_listeners.put(taggable, listeners);
                }
            }
        }
    }

    protected Boolean readBooleanAttribute(TagBase tag, String attr, Boolean def) {
        return manager.readBooleanAttribute(this, tag, attr, def);
    }

    protected boolean writeBooleanAttribute(TagBase tag, String attr, Boolean value) {
        return manager.writeBooleanAttribute(this, tag, attr, value);
    }

    protected Long readLongAttribute(TagBase tag, String attr, Long def) {
        return manager.readLongAttribute(this, tag, attr, def);
    }

    protected boolean writeLongAttribute(TagBase tag, String attr, Long value) {
        return manager.writeLongAttribute(this, tag, attr, value);
    }

    protected String readStringAttribute(TagBase tag, String attr, String def) {
        return manager.readStringAttribute(this, tag, attr, def);
    }

    protected void writeStringAttribute(TagBase tag, String attr, String value) {
        manager.writeStringAttribute(this, tag, attr, value);
    }

    protected String[] readStringListAttribute(TagBase tag, String attr, String[] def) {
        return manager.readStringListAttribute(this, tag, attr, def);
    }

    protected boolean writeStringListAttribute(TagBase tag, String attr, String[] value) {
        return manager.writeStringListAttribute(this, tag, attr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println(this.tag_type_name);
        try {
            writer.indent();
            manager.generate(writer, this);
            List<Tag> tags = this.getTags();
            for (Tag t : tags) {
                ((TagBase)t).generate(writer);
            }
            Object var6_5 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            writer.exdent();
            throw throwable;
        }
    }

    protected void generateConfig(IndentWriter writer, TagBase tag) {
        manager.generate(writer, this, tag);
    }
}

