/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.update.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.update.AzureusRestarter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.unix.ScriptAfterShutdown;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.update.UpdaterUtils;

public class AzureusRestarterImpl
implements AzureusRestarter {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String MAIN_CLASS = "org.gudy.azureus2.update.Updater";
    private static final String UPDATER_JAR = "Updater.jar";
    private static final String EXE_UPDATER = "AzureusUpdater.exe";
    public static final String UPDATE_PROPERTIES = "update.properties";
    protected static boolean restarted = false;
    private static String JAVA_EXEC_DIR = System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator");
    protected AzureusCore azureus_core;
    protected String classpath_prefix;

    public AzureusRestarterImpl(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(boolean update_only) {
        Class<AzureusRestarterImpl> clazz = AzureusRestarterImpl.class;
        synchronized (AzureusRestarterImpl.class) {
            if (restarted) {
                Logger.log(new LogEvent(LOGID, 1, "AzureusRestarter: already restarted!!!!"));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            restarted = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.runUpdateProcess(update_only, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    public void updateNow() throws AzureusCoreException {
        if (!this.runUpdateProcess(true, true)) {
            throw new AzureusCoreException("Failed to invoke restart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean runUpdateProcess(boolean update_only, boolean no_wait) throws AzureusCoreException {
        block21: {
            pi = this.azureus_core.getPluginManager().getPluginInterfaceByID("azupdater");
            if (pi == null) {
                Logger.log(new LogAlert(false, 3, "Can't update/restart, mandatory plugin 'azupdater' not found"));
                throw new AzureusCoreException("mandatory plugin 'azupdater' not found");
            }
            updater_dir = pi.getPluginDirectoryName();
            this.classpath_prefix = updater_dir + File.separator + "Updater.jar";
            app_path = SystemProperties.getApplicationPath();
            while (app_path.endsWith(File.separator)) {
                app_path = app_path.substring(0, app_path.length() - 1);
            }
            user_path = SystemProperties.getUserPath();
            while (user_path.endsWith(File.separator)) {
                user_path = user_path.substring(0, user_path.length() - 1);
            }
            config_override = System.getProperty("azureus.config.path");
            if (config_override == null) {
                config_override = "";
            }
            parameters = new String[]{update_only != false ? "updateonly" : "restart", app_path, user_path, config_override};
            fos = null;
            try {
                update_properties = new Properties();
                max_mem = Runtime.getRuntime().maxMemory();
                update_properties.put("max_mem", "" + max_mem);
                update_properties.put("app_name", SystemProperties.getApplicationName());
                update_properties.put("app_entry", SystemProperties.getApplicationEntryPoint());
                if (System.getProperty("azureus.nativelauncher") != null || Constants.isOSX) {
                    try {
                        cmd = PlatformManagerFactory.getPlatformManager().getApplicationCommandLine();
                        if (cmd != null) {
                            update_properties.put("app_cmd", cmd);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (no_wait) {
                    update_properties.put("no_wait", "1");
                }
                update_properties.put("instance_port", String.valueOf(Constants.INSTANCE_PORT));
                fos = new FileOutputStream(new File(user_path, "update.properties"));
                update_properties.store(fos, "Azureus restart properties");
                var15_16 = null;
                ** if (fos == null) goto lbl-1000
            }
            catch (Throwable var14_22) {
                var15_18 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw var14_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    var15_17 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        }
        properties = new String[]{"-Duser.dir=\"" + app_path + "\""};
        os = new ByteArrayOutputStream();
        res = this.restartAzureus(new PrintWriter(os){

            public void println(String str) {
                Logger.log(new LogEvent(LOGID, str));
            }
        }, "org.gudy.azureus2.update.Updater", properties, parameters, update_only);
        bytes = os.toByteArray();
        if (bytes.length > 0) {
            Logger.log(new LogEvent(AzureusRestarterImpl.LOGID, "AzureusUpdater: extra log - " + new String(bytes)));
        }
        return res;
    }

    private String getClassPath() {
        String classPath = System.getProperty("java.class.path");
        classPath = this.classpath_prefix + System.getProperty("path.separator") + classPath;
        return "-classpath \"" + classPath + "\" ";
    }

    private boolean win32NativeRestart(PrintWriter log, String exec) {
        try {
            PlatformManager pm = PlatformManagerFactory.getPlatformManager();
            pm.createProcess(exec, false);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(log);
            return false;
        }
    }

    private String getExeUpdater(PrintWriter log) {
        try {
            if (Constants.isWindowsVistaOrHigher && PluginInitializer.getDefaultInterface().getUpdateManager().getInstallers().length > 0) {
                log.println("Vista restart w/Updates.. checking if EXE needed");
                if (!FileUtil.canReallyWriteToAppDirectory()) {
                    log.println("It appears we can't write to the application dir, using the EXE updater");
                    return EXE_UPDATER;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private boolean restartViaEXE(PrintWriter log, String exeUpdater, String[] properties, String[] parameters, String backupJavaRunString, boolean update_only) {
        String azRunner = null;
        File fileRestart = null;
        if (!update_only) {
            try {
                azRunner = PlatformManagerFactory.getPlatformManager().getApplicationCommandLine();
            }
            catch (PlatformManagerException e) {
                e.printStackTrace();
            }
        }
        try {
            int result;
            AEWin32Access accessor = AEWin32Manager.getAccessor(true);
            if (accessor == null) {
                result = -123;
            } else if (azRunner != null) {
                byte[] bytes;
                fileRestart = FileUtil.getUserFile("restart.bat");
                String s = "title Azureus Updater Runner\r\n";
                s = s + exeUpdater + " \"updateonly\"";
                for (int i = 1; i < parameters.length; ++i) {
                    s = s + " \"" + parameters[i].replaceAll("\\\"", "") + "\"";
                }
                s = s + "\r\n";
                s = s + "start \"\" \"" + azRunner + "\"";
                String encoding = FileUtil.getScriptCharsetEncoding();
                if (encoding == null) {
                    bytes = s.getBytes();
                } else {
                    try {
                        bytes = s.getBytes(encoding);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        bytes = s.getBytes();
                    }
                }
                FileUtil.writeBytesAsFile(fileRestart.getAbsolutePath(), bytes);
                result = accessor.shellExecute(null, fileRestart.getAbsolutePath(), null, SystemProperties.getApplicationPath(), 2);
            } else {
                int i;
                String execEXE = "\"-J" + this.getClassPath().replaceAll("\\\"", "") + "\" ";
                for (i = 0; i < properties.length; ++i) {
                    execEXE = execEXE + "\"-J" + properties[i].replaceAll("\\\"", "") + "\" ";
                }
                for (i = 0; i < parameters.length; ++i) {
                    execEXE = execEXE + " \"" + parameters[i].replaceAll("\\\"", "") + "\"";
                }
                log.println("Launch via " + exeUpdater + " params " + execEXE);
                result = accessor.shellExecute(null, exeUpdater, execEXE, SystemProperties.getApplicationPath(), 1);
            }
            log.println("   -> " + result);
            if (result <= 32) {
                String sErrorReason = "";
                String key = null;
                switch (result) {
                    case 0: 
                    case 8: {
                        key = "oom";
                        break;
                    }
                    case 2: {
                        key = "fnf";
                        break;
                    }
                    case 3: {
                        key = "pnf";
                        break;
                    }
                    case 5: {
                        key = "denied";
                        break;
                    }
                    case 11: {
                        key = "bad";
                        break;
                    }
                    case -123: {
                        key = "nowin32";
                        break;
                    }
                    default: {
                        sErrorReason = "" + result;
                    }
                }
                if (key != null) {
                    sErrorReason = MessageText.getString("restart.error." + key, new String[]{exeUpdater, SystemProperties.getApplicationPath()});
                }
                Logger.log(new LogAlert(false, 3, MessageText.getString("restart.error", new String[]{sErrorReason})));
                return false;
            }
        }
        catch (Throwable f) {
            f.printStackTrace(log);
            return this.javaSpawn(log, backupJavaRunString);
        }
        return true;
    }

    public boolean restartAzureus(PrintWriter log, String mainClass, String[] properties, String[] parameters, boolean update_only) {
        if (Constants.isOSX) {
            return this.restartAzureus_OSX(log, mainClass, properties, parameters);
        }
        if (Constants.isUnix) {
            return this.restartAzureus_Unix(log, mainClass, properties, parameters);
        }
        return this.restartAzureus_win32(log, mainClass, properties, parameters, update_only);
    }

    private boolean restartAzureus_win32(PrintWriter log, String mainClass, String[] properties, String[] parameters, boolean update_only) {
        int i;
        String exeUpdater = this.getExeUpdater(log);
        String exec = "\"" + JAVA_EXEC_DIR + "javaw\" " + this.getClassPath() + this.getLibraryPath();
        for (i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        exec = exec + mainClass;
        for (i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        if (exeUpdater != null) {
            return this.restartViaEXE(log, exeUpdater, properties, parameters, exec, update_only);
        }
        log.println("  " + exec);
        if (!this.win32NativeRestart(log, exec)) {
            return this.javaSpawn(log, exec);
        }
        return true;
    }

    private boolean javaSpawn(PrintWriter log, String execString) {
        try {
            log.println("Using java spawn");
            Process p = Runtime.getRuntime().exec(execString);
            log.println("    -> " + p);
            return true;
        }
        catch (Throwable g) {
            g.printStackTrace();
            return false;
        }
    }

    private boolean restartAzureus_OSX(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        int i;
        String exec = "\"" + JAVA_EXEC_DIR + "java\" " + this.getClassPath() + this.getLibraryPath();
        for (i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        exec = exec + mainClass;
        for (i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        return this.runExternalCommandViaUnixShell(log, exec);
    }

    private int getUnixScriptVersion() {
        String sVersion = System.getProperty("azureus.script.version", "0");
        int version = 0;
        try {
            version = Integer.parseInt(sVersion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    private boolean restartAzureus_Unix(PrintWriter log, String mainClass, String[] properties, String[] parameters) {
        boolean restartByScript;
        String exec = "\"" + JAVA_EXEC_DIR + "java\" " + this.getClassPath() + this.getLibraryPath();
        for (int i = 0; i < properties.length; ++i) {
            exec = exec + properties[i] + " ";
        }
        int scriptVersion = this.getUnixScriptVersion();
        boolean bl = restartByScript = Constants.compareVersions(UpdaterUtils.getUpdaterPluginVersion(), "1.8.5") >= 0 && scriptVersion > 0;
        if (restartByScript) {
            exec = exec + "-Dazureus.script.version=\"" + scriptVersion + "\" ";
        }
        exec = exec + mainClass;
        for (int i = 0; i < parameters.length; ++i) {
            exec = exec + " \"" + parameters[i] + "\"";
        }
        if (restartByScript) {
            ScriptAfterShutdown.addExtraCommand("echo \"Applying (possible) patches before restarting..\"\n" + exec + "\n" + "echo \"Restarting Azureus..\"\n" + "$0\n");
            ScriptAfterShutdown.setRequiresExit(true);
            return true;
        }
        return this.runExternalCommandViaUnixShell(log, exec);
    }

    private String getLibraryPath() {
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath == null) {
            libraryPath = "";
        } else {
            String temp = "";
            for (int i = 0; i < libraryPath.length(); ++i) {
                char c = libraryPath.charAt(i);
                if (c == '\"') continue;
                temp = temp + c;
            }
            libraryPath = temp;
            while (libraryPath.endsWith(File.separator)) {
                libraryPath = libraryPath.substring(0, libraryPath.length() - 1);
            }
            if (libraryPath.length() > 0) {
                libraryPath = "-Djava.library.path=\"" + libraryPath + "\" ";
            }
        }
        return libraryPath;
    }

    private boolean runExternalCommandViaUnixShell(PrintWriter log, String command) {
        String[] to_run = new String[]{"/bin/sh", "-c", command};
        if (log != null) {
            log.println("Executing: R:[" + to_run[0] + " " + to_run[1] + " " + to_run[2] + "]");
        }
        try {
            Runtime.getRuntime().exec(to_run);
            return true;
        }
        catch (Throwable t) {
            if (log != null) {
                log.println(t.getMessage() != null ? t.getMessage() : "<null>");
                log.println(t);
                t.printStackTrace(log);
            } else {
                t.printStackTrace();
            }
            return false;
        }
    }
}

