/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.io.IOException;
import java.io.InputStream;

public class UncloseableInputStream
extends InputStream {
    private InputStream is;
    private boolean closed;

    public UncloseableInputStream(InputStream _is) {
        this.is = _is;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read();
    }

    public int read(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.read(b, off, len);
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public long skip(long n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.skip(n);
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        return this.is.available();
    }

    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public void reset() throws IOException {
        if (this.closed) {
            throw new IOException("Stream Closed");
        }
        this.is.reset();
    }

    public boolean markSupported() {
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

