/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.clientid;

import com.aelitis.azureus.core.AzureusCore;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.clientid.ClientIDGenerator;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class ClientIDPlugin {
    private static final String CLIENT_NAME = "Vuze 5.7.3.0";
    private static final String CLIENT_NAME_SM = "Vuze (Swarm Merging) 5.7.3.0";
    private static boolean send_os;

    public static void initialize(AzureusCore _core) {
        final AzureusCore core = _core;
        String param = "Tracker Client Send OS and Java Version";
        COConfigurationManager.addAndFireParameterListener("Tracker Client Send OS and Java Version", new ParameterListener(){

            public void parameterChanged(String param) {
                send_os = COConfigurationManager.getBooleanParameter(param);
            }
        });
        ClientIDManagerImpl.getSingleton().setGenerator(new ClientIDGenerator(){

            public byte[] generatePeerID(byte[] hash, boolean for_tracker) {
                return PeerUtils.createPeerID();
            }

            public void generateHTTPProperties(byte[] hash, Properties properties) {
                ClientIDPlugin.doHTTPProperties(properties);
            }

            public String[] filterHTTP(byte[] hash, String[] lines_in) {
                return lines_in;
            }

            public Object getProperty(byte[] hash, String property_name) {
                if (property_name == "Client-Name") {
                    try {
                        GlobalManager gm = core.getGlobalManager();
                        DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                        if (dm != null && gm.isSwarmMerging(dm) != null) {
                            return ClientIDPlugin.CLIENT_NAME_SM;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return ClientIDPlugin.CLIENT_NAME;
                }
                if (property_name == "Messaging-Mode") {
                    return 2;
                }
                return null;
            }
        }, false);
    }

    protected static void doHTTPProperties(Properties properties) {
        Boolean raw = (Boolean)properties.get("Raw-Request");
        if (raw != null && raw.booleanValue()) {
            return;
        }
        String version = "5.7.3.0";
        int pos = version.indexOf(95);
        if (pos != -1) {
            version = version.substring(0, pos);
        }
        String agent = "Azureus " + version;
        if (send_os) {
            agent = agent + ";" + Constants.OSName;
            agent = agent + ";Java " + Constants.JAVA_VERSION;
        }
        properties.put("User-Agent", agent);
    }
}

