/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed.impl.webseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedException;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.impl.ExternalSeedReaderImpl;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloader;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderListener;
import com.aelitis.azureus.plugins.extseed.util.ExternalSeedHTTPDownloaderRange;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;

public class ExternalSeedReaderWebSeed
extends ExternalSeedReaderImpl {
    private URL url;
    private int port;
    private String url_prefix;
    private boolean supports_503;

    protected ExternalSeedReaderWebSeed(ExternalSeedPlugin _plugin, Torrent _torrent, URL _url, Map _params) {
        super(_plugin, _torrent, _url.getHost(), _params);
        this.supports_503 = this.getBooleanParam(_params, "supports_503", true);
        this.url = _url;
        this.port = this.url.getPort();
        if (this.port == -1) {
            this.port = this.url.getDefaultPort();
        }
        try {
            String hash_str = URLEncoder.encode(new String(_torrent.getHash(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.url_prefix = this.url.toString() + "?info_hash=" + hash_str;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean sameAs(ExternalSeedReader other) {
        if (other instanceof ExternalSeedReaderWebSeed) {
            return this.url.toString().equals(((ExternalSeedReaderWebSeed)other).url.toString());
        }
        return false;
    }

    public String getName() {
        return "WebSeed: " + this.url;
    }

    public String getType() {
        return "WebSeed";
    }

    public URL getURL() {
        return this.url;
    }

    public int getPort() {
        return this.port;
    }

    protected int getPieceGroupSize() {
        return 1;
    }

    protected boolean getRequestCanSpanPieces() {
        return false;
    }

    protected void readData(int piece_number, int piece_offset, int length, ExternalSeedHTTPDownloaderListener listener) throws ExternalSeedException {
        long piece_end = piece_offset + length - 1;
        String str = this.url_prefix + "&piece=" + piece_number + "&ranges=" + piece_offset + "-" + piece_end;
        this.setReconnectDelay(30000, false);
        ExternalSeedHTTPDownloader http_downloader = null;
        try {
            http_downloader = new ExternalSeedHTTPDownloaderRange(new URL(str), this.getUserAgent());
            if (this.supports_503) {
                http_downloader.downloadSocket(length, listener, this.isTransient());
            } else {
                http_downloader.download(length, listener, this.isTransient());
            }
        }
        catch (ExternalSeedException ese) {
            if (http_downloader.getLastResponse() == 503 && http_downloader.getLast503RetrySecs() >= 0) {
                int retry_secs = http_downloader.getLast503RetrySecs();
                this.setReconnectDelay(retry_secs * 1000, true);
                throw new ExternalSeedException("Server temporarily unavailable, retrying in " + retry_secs + " seconds");
            }
            throw ese;
        }
        catch (MalformedURLException e) {
            throw new ExternalSeedException("URL encode fails", e);
        }
    }
}

