/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.util.PlatformTorrentUtils;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnetPluginMDDownloader {
    private static final Set<String> active_set = new HashSet<String>();
    private final PluginInterface plugin_interface;
    private final MagnetPlugin plugin;
    private final byte[] hash;
    private final Set<String> networks;
    private final InetSocketAddress[] addresses;
    private final String args;
    private volatile boolean started;
    private volatile boolean cancelled;
    private volatile boolean completed;
    private List<DiskManagerRequest> requests = new ArrayList<DiskManagerRequest>();
    private AESemaphore running_sem = new AESemaphore("MPMDD:run");
    private AESemaphore complete_sem = new AESemaphore("MPMDD:comp");

    protected MagnetPluginMDDownloader(MagnetPlugin _plugin, PluginInterface _plugin_interface, byte[] _hash, Set<String> _networks, InetSocketAddress[] _addresses, String _args) {
        this.plugin = _plugin;
        this.plugin_interface = _plugin_interface;
        this.hash = _hash;
        this.networks = _networks;
        this.addresses = _addresses;
        this.args = _args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(final DownloadListener listener) {
        MagnetPluginMDDownloader magnetPluginMDDownloader = this;
        synchronized (magnetPluginMDDownloader) {
            if (this.started) {
                listener.failed(new Exception("Already started"));
                return;
            }
            if (this.cancelled || this.completed) {
                listener.failed(new Exception("Already cancelled/completed"));
                return;
            }
            this.started = true;
            new AEThread2("MagnetPluginMDDownloader"){

                public void run() {
                    MagnetPluginMDDownloader.this.startSupport(listener);
                }
            }.start();
        }
    }

    protected void cancel() {
        this.cancelSupport(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelSupport(boolean internal) {
        boolean wait_for_complete = !internal;
        try {
            ArrayList<DiskManagerRequest> to_cancel;
            MagnetPluginMDDownloader magnetPluginMDDownloader = this;
            synchronized (magnetPluginMDDownloader) {
                if (!this.started) {
                    Debug.out("Not started!");
                    wait_for_complete = false;
                }
                if (this.cancelled || this.completed) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    Object var7_4 = null;
                    this.running_sem.releaseForever();
                    if (!wait_for_complete) return;
                    this.complete_sem.reserve();
                    return;
                }
                this.cancelled = true;
                to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                this.requests.clear();
            }
            for (DiskManagerRequest request2 : to_cancel) {
                request2.cancel();
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.running_sem.releaseForever();
            if (!wait_for_complete) throw throwable;
            this.complete_sem.reserve();
            throw throwable;
        }
        Object var7_5 = null;
        this.running_sem.releaseForever();
        if (!wait_for_complete) return;
        this.complete_sem.reserve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void startSupport(final DownloadListener listener) {
        block108: {
            Set<String> set;
            TOTorrent torrent;
            String hash_str = ByteFormatter.encodeString(this.hash);
            File tmp_dir = null;
            File data_file = null;
            File torrent_file = null;
            DownloadManager download_manager = this.plugin_interface.getDownloadManager();
            Download download = null;
            final Throwable[] error = new Throwable[]{null};
            final ByteArrayOutputStream result = new ByteArrayOutputStream(32768);
            Object url_sets = null;
            Set<String> set2 = active_set;
            synchronized (set2) {
                if (active_set.contains(hash_str)) {
                    throw new Exception("Download already active for hash " + hash_str);
                }
                active_set.add(hash_str);
            }
            Download existing_download = download_manager.getDownload(this.hash);
            if (existing_download != null) {
                throw new Exception("download already exists");
            }
            tmp_dir = AETemporaryFileHandler.createTempDir();
            int rand = RandomUtils.generateRandomIntUpto(10000);
            data_file = new File(tmp_dir, hash_str + "_" + rand + ".torrent");
            torrent_file = new File(tmp_dir, hash_str + "_" + rand + ".metatorrent");
            RandomAccessFile raf = new RandomAccessFile(data_file, "rw");
            try {
                byte[] buffer = new byte[524288];
                Arrays.fill(buffer, (byte)-1);
                for (long i = 0L; i < 0x4000000L; i += (long)buffer.length) {
                    raf.write(buffer);
                }
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                raf.close();
                throw throwable;
            }
            raf.close();
            URL announce_url = TorrentUtils.getDecentralisedURL(this.hash);
            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(data_file, announce_url, 16384L);
            TOTorrent meta_torrent = creator.create();
            String[] bits = this.args.split("&");
            ArrayList<String> trackers = new ArrayList<String>();
            String name = "magnet:" + Base32.encode(this.hash);
            HashMap<String, String> magnet_args = new HashMap<String, String>();
            for (String bit : bits) {
                String[] x = bit.split("=");
                if (x.length != 2) continue;
                String lhs = x[0].toLowerCase();
                String rhs = UrlUtils.decode(x[1]);
                magnet_args.put(lhs, rhs);
                if (lhs.equals("tr")) {
                    String tracker = rhs;
                    trackers.add(tracker);
                    continue;
                }
                if (!lhs.equals("dn")) continue;
                name = rhs;
            }
            if (trackers.size() > 0) {
                trackers.add(0, announce_url.toExternalForm());
                TOTorrentAnnounceURLGroup ag = meta_torrent.getAnnounceURLGroup();
                ArrayList<TOTorrentAnnounceURLSet> sets = new ArrayList<TOTorrentAnnounceURLSet>();
                for (String tracker : trackers) {
                    try {
                        URL tracker_url = new URL(tracker);
                        sets.add(ag.createAnnounceURLSet(new URL[]{tracker_url}));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                if (sets.size() > 0) {
                    url_sets = sets.toArray(new TOTorrentAnnounceURLSet[sets.size()]);
                    ag.setAnnounceURLSets((TOTorrentAnnounceURLSet[])url_sets);
                }
            }
            if (!data_file.delete()) {
                throw new Exception("Failed to delete " + data_file);
            }
            meta_torrent.setHashOverride(this.hash);
            TorrentUtils.setFlag(meta_torrent, 2, true);
            TorrentUtils.setFlag(meta_torrent, 1, true);
            meta_torrent.serialiseToBEncodedFile(torrent_file);
            download_manager.clearNonPersistentDownloadState(this.hash);
            download = download_manager.addNonPersistentDownloadStopped(PluginCoreUtils.wrap(meta_torrent), torrent_file, data_file);
            String display_name = MessageText.getString("MagnetPlugin.use.md.download.name", new String[]{name});
            DownloadManagerState state = PluginCoreUtils.unwrap(download).getDownloadState();
            state.setDisplayName(display_name + ".torrent");
            if (this.networks.size() == 0 || this.networks.size() == 1 && this.networks.contains("Public")) {
                for (String network : AENetworkClassifier.AT_NETWORKS) {
                    state.setNetworkEnabled(network, true);
                }
            } else {
                for (String network : this.networks) {
                    state.setNetworkEnabled(network, true);
                }
                if (!this.networks.contains("Public")) {
                    state.setNetworkEnabled("Public", false);
                }
            }
            if (!this.plugin.isNetworkEnabled("Public")) {
                state.setNetworkEnabled("Public", false);
            }
            final ArrayList<InetSocketAddress> peers_to_inject = new ArrayList<InetSocketAddress>();
            if (this.addresses != null && this.addresses.length > 0) {
                String[] enabled_nets = state.getNetworks();
                block64: for (InetSocketAddress address : this.addresses) {
                    String host = AddressUtils.getHostAddress(address);
                    String net = AENetworkClassifier.categoriseAddress(host);
                    for (String n : enabled_nets) {
                        if (n != net) continue;
                        peers_to_inject.add(address);
                        continue block64;
                    }
                }
            }
            final HashSet<String> peer_networks = new HashSet<String>();
            final ArrayList peers_for_cache = new ArrayList();
            download.addPeerListener(new DownloadPeerListener(){

                public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                    if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                        download.removePeerListener(this);
                        return;
                    }
                    final PEPeerManager pm = PluginCoreUtils.unwrap(peer_manager);
                    peer_manager.addListener(new PeerManagerListener2(){
                        private PeerManagerListener2 pm_listener = this;
                        private int md_size;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void eventOccurred(PeerManagerEvent event2) {
                            if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed) {
                                peer_manager.removeListener(this);
                                return;
                            }
                            if (event2.getType() != 1) {
                                return;
                            }
                            final Peer peer = event2.getPeer();
                            try {
                                String peer_ip = peer.getIp();
                                String network = AENetworkClassifier.categoriseAddress(peer_ip);
                                Set set = peer_networks;
                                synchronized (set) {
                                    peer_networks.add(network);
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    peers_for_cache.add(map);
                                    map.put("ip", peer_ip.getBytes("UTF-8"));
                                    map.put("port", new Long(peer.getPort()));
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            peer.addListener(new PeerListener2(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void eventOccurred(PeerEvent event2) {
                                    if (MagnetPluginMDDownloader.this.cancelled || MagnetPluginMDDownloader.this.completed || md_size > 0) {
                                        peer.removeListener(this);
                                        return;
                                    }
                                    if (event2.getType() != 1) {
                                        return;
                                    }
                                    if ((Integer)event2.getData() != 30) {
                                        return;
                                    }
                                    PeerManagerListener2 peerManagerListener2 = pm_listener;
                                    synchronized (peerManagerListener2) {
                                        if (md_size > 0) {
                                            return;
                                        }
                                        md_size = pm.getTorrentInfoDictSize();
                                        if (md_size <= 0) {
                                            return;
                                        }
                                        peer_manager.removeListener(pm_listener);
                                    }
                                    listener.reportProgress(0, md_size);
                                    new AEThread2(""){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         * Enabled aggressive block sorting
                                         * Enabled unnecessary exception pruning
                                         * Enabled aggressive exception aggregation
                                         */
                                        public void run() {
                                            DiskManagerChannel channel2 = null;
                                            try {
                                                try {
                                                    channel2 = download.getDiskManagerFileInfo()[0].createChannel();
                                                    final DiskManagerRequest request2 = channel2.createRequest();
                                                    request2.setType(1);
                                                    request2.setOffset(0L);
                                                    request2.setLength(md_size);
                                                    request2.setMaximumReadChunkSize(16384);
                                                    request2.addListener(new DiskManagerListener(){

                                                        /*
                                                         * WARNING - Removed try catching itself - possible behaviour change.
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        public void eventOccurred(DiskManagerEvent event2) {
                                                            int type = event2.getType();
                                                            if (type == 2) {
                                                                error[0] = event2.getFailure();
                                                                MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                return;
                                                            }
                                                            if (type == 1) {
                                                                PooledByteBuffer buffer = null;
                                                                try {
                                                                    block10: {
                                                                        try {
                                                                            int dl_size;
                                                                            buffer = event2.getBuffer();
                                                                            byte[] bytes = buffer.toByteArray();
                                                                            MagnetPluginMDDownloader magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                                            synchronized (magnetPluginMDDownloader) {
                                                                                result.write(bytes);
                                                                                dl_size = result.size();
                                                                                if (dl_size == md_size) {
                                                                                    MagnetPluginMDDownloader.this.completed = true;
                                                                                    listener.reportProgress(md_size, md_size);
                                                                                    MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                                }
                                                                            }
                                                                            if (MagnetPluginMDDownloader.this.completed) break block10;
                                                                            listener.reportProgress(dl_size, md_size);
                                                                        }
                                                                        catch (Throwable e) {
                                                                            error[0] = e;
                                                                            request2.cancel();
                                                                            MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                                            Object var9_10 = null;
                                                                            if (buffer == null) return;
                                                                            buffer.returnToPool();
                                                                            return;
                                                                        }
                                                                    }
                                                                    Object var9_9 = null;
                                                                    if (buffer == null) return;
                                                                    buffer.returnToPool();
                                                                    return;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var9_11 = null;
                                                                    if (buffer == null) throw throwable;
                                                                    buffer.returnToPool();
                                                                    throw throwable;
                                                                }
                                                            }
                                                            if (type != 3) return;
                                                        }
                                                    });
                                                    MagnetPluginMDDownloader magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                    synchronized (magnetPluginMDDownloader) {
                                                        if (MagnetPluginMDDownloader.this.cancelled) {
                                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 10] lbl14 : MonitorExitStatement: MONITOREXIT : var3_4
                                                            Object var7_5 = null;
                                                            if (channel2 == null) return;
                                                            channel2.destroy();
                                                            return;
                                                        }
                                                        MagnetPluginMDDownloader.this.requests.add(request2);
                                                    }
                                                    request2.run();
                                                    magnetPluginMDDownloader = MagnetPluginMDDownloader.this;
                                                    synchronized (magnetPluginMDDownloader) {
                                                        MagnetPluginMDDownloader.this.requests.remove(request2);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    error[0] = e;
                                                    MagnetPluginMDDownloader.this.running_sem.releaseForever();
                                                    Object var7_7 = null;
                                                    if (channel2 == null) return;
                                                    channel2.destroy();
                                                    return;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var7_8 = null;
                                                if (channel2 == null) throw throwable;
                                                channel2.destroy();
                                                throw throwable;
                                            }
                                            Object var7_6 = null;
                                            if (channel2 == null) return;
                                            channel2.destroy();
                                        }
                                    }.start();
                                }
                            });
                        }
                    });
                }

                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                }
            });
            final Download f_download = download;
            DownloadManagerListener dl_listener = new DownloadManagerListener(){
                private Object lock = this;
                private TimerEventPeriodic timer_event;
                private boolean removed;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadAdded(final Download download) {
                    if (download == f_download) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (!this.removed) {
                                if (this.timer_event == null) {
                                    this.timer_event = SimpleTimer.addPeriodicEvent("announcer", 30000L, new TimerEventPerformer(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void perform(TimerEvent event2) {
                                            Object object = lock;
                                            synchronized (object) {
                                                if (removed) {
                                                    return;
                                                }
                                                if (MagnetPluginMDDownloader.this.running_sem.isReleasedForever()) {
                                                    if (timer_event != null) {
                                                        timer_event.cancel();
                                                        timer_event = null;
                                                    }
                                                    return;
                                                }
                                            }
                                            download.requestTrackerAnnounce(true);
                                            this.injectPeers(download);
                                        }
                                    });
                                }
                                if (peers_to_inject.size() > 0) {
                                    SimpleTimer.addEvent("injecter", SystemTime.getOffsetTime(5000L), new TimerEventPerformer(){

                                        public void perform(TimerEvent event2) {
                                            this.injectPeers(download);
                                        }
                                    });
                                }
                            }
                        }
                    }
                }

                private void injectPeers(Download download) {
                    PeerManager pm = download.getPeerManager();
                    if (pm != null) {
                        for (InetSocketAddress address : peers_to_inject) {
                            pm.addPeer(AddressUtils.getHostAddress(address), address.getPort());
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadRemoved(Download dl) {
                    if (dl == f_download) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.removed = true;
                            if (this.timer_event != null) {
                                this.timer_event.cancel();
                                this.timer_event = null;
                            }
                        }
                        if (!MagnetPluginMDDownloader.this.cancelled && !MagnetPluginMDDownloader.this.completed) {
                            error[0] = new Exception("Download manually removed");
                            MagnetPluginMDDownloader.this.running_sem.releaseForever();
                        }
                    }
                }
            };
            download_manager.addListener(dl_listener, true);
            try {
                download.moveTo(1);
                download.setForceStart(true);
                download.setFlag(4L, true);
                this.running_sem.reserve();
                Object var36_63 = null;
                download_manager.removeListener(dl_listener);
            }
            catch (Throwable throwable) {
                Object var36_64 = null;
                download_manager.removeListener(dl_listener);
                throw throwable;
            }
            if (this.completed) {
                byte[] bytes = result.toByteArray();
                Map<String, Object> info = BDecoder.decode(bytes);
                HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
                map.put("info", info);
                torrent = TOTorrentFactory.deserialiseFromMap(map);
                byte[] final_hash = torrent.getHash();
                if (!Arrays.equals(this.hash, final_hash)) {
                    throw new Exception("Metadata torrent hash mismatch: expected=" + ByteFormatter.encodeString(this.hash) + ", actual=" + ByteFormatter.encodeString(final_hash));
                }
                if (url_sets != null) {
                    ArrayList<TOTorrentAnnounceURLSet> updated = new ArrayList<TOTorrentAnnounceURLSet>();
                    for (TOTorrentAnnounceURLSet set3 : url_sets) {
                        if (TorrentUtils.isDecentralised(set3.getAnnounceURLs()[0])) continue;
                        updated.add(set3);
                    }
                    url_sets = updated.size() == 0 ? null : updated.toArray(new TOTorrentAnnounceURLSet[updated.size()]);
                }
                if (url_sets != null) {
                    torrent.setAnnounceURL(url_sets[0].getAnnounceURLs()[0]);
                    torrent.getAnnounceURLGroup().setAnnounceURLSets((TOTorrentAnnounceURLSet[])url_sets);
                } else {
                    torrent.setAnnounceURL(TorrentUtils.getDecentralisedURL(this.hash));
                }
                if (peers_for_cache.size() > 0) {
                    HashMap peer_cache = new HashMap();
                    peer_cache.put("tracker_peers", peers_for_cache);
                    TorrentUtils.setPeerCache(torrent, peer_cache);
                }
                try {
                    String pfi_str;
                    String dn = (String)magnet_args.get("dn");
                    if (dn != null) {
                        PlatformTorrentUtils.setContentTitle(torrent, dn);
                    }
                    if ((pfi_str = (String)magnet_args.get("pfi")) != null) {
                        PlatformTorrentUtils.setContentPrimaryFileIndex(torrent, Integer.parseInt(pfi_str));
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            } else {
                if (this.cancelled) {
                    throw new Exception("Download cancelled");
                }
                this.cancelSupport(true);
                try {
                    if (error[0] != null) {
                        throw error[0];
                    }
                    throw new Exception("Download terminated prematurely");
                }
                catch (Throwable e) {
                    listener.failed(e);
                    Debug.out(e);
                    throw e;
                }
            }
            listener.complete(torrent, peer_networks);
            Object var39_69 = null;
            try {
                block106: {
                    ArrayList<DiskManagerRequest> to_cancel;
                    if (download != null) {
                        try {
                            download.stop();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                        try {
                            download.remove();
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                    }
                    MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                    synchronized (magnetPluginMDDownloader) {
                        to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                        this.requests.clear();
                    }
                    for (DiskManagerRequest request2 : to_cancel) {
                        request2.cancel();
                    }
                    if (torrent_file != null) {
                        torrent_file.delete();
                    }
                    if (data_file != null) {
                        data_file.delete();
                    }
                    if (tmp_dir == null) break block106;
                    tmp_dir.delete();
                }
                Object var44_87 = null;
                set = active_set;
            }
            catch (Throwable throwable) {
                Object var44_89 = null;
                Set<String> set4 = active_set;
                synchronized (set4) {
                    active_set.remove(hash_str);
                }
                this.complete_sem.releaseForever();
                throw throwable;
            }
            synchronized (set) {
                active_set.remove(hash_str);
            }
            this.complete_sem.releaseForever();
            {
                break block108;
                catch (Throwable e3) {
                    Debug.out(e3);
                    Object var44_88 = null;
                    Set<String> set5 = active_set;
                    synchronized (set5) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                    break block108;
                }
            }
            {
                catch (Throwable e) {
                    Set<String> set6;
                    boolean was_cancelled = this.cancelled;
                    this.cancelSupport(true);
                    if (!was_cancelled) {
                        listener.failed(e);
                        Debug.out(e);
                    }
                    Object var39_70 = null;
                    try {
                        block114: {
                            ArrayList<DiskManagerRequest> to_cancel;
                            if (download != null) {
                                try {
                                    download.stop();
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                try {
                                    download.remove();
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                            MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                            synchronized (magnetPluginMDDownloader) {
                                to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                                this.requests.clear();
                            }
                            for (DiskManagerRequest request2 : to_cancel) {
                                request2.cancel();
                            }
                            if (torrent_file != null) {
                                torrent_file.delete();
                            }
                            if (data_file != null) {
                                data_file.delete();
                            }
                            if (tmp_dir == null) break block114;
                            tmp_dir.delete();
                        }
                        Object var44_90 = null;
                        set6 = active_set;
                    }
                    catch (Throwable throwable) {
                        Object var44_92 = null;
                        Set<String> set7 = active_set;
                        synchronized (set7) {
                            active_set.remove(hash_str);
                        }
                        this.complete_sem.releaseForever();
                        throw throwable;
                    }
                    synchronized (set6) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                    {
                        break block108;
                        catch (Throwable e3) {
                            Debug.out(e3);
                            Object var44_91 = null;
                            Set<String> set8 = active_set;
                            synchronized (set8) {
                                active_set.remove(hash_str);
                            }
                            this.complete_sem.releaseForever();
                            break block108;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block120: {
                    Set<String> set9;
                    Object var39_71 = null;
                    try {
                        block118: {
                            ArrayList<DiskManagerRequest> to_cancel;
                            if (download != null) {
                                try {
                                    download.stop();
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                try {
                                    download.remove();
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                            MagnetPluginMDDownloader magnetPluginMDDownloader = this;
                            synchronized (magnetPluginMDDownloader) {
                                to_cancel = new ArrayList<DiskManagerRequest>(this.requests);
                                this.requests.clear();
                            }
                            for (DiskManagerRequest request2 : to_cancel) {
                                request2.cancel();
                            }
                            if (torrent_file != null) {
                                torrent_file.delete();
                            }
                            if (data_file != null) {
                                data_file.delete();
                            }
                            if (tmp_dir == null) break block118;
                            tmp_dir.delete();
                        }
                        Object var44_93 = null;
                        set9 = active_set;
                    }
                    catch (Throwable throwable2) {
                        Object var44_95 = null;
                        Set<String> set10 = active_set;
                        synchronized (set10) {
                            active_set.remove(hash_str);
                        }
                        this.complete_sem.releaseForever();
                        throw throwable2;
                    }
                    synchronized (set9) {
                        active_set.remove(hash_str);
                    }
                    this.complete_sem.releaseForever();
                    {
                        break block120;
                        catch (Throwable e3) {
                            Debug.out(e3);
                            Object var44_94 = null;
                            Set<String> set11 = active_set;
                            synchronized (set11) {
                                active_set.remove(hash_str);
                            }
                            this.complete_sem.releaseForever();
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface DownloadListener {
        public void reportProgress(int var1, int var2);

        public void complete(TOTorrent var1, Set<String> var2);

        public void failed(Throwable var1);
    }
}

