/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyPluginUtils {
    private static AsyncDispatcher peek_dispatcher = new AsyncDispatcher("peeker");

    private static BuddyPlugin getPlugin() {
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azbuddy", true);
        if (pi != null) {
            return (BuddyPlugin)pi.getPlugin();
        }
        return null;
    }

    public static BuddyPluginBeta getBetaPlugin() {
        BuddyPluginBeta beta;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && (beta = bp.getBeta()).isAvailable()) {
            return beta;
        }
        return null;
    }

    public static boolean isBetaChatAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable();
        }
        return false;
    }

    public static boolean isBetaChatAnonAvailable() {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().isAvailable() && bp.getBeta().isI2PAvailable();
        }
        return false;
    }

    public static void createBetaChat(final String network, final String key, final Runnable callback) {
        new AEThread2("Chat create async"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
                        bp.getBeta().getAndShowChat(network, key);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        Object var3_4 = null;
                        if (callback != null) {
                            callback.run();
                        }
                    }
                    Object var3_3 = null;
                    if (callback != null) {
                        callback.run();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (callback != null) {
                        callback.run();
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    public static Map<String, Object> peekChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(net, key);
        }
        return null;
    }

    public static Map<String, Object> peekChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().peekChat(download, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void peekChatAsync(final String net, final String key, final Runnable done) {
        boolean async;
        block4: {
            block5: {
                async = false;
                try {
                    if (!BuddyPluginUtils.isBetaChatAvailable()) break block4;
                    if (net != "Public" && !BuddyPluginUtils.isBetaChatAnonAvailable()) {
                        Object var5_4 = null;
                        if (async) return;
                        done.run();
                        return;
                    }
                    if (peek_dispatcher.getQueueSize() > 200) {
                        break block5;
                    }
                    peek_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            try {
                                Map<String, Object> peek_data = BuddyPluginUtils.peekChat(net, key);
                                if (peek_data != null) {
                                    BuddyPluginBeta.ChatInstance chat;
                                    Number message_count = (Number)peek_data.get("m");
                                    Number node_count = (Number)peek_data.get("n");
                                    if (message_count != null && node_count != null && message_count.intValue() > 0 && (chat = BuddyPluginUtils.getChat(net, key)) != null) {
                                        chat.setAutoNotify(true);
                                    }
                                }
                                Object var6_5 = null;
                                done.run();
                            }
                            catch (Throwable throwable) {
                                Object var6_6 = null;
                                done.run();
                                throw throwable;
                            }
                        }
                    });
                    async = true;
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (async) throw throwable;
                    done.run();
                    throw throwable;
                }
            }
            Object var5_5 = null;
            if (async) return;
            done.run();
            return;
        }
        Object var5_6 = null;
        if (async) return;
        done.run();
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(String net, String key, Map<String, Object> options) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            try {
                return bp.getBeta().getChat(net, key, options);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return null;
    }

    public static BuddyPluginBeta.ChatInstance getChat(Download download) {
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled()) {
            return bp.getBeta().getChat(download);
        }
        return null;
    }

    public static BuddyPluginViewInterface.View buildChatView(Map<String, Object> properties, BuddyPluginViewInterface.ViewListener listener) {
        BuddyPluginViewInterface ui;
        BuddyPlugin bp = BuddyPluginUtils.getPlugin();
        if (bp != null && bp.isBetaEnabled() && bp.getBeta().isAvailable() && (ui = bp.getSWTUI()) != null) {
            return ui.buildView(properties, listener);
        }
        return null;
    }

    public static String getChatKey(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        return BuddyPluginUtils.getChatKey(PluginCoreUtils.wrap(torrent));
    }

    public static String getChatKey(Download download) {
        return BuddyPluginUtils.getChatKey(download.getTorrent());
    }

    public static String getChatKey(Torrent torrent) {
        if (torrent == null) {
            return null;
        }
        String torrent_name = null;
        try {
            TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
            torrent_name = to_torrent.getUTF8Name();
            if (torrent_name == null) {
                torrent_name = new String(to_torrent.getName(), "UTF-8");
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (torrent_name == null) {
            torrent_name = torrent.getName();
        }
        String key = "Download: " + torrent_name + " {" + ByteFormatter.encodeString(torrent.getHash()) + "}";
        return key;
    }
}

