/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.startstoprules.defaultplugin;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DownloadingRankColumnListener;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.SeedingRankColumnListener;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesFPListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartStopRulesDefaultPlugin
implements Plugin,
COConfigurationListener,
AEDiagnosticsEvidenceGenerator {
    private static final String sStates = " WPRDS.XEQ";
    public static final int RANK_NONE = 0;
    public static final int RANK_SPRATIO = 1;
    public static final int RANK_SEEDCOUNT = 2;
    public static final int RANK_TIMED = 3;
    public static final int RANK_PEERCOUNT = 4;
    private static final int FORCE_CHECK_PERIOD = 60000;
    private static final int CHECK_FOR_GROSS_CHANGE_PERIOD = 30000;
    private static final int PROCESS_CHECK_PERIOD = 1500;
    private static final int MIN_SEEDING_STARTUP_WAIT = 20000;
    private static final int MIN_FIRST_SCRAPE_WAIT = 90000;
    private static final float IGNORE_SLOT_THRESHOLD_FACTOR = 0.9f;
    private static final int MIN_DOWNLOADING_STARTUP_WAIT = 30000;
    private static final int SMOOTHING_PERIOD_SECS = 15;
    private static final int SMOOTHING_PERIOD = 15000;
    private Average globalDownloadSpeedAverage = AverageFactory.MovingImmediateAverage(10);
    private AEMonitor this_mon = new AEMonitor("StartStopRules");
    private PluginInterface pi;
    protected PluginConfig plugin_config;
    private DownloadManager download_manager;
    protected LoggerChannel log;
    private RecalcSeedingRanksTask recalcSeedingRanksTask;
    private static Map<Download, DefaultRankCalculator> downloadDataMap = Collections.synchronizedMap(new HashMap());
    private volatile DefaultRankCalculator[] sortedArrayCache;
    private volatile boolean closingDown;
    private volatile boolean somethingChanged;
    private Set ranksToRecalc = new LightHashSet();
    private AEMonitor ranksToRecalc_mon = new AEMonitor("ranksToRecalc");
    private long monoStartedOn;
    protected boolean bDebugLog;
    private int iRankType = -1;
    private int minSpeedForActiveSeeding;
    private int maxStalledSeeding;
    private int numPeersAsFullCopy;
    private int iFakeFullCopySeedStart;
    private int _maxActive;
    private boolean _maxActiveWhenSeedingEnabled;
    private int _maxActiveWhenSeeding;
    private int globalDownloadLimit;
    private int globalUploadLimit;
    private int globalUploadWhenSeedingLimit;
    private int maxConfiguredDownloads;
    private boolean bMaxDownloadIgnoreChecking;
    private int minDownloads;
    private boolean bAutoReposition;
    private long minTimeAlive;
    private boolean bAutoStart0Peers;
    private boolean bStopOnceBandwidthMet = false;
    private boolean bStartNoMoreSeedsWhenUpLimitMet = false;
    private boolean bStartNoMoreSeedsWhenUpLimitMetPercent = true;
    private int bStartNoMoreSeedsWhenUpLimitMetSlack = 95;
    private int iDownloadSortType;
    private int iDownloadTestTimeMillis;
    private int iDownloadReTestMillis;
    private static boolean bAlreadyInitialized = false;
    private TableColumn seedingRankColumn;
    private TableContextMenuItem debugMenuItem = null;
    private UIAdapter swt_ui;
    private CopyOnWriteList listenersFP = new CopyOnWriteList();
    public static boolean pauseChangeFlagChecker = false;
    private volatile boolean immediateProcessingScheduled = false;
    private long changeCheckCount = 0L;
    private long changeCheckTotalMS = 0L;
    private long changeCheckMaxMS = 0L;
    private long processCount = 0L;
    private long processTotalMS = 0L;
    private long processMaxMS = 0L;
    private long processLastComplete = 0L;
    private long processTotalGap = 0L;
    private long processTotalRecalcs = 0L;
    private long processTotalZeroRecalcs = 0L;
    private DefaultRankCalculator dlr_current_active;
    private long dlr_max_rate_time;
    private long processMergeCount = 0L;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", "Start/Stop Rules");
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        if (bAlreadyInitialized) {
            System.err.println("StartStopRulesDefaultPlugin Already initialized!!");
        } else {
            bAlreadyInitialized = true;
        }
        AEDiagnostics.addEvidenceGenerator(this);
        this.monoStartedOn = SystemTime.getMonotonousTime();
        this.pi = _plugin_interface;
        this.plugin_config = this.pi.getPluginconfig();
        this.plugin_config.setPluginConfigKeyPrefix("");
        this.download_manager = this.pi.getDownloadManager();
        UIManager manager = this.pi.getUIManager();
        final BasicPluginConfigModel configModel = manager.createBasicPluginConfigModel("root", "Q");
        this.setupConfigModel(configModel);
        this.pi.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
                StartStopRulesDefaultPlugin.this.closingDown = true;
                COConfigurationManager.removeListener(StartStopRulesDefaultPlugin.this);
            }

            public void closedownComplete() {
            }
        });
        Runnable r = new Runnable(){

            public void run() {
                StartStopRulesDefaultPlugin.this.download_manager.addListener(new StartStopDMListener());
                SimpleTimer.addPeriodicEvent("StartStop:gross", 30000L, new ChangeCheckerTimerTask());
                SimpleTimer.addPeriodicEvent("StartStop:check", 1500L, new ChangeFlagCheckerTask());
            }
        };
        this.pi.getUtilities().createDelayedTask(r).queue();
        this.log = this.pi.getLogger().getTimeStampedChannel("StartStopRules");
        this.log.log(1, "Default StartStopRules Plugin Initialisation");
        COConfigurationManager.addListener(this);
        try {
            this.pi.getUIManager().createLoggingViewModel(this.log, true);
            this.pi.getUIManager().addUIListener(new UIManagerListener(){

                public void UIAttached(UIInstance instance) {
                    TableManager tm = StartStopRulesDefaultPlugin.this.pi.getUIManager().getTableManager();
                    StartStopRulesDefaultPlugin.this.seedingRankColumn = tm.createColumn("MySeeders", "SeedingRank");
                    StartStopRulesDefaultPlugin.this.seedingRankColumn.initialize(2, -2, 80, -2);
                    TableCellRefreshListener columnListener = new SeedingRankColumnListener(downloadDataMap, StartStopRulesDefaultPlugin.this.plugin_config);
                    StartStopRulesDefaultPlugin.this.seedingRankColumn.addCellRefreshListener(columnListener);
                    tm.addColumn(StartStopRulesDefaultPlugin.this.seedingRankColumn);
                    TableColumn downloadingRankColumn = tm.createColumn("MyTorrents", "DownloadingRank");
                    downloadingRankColumn.setMinimumRequiredUserMode(1);
                    downloadingRankColumn.initialize(2, -1, 80, -2);
                    columnListener = new DownloadingRankColumnListener(StartStopRulesDefaultPlugin.this);
                    downloadingRankColumn.addCellRefreshListener(columnListener);
                    tm.addColumn(downloadingRankColumn);
                    if (instance.getUIType() == 1) {
                        configModel.destroy();
                        try {
                            StartStopRulesDefaultPlugin.this.swt_ui = (UIAdapter)Class.forName("com.aelitis.azureus.plugins.startstoprules.defaultplugin.ui.swt.StartStopRulesDefaultPluginSWTUI").getConstructor(PluginInterface.class).newInstance(StartStopRulesDefaultPlugin.this.pi);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                public void UIDetached(UIInstance instance) {
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.reloadConfigParams();
    }

    private void setupConfigModel(BasicPluginConfigModel configModel) {
        String PREFIX_RES = "ConfigView.label.seeding.";
        configModel.addIntParameter2("StartStopManager_iRankType", "ConfigView.label.seeding.rankType", 1);
        configModel.addIntParameter2("StartStopManager_iRankTypeSeedFallback", "ConfigView.label.seeding.rankType.seed.fallback", 0);
        configModel.addIntParameter2("StartStopManager_iTimed_MinSeedingTimeWithPeers", "ConfigView.label.seeding.rankType.timed.minTimeWithPeers", 0);
        configModel.addBooleanParameter2("StartStopManager_bAutoReposition", "ConfigView.label.seeding.autoReposition", false);
        configModel.addIntParameter2("StartStopManager_iMinSeedingTime", "ConfigView.label.minSeedingTime", 600);
        configModel.addBooleanParameter2("StartStopManager_bIgnore0Peers", "ConfigView.label.seeding.ignore0Peers", true);
        configModel.addIntParameter2("StartStopManager_iIgnoreSeedCount", "ConfigView.label.ignoreSeeds", 0);
        configModel.addIntParameter2("StartStopManager_iIgnoreRatioPeersSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        configModel.addIntParameter2("StartStopManager_iIgnoreShareRatioSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0);
        configModel.addBooleanParameter2("StartStopManager_bPreferLargerSwarms", "ConfigView.label.seeding.preferLargerSwarms", true);
        configModel.addBooleanParameter2("StartStopManager_bAutoStart0Peers", "ConfigView.label.seeding.autoStart0Peers", false);
        configModel.addIntParameter2("StartStopManager_iMinPeersToBoostNoSeeds", "ConfigView.label.minPeersToBoostNoSeeds", 1);
        configModel.addBooleanParameter2("StartStopManager_bMaxDownloadIgnoreChecking", "ConfigView.label.ignoreChecking", false);
        configModel.addIntParameter2("StartStopManager_iMinSpeedForActiveDL", "ConfigView.label.minSpeedForActiveDL", 512);
        configModel.addIntParameter2("StartStopManager_iMinSpeedForActiveSeeding", "ConfigView.label.minSpeedForActiveSeeding", 512);
        configModel.addIntParameter2("StartStopManager_iMaxStalledSeeding", "ConfigView.label.maxStalledSeeding", 5);
        configModel.addBooleanParameter2("StartStopManager_bDebugLog", "ConfigView.label.queue.debuglog", false);
        configModel.addBooleanParameter2("StartStopManager_bNewSeedsMoveTop", "ConfigView.label.queue.newseedsmovetop", true);
        configModel.addBooleanParameter2("StartStopManager_bRetainForceStartWhenComplete", "ConfigView.label.queue.retainforce", false);
        configModel.addIntParameter2("StartStopManager_iMaxActiveTorrentsWhenSeeding", "ConfigView.label.queue.maxactivetorrentswhenseeding", 0);
        configModel.addBooleanParameter2("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", "ConfigView.label.queue.maxactivetorrentswhenseeding", false);
        configModel.addBooleanParameter2("StartStopManager_bStopOnceBandwidthMet", "ConfigView.label.queue.stoponcebandwidthmet", true);
        configModel.addIntParameter2("StartStopManager_iFirstPriority_Type", "ConfigView.label.seeding.firstPriority", 1);
        configModel.addIntParameter2("StartStopManager_iFirstPriority_ShareRatio", "ConfigView.label.seeding.firstPriority.shareRatio", 500);
        configModel.addIntParameter2("StartStopManager_iFirstPriority_SeedingMinutes", "ConfigView.label.seeding.firstPriority.seedingMinutes", 0);
        configModel.addIntParameter2("StartStopManager_iFirstPriority_DLMinutes", "ConfigView.label.seeding.firstPriority.DLMinutes", 0);
        configModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreSPRatio", "ConfigView.label.seeding.firstPriority.ignoreSPRatio", 0);
        configModel.addBooleanParameter2("StartStopManager_bFirstPriority_ignore0Peer", "ConfigView.label.seeding.firstPriority.ignore0Peer", !COConfigurationManager.getStringParameter("ui", "").equals("az2"));
        configModel.addIntParameter2("StartStopManager_iFirstPriority_ignoreIdleHours", "ConfigView.label.seeding.firstPriority.ignoreIdleHours", 24);
        configModel.addIntParameter2("StartStopManager_iAddForSeedingDLCopyCount", "ConfigView.label.seeding.addForSeedingDLCopyCount", 1);
        configModel.addIntParameter2("StartStopManager_iNumPeersAsFullCopy", PREFIX_RES + "numPeersAsFullCopy", 0);
        configModel.addIntParameter2("StartStopManager_iFakeFullCopySeedStart", PREFIX_RES + "fakeFullCopySeedStart", 1);
        configModel.addBooleanParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMet", "ConfigView.label.seeding.StartStopManager_bStartNoMoreSeedsWhenUpLimitMet", false);
        configModel.addBooleanParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetPercent", "ConfigView.label.seeding.bStartNoMoreSeedsWhenUpLimitMetPercent", true);
        configModel.addIntParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetSlack", "ConfigView.label.seeding.bStartNoMoreSeedsWhenUpLimitMetSlack", 95);
        PREFIX_RES = "ConfigView.label.downloading.";
        configModel.addIntParameter2("StartStopManager_Downloading_iSortType", "ConfigView.label.downloading.autoReposition", 0);
        configModel.addIntParameter2("StartStopManager_Downloading_iTestTimeSecs", PREFIX_RES + "testTime", 120);
        configModel.addIntParameter2("StartStopManager_Downloading_iRetestTimeMins", PREFIX_RES + "reTest", 30);
        configModel.destroy();
    }

    public static DefaultRankCalculator getRankCalculator(Download dl) {
        return downloadDataMap.get(dl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcAllSeedingRanks(boolean force) {
        if (this.closingDown) {
            return;
        }
        try {
            DefaultRankCalculator[] dlDataArray;
            this.this_mon.enter();
            Map<Download, DefaultRankCalculator> map = downloadDataMap;
            synchronized (map) {
                dlDataArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
            }
            for (int i = 0; i < dlDataArray.length; ++i) {
                if (force) {
                    dlDataArray[i].getDownloadObject().setSeedingRank(0);
                }
                dlDataArray[i].recalcSeedingRank();
            }
            Object var6_6 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void configurationSaved() {
        new AEThread2("reloadConfigParams", true){

            public void run() {
                StartStopRulesDefaultPlugin.this.reloadConfigParams();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigParams() {
        try {
            this.this_mon.enter();
            int iNewRankType = this.plugin_config.getIntParameter("StartStopManager_iRankType");
            this.minSpeedForActiveSeeding = this.plugin_config.getIntParameter("StartStopManager_iMinSpeedForActiveSeeding");
            this.maxStalledSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxStalledSeeding");
            if (this.maxStalledSeeding <= 0) {
                this.maxStalledSeeding = 999;
            }
            this._maxActive = this.plugin_config.getIntParameter("max active torrents");
            this._maxActiveWhenSeedingEnabled = this.plugin_config.getBooleanParameter("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
            this._maxActiveWhenSeeding = this.plugin_config.getIntParameter("StartStopManager_iMaxActiveTorrentsWhenSeeding");
            this.minDownloads = this.plugin_config.getIntParameter("min downloads");
            this.maxConfiguredDownloads = this.plugin_config.getIntParameter("max downloads");
            this.bMaxDownloadIgnoreChecking = this.plugin_config.getBooleanParameter("StartStopManager_bMaxDownloadIgnoreChecking");
            this.numPeersAsFullCopy = this.plugin_config.getIntParameter("StartStopManager_iNumPeersAsFullCopy");
            this.iFakeFullCopySeedStart = this.plugin_config.getIntParameter("StartStopManager_iFakeFullCopySeedStart");
            this.bAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_bAutoReposition");
            this.minTimeAlive = this.plugin_config.getIntParameter("StartStopManager_iMinSeedingTime") * 1000;
            this.bDebugLog = this.plugin_config.getBooleanParameter("StartStopManager_bDebugLog");
            this.bAutoStart0Peers = this.plugin_config.getBooleanParameter("StartStopManager_bAutoStart0Peers");
            this.globalDownloadLimit = this.plugin_config.getIntParameter("Max Download Speed KBs", 0);
            this.globalUploadLimit = this.plugin_config.getIntParameter("Max Upload Speed KBs", 0);
            this.globalUploadWhenSeedingLimit = this.plugin_config.getBooleanParameter("enable.seedingonly.upload.rate") ? this.plugin_config.getIntParameter("Max Upload Speed Seeding KBs", 0) : this.globalUploadLimit;
            this.bStopOnceBandwidthMet = this.plugin_config.getBooleanParameter("StartStopManager_bStopOnceBandwidthMet");
            this.bStartNoMoreSeedsWhenUpLimitMet = this.plugin_config.getBooleanParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMet");
            this.bStartNoMoreSeedsWhenUpLimitMetPercent = this.plugin_config.getBooleanParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetPercent");
            this.bStartNoMoreSeedsWhenUpLimitMetSlack = this.plugin_config.getIntParameter("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetSlack");
            boolean move_top = this.plugin_config.getBooleanParameter("StartStopManager_bNewSeedsMoveTop");
            this.plugin_config.setBooleanParameter("Newly Seeding Torrents Get First Priority", move_top);
            if (iNewRankType != this.iRankType) {
                this.iRankType = iNewRankType;
                if (this.iRankType == 3) {
                    if (this.recalcSeedingRanksTask == null) {
                        this.recalcAllSeedingRanks(false);
                        this.recalcSeedingRanksTask = new RecalcSeedingRanksTask();
                        SimpleTimer.addPeriodicEvent("StartStop:recalcSR", 1000L, this.recalcSeedingRanksTask);
                    }
                } else if (this.recalcSeedingRanksTask != null) {
                    this.recalcSeedingRanksTask.cancel();
                    this.recalcSeedingRanksTask = null;
                }
            }
            this.iDownloadSortType = this.plugin_config.getIntParameter("StartStopManager_Downloading_iSortType", -1);
            if (this.iDownloadSortType == -1) {
                boolean bDownloadAutoReposition = this.plugin_config.getBooleanParameter("StartStopManager_Downloading_bAutoReposition");
                this.iDownloadSortType = bDownloadAutoReposition ? 2 : 0;
                this.plugin_config.setIntParameter("StartStopManager_Downloading_iSortType", this.iDownloadSortType);
            }
            this.iDownloadTestTimeMillis = this.plugin_config.getIntParameter("StartStopManager_Downloading_iTestTimeSecs") * 1000;
            this.iDownloadReTestMillis = this.plugin_config.getIntParameter("StartStopManager_Downloading_iRetestTimeMins") * 60 * 1000;
            Collection<DefaultRankCalculator> allDownloads = downloadDataMap.values();
            DefaultRankCalculator[] dlDataArray = allDownloads.toArray(new DefaultRankCalculator[0]);
            for (int i = 0; i < dlDataArray.length; ++i) {
                dlDataArray[i].getDownloadObject().setSeedingRank(0);
            }
            try {
                this.ranksToRecalc_mon.enter();
                Map<Download, DefaultRankCalculator> i = downloadDataMap;
                synchronized (i) {
                    this.ranksToRecalc.addAll(allDownloads);
                }
                Object var8_11 = null;
                this.ranksToRecalc_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.ranksToRecalc_mon.exit();
                throw throwable;
            }
            this.requestProcessCycle(null);
            if (this.bDebugLog) {
                this.log.log(1, "somethingChanged: config reload");
                try {
                    if (this.debugMenuItem == null) {
                        String DEBUG_MENU_ID = "StartStopRules.menu.viewDebug";
                        MenuItemListener menuListener = new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                if (!(target instanceof TableRow)) {
                                    return;
                                }
                                TableRow tr = (TableRow)target;
                                Object ds = tr.getDataSource();
                                if (!(ds instanceof Download)) {
                                    return;
                                }
                                DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(ds);
                                if (dlData != null) {
                                    if (StartStopRulesDefaultPlugin.this.swt_ui != null) {
                                        StartStopRulesDefaultPlugin.this.swt_ui.openDebugWindow(dlData);
                                    } else {
                                        StartStopRulesDefaultPlugin.this.pi.getUIManager().showTextMessage(null, null, "FP:\n" + dlData.sExplainFP + "\n" + "SR:" + dlData.sExplainSR + "\n" + "TRACE:\n" + dlData.sTrace);
                                    }
                                }
                            }
                        };
                        TableManager tm = this.pi.getUIManager().getTableManager();
                        this.debugMenuItem = tm.addContextMenuItem("MySeeders", "StartStopRules.menu.viewDebug");
                        this.debugMenuItem.addListener(menuListener);
                        this.debugMenuItem = tm.addContextMenuItem("MyTorrents", "StartStopRules.menu.viewDebug");
                        this.debugMenuItem.addListener(menuListener);
                    }
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
            Object var10_15 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    private int calcMaxSeeders(int iDLs) {
        int maxActive = this.getMaxActive();
        if (maxActive == 0) {
            return 999999;
        }
        return maxActive - iDLs;
    }

    protected int getMaxActive() {
        if (!this._maxActiveWhenSeedingEnabled) {
            return this._maxActive;
        }
        if (this.download_manager.isSeedingOnly()) {
            if (this._maxActiveWhenSeeding <= this._maxActive) {
                return this._maxActiveWhenSeeding;
            }
            Download[] downloads = this.download_manager.getDownloads();
            boolean danger = false;
            block0: for (int i = 0; i < downloads.length && !danger; ++i) {
                Download download = downloads[i];
                int state = download.getState();
                if (state == 4 || state == 5 || state == 7 || state == 6 || state == 8) continue;
                DiskManagerFileInfo[] files = download.getDiskManagerFileInfo();
                for (int j = 0; j < files.length; ++j) {
                    DiskManagerFileInfo file = files[j];
                    if (file.isSkipped() || file.getDownloaded() == file.getLength()) continue;
                    danger = true;
                    continue block0;
                }
            }
            if (!danger) {
                return this._maxActiveWhenSeeding;
            }
        }
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        block35: {
            long now = 0L;
            try {
                Object[] dlDataArray;
                Object rankObj;
                Object[] recalcArray;
                this.this_mon.enter();
                now = SystemTime.getCurrentTime();
                this.somethingChanged = false;
                try {
                    this.ranksToRecalc_mon.enter();
                    recalcArray = this.ranksToRecalc.toArray();
                    this.ranksToRecalc.clear();
                    Object var5_3 = null;
                    this.ranksToRecalc_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.ranksToRecalc_mon.exit();
                    throw throwable;
                }
                for (int i = 0; i < recalcArray.length; ++i) {
                    rankObj = (DefaultRankCalculator)recalcArray[i];
                    if (this.bDebugLog) {
                        long oldSR = ((DefaultRankCalculator)rankObj).dl.getSeedingRank();
                        ((DefaultRankCalculator)rankObj).recalcSeedingRank();
                        String s = "recalc seeding rank.  old/new=" + oldSR + "/" + ((DefaultRankCalculator)rankObj).dl.getSeedingRank();
                        this.log.log((Object)((DefaultRankCalculator)rankObj).dl.getTorrent(), 1, s);
                        continue;
                    }
                    ((DefaultRankCalculator)rankObj).recalcSeedingRank();
                }
                this.processTotalRecalcs += (long)recalcArray.length;
                if (recalcArray.length == 0) {
                    ++this.processTotalZeroRecalcs;
                }
                if (this.sortedArrayCache != null && this.sortedArrayCache.length == downloadDataMap.size()) {
                    dlDataArray = this.sortedArrayCache;
                } else {
                    rankObj = downloadDataMap;
                    synchronized (rankObj) {
                        this.sortedArrayCache = downloadDataMap.values().toArray(new DefaultRankCalculator[downloadDataMap.size()]);
                        dlDataArray = this.sortedArrayCache;
                    }
                }
                TotalsStats totals = new TotalsStats((DefaultRankCalculator[])dlDataArray);
                String[] mainDebugEntries = null;
                if (this.bDebugLog) {
                    this.log.log(1, ">>process()");
                    mainDebugEntries = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents, "maxA=" + totals.maxActive};
                }
                Arrays.sort(dlDataArray);
                ProcessVars vars = new ProcessVars();
                vars.numWaitingOrSeeding = totals.forcedSeeding;
                vars.numWaitingOrDLing = 0;
                vars.higherCDtoStart = false;
                vars.higherDLtoStart = false;
                vars.posComplete = 0;
                vars.stalledSeeders = 0;
                ArrayList<DefaultRankCalculator> incompleteDownloads = new ArrayList<DefaultRankCalculator>();
                for (int i = 0; i < dlDataArray.length; ++i) {
                    int state;
                    Object dlData = dlDataArray[i];
                    Download download = ((DefaultRankCalculator)dlData).getDownloadObject();
                    vars.bStopAndQueued = false;
                    ((DefaultRankCalculator)dlData).sTrace = "";
                    if (download.getState() == 1) {
                        try {
                            download.initialize();
                            String s = "initialize: state is waiting";
                            this.log.log((Object)download.getTorrent(), 1, s);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        if (this.bDebugLog && download.getState() == 1) {
                            ((DefaultRankCalculator)dlData).sTrace = ((DefaultRankCalculator)dlData).sTrace + "still in waiting state after initialize!\n";
                        }
                    }
                    if (this.bAutoReposition && this.iRankType != 0 && download.isComplete() && (totals.bOkToStartSeeding || totals.firstPriority > 0)) {
                        download.setPosition(++vars.posComplete);
                    }
                    if ((state = download.getState()) == 6 || state == 7 || state == 8) continue;
                    if (download.isForceStart()) {
                        String s;
                        if (state == 7 || state == 9) {
                            try {
                                download.restart();
                                s = "restart: isForceStart";
                                this.log.log((Object)download.getTorrent(), 1, s);
                                ((DefaultRankCalculator)dlData).sTrace = ((DefaultRankCalculator)dlData).sTrace + s + "\n";
                            }
                            catch (DownloadException e) {
                                // empty catch block
                            }
                            state = download.getState();
                        }
                        if (state == 3) {
                            try {
                                download.start();
                                s = "Start: isForceStart";
                                this.log.log((Object)download.getTorrent(), 1, s);
                                ((DefaultRankCalculator)dlData).sTrace = ((DefaultRankCalculator)dlData).sTrace + s + "\n";
                            }
                            catch (DownloadException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (!download.isComplete()) {
                        incompleteDownloads.add((DefaultRankCalculator)dlData);
                        this.handleInCompleteDownload((DefaultRankCalculator)dlData, vars, totals);
                        continue;
                    }
                    this.handleCompletedDownload((DefaultRankCalculator[])dlDataArray, (DefaultRankCalculator)dlData, vars, totals);
                }
                this.processDownloadingRules(incompleteDownloads);
                if (this.bDebugLog) {
                    String[] mainDebugEntries2 = new String[]{"ok2Start=" + this.boolDebug(totals.bOkToStartSeeding), "tFrcdCding=" + totals.forcedSeeding, "actvCDs=" + totals.activelyCDing, "tW8tingToCd=" + totals.waitingToSeed, "tDLing=" + totals.downloading, "actvDLs=" + totals.activelyDLing, "tW8tingToDL=" + totals.waitingToDL, "tCom=" + totals.complete, "tIncQd=" + totals.incompleteQueued, "mxCdrs=" + totals.maxSeeders, "tFP=" + totals.firstPriority, "maxT=" + totals.maxTorrents, "maxA=" + totals.maxActive};
                    this.printDebugChanges("<<process() ", mainDebugEntries, mainDebugEntries2, "", "", true, null);
                }
                Object var15_23 = null;
                if (now <= 0L) break block35;
                ++this.processCount;
            }
            catch (Throwable throwable) {
                Object var15_24 = null;
                if (now > 0L) {
                    ++this.processCount;
                    long timeTaken = SystemTime.getCurrentTime() - now;
                    if (this.bDebugLog) {
                        this.log.log(1, "process() took " + timeTaken);
                    }
                    this.processTotalMS += timeTaken;
                    if (timeTaken > this.processMaxMS) {
                        this.processMaxMS = timeTaken;
                    }
                    if (this.processLastComplete > 0L) {
                        this.processTotalGap += now - this.processLastComplete;
                    }
                    this.processLastComplete = now;
                }
                this.immediateProcessingScheduled = false;
                this.this_mon.exit();
                throw throwable;
            }
            long timeTaken = SystemTime.getCurrentTime() - now;
            if (this.bDebugLog) {
                this.log.log(1, "process() took " + timeTaken);
            }
            this.processTotalMS += timeTaken;
            if (timeTaken > this.processMaxMS) {
                this.processMaxMS = timeTaken;
            }
            if (this.processLastComplete > 0L) {
                this.processTotalGap += now - this.processLastComplete;
            }
            this.processLastComplete = now;
            {
            }
        }
        this.immediateProcessingScheduled = false;
        this.this_mon.exit();
    }

    private void processDownloadingRules(List<DefaultRankCalculator> downloads) {
        long mono_now = SystemTime.getMonotonousTime();
        if (mono_now - this.monoStartedOn < 30000L) {
            return;
        }
        if (this.iDownloadSortType != 2 && this.dlr_current_active != null) {
            this.dlr_current_active.setDLRInactive();
            this.dlr_current_active = null;
        }
        if (this.iDownloadSortType == 0) {
            return;
        }
        if (this.iDownloadSortType == 1) {
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){

                @Override
                public int compare(DefaultRankCalculator d1, DefaultRankCalculator d2) {
                    DownloadScrapeResult s1 = d1.getDownloadObject().getAggregatedScrapeResult();
                    DownloadScrapeResult s2 = d2.getDownloadObject().getAggregatedScrapeResult();
                    int result = s2.getSeedCount() - s1.getSeedCount();
                    if (result == 0) {
                        result = s2.getNonSeedCount() - s1.getNonSeedCount();
                    }
                    return result;
                }
            });
            for (int i = 0; i < downloads.size(); ++i) {
                DefaultRankCalculator drc = downloads.get(i);
                if (drc.dl.getPosition() == i + 1) continue;
                drc.dl.moveTo(i + 1);
            }
        } else {
            if (this.dlr_current_active != null && !downloads.contains(this.dlr_current_active)) {
                this.dlr_current_active.setDLRInactive();
                this.dlr_current_active = null;
            }
            if (downloads.size() < 2) {
                return;
            }
            if (this.globalDownloadLimit > 0) {
                int downloadKBSec = (int)(this.globalDownloadSpeedAverage.getAverage() * 1000.0 / 1500.0 / 1024.0);
                if (this.globalDownloadLimit - downloadKBSec < 5) {
                    if (this.dlr_max_rate_time == 0L) {
                        this.dlr_max_rate_time = mono_now;
                    } else if (mono_now - this.dlr_max_rate_time >= 60000L) {
                        if (this.dlr_current_active != null) {
                            this.dlr_current_active.setDLRInactive();
                            this.dlr_current_active = null;
                        }
                        return;
                    }
                } else {
                    this.dlr_max_rate_time = 0L;
                }
            } else {
                this.dlr_max_rate_time = 0L;
            }
            if (this.dlr_current_active != null) {
                long last_test = this.dlr_current_active.getDLRLastTestTime();
                long tested_ago = mono_now - last_test;
                if (tested_ago < (long)this.iDownloadTestTimeMillis) {
                    return;
                }
                this.dlr_current_active.setDLRComplete(mono_now);
                this.dlr_current_active = null;
            }
            if (this.dlr_current_active == null) {
                DefaultRankCalculator to_test = null;
                long oldest_test = 0L;
                long adjustedReTest = this.iDownloadReTestMillis + this.iDownloadTestTimeMillis * downloads.size();
                for (DefaultRankCalculator drc : downloads) {
                    long tested_ago;
                    if (!drc.isQueued()) continue;
                    long last_test = drc.getDLRLastTestTime();
                    if (last_test == 0L) {
                        to_test = drc;
                        break;
                    }
                    if (this.iDownloadReTestMillis <= 0 || (tested_ago = mono_now - last_test) < adjustedReTest || tested_ago <= oldest_test) continue;
                    oldest_test = tested_ago;
                    to_test = drc;
                }
                if (to_test != null) {
                    this.dlr_current_active = to_test;
                    to_test.setDLRActive(mono_now);
                }
            }
            Collections.sort(downloads, new Comparator<DefaultRankCalculator>(){

                @Override
                public int compare(DefaultRankCalculator o1, DefaultRankCalculator o2) {
                    if (o1 == StartStopRulesDefaultPlugin.this.dlr_current_active) {
                        return -1;
                    }
                    if (o2 == StartStopRulesDefaultPlugin.this.dlr_current_active) {
                        return 1;
                    }
                    int speed1 = o1.getDLRLastTestSpeed();
                    int speed2 = o2.getDLRLastTestSpeed();
                    int res = speed2 - speed1;
                    if (res == 0) {
                        res = o1.dl.getPosition() - o2.dl.getPosition();
                    }
                    return res;
                }
            });
            for (int i = 0; i < downloads.size(); ++i) {
                DefaultRankCalculator drc = downloads.get(i);
                if (drc.getDLRLastTestSpeed() <= 0 || drc.dl.getPosition() == i + 1) continue;
                drc.dl.moveTo(i + 1);
            }
        }
    }

    private int getMaxDownloads() {
        if (this.dlr_current_active == null) {
            return this.maxConfiguredDownloads;
        }
        return this.maxConfiguredDownloads + 1;
    }

    private void handleInCompleteDownload(DefaultRankCalculator dlData, ProcessVars vars, TotalsStats totals) {
        int oldState;
        boolean fakedActively;
        boolean globalRateAdjustedActivelyDownloading;
        boolean globalDownLimitReached;
        org.gudy.azureus2.core3.download.DownloadManager core_dm;
        Download download = dlData.dl;
        int state = download.getState();
        if (download.isForceStart()) {
            if (this.bDebugLog) {
                String s = "isForceStart.. rules skipped";
                this.log.log((Object)download.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
            return;
        }
        if (this.bMaxDownloadIgnoreChecking && (core_dm = PluginCoreUtils.unwrap(download)) != null && core_dm.getState() == 30) {
            if (this.bDebugLog) {
                String s = "isChecking.. rules skipped";
                this.log.log((Object)download.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
            return;
        }
        if (state == 2) {
            ++vars.numWaitingOrDLing;
            if (this.bDebugLog) {
                String s = "ST_PREPARING.. rules skipped. numW8tngorDLing=" + vars.numWaitingOrDLing;
                this.log.log((Object)download.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
            return;
        }
        int maxDLs = 0;
        int maxDownloads = this.getMaxDownloads();
        if (totals.maxActive == 0) {
            maxDLs = maxDownloads;
        } else {
            int DLmax = 0;
            DLmax = totals.stalledFPSeeders + totals.forcedActive + totals.maxActive - totals.firstPriority - totals.forcedSeedingNonFP;
            int n = DLmax <= 0 ? 0 : (maxDLs = maxDownloads - DLmax <= 0 ? maxDownloads : DLmax);
        }
        if (maxDLs < this.minDownloads) {
            maxDLs = this.minDownloads;
        }
        boolean bActivelyDownloading = dlData.getActivelyDownloading();
        if (this.bStopOnceBandwidthMet) {
            boolean isRunning = download.getState() == 4;
            globalDownLimitReached = this.globalDownloadLimit > 0 && (double)vars.accumulatedDownloadSpeed / 1024.0 > (double)((float)this.globalDownloadLimit * 0.9f);
            globalRateAdjustedActivelyDownloading = bActivelyDownloading || isRunning && globalDownLimitReached;
            boolean bl = fakedActively = globalRateAdjustedActivelyDownloading && !bActivelyDownloading;
            if (fakedActively) {
                ++totals.activelyDLing;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
        } else {
            globalDownLimitReached = false;
            globalRateAdjustedActivelyDownloading = bActivelyDownloading;
            fakedActively = false;
        }
        if (this.bDebugLog) {
            String s = ">> DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + vars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";maxDLs=" + maxDLs + ";ActDLing=" + this.boolDebug(bActivelyDownloading) + ";globDwnRchd=" + this.boolDebug(globalDownLimitReached) + ";hgherQd=" + this.boolDebug(vars.higherDLtoStart) + ";isCmplt=" + this.boolDebug(download.isComplete());
            this.log.log((Object)download.getTorrent(), 1, s);
            dlData.sTrace = dlData.sTrace + s + "\n";
        }
        if (state == 4 && globalRateAdjustedActivelyDownloading || state == 3 || state == 1 || state == 2) {
            ++vars.numWaitingOrDLing;
        }
        if (state == 3 || state == 4 || state == 1) {
            boolean bDownloading;
            boolean bOverLimit = vars.numWaitingOrDLing > maxDLs || vars.numWaitingOrDLing >= maxDLs && vars.higherDLtoStart;
            boolean bl = bDownloading = state == 4;
            if (maxDownloads != 0 && bOverLimit && !download.isChecking() && !download.isMoving() && (globalRateAdjustedActivelyDownloading || !bDownloading || bDownloading && totals.maxActive != 0 && !globalRateAdjustedActivelyDownloading && totals.activelyCDing + totals.activelyDLing >= totals.maxActive)) {
                try {
                    if (this.bDebugLog) {
                        String s = "   stopAndQueue: " + vars.numWaitingOrDLing + " waiting or downloading, when limit is " + maxDLs + "(" + maxDownloads + ")";
                        if (vars.higherDLtoStart) {
                            s = s + " and higher DL is starting";
                        }
                        this.log.log((Object)download.getTorrent(), 1, s);
                        dlData.sTrace = dlData.sTrace + s + "\n";
                    }
                    download.stopAndQueue();
                    --vars.numWaitingOrDLing;
                    if (state == 4) {
                        --totals.downloading;
                        if (bActivelyDownloading || fakedActively) {
                            --totals.activelyDLing;
                        }
                    } else {
                        --totals.waitingToDL;
                    }
                    totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                state = download.getState();
            } else if (this.bDebugLog) {
                String s = "NOT queuing: ";
                s = maxDownloads == 0 ? s + "maxDownloads = " + maxDownloads : (!bOverLimit ? s + "not over limit.  numWaitingOrDLing(" + vars.numWaitingOrDLing + ") <= maxDLs(" + maxDLs + ")" : (!bActivelyDownloading || bDownloading ? s + "not actively downloading" : (totals.maxActive == 0 ? s + "unlimited active allowed (set)" : s + "# active(" + (totals.activelyCDing + totals.activelyDLing) + ") < maxActive(" + totals.maxActive + ")")));
                this.log.log((Object)download.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
        }
        if (state == 3 && (maxDownloads == 0 || totals.activelyDLing < maxDLs)) {
            try {
                if (this.bDebugLog) {
                    String s = "   start: READY && activelyDLing (" + totals.activelyDLing + ") < maxDLs (" + maxDownloads + ")";
                    this.log.log((Object)download.getTorrent(), 1, s);
                    dlData.sTrace = dlData.sTrace + s + "\n";
                }
                download.start();
                --totals.waitingToDL;
                ++totals.activelyDLing;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            state = download.getState();
        }
        if (state == 9 && (maxDownloads == 0 || vars.numWaitingOrDLing < maxDLs)) {
            try {
                if (this.bDebugLog) {
                    String s = "   restart: QUEUED && numWaitingOrDLing (" + vars.numWaitingOrDLing + ") < maxDLS (" + maxDLs + ")";
                    this.log.log(1, s);
                    dlData.sTrace = dlData.sTrace + s + "\n";
                }
                download.restart();
                ++vars.numWaitingOrDLing;
                ++totals.waitingToDL;
                totals.maxSeeders = this.calcMaxSeeders(totals.activelyDLing + totals.waitingToDL);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            state = download.getState();
        }
        if ((oldState = state) != (state = download.getState())) {
            if (this.bDebugLog) {
                this.log.log(1, ">> somethingChanged: state");
            }
            this.somethingChanged = true;
        }
        if (download.getSeedingRank() >= 0 && (state == 9 || state == 3 || state == 1 || state == 2)) {
            vars.higherDLtoStart = true;
        }
        if (this.bDebugLog) {
            String s = "<< DL state=" + sStates.charAt(download.getState()) + ";shareRatio=" + download.getStats().getShareRatio() + ";numW8tngorDLing=" + vars.numWaitingOrDLing + ";maxCDrs=" + totals.maxSeeders + ";forced=" + this.boolDebug(download.isForceStart()) + ";actvDLs=" + totals.activelyDLing + ";hgherQd=" + this.boolDebug(vars.higherDLtoStart) + ";ActDLing=" + this.boolDebug(dlData.getActivelyDownloading());
            this.log.log((Object)download.getTorrent(), 1, s);
            dlData.sTrace = dlData.sTrace + s + "\n";
        }
        if (this.bStopOnceBandwidthMet) {
            vars.accumulatedDownloadSpeed += download.getStats().getDownloadAverage();
            vars.accumulatedUploadSpeed += download.getStats().getUploadAverage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCompletedDownload(DefaultRankCalculator[] dlDataArray, DefaultRankCalculator dlData, ProcessVars vars, TotalsStats totals) {
        boolean isFP;
        String sDebugLine;
        String[] debugEntries;
        Download download;
        block72: {
            block71: {
                block70: {
                    if (!totals.bOkToStartSeeding) {
                        return;
                    }
                    download = dlData.dl;
                    int state = download.getState();
                    boolean stateReadyOrSeeding = state == 3 || state == 5;
                    debugEntries = null;
                    sDebugLine = "";
                    int numPeers = dlData.lastModifiedScrapeResultPeers;
                    isFP = false;
                    if (this.bDebugLog) {
                        isFP = dlData.isFirstPriority();
                        debugEntries = new String[]{"CD state=" + sStates.charAt(state), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.lastModifiedScrapeResultSeeds, "nPeers=" + dlData.lastModifiedScrapeResultPeers};
                    }
                    try {
                        int rank;
                        block73: {
                            boolean okToStop;
                            boolean fakedActively;
                            boolean globalRateAdjustedActivelySeeding;
                            boolean bActivelySeeding;
                            block76: {
                                block74: {
                                    boolean bSeeding;
                                    boolean bOverLimit;
                                    block75: {
                                        block77: {
                                            boolean okToQueue;
                                            boolean bScrapeOk = dlData.lastScrapeResultOk;
                                            if (this.bAutoStart0Peers && numPeers == 0 && bScrapeOk) {
                                                if (state == 9) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            sDebugLine = sDebugLine + "\nrestart() 0Peers";
                                                        }
                                                        download.restart();
                                                        ++totals.waitingToSeed;
                                                        ++vars.numWaitingOrSeeding;
                                                        state = download.getState();
                                                        if (state == 3) {
                                                            if (this.bDebugLog) {
                                                                sDebugLine = sDebugLine + "\nstart(); 0Peers";
                                                            }
                                                            download.start();
                                                            ++totals.activelyCDing;
                                                        }
                                                    }
                                                    catch (Exception ignore) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (state == 3) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            sDebugLine = sDebugLine + "\nstart(); 0Peers";
                                                        }
                                                        download.start();
                                                        ++totals.activelyCDing;
                                                        ++vars.numWaitingOrSeeding;
                                                    }
                                                    catch (Exception ignore) {
                                                    }
                                                }
                                                Object var26_16 = null;
                                                if (!this.bDebugLog) {
                                                    return;
                                                }
                                                break block70;
                                            }
                                            rank = download.getSeedingRank();
                                            if (!(rank >= -1 || download.isForceStart() || stateReadyOrSeeding || this.bAutoStart0Peers)) {
                                                if (!this.bDebugLog) break block71;
                                                sDebugLine = sDebugLine + "\n  Skip !forceStart";
                                                int idx = rank * -1;
                                                if (idx < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                                                    sDebugLine = sDebugLine + " && " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[idx];
                                                }
                                                break block71;
                                            }
                                            if (vars.higherCDtoStart && !download.isForceStart() && !this.bAutoStart0Peers && !stateReadyOrSeeding) {
                                                sDebugLine = sDebugLine + " a torrent with a higher rank is queued or starting";
                                            }
                                            if (this.bDebugLog && this.bAutoStart0Peers && numPeers == 0 && !bScrapeOk && (state == 9 || state == 3)) {
                                                sDebugLine = sDebugLine + "\n  NOT starting 0 Peer torrent because scrape isn't ok";
                                            }
                                            if (!this.bDebugLog) {
                                                isFP = dlData.isFirstPriority();
                                            }
                                            bActivelySeeding = dlData.getActivelySeeding();
                                            if (this.bStopOnceBandwidthMet) {
                                                boolean isRunning = download.getState() == 5;
                                                boolean globalUpLimitReached = totals.maxUploadSpeed() > 0 && (double)vars.accumulatedUploadSpeed / 1024.0 > (double)((float)totals.maxUploadSpeed() * 0.9f);
                                                boolean globalDownLimitReached = this.globalDownloadLimit > 0 && (double)vars.accumulatedDownloadSpeed / 1024.0 > (double)((float)this.globalDownloadLimit * 0.9f);
                                                globalRateAdjustedActivelySeeding = bActivelySeeding || isRunning && (globalUpLimitReached || globalDownLimitReached);
                                                boolean bl = fakedActively = globalRateAdjustedActivelySeeding && !bActivelySeeding;
                                                if (fakedActively) {
                                                    ++totals.activelyCDing;
                                                }
                                            } else {
                                                boolean globalUpLimitReached = false;
                                                globalRateAdjustedActivelySeeding = bActivelySeeding;
                                                boolean globalDownLimitReached = false;
                                                fakedActively = false;
                                            }
                                            if (state == 5 && !bActivelySeeding) {
                                                ++vars.stalledSeeders;
                                            }
                                            boolean bl = okToQueue = stateReadyOrSeeding && (!isFP || isFP && totals.maxActive != 0 && vars.numWaitingOrSeeding >= totals.maxActive - this.minDownloads) && !download.isForceStart();
                                            if (okToQueue && state == 5) {
                                                long timeAlive = SystemTime.getCurrentTime() - download.getStats().getTimeStarted();
                                                boolean bl2 = okToQueue = timeAlive >= this.minTimeAlive;
                                                if (!okToQueue && this.bDebugLog) {
                                                    sDebugLine = sDebugLine + "\n  Torrent can't be stopped yet, timeAlive(" + timeAlive + ") < minTimeAlive(" + this.minTimeAlive + ")";
                                                }
                                            }
                                            if (state != 9 && (state == 3 || state == 1 || state == 2 || state == 5 && globalRateAdjustedActivelySeeding && !download.isForceStart())) {
                                                ++vars.numWaitingOrSeeding;
                                                if (this.bDebugLog) {
                                                    sDebugLine = sDebugLine + "\n  Torrent is waiting or seeding";
                                                }
                                            }
                                            boolean up_limit_prohibits = false;
                                            if (!okToQueue && totals.upLimitProhibitsNewSeeds) {
                                                okToQueue = true;
                                                up_limit_prohibits = true;
                                            }
                                            if (!(okToQueue || state != 9 || totals.maxActive != 0 && vars.numWaitingOrSeeding >= totals.maxSeeders || rank < -1 || vars.stalledSeeders >= this.maxStalledSeeding || vars.higherCDtoStart)) {
                                                try {
                                                    if (this.bDebugLog) {
                                                        sDebugLine = sDebugLine + "\n  restart: ok2Q=" + okToQueue + "; QUEUED && numWaitingOrSeeding( " + vars.numWaitingOrSeeding + ") < maxSeeders (" + totals.maxSeeders + ")";
                                                    }
                                                    download.restart();
                                                    okToQueue = false;
                                                    ++totals.waitingToSeed;
                                                    ++vars.numWaitingOrSeeding;
                                                    if (this.iRankType == 3) {
                                                        dlData.recalcSeedingRank();
                                                    }
                                                }
                                                catch (Exception ignore) {
                                                    // empty catch block
                                                }
                                                state = download.getState();
                                            } else if (this.bDebugLog && state == 9) {
                                                sDebugLine = sDebugLine + "\n  NOT restarting:";
                                                if (rank < -1) {
                                                    sDebugLine = sDebugLine + " torrent is being ignored";
                                                    int idx = rank * -1;
                                                    if (idx < DefaultRankCalculator.SR_NEGATIVE_DEBUG.length) {
                                                        sDebugLine = sDebugLine + ": " + DefaultRankCalculator.SR_NEGATIVE_DEBUG[idx];
                                                    }
                                                } else if (vars.higherCDtoStart) {
                                                    sDebugLine = sDebugLine + " a torrent with a higher rank is queued or starting";
                                                } else {
                                                    if (okToQueue) {
                                                        sDebugLine = sDebugLine + " no starting of okToQueue'd;";
                                                    }
                                                    sDebugLine = vars.numWaitingOrSeeding >= totals.maxSeeders ? sDebugLine + " at limit, numWaitingOrSeeding(" + vars.numWaitingOrSeeding + ") >= maxSeeders(" + totals.maxSeeders + ")" : (vars.stalledSeeders >= this.maxStalledSeeding ? sDebugLine + " at limit, stalledSeeders(" + vars.stalledSeeders + ") >= maxStalledSeeding(" + this.maxStalledSeeding + ") " : (up_limit_prohibits ? sDebugLine + " upload rate prohibits starting new seeds" : sDebugLine + "huh? qd=" + (state == 9) + "; " + totals.maxActive + ";" + (vars.numWaitingOrSeeding < totals.maxSeeders) + ";" + (vars.stalledSeeders <= this.maxStalledSeeding) + ";ignore?" + (rank >= -1)));
                                                }
                                            }
                                            boolean bForceStop = false;
                                            if (state == 3 && totals.activelyCDing < totals.maxSeeders) {
                                                if (rank >= -1 || download.isForceStart()) {
                                                    try {
                                                        if (this.bDebugLog) {
                                                            sDebugLine = sDebugLine + "\n  start: READY && total activelyCDing(" + totals.activelyCDing + ") < maxSeeders(" + totals.maxSeeders + ")";
                                                        }
                                                        download.start();
                                                        okToQueue = false;
                                                    }
                                                    catch (Exception ignore) {
                                                        // empty catch block
                                                    }
                                                    state = download.getState();
                                                    ++totals.activelyCDing;
                                                    bActivelySeeding = true;
                                                    globalRateAdjustedActivelySeeding = true;
                                                    ++vars.numWaitingOrSeeding;
                                                } else if (okToQueue) {
                                                    bForceStop = true;
                                                }
                                            }
                                            if (!okToQueue && !bForceStop) break block73;
                                            okToStop = bForceStop;
                                            if (okToStop) break block74;
                                            bOverLimit = vars.numWaitingOrSeeding > totals.maxSeeders || !bActivelySeeding && vars.stalledSeeders > this.maxStalledSeeding || (vars.numWaitingOrSeeding >= totals.maxSeeders || totals.upLimitProhibitsNewSeeds) && vars.higherCDtoStart;
                                            bSeeding = state == 5;
                                            boolean bl3 = okToStop = !download.isChecking() && !download.isMoving() && (bOverLimit || rank < -1) && (globalRateAdjustedActivelySeeding || !bSeeding || !globalRateAdjustedActivelySeeding && bSeeding);
                                            if (!this.bDebugLog) break block75;
                                            if (!okToStop) break block76;
                                            sDebugLine = sDebugLine + "\n  stopAndQueue: ";
                                            if (bOverLimit) {
                                                sDebugLine = vars.higherCDtoStart ? sDebugLine + "higherQueued (it should be seeding instead of this one)" : (!bActivelySeeding && vars.stalledSeeders > totals.maxSeeders ? sDebugLine + "over stale seeds limit" : sDebugLine + "over limit");
                                            } else if (rank < -1) {
                                                sDebugLine = sDebugLine + "ignoreRule met";
                                            }
                                            sDebugLine = sDebugLine + " && ";
                                            if (!bActivelySeeding) break block77;
                                            sDebugLine = sDebugLine + "activelySeeding";
                                            break block76;
                                        }
                                        if (!bSeeding) {
                                            sDebugLine = sDebugLine + "not SEEDING";
                                            break block76;
                                        } else if (!bActivelySeeding && bSeeding) {
                                            sDebugLine = sDebugLine + "SEEDING, but not actively";
                                        }
                                        break block76;
                                    }
                                    sDebugLine = sDebugLine + "\n  NOT queuing: ";
                                    sDebugLine = download.isChecking() ? sDebugLine + "can't auto-queue a checking torrent" : (download.isMoving() ? sDebugLine + "can't auto-queue a moving torrent" : (!bOverLimit ? sDebugLine + "not over limit.  numWaitingOrSeeding(" + vars.numWaitingOrSeeding + ") <= maxSeeders(" + totals.maxSeeders + ")" : sDebugLine + "bActivelySeeding=" + bActivelySeeding + ";bSeeding" + bSeeding));
                                    break block76;
                                }
                                if (this.bDebugLog) {
                                    sDebugLine = sDebugLine + "\n  Forcing a stop..";
                                }
                            }
                            if (okToStop) {
                                try {
                                    if (state == 3) {
                                        --totals.waitingToSeed;
                                    }
                                    download.stopAndQueue();
                                    vars.bStopAndQueued = true;
                                    if (bActivelySeeding || fakedActively) {
                                        --totals.activelyCDing;
                                        bActivelySeeding = false;
                                    }
                                    if (globalRateAdjustedActivelySeeding) {
                                        --vars.numWaitingOrSeeding;
                                        globalRateAdjustedActivelySeeding = false;
                                    }
                                    if (state == 3) {
                                        --totals.waitingToSeed;
                                    }
                                }
                                catch (Exception ignore) {
                                    // empty catch block
                                }
                                state = download.getState();
                            }
                        }
                        state = download.getState();
                        if (rank >= 0 && (state == 9 || state == 3 || state == 1 || state == 2)) {
                            vars.higherCDtoStart = true;
                        }
                        break block72;
                    }
                    catch (Throwable throwable) {
                        Object var26_19 = null;
                        if (!this.bDebugLog) throw throwable;
                        String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.lastModifiedScrapeResultSeeds, "nPeers=" + dlData.lastModifiedScrapeResultPeers};
                        this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
                        throw throwable;
                    }
                }
                String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.lastModifiedScrapeResultSeeds, "nPeers=" + dlData.lastModifiedScrapeResultPeers};
                this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
                return;
            }
            Object var26_17 = null;
            if (!this.bDebugLog) return;
            String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.lastModifiedScrapeResultSeeds, "nPeers=" + dlData.lastModifiedScrapeResultPeers};
            this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
            return;
        }
        Object var26_18 = null;
        if (this.bDebugLog) {
            String[] debugEntries2 = new String[]{"CD state=" + sStates.charAt(download.getState()), "shareR=" + download.getStats().getShareRatio(), "nWorCDing=" + vars.numWaitingOrSeeding, "nWorDLing=" + vars.numWaitingOrDLing, "sr=" + download.getSeedingRank(), "hgherQd=" + this.boolDebug(vars.higherCDtoStart), "maxCDrs=" + totals.maxSeeders, "FP=" + this.boolDebug(isFP), "nActCDing=" + totals.activelyCDing, "ActCDing=" + this.boolDebug(dlData.getActivelySeeding()), "nSeeds=" + dlData.lastModifiedScrapeResultSeeds, "nPeers=" + dlData.lastModifiedScrapeResultPeers};
            this.printDebugChanges("", debugEntries, debugEntries2, sDebugLine, "  ", true, dlData);
        }
        if (!this.bStopOnceBandwidthMet) return;
        vars.accumulatedUploadSpeed += download.getStats().getUploadAverage();
    }

    private String boolDebug(boolean b) {
        return b ? "Y" : "N";
    }

    private void printDebugChanges(String sPrefixFirstLine, String[] oldEntries, String[] newEntries, String sDebugLine, String sPrefix, boolean bAlwaysPrintNoChangeLine, DefaultRankCalculator dlData) {
        boolean bAnyChanged = false;
        String sDebugLineNoChange = sPrefixFirstLine;
        StringBuffer sDebugLineOld = new StringBuffer(120);
        StringBuffer sDebugLineNew = new StringBuffer(120);
        for (int j = 0; j < oldEntries.length; ++j) {
            if (oldEntries[j].equals(newEntries[j])) {
                sDebugLineNoChange = sDebugLineNoChange + oldEntries[j] + ";";
                continue;
            }
            sDebugLineOld.append(oldEntries[j]);
            sDebugLineOld.append(";");
            sDebugLineNew.append(newEntries[j]);
            sDebugLineNew.append(";");
            bAnyChanged = true;
        }
        String sDebugLineOut = (bAlwaysPrintNoChangeLine || bAnyChanged ? sDebugLineNoChange : "") + (bAnyChanged ? "\nOld:" + sDebugLineOld + "\nNew:" + sDebugLineNew : "") + sDebugLine;
        if (!sDebugLineOut.equals("")) {
            String[] lines = sDebugLineOut.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String s = sPrefix + (i > 0 ? "  " : "") + lines[i];
                if (dlData == null) {
                    this.log.log(1, s);
                    continue;
                }
                this.log.log((Object)dlData.dl.getTorrent(), 1, s);
                dlData.sTrace = dlData.sTrace + s + "\n";
            }
        }
    }

    public int calcPeersNoUs(Download download, DownloadScrapeResult sr) {
        int numPeers = 0;
        if (sr.getScrapeStartTime() > 0L && (numPeers = sr.getNonSeedCount()) > 0 && download.getState() == 4 && sr.getScrapeStartTime() > download.getStats().getTimeStarted()) {
            --numPeers;
        }
        if (numPeers == 0) {
            DownloadActivationEvent activationState;
            DownloadAnnounceResult ar = download.getLastAnnounceResult();
            if (ar != null && ar.getResponseType() == 1) {
                numPeers = ar.getNonSeedCount();
            }
            if (numPeers == 0 && (activationState = download.getActivationState()) != null) {
                numPeers = activationState.getActivationCount();
            }
        }
        return numPeers;
    }

    private boolean scrapeResultOk(Download download) {
        DownloadScrapeResult sr = download.getAggregatedScrapeResult();
        return sr.getResponseType() == 1;
    }

    public int calcSeedsNoUs(Download download, DownloadScrapeResult sr) {
        return this.calcSeedsNoUs(download, sr, this.calcPeersNoUs(download, sr));
    }

    public int calcSeedsNoUs(Download download, DownloadScrapeResult sr, int numPeers) {
        DownloadAnnounceResult ar;
        int numSeeds = 0;
        if (sr.getScrapeStartTime() > 0L) {
            long seedingStartedOn = download.getStats().getTimeStartedSeeding();
            numSeeds = sr.getSeedCount();
            if (numSeeds > 0 && seedingStartedOn > 0L && download.getState() == 5 && sr.getScrapeStartTime() > seedingStartedOn) {
                --numSeeds;
            }
        }
        if (numSeeds == 0 && (ar = download.getLastAnnounceResult()) != null && ar.getResponseType() == 1) {
            numSeeds = ar.getSeedCount();
        }
        if (this.numPeersAsFullCopy != 0 && numSeeds >= this.iFakeFullCopySeedStart) {
            numSeeds += numPeers / this.numPeersAsFullCopy;
        }
        return numSeeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestProcessCycle(DefaultRankCalculator rankToRecalc) {
        if (rankToRecalc != null) {
            try {
                this.ranksToRecalc_mon.enter();
                this.ranksToRecalc.add(rankToRecalc);
                Object var3_2 = null;
                this.ranksToRecalc_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.ranksToRecalc_mon.exit();
                throw throwable;
            }
        }
        if (this.somethingChanged) {
            ++this.processMergeCount;
        } else {
            this.somethingChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("StartStopRules Manager");
        try {
            block6: {
                try {
                    writer.indent();
                    writer.println("Started " + TimeFormatter.format100ths(SystemTime.getMonotonousTime() - this.monoStartedOn) + " ago");
                    writer.println("debugging = " + this.bDebugLog);
                    writer.println("downloadDataMap size = " + downloadDataMap.size());
                    if (this.changeCheckCount > 0L) {
                        writer.println("changeCheck CPU ms: avg=" + this.changeCheckTotalMS / this.changeCheckCount + "; max = " + this.changeCheckMaxMS);
                    }
                    if (this.processCount <= 0L) break block6;
                    writer.println("# process cycles: " + this.processCount);
                    writer.println("process CPU ms: avg=" + this.processTotalMS / this.processCount + "; max = " + this.processMaxMS);
                    if (this.processCount > 1L) {
                        writer.println("process avg gap: " + this.processTotalGap / (this.processCount - 1L) + "ms");
                    }
                    writer.println("Avg # recalcs per process cycle: " + this.processTotalRecalcs / this.processCount);
                    if (this.processTotalZeroRecalcs <= 0L) break block6;
                    writer.println("# process cycle with 0 recalcs: " + this.processTotalZeroRecalcs);
                }
                catch (Exception exception) {
                    Object var4_3 = null;
                    writer.exdent();
                }
            }
            Object var4_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public void addListener(StartStopRulesFPListener listener) {
        this.listenersFP.add(listener);
    }

    public void removeListener(StartStopRulesFPListener listener) {
        this.listenersFP.remove(listener);
    }

    public List getFPListeners() {
        return this.listenersFP.getList();
    }

    static /* synthetic */ DefaultRankCalculator[] access$1502(StartStopRulesDefaultPlugin x0, DefaultRankCalculator[] x1) {
        x0.sortedArrayCache = x1;
        return x1;
    }

    private class ChangeCheckerTimerTask
    implements TimerEventPerformer {
        long lLastRunTime = 0L;

        private ChangeCheckerTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(TimerEvent event2) {
            long now;
            block16: {
                block14: {
                    block15: {
                        now = 0L;
                        try {
                            DefaultRankCalculator[] dlDataArray;
                            StartStopRulesDefaultPlugin.this.this_mon.enter();
                            now = SystemTime.getCurrentTime();
                            if (now > this.lLastRunTime && now - this.lLastRunTime < 1000L) {
                                Object var9_3 = null;
                                if (now <= 0L) break block14;
                                break block15;
                            }
                            this.lLastRunTime = now;
                            Map map = downloadDataMap;
                            synchronized (map) {
                                dlDataArray = downloadDataMap.values().toArray(new DefaultRankCalculator[0]);
                            }
                            int iNumDLing = 0;
                            int iNumCDing = 0;
                            for (int i = 0; i < dlDataArray.length; ++i) {
                                if (dlDataArray[i].changeChecker()) {
                                    StartStopRulesDefaultPlugin.this.requestProcessCycle(dlDataArray[i]);
                                }
                                if (dlDataArray[i].getActivelyDownloading()) {
                                    ++iNumDLing;
                                }
                                if (!dlDataArray[i].getActivelySeeding()) continue;
                                ++iNumCDing;
                            }
                            int iMaxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(iNumDLing);
                            if (iNumCDing <= iMaxSeeders) break block16;
                            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
                            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                                StartStopRulesDefaultPlugin.this.log.log(1, "somethingChanged: More Seeding than limit");
                            }
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var9_5 = null;
                            if (now > 0L) {
                                StartStopRulesDefaultPlugin.this.changeCheckCount++;
                                long timeTaken = SystemTime.getCurrentTime() - now;
                                StartStopRulesDefaultPlugin.this.changeCheckTotalMS += timeTaken;
                                if (timeTaken > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                                    StartStopRulesDefaultPlugin.this.changeCheckMaxMS = timeTaken;
                                }
                            }
                            StartStopRulesDefaultPlugin.this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    StartStopRulesDefaultPlugin.this.changeCheckCount++;
                    long timeTaken = SystemTime.getCurrentTime() - now;
                    StartStopRulesDefaultPlugin.this.changeCheckTotalMS += timeTaken;
                    if (timeTaken > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                        StartStopRulesDefaultPlugin.this.changeCheckMaxMS = timeTaken;
                    }
                }
                StartStopRulesDefaultPlugin.this.this_mon.exit();
                return;
            }
            Object var9_4 = null;
            if (now > 0L) {
                StartStopRulesDefaultPlugin.this.changeCheckCount++;
                long timeTaken = SystemTime.getCurrentTime() - now;
                StartStopRulesDefaultPlugin.this.changeCheckTotalMS += timeTaken;
                if (timeTaken > StartStopRulesDefaultPlugin.this.changeCheckMaxMS) {
                    StartStopRulesDefaultPlugin.this.changeCheckMaxMS = timeTaken;
                }
            }
            StartStopRulesDefaultPlugin.this.this_mon.exit();
        }
    }

    private class ChangeFlagCheckerTask
    implements TimerEventPerformer {
        final long FORCE_CHECK_CYCLES = 40L;
        final DownloadManagerStats dmStats = StartStopRulesDefaultPlugin.access$100(StartStopRulesDefaultPlugin.this).getStats();
        long prevReceived = -1L;
        long cycleNo = 0L;

        private ChangeFlagCheckerTask() {
        }

        public void perform(TimerEvent event2) {
            long recv = this.dmStats.getDataBytesReceived() + this.dmStats.getProtocolBytesReceived();
            if (this.prevReceived != -1L) {
                StartStopRulesDefaultPlugin.this.globalDownloadSpeedAverage.update(recv - this.prevReceived);
            }
            this.prevReceived = recv;
            if (StartStopRulesDefaultPlugin.this.closingDown || pauseChangeFlagChecker) {
                return;
            }
            ++this.cycleNo;
            if (this.cycleNo > 40L) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log(1, ">>force process");
                }
                StartStopRulesDefaultPlugin.this.somethingChanged = true;
            }
            if (StartStopRulesDefaultPlugin.this.somethingChanged) {
                try {
                    this.cycleNo = 0L;
                    StartStopRulesDefaultPlugin.this.process();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private static class ProcessVars {
        int numWaitingOrSeeding;
        int numWaitingOrDLing;
        long accumulatedDownloadSpeed;
        long accumulatedUploadSpeed;
        boolean higherCDtoStart;
        boolean higherDLtoStart;
        int posComplete;
        boolean bStopAndQueued;
        int stalledSeeders;

        private ProcessVars() {
        }
    }

    private class RecalcSeedingRanksTask
    implements TimerEventPerformer {
        boolean bCancel = false;

        private RecalcSeedingRanksTask() {
        }

        public void perform(TimerEvent event2) {
            if (this.bCancel) {
                event2.cancel();
                return;
            }
            StartStopRulesDefaultPlugin.this.recalcAllSeedingRanks(false);
        }

        public void cancel() {
            this.bCancel = true;
        }
    }

    private class StartStopDMListener
    implements DownloadManagerListener {
        private DownloadTrackerListener download_tracker_listener;
        private DownloadListener download_listener;
        private DownloadActivationListener download_activation_listener;

        public StartStopDMListener() {
            this.download_tracker_listener = new StartStopDMTrackerListener();
            this.download_listener = new StartStopDownloadListener();
            this.download_activation_listener = new StartStopDownloadActivationListener();
        }

        public void downloadAdded(Download download) {
            DefaultRankCalculator dlData = null;
            if (downloadDataMap.containsKey(download)) {
                dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            } else {
                dlData = new DefaultRankCalculator(StartStopRulesDefaultPlugin.this, download);
                StartStopRulesDefaultPlugin.access$1502(StartStopRulesDefaultPlugin.this, null);
                downloadDataMap.put(download, dlData);
                download.addListener(this.download_listener);
                download.addTrackerListener(this.download_tracker_listener, false);
                download.addActivationListener(this.download_activation_listener);
            }
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadAdded, state: " + StartStopRulesDefaultPlugin.sStates.charAt(download.getState()));
                }
            }
        }

        public void downloadRemoved(Download download) {
            download.removeListener(this.download_listener);
            download.removeTrackerListener(this.download_tracker_listener);
            download.removeActivationListener(this.download_activation_listener);
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.remove(download);
            if (dlData != null) {
                StartStopRulesDefaultPlugin.access$1502(StartStopRulesDefaultPlugin.this, null);
                dlData.destroy();
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(null);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download.getTorrent(), 1, "somethingChanged: downloadRemoved");
            }
        }
    }

    private class StartStopDMTrackerListener
    implements DownloadTrackerListener {
        private StartStopDMTrackerListener() {
        }

        public void scrapeResult(DownloadScrapeResult result) {
            Download dl = result.getDownload();
            if (dl == null) {
                return;
            }
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(dl);
            if (result.getResponseType() == 2) {
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "Ignored somethingChanged: new scrapeResult (RT_ERROR)");
                }
                if (dlData != null) {
                    dlData.lastScrapeResultOk = false;
                }
                return;
            }
            if (dlData != null) {
                dlData.lastScrapeResultOk = true;
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dl.getTorrent(), 1, "somethingChanged: new scrapeResult S:" + result.getSeedCount() + ";P:" + result.getNonSeedCount());
                }
            }
        }

        public void announceResult(DownloadAnnounceResult result) {
        }
    }

    private class StartStopDownloadActivationListener
    implements DownloadActivationListener {
        private StartStopDownloadActivationListener() {
        }

        public boolean activationRequested(DownloadActivationEvent event2) {
            DownloadScrapeResult sr;
            int numPeers;
            Download download = event2.getDownload();
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                StartStopRulesDefaultPlugin.this.log.log((Object)download, 1, ">> somethingChanged: ActivationRequest");
            }
            StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
            return download.isComplete() && (numPeers = (sr = event2.getDownload().getAggregatedScrapeResult()).getNonSeedCount()) <= 0;
        }
    }

    private class StartStopDownloadListener
    implements DownloadListener {
        private StartStopDownloadListener() {
        }

        public void stateChanged(Download download, int old_state, int new_state) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (new_state == 3 || new_state == 1) {
                    if (StartStopRulesDefaultPlugin.this.immediateProcessingScheduled) {
                        StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                    } else {
                        StartStopRulesDefaultPlugin.this.immediateProcessingScheduled = true;
                        new AEThread2("processReady", true){

                            public void run() {
                                StartStopRulesDefaultPlugin.this.process();
                            }
                        }.start();
                    }
                }
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dlData.dl.getTorrent(), 1, "somethingChanged: stateChange from " + StartStopRulesDefaultPlugin.sStates.charAt(old_state) + " (" + old_state + ") to " + StartStopRulesDefaultPlugin.sStates.charAt(new_state) + " (" + new_state + ")");
                }
            }
        }

        public void positionChanged(Download download, int oldPosition, int newPosition) {
            DefaultRankCalculator dlData = (DefaultRankCalculator)downloadDataMap.get(download);
            if (dlData != null) {
                StartStopRulesDefaultPlugin.this.requestProcessCycle(dlData);
                if (StartStopRulesDefaultPlugin.this.bDebugLog) {
                    StartStopRulesDefaultPlugin.this.log.log((Object)dlData.dl.getTorrent(), 1, "somethingChanged: positionChanged from " + oldPosition + " to " + newPosition);
                }
            }
        }
    }

    private class TotalsStats {
        int forcedSeeding = 0;
        int forcedSeedingNonFP = 0;
        int waitingToSeed = 0;
        int waitingToDL = 0;
        int downloading = 0;
        int activelyDLing = 0;
        int activelyCDing = 0;
        int complete = 0;
        int incompleteQueued = 0;
        int firstPriority = 0;
        int stalledSeeders = 0;
        int stalledFPSeeders = 0;
        int forcedActive = 0;
        boolean bOkToStartSeeding;
        int maxSeeders;
        int maxActive;
        int maxTorrents;
        boolean upLimitProhibitsNewSeeds;

        public int maxUploadSpeed() {
            return this.downloading == 0 ? StartStopRulesDefaultPlugin.this.globalUploadWhenSeedingLimit : StartStopRulesDefaultPlugin.this.globalUploadLimit;
        }

        public TotalsStats(DefaultRankCalculator[] dlDataArray) {
            long target;
            long current_up_kbps;
            this.bOkToStartSeeding = StartStopRulesDefaultPlugin.this.iRankType == 0 || StartStopRulesDefaultPlugin.this.iRankType == 3 || SystemTime.getMonotonousTime() - StartStopRulesDefaultPlugin.this.monoStartedOn > 90000L;
            int totalOKScrapes = 0;
            for (int i = 0; i < dlDataArray.length; ++i) {
                Download download;
                int state;
                DefaultRankCalculator dlData = dlDataArray[i];
                if (dlData == null || (state = (download = dlData.getDownloadObject()).getState()) == 8 || state == 7) continue;
                boolean completed = download.isComplete();
                boolean bIsFirstP = false;
                if (!completed && download.isForceStart()) continue;
                if (completed) {
                    boolean bScrapeOk = true;
                    if (!this.bOkToStartSeeding) {
                        bScrapeOk = StartStopRulesDefaultPlugin.this.scrapeResultOk(download);
                        if (StartStopRulesDefaultPlugin.this.calcSeedsNoUs(download, download.getAggregatedScrapeResult()) == 0 && bScrapeOk) {
                            this.bOkToStartSeeding = true;
                        } else if (download.getSeedingRank() > 0 && (state == 9 || state == 3) && SystemTime.getMonotonousTime() - StartStopRulesDefaultPlugin.this.monoStartedOn > 20000L) {
                            this.bOkToStartSeeding = true;
                        }
                    }
                    ++this.complete;
                    if (!this.bOkToStartSeeding && bScrapeOk) {
                        ++totalOKScrapes;
                    }
                    if (dlData.isFirstPriority()) {
                        if (!this.bOkToStartSeeding) {
                            this.bOkToStartSeeding = true;
                        }
                        ++this.firstPriority;
                        bIsFirstP = true;
                    }
                    if (dlData.getActivelySeeding()) {
                        if (dlData.isForceActive()) {
                            ++this.forcedActive;
                        }
                        ++this.activelyCDing;
                        if (download.isForceStart()) {
                            ++this.forcedSeeding;
                            if (!bIsFirstP) {
                                ++this.forcedSeedingNonFP;
                            }
                        }
                    } else if (state == 5) {
                        if (bIsFirstP) {
                            ++this.stalledFPSeeders;
                        }
                        ++this.stalledSeeders;
                    }
                    if (state != 3 && state != 1 && state != 2) continue;
                    ++this.waitingToSeed;
                    continue;
                }
                if (state == 4) {
                    ++this.downloading;
                    if (dlData.getActivelyDownloading()) {
                        ++this.activelyDLing;
                    }
                }
                if (state == 3 || state == 1 || state == 2) {
                    ++this.waitingToDL;
                    continue;
                }
                if (state != 9) continue;
                ++this.incompleteQueued;
            }
            if (!this.bOkToStartSeeding && totalOKScrapes == this.complete) {
                this.bOkToStartSeeding = true;
            }
            this.maxSeeders = StartStopRulesDefaultPlugin.this.calcMaxSeeders(this.activelyDLing + this.waitingToDL);
            this.maxActive = StartStopRulesDefaultPlugin.this.getMaxActive();
            if (this.maxActive == 0) {
                this.maxTorrents = 9999;
            } else if (this.maxUploadSpeed() == 0) {
                this.maxTorrents = this.maxActive + 4;
            } else {
                int minSpeedPerActive = StartStopRulesDefaultPlugin.this.minSpeedForActiveSeeding * 2 / 1024;
                if (minSpeedPerActive < 3) {
                    minSpeedPerActive = 3;
                }
                this.maxTorrents = this.maxUploadSpeed() / minSpeedPerActive;
                if (this.maxTorrents < this.maxActive) {
                    this.maxTorrents = this.maxActive;
                }
            }
            long up_limit = this.maxUploadSpeed();
            if (StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMet && up_limit > 0L && (current_up_kbps = StartStopRulesDefaultPlugin.this.download_manager.getStats().getSmoothedSendRate() / 1024L) > (target = StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetPercent ? up_limit * (long)StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetSlack / 100L : up_limit - (long)StartStopRulesDefaultPlugin.this.bStartNoMoreSeedsWhenUpLimitMetSlack)) {
                this.upLimitProhibitsNewSeeds = true;
            }
        }
    }

    public static interface UIAdapter {
        public void openDebugWindow(DefaultRankCalculator var1);
    }
}

