/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionMaxResults
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static String COLUMN_ID = "max-results";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionMaxResults(String sTableID) {
        super(COLUMN_ID, -1, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidth(100);
        this.setMaxWidth(100);
        this.setAlignment(2);
    }

    public void refresh(TableCell cell) {
        boolean is_st;
        int maxResults = 0;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub != null) {
            maxResults = sub.getHistory().getMaxNonDeletedResults();
        }
        if (maxResults < 0) {
            maxResults = SubscriptionManagerFactory.getSingleton().getMaxNonDeletedResults();
        }
        if (!cell.setSortValue((is_st = sub.isSearchTemplate()) ? -1L : (long)maxResults) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        if (is_st) {
            cell.setText("");
        } else if (maxResults == 0) {
            cell.setText(MessageText.getString("ConfigView.unlimited"));
        } else {
            cell.setText("" + maxResults);
        }
    }
}

