/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ColumnSubscriptionTag
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static String COLUMN_ID = "tag.name";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionTag(String sTableID) {
        super(COLUMN_ID, -2, 100, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidth(100);
        this.setMaxWidth(100);
    }

    public void refresh(TableCell cell) {
        String tag_str;
        Subscription sub = (Subscription)cell.getDataSource();
        Tag tag = tag_manager.lookupTagByUID(sub.getTagID());
        String string = tag_str = tag == null ? "" : tag.getTagName(true);
        if (!cell.setSortValue((Comparable)((Object)tag_str)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(tag_str);
    }
}

