/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tag;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import java.io.File;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTagCopyOnComp
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.copyoncomp";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagCopyOnComp(TableColumn column) {
        column.setWidth(200);
        column.addListeners(this);
    }

    public void refresh(TableCell cell) {
        TagFeatureFileLocation fl;
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagFeatureFileLocation && (fl = (TagFeatureFileLocation)((Object)tag)).supportsTagCopyOnComplete()) {
            File target_file = fl.getTagCopyOnCompleteFolder();
            String target = target_file == null ? "" : target_file.getAbsolutePath();
            if (!cell.setSortValue((Comparable)((Object)target)) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(target);
        }
    }
}

