/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tag;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureLimits;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTagLimits
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.limit";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnTagLimits(TableColumn column) {
        column.setWidth(200);
        column.addListeners(this);
    }

    public void refresh(TableCell cell) {
        TagFeatureLimits tfl;
        int max;
        Tag tag = (Tag)cell.getDataSource();
        String tag_limits = "";
        if (tag instanceof TagFeatureLimits && (max = (tfl = (TagFeatureLimits)((Object)tag)).getMaximumTaggables()) > 0) {
            tag_limits = String.valueOf(max);
            String policy = null;
            switch (tfl.getRemovalStrategy()) {
                case 0: {
                    policy = "label.none.assigned";
                    break;
                }
                case 1: {
                    policy = "MyTorrentsView.menu.archive";
                    break;
                }
                case 2: {
                    policy = "Button.deleteContent.fromLibrary";
                    break;
                }
                case 3: {
                    policy = "Button.deleteContent.fromComputer";
                }
            }
            if (policy != null) {
                tag_limits = tag_limits + "; " + MessageText.getString(policy);
            }
        }
        if (!cell.setSortValue((Comparable)((Object)tag_limits)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(tag_limits);
    }
}

