/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tag;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTagMinSR
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "min_sr";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
        info.setProficiency((byte)1);
    }

    public ColumnTagMinSR(TableColumn column) {
        column.setWidth(60);
        column.setRefreshInterval(-2);
        column.setAlignment(2);
        column.addListeners(this);
    }

    public void refresh(TableCell cell) {
        TagFeatureRateLimit rl;
        int sr;
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagFeatureRateLimit && (sr = (rl = (TagFeatureRateLimit)((Object)tag)).getTagMinShareRatio()) >= 0) {
            if (!cell.setSortValue(sr) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(sr == 0 ? "" : String.valueOf((float)sr / 1000.0f));
        }
    }
}

