/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.util.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import java.io.File;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellClipboardListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnThumbAndName
extends CoreTableColumnSWT
implements TableCellLightRefreshListener,
ObfusticateCellText,
TableCellDisposeListener,
TableCellSWTPaintListener,
TableCellClipboardListener,
TableCellMouseMoveListener {
    public static final Class<?>[] DATASOURCE_TYPES = new Class[]{Download.class, org.gudy.azureus2.plugins.disk.DiskManagerFileInfo.class};
    public static final String COLUMN_ID = "name";
    private static final String ID_EXPANDOHITAREA = "expandoHitArea";
    private static final String ID_EXPANDOHITAREASHOW = "expandoHitAreaShow";
    private static final boolean NEVER_SHOW_TWISTY = !COConfigurationManager.getBooleanParameter("Table.useTree");
    private boolean showIcon;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    public ColumnThumbAndName(String sTableID) {
        super(COLUMN_ID, 250, sTableID);
        this.setAlignment(1);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        this.setObfustication(true);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(250);
        this.setMinWidth(100);
        TableContextMenuItem menuItem = this.addContextMenuItem("MyTorrentsView.menu.rename.displayed");
        menuItem.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                Object[] o;
                if (target == null) {
                    return;
                }
                for (Object object : o = (Object[])target) {
                    if (object instanceof TableRowCore) {
                        TableRowCore row = (TableRowCore)object;
                        object = row.getDataSource(true);
                    }
                    if (!(object instanceof DownloadManager)) continue;
                    final DownloadManager dm = (DownloadManager)object;
                    String msg_key_prefix = "MyTorrentsView.menu.rename.displayed.enter.";
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(msg_key_prefix + "title", msg_key_prefix + "message");
                    entryWindow.setPreenteredText(dm.getDisplayName(), false);
                    entryWindow.maintainWhitespace(true);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            String value = entryWindow.getSubmittedInput();
                            if (value != null && value.length() > 0) {
                                dm.getDownloadState().setDisplayName(value);
                            }
                        }
                    });
                }
            }
        });
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showProgramIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(new Boolean(ColumnThumbAndName.this.showIcon));
            }
        });
        final String CFG_SHOWPROGRAMICON = "NameColumn.showProgramIcon." + this.getTableID();
        menuShowIcon.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(CFG_SHOWPROGRAMICON, (Boolean)menu.getData());
            }
        });
        COConfigurationManager.addAndFireParameterListener(CFG_SHOWPROGRAMICON, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                ColumnThumbAndName.this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOWPROGRAMICON, COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon")));
            }
        });
    }

    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter("NameColumn.showProgramIcon." + this.getTableID());
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            TableRowCore row;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            if (fileInfo2.isSkipped() && (fileInfo2.getStorageType() == 2 || fileInfo2.getStorageType() == 4) && (row = (TableRowCore)cell.getTableRow()) != null) {
                row.getParentRowCore().removeSubRow(ds);
            }
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        cell.setSortValue((Comparable)((Object)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cellPaint(GC gc, final TableCellSWT cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.cellPaintFileInfo(gc, cell, (DiskManagerFileInfo)ds);
            return;
        }
        Rectangle cellBounds = cell.getBounds();
        int textX = cellBounds.x;
        TableRowCore rowCore = cell.getTableRowCore();
        if (rowCore != null) {
            boolean show_twisty;
            int numSubItems = rowCore.getSubItemCount();
            int paddingX = 3;
            int width = 7;
            if (NEVER_SHOW_TWISTY) {
                show_twisty = false;
            } else if (numSubItems > 1) {
                show_twisty = true;
            } else {
                Boolean show = (Boolean)rowCore.getData(ID_EXPANDOHITAREASHOW);
                if (show == null) {
                    DownloadManager dm = (DownloadManager)ds;
                    TOTorrent torrent = dm.getTorrent();
                    show_twisty = torrent != null && !dm.getTorrent().isSimpleTorrent();
                    rowCore.setData(ID_EXPANDOHITAREASHOW, new Boolean(show_twisty));
                } else {
                    show_twisty = show;
                }
            }
            if (show_twisty) {
                int middleY = cellBounds.y + cellBounds.height / 2 - 1;
                int startX = cellBounds.x + paddingX;
                int halfHeight = 2;
                Color bg = gc.getBackground();
                gc.setBackground(gc.getForeground());
                gc.setAntialias(1);
                gc.setAdvanced(true);
                if (rowCore.isExpanded()) {
                    gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + width, middleY - halfHeight, startX + width / 2, middleY + halfHeight * 2 + 1});
                } else {
                    gc.fillPolygon(new int[]{startX, middleY - halfHeight, startX + width, middleY + halfHeight, startX, middleY + halfHeight * 2 + 1});
                }
                gc.setBackground(bg);
                Rectangle hitArea = new Rectangle(paddingX, middleY - halfHeight - cellBounds.y, width, halfHeight * 4 + 1);
                rowCore.setData(ID_EXPANDOHITAREA, hitArea);
            }
            if (!NEVER_SHOW_TWISTY) {
                cellBounds.x += paddingX * 2 + width;
                cellBounds.width -= paddingX * 2 + width;
            }
        }
        if (!this.showIcon) {
            cellBounds.x += 2;
            cellBounds.width -= 4;
            this.cellPaintName(cell, gc, cellBounds, cellBounds.x);
            return;
        }
        Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, cellBounds.height >= 20, new TorrentUIUtilsV3.ContentImageLoadedListener(){

            public void contentImageLoaded(Image image, boolean wasReturned) {
                if (!wasReturned) {
                    cell.invalidate();
                }
            }
        });
        if (imgThumbnail != null && ImageLoader.isRealImage(imgThumbnail[0])) {
            try {
                block37: {
                    int dstWidth;
                    int dstHeight;
                    if (cellBounds.height > 30) {
                        ++cellBounds.y;
                        cellBounds.height -= 3;
                    }
                    Rectangle imgBounds = imgThumbnail[0].getBounds();
                    if (imgBounds.height > cellBounds.height) {
                        dstHeight = cellBounds.height;
                        dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                    } else if (imgBounds.width > cellBounds.width) {
                        dstWidth = cellBounds.width - 4;
                        dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                    } else {
                        dstWidth = imgBounds.width;
                        dstHeight = imgBounds.height;
                    }
                    if (cellBounds.height <= 18) {
                        dstWidth = Math.min(dstWidth, cellBounds.height);
                        dstHeight = Math.min(dstHeight, cellBounds.height);
                        if (imgBounds.width > 16) {
                            ++cellBounds.y;
                            dstHeight -= 2;
                        }
                    }
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int x = cellBounds.x;
                    textX = x + dstWidth + 3;
                    int minWidth = dstHeight * 7 / 4;
                    int imgPad = 0;
                    if (dstHeight > 25 && dstWidth < minWidth) {
                        imgPad = (minWidth - dstWidth + 1) / 2;
                        x = cellBounds.x + imgPad;
                        textX = cellBounds.x + minWidth + 3;
                    }
                    if (cellBounds.width - dstWidth - imgPad * 2 < 100 && dstHeight > 18) {
                        dstWidth = Math.min(32, dstHeight);
                        x = cellBounds.x + (32 - dstWidth + 1) / 2;
                        dstHeight = imgBounds.height * dstWidth / imgBounds.width;
                        textX = cellBounds.x + dstWidth + 3;
                    }
                    int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
                    if (dstWidth > 0 && dstHeight > 0 && !imgBounds.isEmpty()) {
                        Rectangle lastClipping = gc.getClipping();
                        try {
                            block36: {
                                try {
                                    boolean hack_adv;
                                    Utils.setClipping(gc, cellBounds);
                                    boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                                    if (hack_adv) {
                                        gc.setAdvanced(false);
                                    }
                                    for (int i = 0; i < imgThumbnail.length; ++i) {
                                        int h;
                                        int w;
                                        Image image = imgThumbnail[i];
                                        if (image == null || image.isDisposed()) continue;
                                        Rectangle srcBounds = image.getBounds();
                                        if (i == 0) {
                                            w = dstWidth;
                                            h = dstHeight;
                                            if (imgThumbnail.length > 1) {
                                                w = w * 9 / 10;
                                                h = h * 9 / 10;
                                            }
                                            gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                            continue;
                                        }
                                        w = dstWidth * 3 / 8;
                                        h = dstHeight * 3 / 8;
                                        gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                    }
                                    if (!hack_adv) break block36;
                                    gc.setAdvanced(true);
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                    Object var23_35 = null;
                                    Utils.setClipping(gc, lastClipping);
                                    break block37;
                                }
                            }
                            Object var23_34 = null;
                        }
                        catch (Throwable throwable) {
                            Object var23_36 = null;
                            Utils.setClipping(gc, lastClipping);
                            throw throwable;
                        }
                        Utils.setClipping(gc, lastClipping);
                    }
                }
                TorrentUIUtilsV3.releaseContentImage(ds);
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        this.cellPaintName(cell, gc, cellBounds, textX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cellPaintFileInfo(GC gc, TableCellSWT cell, DiskManagerFileInfo fileInfo2) {
        int pos;
        String dnd_sf;
        int textX;
        Rectangle cellBounds;
        block24: {
            cellBounds = cell.getBounds();
            int padding = 5 + cellBounds.height;
            cellBounds.x += padding;
            cellBounds.width -= padding;
            textX = cellBounds.x;
            Image[] imgThumbnail = new Image[]{ImageRepository.getPathIcon(fileInfo2.getFile(true).getPath(), cellBounds.height >= 20, false)};
            if (imgThumbnail != null && ImageLoader.isRealImage(imgThumbnail[0])) {
                try {
                    int dstWidth;
                    int dstHeight;
                    if (cellBounds.height > 30) {
                        ++cellBounds.y;
                        cellBounds.height -= 3;
                    }
                    Rectangle imgBounds = imgThumbnail[0].getBounds();
                    if (imgBounds.height > cellBounds.height) {
                        dstHeight = cellBounds.height;
                        dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
                    } else if (imgBounds.width > cellBounds.width) {
                        dstWidth = cellBounds.width - 4;
                        dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                    } else {
                        dstWidth = imgBounds.width;
                        dstHeight = imgBounds.height;
                    }
                    if (cellBounds.height <= 18) {
                        dstWidth = Math.min(dstWidth, cellBounds.height);
                        dstHeight = Math.min(dstHeight, cellBounds.height);
                        if (imgBounds.width > 16) {
                            ++cellBounds.y;
                            dstHeight -= 2;
                        }
                    }
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int x = cellBounds.x;
                    textX = x + dstWidth + 3;
                    int minWidth = dstHeight;
                    int imgPad = 0;
                    if (dstHeight > 25 && dstWidth < minWidth) {
                        imgPad = (minWidth - dstWidth + 1) / 2;
                        x = cellBounds.x + imgPad;
                        textX = cellBounds.x + minWidth + 3;
                    }
                    if (cellBounds.width - dstWidth - imgPad * 2 < 100 && dstHeight > 18) {
                        dstWidth = Math.min(32, dstHeight);
                        x = cellBounds.x + (32 - dstWidth + 1) / 2;
                        dstHeight = imgBounds.height * dstWidth / imgBounds.width;
                        textX = cellBounds.x + dstWidth + 3;
                    }
                    int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
                    if (dstWidth <= 0 || dstHeight <= 0 || imgBounds.isEmpty()) break block24;
                    Rectangle lastClipping = gc.getClipping();
                    try {
                        block25: {
                            try {
                                boolean hack_adv;
                                Utils.setClipping(gc, cellBounds);
                                boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                                if (hack_adv) {
                                    gc.setAdvanced(false);
                                }
                                for (int i = 0; i < imgThumbnail.length; ++i) {
                                    int h;
                                    int w;
                                    Image image = imgThumbnail[i];
                                    if (image == null || image.isDisposed()) continue;
                                    Rectangle srcBounds = image.getBounds();
                                    if (i == 0) {
                                        w = dstWidth;
                                        h = dstHeight;
                                        if (imgThumbnail.length > 1) {
                                            w = w * 9 / 10;
                                            h = h * 9 / 10;
                                        }
                                        gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                        continue;
                                    }
                                    w = dstWidth * 3 / 8;
                                    h = dstHeight * 3 / 8;
                                    gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                }
                                if (!hack_adv) break block25;
                                gc.setAdvanced(true);
                            }
                            catch (Exception e) {
                                Debug.out(e);
                                Object var23_29 = null;
                                Utils.setClipping(gc, lastClipping);
                                break block24;
                            }
                        }
                        Object var23_28 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_30 = null;
                        Utils.setClipping(gc, lastClipping);
                        throw throwable;
                    }
                    Utils.setClipping(gc, lastClipping);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        String prefix = fileInfo2.getDownloadManager().getSaveLocation().toString();
        String s = fileInfo2.getFile(true).toString();
        if (s.startsWith(prefix)) {
            s = s.substring(prefix.length() + 1);
        }
        if (fileInfo2.isSkipped() && (dnd_sf = fileInfo2.getDownloadManager().getDownloadState().getAttribute("dnd_sf")) != null && (dnd_sf = dnd_sf.trim()).length() > 0 && (pos = s.indexOf(dnd_sf = dnd_sf + File.separatorChar)) != -1) {
            s = s.substring(0, pos) + s.substring(pos + dnd_sf.length());
        }
        cellBounds.width -= textX - cellBounds.x;
        cellBounds.x = textX;
        boolean over = GCStringPrinter.printString(gc, s, cellBounds, true, false, 16448);
        cell.setToolTip(over ? null : s);
    }

    private void cellPaintName(TableCell cell, GC gc, Rectangle cellBounds, int textX) {
        String tooltip;
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        boolean over = GCStringPrinter.printString(gc, name, new Rectangle(textX, cellBounds.y, cellBounds.x + cellBounds.width - textX, cellBounds.height), true, true, this.getTableID().endsWith(".big") ? 64 : 0);
        String string = tooltip = over ? "" : name;
        if (dm != null) {
            try {
                String desc = PlatformTorrentUtils.getContentDescription(dm.getTorrent());
                if (desc != null && desc.length() > 0) {
                    tooltip = tooltip + (tooltip.length() == 0 ? "" : "\r\n") + desc;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        cell.setToolTip(tooltip.length() == 0 ? null : tooltip);
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
            return fileInfo2.getIndex() + ": " + Debug.secretFileName(fileInfo2.getFile(true).getName());
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void dispose(TableCell cell) {
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
        this.invalidateCells();
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public String getClipboardText(TableCell cell) {
        String name = null;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            return null;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 3 || event2.eventType == 0) {
            TableRow row = event2.cell.getTableRow();
            if (row == null) {
                return;
            }
            Object data = row.getData(ID_EXPANDOHITAREA);
            if (data instanceof Rectangle) {
                Rectangle hitArea = (Rectangle)data;
                boolean inExpando = hitArea.contains(event2.x, event2.y);
                if (event2.eventType == 3) {
                    ((TableCellCore)event2.cell).setCursorID(inExpando ? 21 : 0);
                } else if (inExpando && row instanceof TableRowCore) {
                    TableRowCore rowCore;
                    rowCore.setExpanded(!(rowCore = (TableRowCore)row).isExpanded());
                }
            }
        }
    }
}

