/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.feature;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import com.aelitis.azureus.util.FeatureUtils;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.ui.swt.Utils;

public class FeatureManagerInstallWindow
implements FeatureManager.Licence.LicenceInstallationListener {
    private static final boolean FAKE_DELAY = Constants.IS_CVS_VERSION;
    private VuzeMessageBox box;
    private ProgressBar progressBar;
    private FeatureManager.Licence licence;
    private SWTSkinObjectText soProgressText;
    private String progressText;
    private SWTSkinObjectText soInstallPct;
    public static boolean alreadyFailing = false;

    public FeatureManagerInstallWindow(FeatureManager.Licence licence) {
        if (!FeatureManagerUI.enabled) {
            return;
        }
        this.licence = licence;
        licence.addInstallationListener(this);
    }

    public void open() {
        if (!FeatureManagerUI.enabled) {
            return;
        }
        boolean isTrial = FeatureUtils.isTrialLicence(this.licence);
        this.box = new VuzeMessageBox(MessageText.getString("dlg.auth.title"), "", null, 0);
        this.box.setSubTitle(MessageText.getString(isTrial ? "dlg.auth.install.subtitle.trial" : "dlg.auth.install.subtitle.plus"));
        this.box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        this.box.setIconResource(isTrial ? "image.burn.dlg.header" : "image.vp");
        this.box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.register.install", "dlg.register.install", soExtra);
                SWTSkinObjectContainer soProgressBar = (SWTSkinObjectContainer)skin.getSkinObject("progress-bar");
                if (soProgressBar != null) {
                    FeatureManagerInstallWindow.this.progressBar = new ProgressBar(soProgressBar.getComposite(), 256);
                    FeatureManagerInstallWindow.this.progressBar.setMinimum(0);
                    FeatureManagerInstallWindow.this.progressBar.setMaximum(100);
                    FeatureManagerInstallWindow.this.progressBar.setLayoutData((Object)Utils.getFilledFormData());
                }
                FeatureManagerInstallWindow.this.soInstallPct = (SWTSkinObjectText)skin.getSkinObject("install-pct");
                FeatureManagerInstallWindow.this.soProgressText = (SWTSkinObjectText)skin.getSkinObject("progress-text");
                if (FeatureManagerInstallWindow.this.soProgressText != null && FeatureManagerInstallWindow.this.progressText != null) {
                    FeatureManagerInstallWindow.this.soProgressText.setText(FeatureManagerInstallWindow.this.progressText);
                }
            }
        });
        this.box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                FeatureManagerInstallWindow.this.licence.removeInstallationListener(FeatureManagerInstallWindow.this);
            }
        });
    }

    public void reportActivity(String licence_key, String install, String activity) {
        if (FAKE_DELAY) {
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.soProgressText != null) {
            String[] split = install.split("/", 2);
            this.progressText = MessageText.getString("dlg.auth.install.progress", new String[]{split.length == 2 ? split[1] : split[0]});
            this.soProgressText.setText(this.progressText);
        }
    }

    public void reportProgress(String licence_key, String install, final int percent) {
        if (FAKE_DELAY) {
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int pct;
                int n = pct = percent == 100 ? 99 : percent;
                if (FeatureManagerInstallWindow.this.soInstallPct != null) {
                    FeatureManagerInstallWindow.this.soInstallPct.setText(MessageText.getString("dlg.auth.install.pct", new String[]{"" + pct}));
                }
                if (FeatureManagerInstallWindow.this.progressBar != null && !FeatureManagerInstallWindow.this.progressBar.isDisposed()) {
                    FeatureManagerInstallWindow.this.progressBar.setSelection(pct);
                }
            }
        });
    }

    public void complete(String licence_key) {
        if (this.box != null) {
            this.box.close(0);
        }
        this.licence.removeInstallationListener(this);
    }

    public void failed(String licence_key, PluginException error) {
        if (alreadyFailing) {
            return;
        }
        alreadyFailing = true;
        UIFunctionsManager.getUIFunctions().promptUser(MessageText.getString("dlg.auth.install.failed.title"), MessageText.getString("dlg.auth.install.failed.text", new String[]{licence_key, Debug.getNestedExceptionMessage(error)}), new String[]{MessageText.getString("Button.ok")}, 0, null, null, false, 0, new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                alreadyFailing = false;
            }
        });
        Logger.log(new LogAlert(true, "Error while installing " + licence_key, error));
        this.box.close(0);
        this.licence.removeInstallationListener(this);
    }

    public void close() {
        this.box.close(0);
        this.licence.removeInstallationListener(this);
    }

    public void start(String licence_key) {
    }
}

