/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.skin.SkinProperties;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinLayoutCompleteListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCombo;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandBar;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandItem;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSeparator;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSlider;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTabFolder;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText2;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectToggle;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesClone;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesParam;
import com.aelitis.azureus.ui.swt.skin.SWTSkinPropertiesParamImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTSkin {
    public static final boolean DEBUG_VISIBILITIES = false;
    private static final SWTSkinObjectListener[] NOLISTENERS = new SWTSkinObjectListener[0];
    private static SWTSkin default_instance;
    public boolean DEBUGLAYOUT = System.getProperty("debuglayout") != null;
    private Map<SkinProperties, ImageLoader> mapImageLoaders = new ConcurrentHashMap<SkinProperties, ImageLoader>();
    private SWTSkinProperties skinProperties;
    private Listener handCursorListener;
    private HashMap<String, SWTSkinObject[]> mapIDsToSOs = new HashMap();
    private AEMonitor mon_MapIDsToSOs = new AEMonitor("mapIDsToControls");
    private HashMap<String, SWTSkinTabSet> mapTabSetToControls = new HashMap();
    private HashMap<String, SWTSkinObject[]> mapPublicViewIDsToSOs = new HashMap();
    private AEMonitor mon_mapPublicViewIDsToSOs = new AEMonitor("mapPVIDsToSOs");
    private HashMap<String, ArrayList<SWTSkinObjectListener>> mapPublicViewIDsToListeners = new HashMap();
    private AEMonitor mapPublicViewIDsToListeners_mon = new AEMonitor("mapPVIDsToListeners");
    private ArrayList<SWTSkinObjectBasic> ontopImages = new ArrayList();
    private Composite skinComposite;
    private boolean bLayoutComplete = false;
    private CopyOnWriteList<SWTSkinLayoutCompleteListener> listenersLayoutComplete = new CopyOnWriteList();
    private int currentSkinObjectcreationCount = 0;
    private ImageLoader imageLoader;
    private String startID;
    private boolean autoSizeOnLayout = true;

    protected static synchronized SWTSkin getDefaultInstance() {
        if (default_instance == null) {
            default_instance = new SWTSkin();
        }
        return default_instance;
    }

    protected SWTSkin() {
        this.init(new SWTSkinPropertiesImpl(), true);
    }

    protected SWTSkin(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        this.init(new SWTSkinPropertiesImpl(classLoader, skinPath, mainSkinFile), false);
    }

    private void init(SWTSkinProperties skinProperties, boolean is_default) {
        this.skinProperties = skinProperties;
        if (is_default) {
            this.imageLoader = ImageLoader.getInstance();
            this.imageLoader.addSkinProperties(skinProperties);
        } else {
            this.imageLoader = new ImageLoader(Display.getDefault(), skinProperties);
            this.mapImageLoaders.put(skinProperties, this.imageLoader);
        }
    }

    public ImageLoader getImageLoader(SkinProperties properties) {
        if (properties == this.skinProperties) {
            return this.imageLoader;
        }
        ImageLoader loader = this.mapImageLoaders.get(properties);
        if (loader != null) {
            return loader;
        }
        loader = new ImageLoader(Display.getDefault(), properties);
        this.mapImageLoaders.put(properties, loader);
        return loader;
    }

    public void addToControlMap(SWTSkinObject skinObject) {
        String sID = skinObject.getSkinObjectID();
        if (this.DEBUGLAYOUT) {
            System.out.println("addToControlMap: " + sID + " : " + skinObject);
        }
        this.addToSOArrayMap(this.mapIDsToSOs, this.mon_MapIDsToSOs, sID, skinObject);
        Control control = skinObject.getControl();
        if (control != null) {
            control.setData("ConfigID", (Object)skinObject.getConfigID());
            control.setData("SkinID", (Object)sID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSOArrayMap(Map<String, SWTSkinObject[]> arrayMap, AEMonitor mon, String key, SWTSkinObject object) {
        if (mon != null) {
            mon.enter();
        }
        try {
            SWTSkinObject[] existingObjects = arrayMap.get(key);
            if (existingObjects != null) {
                boolean bAlreadyPresent = false;
                for (int i = 0; i < existingObjects.length; ++i) {
                    if (existingObjects[i] == null || !existingObjects[i].equals(object)) continue;
                    bAlreadyPresent = true;
                    System.err.println("already present: " + key + "; " + object + "; existing: " + existingObjects[i] + " via " + Debug.getCompressedStackTrace());
                    break;
                }
                if (!bAlreadyPresent) {
                    int length = existingObjects.length;
                    SWTSkinObject[] newObjects = new SWTSkinObject[length + 1];
                    System.arraycopy(existingObjects, 0, newObjects, 0, length);
                    newObjects[length] = object;
                    arrayMap.put(key, newObjects);
                }
            } else {
                arrayMap.put(key, new SWTSkinObject[]{object});
            }
            Object var10_9 = null;
            if (mon != null) {
                mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (mon != null) {
                mon.exit();
            }
            throw throwable;
        }
    }

    private Object getFromSOArrayMap(Map<String, SWTSkinObject[]> arrayMap, Object key, SWTSkinObject parent) {
        if (parent == null) {
            return null;
        }
        SWTSkinObject[] objects = arrayMap.get(key);
        if (objects == null) {
            return null;
        }
        for (int i = 0; i < objects.length; ++i) {
            SWTSkinObject object;
            for (SWTSkinObject thisParent = object = objects[i]; thisParent != null; thisParent = thisParent.getParent()) {
                if (!thisParent.equals(parent)) continue;
                return object;
            }
        }
        return null;
    }

    private void setSkinObjectViewID(SWTSkinObject skinObject, String sViewID) {
        this.addToSOArrayMap(this.mapPublicViewIDsToSOs, this.mon_mapPublicViewIDsToSOs, sViewID, skinObject);
    }

    public SWTSkinObject getSkinObjectByID(String sID) {
        SWTSkinObject[] objects = this.mapIDsToSOs.get(sID);
        if (objects == null || objects.length == 0) {
            return null;
        }
        return objects[0];
    }

    public SWTSkinObject getSkinObjectByID(String sID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObjectByID(sID);
        }
        return (SWTSkinObject)this.getFromSOArrayMap(this.mapIDsToSOs, sID, parent);
    }

    public SWTSkinObject getSkinObject(String sViewID) {
        SWTSkinObject[] objects = this.mapPublicViewIDsToSOs.get(sViewID);
        if (objects == null || objects.length == 0) {
            return this.createUnattachedView(sViewID, null);
        }
        return objects[0];
    }

    private SWTSkinObject createUnattachedView(String viewID, SWTSkinObject parent) {
        String unattachedView = this.skinProperties.getStringValue("UnattachedView." + viewID);
        if (unattachedView != null) {
            String[] split;
            String parentID;
            SWTSkinObject soParent;
            if (!Utils.isThisThreadSWT()) {
                Debug.out("View " + viewID + " does not exist.  Skipping unattach check because not in SWT thread");
                return null;
            }
            if (unattachedView.indexOf(44) > 0 && (soParent = this.getSkinObjectByID(parentID = (split = Constants.PAT_SPLIT_COMMA.split(unattachedView))[1], parent)) != null) {
                String configID = split[0];
                return this.createSkinObject(configID, configID, soParent);
            }
            SWTSkinObjectListener[] listeners = this.getSkinObjectListeners(viewID);
            for (int i = 0; i < listeners.length; ++i) {
                SWTSkinObjectListener l = listeners[i];
                Object o = l.eventOccured(null, 5, new String[]{viewID, unattachedView});
                if (!(o instanceof SWTSkinObject)) continue;
                return (SWTSkinObject)o;
            }
        }
        return null;
    }

    public SWTSkinObject getSkinObject(String sViewID, SWTSkinObject parent) {
        if (parent == null) {
            return this.getSkinObject(sViewID);
        }
        String parentViewID = parent.getViewID();
        if (parentViewID != null && parentViewID.equals(sViewID)) {
            return parent;
        }
        SWTSkinObject so = (SWTSkinObject)this.getFromSOArrayMap(this.mapPublicViewIDsToSOs, sViewID, parent);
        if (so == null) {
            so = this.createUnattachedView(sViewID, parent);
        }
        return so;
    }

    public SWTSkinTabSet getTabSet(String sID) {
        return this.mapTabSetToControls.get(sID);
    }

    public SWTSkinObjectTab activateTab(SWTSkinObject skinObjectInTab) {
        if (skinObjectInTab == null) {
            return null;
        }
        if (skinObjectInTab instanceof SWTSkinObjectTab) {
            SWTSkinObjectTab tab = (SWTSkinObjectTab)skinObjectInTab;
            tab.getTabset().setActiveTab(tab);
            return tab;
        }
        for (SWTSkinTabSet tabset : this.mapTabSetToControls.values()) {
            SWTSkinObjectTab[] tabs = tabset.getTabs();
            boolean bHasSkinObject = false;
            for (int i = 0; i < tabs.length; ++i) {
                SWTSkinObjectTab tab = tabs[i];
                SWTSkinObject[] activeWidgets = tab.getActiveWidgets(true);
                for (int j = 0; j < activeWidgets.length; ++j) {
                    SWTSkinObject object = activeWidgets[j];
                    if (!this.hasSkinObject(object, skinObjectInTab)) continue;
                    tabset.setActiveTab(tab);
                    return tab;
                }
            }
        }
        System.out.println("NOT FOUND" + skinObjectInTab);
        return null;
    }

    private boolean hasSkinObject(SWTSkinObject start, SWTSkinObject skinObject) {
        if (start instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children = ((SWTSkinObjectContainer)start).getChildren();
            for (int i = 0; i < children.length; ++i) {
                SWTSkinObject object = children[i];
                if (!this.hasSkinObject(object, skinObject)) continue;
                return true;
            }
        }
        return skinObject.equals(start);
    }

    public SWTSkinTabSet getTabSet(SWTSkinObject skinObject) {
        String sTabSetID = skinObject.getProperties().getStringValue(skinObject.getConfigID() + ".tabset");
        return this.getTabSet(sTabSetID);
    }

    public boolean setActiveTab(String sTabSetID, String sTabViewID) {
        SWTSkinTabSet tabSet = this.getTabSet(sTabSetID);
        if (tabSet == null) {
            System.err.println(sTabSetID);
            return false;
        }
        return tabSet.setActiveTab(sTabViewID);
    }

    public void initialize(Composite skincomp, String startID) {
        this.initialize(skincomp, startID, null);
    }

    public void initialize(Composite skincomp, String startID, IUIIntializer uiInitializer) {
        String[] sMainGroups;
        Color fg;
        this.skinComposite = skincomp;
        this.startID = startID;
        FormLayout layout = new FormLayout();
        this.skinComposite.setLayout((Layout)layout);
        this.skinComposite.setBackgroundMode(1);
        this.skinComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTSkin.this.disposeSkin();
            }
        });
        Listener l = new Listener(){
            Control lastControl = null;

            public void handleEvent(Event event2) {
                if (SWTSkin.this.skinComposite.isDisposed() && event2.display != null) {
                    event2.display.removeFilter(5, (Listener)this);
                    event2.display.removeFilter(7, (Listener)this);
                    return;
                }
                Control cursorControl = SWTSkin.this.skinComposite.getDisplay().getCursorControl();
                if (cursorControl != this.lastControl) {
                    Point cursorLocation = SWTSkin.this.skinComposite.getDisplay().getCursorLocation();
                    while (this.lastControl != null && !this.lastControl.isDisposed()) {
                        SWTSkinObjectBasic so;
                        Point cursorLocationInControl = this.lastControl.toControl(cursorLocation);
                        Point size = this.lastControl.getSize();
                        if (!new Rectangle(0, 0, size.x, size.y).contains(cursorLocationInControl) && (so = (SWTSkinObjectBasic)this.lastControl.getData("SkinObject")) != null) {
                            so.switchSuffix("", 3, false, false);
                        }
                        this.lastControl = this.lastControl.getParent();
                    }
                    this.lastControl = cursorControl;
                    while (cursorControl != null) {
                        SWTSkinObjectBasic so = (SWTSkinObjectBasic)cursorControl.getData("SkinObject");
                        if (so != null) {
                            so.switchSuffix("-over", 3, false, false);
                        }
                        cursorControl = cursorControl.getParent();
                    }
                }
            }
        };
        Display display = this.skinComposite.getDisplay();
        display.addFilter(5, l);
        display.addFilter(7, l);
        this.skinComposite.addListener(27, l);
        this.skinComposite.addListener(26, l);
        Color bg = this.skinProperties.getColor(startID + ".color");
        if (bg != null) {
            this.skinComposite.setBackground(bg);
        }
        if ((fg = this.skinProperties.getColor(startID + ".fgcolor")) != null) {
            this.skinComposite.setForeground(fg);
        }
        int width = this.skinProperties.getPxValue(startID + ".width", -1);
        int height = this.skinProperties.getPxValue(startID + ".height", -1);
        if (width > 0 && height > 0) {
            this.skinComposite.setSize(width, height);
        }
        if (this.skinComposite instanceof Shell) {
            String title;
            Shell shell = (Shell)this.skinComposite;
            int minWidth = this.skinProperties.getPxValue(startID + ".minwidth", -1);
            int minHeight = this.skinProperties.getPxValue(startID + ".minheight", -1);
            if (minWidth > 0 || minHeight > 0) {
                Point minimumSize = shell.getMinimumSize();
                shell.setMinimumSize(minWidth > 0 ? minWidth : minimumSize.x, minHeight > 0 ? minHeight : minimumSize.y);
            }
            if ((title = this.skinProperties.getStringValue(startID + ".title", (String)null)) != null) {
                ((Shell)this.skinComposite).setText(title);
            }
        }
        if ((sMainGroups = this.skinProperties.getStringArray(startID + ".widgets")) == null) {
            System.out.println("NO " + startID + ".widgets!!");
            sMainGroups = new String[]{};
        }
        for (int i = 0; i < sMainGroups.length; ++i) {
            String sID = sMainGroups[i];
            if (this.DEBUGLAYOUT) {
                System.out.println("Container: " + sID);
            }
            if (uiInitializer != null) {
                uiInitializer.increaseProgress();
            }
            this.linkIDtoParent(this.skinProperties, sID, sID, null, false, true, null);
        }
    }

    private void disposeSkin() {
        for (ImageLoader loader : this.mapImageLoaders.values()) {
            loader.unLoadImages();
        }
    }

    public void layout(SWTSkinObject soStart) {
        if (soStart instanceof SWTSkinObjectContainer) {
            SWTSkinObject[] children;
            SWTSkinObjectContainer soContainer = (SWTSkinObjectContainer)soStart;
            for (SWTSkinObject so : children = soContainer.getChildren()) {
                this.layout(so);
            }
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("attachControl " + soStart.toString());
        }
        this.attachControl(soStart);
    }

    public void layout() {
        if (this.DEBUGLAYOUT) {
            System.out.println("==== Start Apply Layout");
        }
        Object[] values = this.mapIDsToSOs.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            SWTSkinObject[] skinObjects = (SWTSkinObject[])values[i];
            if (skinObjects == null) continue;
            for (int j = 0; j < skinObjects.length; ++j) {
                SWTSkinObject skinObject = skinObjects[j];
                if (this.DEBUGLAYOUT) {
                    System.out.println("Apply Layout for " + skinObject);
                }
                this.attachControl(skinObject);
            }
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("====  Applied Layout");
        }
        this.bLayoutComplete = true;
        int width = this.skinProperties.getPxValue(this.startID + ".width", -1);
        int height = this.skinProperties.getPxValue(this.startID + ".height", -1);
        if (this.skinComposite instanceof ShellFactory.AEShell) {
            ((ShellFactory.AEShell)this.skinComposite).setAdjustPXforDPI(false);
        }
        if (this.autoSizeOnLayout) {
            if (width > 0 && height == -1) {
                Point computeSize = this.skinComposite.computeSize(width, -1);
                this.skinComposite.setSize(computeSize);
            } else if (height > 0 && width == -1) {
                Point computeSize = this.skinComposite.computeSize(-1, height);
                this.skinComposite.setSize(computeSize);
            } else if (height > 0 && width > 0) {
                this.skinComposite.setSize(width, height);
            }
        } else {
            Point size = this.skinComposite.getSize();
            if (width > 0) {
                size.x = width;
            }
            if (height > 0) {
                size.y = height;
            }
            this.skinComposite.setSize(size);
        }
        for (SWTSkinLayoutCompleteListener l : this.listenersLayoutComplete) {
            l.skinLayoutCompleted();
        }
        this.listenersLayoutComplete.clear();
        if (this.DEBUGLAYOUT) {
            System.out.println("==== End Apply Layout");
        }
        this.skinProperties.clearCache();
    }

    void attachControl(SWTSkinObject skinObject) {
        if (skinObject == null) {
            return;
        }
        Control controlToLayout = skinObject.getControl();
        if (controlToLayout == null || controlToLayout.isDisposed()) {
            return;
        }
        if (controlToLayout.getData("skin.layedout") != null) {
            return;
        }
        String sConfigID = skinObject.getConfigID();
        SWTSkinProperties properties = skinObject.getProperties();
        String[] sDirections = new String[]{"top", "bottom", "left", "right"};
        Object data = controlToLayout.getLayoutData();
        if (data != null && !(data instanceof FormData)) {
            return;
        }
        FormData oldFormData = (FormData)controlToLayout.getLayoutData();
        if (oldFormData == null) {
            oldFormData = new FormData();
        }
        FormData newFormData = new FormData(oldFormData.width, oldFormData.height);
        String templateID = properties.getStringValue(sConfigID + ".attach.template");
        if (templateID == null) {
            // empty if block
        }
        boolean debugControl = controlToLayout.getData("DEBUG") != null;
        block18: for (int i = 0; i < sDirections.length; ++i) {
            FormAttachment attachment;
            Control control = null;
            int offset = 0;
            int percent = 0;
            String sAlign = null;
            int align = -1;
            switch (i) {
                case 0: {
                    attachment = oldFormData.top;
                    break;
                }
                case 1: {
                    attachment = oldFormData.bottom;
                    break;
                }
                case 2: {
                    attachment = oldFormData.left;
                    break;
                }
                case 3: {
                    attachment = oldFormData.right;
                    break;
                }
                default: {
                    attachment = null;
                }
            }
            if (attachment != null) {
                control = attachment.control;
                offset = attachment.offset;
                align = attachment.alignment;
                percent = attachment.numerator;
            }
            String suffix = ".attach." + sDirections[i];
            String prefix = sConfigID;
            String[] sParams = properties.getStringArray(sConfigID + suffix);
            if (sParams == null && templateID != null) {
                sParams = properties.getStringArray(templateID + suffix);
                prefix = templateID;
            }
            if (sParams == null) {
                if (attachment != null) {
                    attachment = control == null ? new FormAttachment(percent, offset) : new FormAttachment(control, offset, align);
                }
            } else if (sParams.length == 0 || sParams.length == 1 && sParams[0].length() == 0) {
                attachment = null;
            } else if (sParams[0].length() > 0 && Character.isDigit(sParams[0].charAt(0))) {
                try {
                    percent = Integer.parseInt(sParams[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sParams.length > 1) {
                    try {
                        String value = sParams[1];
                        if (value.endsWith("rem")) {
                            float em = Float.parseFloat(value.substring(0, value.length() - 3));
                            offset = (int)((float)properties.getEmHeightPX() * em);
                        } else {
                            offset = Integer.parseInt(value);
                            offset = Utils.adjustPXForDPI(offset);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                attachment = new FormAttachment(percent, offset);
            } else {
                int iNextPos;
                String sWidget = sParams[0];
                SWTSkinObject configSkinObject = this.getSkinObjectByID(sWidget, skinObject.getParent());
                if (configSkinObject != null) {
                    control = configSkinObject.getControl();
                    iNextPos = 1;
                } else {
                    iNextPos = 0;
                    if (sWidget.length() != 0) {
                        System.err.println("ERROR: Trying to attach " + sDirections[i] + " of widget '" + skinObject + "' to non-existant widget '" + sWidget + "'.  Attachment Parameters: " + properties.getStringValue(prefix + suffix));
                    }
                }
                for (int j = iNextPos; j < sParams.length; ++j) {
                    if (sParams[j].length() <= 0) continue;
                    char c = sParams[j].charAt(0);
                    if (Character.isDigit(c) || c == '-') {
                        try {
                            String value = sParams[j];
                            if (value.endsWith("rem")) {
                                float em = Float.parseFloat(value.substring(0, value.length() - 3));
                                offset = (int)((float)properties.getEmHeightPX() * em);
                                continue;
                            }
                            offset = Integer.parseInt(value);
                            offset = Utils.adjustPXForDPI(offset);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    sAlign = sParams[j];
                }
                if (sAlign != null) {
                    align = SWTSkinUtils.getAlignment(sAlign, align);
                }
                attachment = new FormAttachment(control, offset, align);
            }
            if (debugControl && attachment != null && controlToLayout instanceof Group) {
                Group group = (Group)controlToLayout;
                String sValue = properties.getStringValue(prefix + suffix);
                String sText = group.getText() + "; " + sDirections[i].substring(0, 1) + "=" + (sValue == null ? "(def)" : sValue);
                if (sText.length() < 20) {
                    group.setText(sText);
                }
                group.setToolTipText(sText);
            }
            if (this.DEBUGLAYOUT) {
                System.out.println("Attach: " + sConfigID + suffix + ": " + properties.getStringValue(prefix + suffix) + "/" + attachment);
            }
            switch (i) {
                case 0: {
                    newFormData.top = attachment;
                    continue block18;
                }
                case 1: {
                    newFormData.bottom = attachment;
                    continue block18;
                }
                case 2: {
                    newFormData.left = attachment;
                    continue block18;
                }
                case 3: {
                    newFormData.right = attachment;
                }
            }
        }
        if (!skinObject.getDefaultVisibility()) {
            if (controlToLayout.getData("oldSize") == null) {
                controlToLayout.setData("oldSize", (Object)new Point(properties.getPxValue(sConfigID + ".width", -1), properties.getPxValue(sConfigID + ".height", -1)));
            }
            newFormData.width = 0;
            newFormData.height = 0;
        } else {
            int h = properties.getPxValue(sConfigID + ".height", -2);
            int w = properties.getPxValue(sConfigID + ".width", -2);
            if (h != -2) {
                newFormData.height = h;
            }
            if (w != -2) {
                newFormData.width = w;
            }
        }
        controlToLayout.setLayoutData((Object)newFormData);
        controlToLayout.setData("skin.layedout", (Object)"");
        skinObject.layoutComplete();
    }

    private SWTSkinObject createContainer(SWTSkinProperties properties, String sID, String sConfigID, String[] sTypeParams, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(sConfigID + ".widgets") + " on " + parentSkinObject);
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject == null) {
                skinObject = new SWTSkinObjectContainer(this, properties, sID, sConfigID, sTypeParams, parentSkinObject);
                this.addToControlMap(skinObject);
            } else {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(sConfigID + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private void addContainerChildren(SWTSkinObject skinObject, String[] sItems, SWTSkinProperties properties) {
        String[] paramValues = null;
        if (properties instanceof SWTSkinPropertiesParam) {
            paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
        }
        if (properties instanceof SWTSkinPropertiesClone) {
            properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
        }
        if (paramValues != null) {
            properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
        }
        SWTSkinObject[] soChildren = new SWTSkinObject[sItems.length];
        for (int i = 0; i < sItems.length; ++i) {
            String sItemID = sItems[i];
            soChildren[i] = this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true, null);
        }
        if (this.bLayoutComplete) {
            for (SWTSkinObject so : soChildren) {
                if (so == null) continue;
                this.attachControl(so);
            }
        }
    }

    private SWTSkinObject createSash(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectBasic skinObject;
        int style = bVertical ? 512 : 256;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        Composite createOn = parentSkinObject == null ? this.skinComposite : (Composite)parentSkinObject.getControl();
        if (sItems == null) {
            Sash sash = new Sash(createOn, style);
            skinObject = new SWTSkinObjectBasic(this, properties, (Control)sash, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            sash.setBackground(sash.getDisplay().getSystemColor(3));
            sash.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Sash sash = (Sash)e.widget;
                    boolean FASTDRAG = true;
                    if (e.detail == 1) {
                        return;
                    }
                    Rectangle parentArea = sash.getParent().getClientArea();
                    FormData formData = (FormData)sash.getLayoutData();
                    formData.left = new FormAttachment(e.x * 100 / parentArea.width);
                    sash.getParent().layout();
                }
            });
        } else {
            SashForm sashForm = new SashForm(createOn, style);
            skinObject = new SWTSkinObjectContainer(this, properties, (Control)sashForm, sID, sConfigID, "sash", parentSkinObject);
            this.addToControlMap(skinObject);
            int iSashWidth = properties.getIntValue(sConfigID + ".sash.width", -1);
            if (iSashWidth > 0) {
                sashForm.SASH_WIDTH = iSashWidth;
            }
            for (int i = 0; i < sItems.length; ++i) {
                String sChildID = sItems[i];
                this.linkIDtoParent(properties, sChildID, sChildID, skinObject, false, true, null);
            }
        }
        return skinObject;
    }

    private SWTSkinObject createMySash(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject, boolean bVertical) {
        SWTSkinObjectSash skinObject = new SWTSkinObjectSash(this, properties, sID, sConfigID, typeParams, parentSkinObject, bVertical);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public SWTSkinObjectTab createTab(String sID, String sTemplateKey, SWTSkinObject tabHolder) {
        String sTemplateID = SWTSkinTabSet.getTemplateID(this, tabHolder, sTemplateKey);
        if (sTemplateID == null) {
            return null;
        }
        SWTSkinObject skinObject = this.linkIDtoParent(this.skinProperties, sID, sTemplateID, tabHolder, true, true, null);
        if (this.bLayoutComplete && skinObject != null) {
            ((Composite)skinObject.getControl()).getParent().layout(true);
        }
        if (skinObject instanceof SWTSkinObjectTab) {
            return (SWTSkinObjectTab)skinObject;
        }
        System.err.println(skinObject + " not a SWTSkinObjectTab! Template: " + sTemplateID);
        return null;
    }

    private SWTSkinObjectTab _createTab(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectTab skinObjectTab = new SWTSkinObjectTab(this, properties, sID, sConfigID, parentSkinObject);
        this.createContainer(properties, sID, sConfigID, null, parentSkinObject, true, true, skinObjectTab);
        this.addToControlMap(skinObjectTab);
        String sTabSet = properties.getStringValue(sConfigID + ".tabset", "default");
        SWTSkinTabSet tabset = this.mapTabSetToControls.get(sTabSet);
        if (tabset == null) {
            tabset = new SWTSkinTabSet(this, sTabSet);
            this.mapTabSetToControls.put(sTabSet, tabset);
            if (this.DEBUGLAYOUT) {
                System.out.println("New TabSet: " + sTabSet);
            }
        }
        tabset.addTab(skinObjectTab);
        if (this.DEBUGLAYOUT) {
            System.out.println("Tab " + sID + " added");
        }
        return skinObjectTab;
    }

    private SWTSkinObject createTextLabel(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        if (this.DEBUGLAYOUT) {
            System.out.println("createTextLabel: " + sID + " on " + parentSkinObject);
        }
        SWTSkinObjectText2 skinObject = new SWTSkinObjectText2(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createSlider(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSlider skinObject = new SWTSkinObjectSlider(this, properties, sID, sConfigID, typeParams, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public Composite getShell() {
        return this.skinComposite;
    }

    protected Listener getHandCursorListener(Display display) {
        if (this.handCursorListener == null) {
            final Cursor handCursor = new Cursor((Device)display, 21);
            this.handCursorListener = new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.type == 6) {
                        ((Control)event2.widget).setCursor(handCursor);
                    }
                    if (event2.type == 7) {
                        ((Control)event2.widget).setCursor(null);
                    }
                }
            };
        }
        return this.handCursorListener;
    }

    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        return this.createSkinObject(sID, sConfigID, parentSkinObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SWTSkinObject createSkinObject(String sID, String sConfigID, SWTSkinObject parentSkinObject, Object datasource) {
        SWTSkinObject skinObject = null;
        Cursor cursor = this.skinComposite.getCursor();
        try {
            block4: {
                try {
                    this.skinComposite.setCursor(this.skinComposite.getDisplay().getSystemCursor(1));
                    skinObject = this.linkIDtoParent(this.skinProperties, sID, sConfigID, parentSkinObject, true, true, datasource);
                    if (!this.bLayoutComplete) break block4;
                    this.layout(skinObject);
                }
                catch (Exception e) {
                    Debug.out("Trying to create " + sID + "." + sConfigID + " on " + parentSkinObject, e);
                    Object var9_8 = null;
                    this.skinComposite.setCursor(cursor);
                    return skinObject;
                }
            }
            Object var9_7 = null;
            this.skinComposite.setCursor(cursor);
            return skinObject;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.skinComposite.setCursor(cursor);
            throw throwable;
        }
    }

    public void addSkinObject(SWTSkinObject skinObject) {
        String sViewID = skinObject.getViewID();
        if (sViewID != null) {
            this.setSkinObjectViewID(skinObject, sViewID);
        }
        this.attachControl(skinObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSkinObject(SWTSkinObject skinObject) {
        int x;
        SWTSkinObject[] objects;
        skinObject.triggerListeners(3);
        String id = skinObject.getSkinObjectID();
        this.mon_MapIDsToSOs.enter();
        try {
            objects = this.mapIDsToSOs.get(id);
            if (objects != null) {
                x = 0;
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] == skinObject) continue;
                    objects[x++] = objects[i];
                }
                SWTSkinObject[] newObjects = new SWTSkinObject[x];
                System.arraycopy(objects, 0, newObjects, 0, x);
                this.mapIDsToSOs.put(id, newObjects);
            }
            Object var7_9 = null;
            this.mon_MapIDsToSOs.exit();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.mon_MapIDsToSOs.exit();
            throw throwable;
        }
        this.mon_mapPublicViewIDsToSOs.enter();
        try {
            id = skinObject.getViewID();
            objects = this.mapPublicViewIDsToSOs.get(id);
            if (objects != null) {
                x = 0;
                for (int i = 0; i < objects.length; ++i) {
                    if (objects[i] == skinObject) continue;
                    objects[x++] = objects[i];
                }
                SWTSkinObject[] newObjects = new SWTSkinObject[x];
                System.arraycopy(objects, 0, newObjects, 0, x);
                this.mapPublicViewIDsToSOs.put(id, newObjects);
            }
            Object var9_12 = null;
            this.mon_mapPublicViewIDsToSOs.exit();
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.mon_mapPublicViewIDsToSOs.exit();
            throw throwable;
        }
        skinObject.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SWTSkinObject linkIDtoParent(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bAddView, Object datasource) {
        SWTSkinObject skinObject;
        block67: {
            block66: {
                SWTSkinObject userMode2;
                block65: {
                    block64: {
                        SWTSkinObject sWTSkinObject;
                        block63: {
                            String sText;
                            block62: {
                                ++this.currentSkinObjectcreationCount;
                                skinObject = null;
                                try {
                                    try {
                                        String sViewID;
                                        int userMode2;
                                        String sType;
                                        if (sConfigID == null) {
                                            SWTSkinObject sWTSkinObject2 = null;
                                            Object var15_12 = null;
                                            --this.currentSkinObjectcreationCount;
                                            return sWTSkinObject2;
                                        }
                                        String[] sTypeParams = properties.getStringArray(sConfigID + ".type");
                                        if (sTypeParams != null && sTypeParams.length > 0) {
                                            sType = sTypeParams[0];
                                            bForceCreate = true;
                                        } else {
                                            sType = null;
                                            String sImageLoc = properties.getStringValue(sConfigID);
                                            if (sImageLoc != null) {
                                                sType = "image";
                                            } else {
                                                sText = properties.getStringValue(sConfigID + ".text");
                                                if (sText != null) {
                                                    sType = "text";
                                                } else {
                                                    String sWidgets = properties.getStringValue(sConfigID + ".widgets");
                                                    if (sWidgets != null || bForceCreate) {
                                                        sType = "container";
                                                    }
                                                }
                                            }
                                            if (sType == null) {
                                                if (this.DEBUGLAYOUT) {
                                                    System.err.println("no type defined for " + sConfigID);
                                                }
                                                sText = null;
                                                break block62;
                                            }
                                            sTypeParams = new String[]{sType};
                                        }
                                        int iMinUserMode = properties.getIntValue(sConfigID + ".minUserMode", -1);
                                        if (iMinUserMode > 0 && (userMode2 = COConfigurationManager.getIntParameter("User Mode")) <= iMinUserMode) {
                                            sWTSkinObject = null;
                                            break block63;
                                        }
                                        if (sType.equals("image")) {
                                            skinObject = this.createImageLabel(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                        } else if (sType.equals("image2")) {
                                            skinObject = this.createImageLabel2(properties, sID, parentSkinObject);
                                        } else if (sType.equals("container2")) {
                                            skinObject = this.createContainer2(properties, sID, sConfigID, parentSkinObject, bForceCreate, false, null);
                                        } else if (sType.equals("container")) {
                                            skinObject = this.createContainer(properties, sID, sConfigID, sTypeParams, parentSkinObject, bForceCreate, false, null);
                                        } else if (sType.equals("text")) {
                                            skinObject = this.createTextLabel(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                        } else if (sType.equals("tab")) {
                                            skinObject = this._createTab(properties, sID, sConfigID, parentSkinObject);
                                        } else if (sType.equals("v-sash")) {
                                            skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, true);
                                        } else if (sType.equals("h-sash")) {
                                            skinObject = this.createSash(properties, sID, sConfigID, parentSkinObject, false);
                                        } else if (sType.equals("v-mysash")) {
                                            skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, true);
                                        } else if (sType.equals("h-mysash")) {
                                            skinObject = this.createMySash(properties, sID, sConfigID, sTypeParams, parentSkinObject, false);
                                        } else if (sType.equals("clone")) {
                                            skinObject = this.createClone(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                        } else if (sType.equals("slider")) {
                                            skinObject = this.createSlider(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                        } else {
                                            if (sType.equals("hidden")) {
                                                userMode2 = null;
                                                break block64;
                                            }
                                            if (sType.equals("browser")) {
                                                skinObject = this.createBrowser(properties, sID, sConfigID, parentSkinObject);
                                            } else if (sType.equals("separator")) {
                                                skinObject = this.createSeparator(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("button")) {
                                                skinObject = this.createButton(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("checkbox")) {
                                                skinObject = this.createCheckbox(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("toggle")) {
                                                skinObject = this.createToggle(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("textbox")) {
                                                skinObject = this.createTextbox(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("combo")) {
                                                skinObject = this.createCombo(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("tabfolder")) {
                                                skinObject = this.createTabFolder(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else if (sType.equals("expandbar")) {
                                                skinObject = this.createExpandBar(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            } else {
                                                if (!sType.equals("expanditem")) {
                                                    System.err.println(sConfigID + ": Invalid type of " + sType);
                                                    userMode2 = null;
                                                    break block65;
                                                }
                                                skinObject = this.createExpandItem(properties, sID, sConfigID, sTypeParams, parentSkinObject);
                                            }
                                        }
                                        if (skinObject == null) break block66;
                                        skinObject.setData("CreationParams", datasource);
                                        if (datasource != null) {
                                            skinObject.triggerListeners(7, datasource);
                                        }
                                        if (bAddView && (sViewID = skinObject.getViewID()) != null) {
                                            this.setSkinObjectViewID(skinObject, sViewID);
                                        }
                                        break block66;
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        Object var15_18 = null;
                                        --this.currentSkinObjectcreationCount;
                                        break block67;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var15_19 = null;
                                    --this.currentSkinObjectcreationCount;
                                    throw throwable;
                                }
                            }
                            Object var15_13 = null;
                            --this.currentSkinObjectcreationCount;
                            return sText;
                        }
                        Object var15_14 = null;
                        --this.currentSkinObjectcreationCount;
                        return sWTSkinObject;
                    }
                    Object var15_15 = null;
                    --this.currentSkinObjectcreationCount;
                    return userMode2;
                }
                Object var15_16 = null;
                --this.currentSkinObjectcreationCount;
                return userMode2;
            }
            Object var15_17 = null;
            --this.currentSkinObjectcreationCount;
        }
        if (skinObject != null) {
            skinObject.triggerListeners(4);
        }
        return skinObject;
    }

    private SWTSkinObject createButton(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectButton skinObject = new SWTSkinObjectButton(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createCheckbox(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectCheckbox skinObject = new SWTSkinObjectCheckbox(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createToggle(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectToggle skinObject = new SWTSkinObjectToggle(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createExpandBar(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(configID + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandBar: " + id + ";" + properties.getStringValue(configID + ".widgets"));
        }
        SWTSkinObjectExpandBar skinObject = new SWTSkinObjectExpandBar(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createExpandItem(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sItems = properties.getStringArray(configID + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createExpandItem: " + id + ";" + properties.getStringValue(configID + ".widgets"));
        }
        SWTSkinObjectExpandItem skinObject = new SWTSkinObjectExpandItem(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createTextbox(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectTextbox skinObject = new SWTSkinObjectTextbox(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createCombo(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectCombo skinObject = new SWTSkinObjectCombo(this, properties, id, configID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createTabFolder(SWTSkinProperties properties, String id, String configID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(configID + ".widgets");
        if (this.DEBUGLAYOUT) {
            System.out.println("createTabFolder: " + id + ";" + properties.getStringValue(configID + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(id, parentSkinObject)) == null) {
            skinObject = new SWTSkinObjectTabFolder(this, properties, id, configID, parentSkinObject);
            this.addToControlMap(skinObject);
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (sItems != null) {
            this.addContainerChildren(skinObject, sItems, properties);
        }
        return skinObject;
    }

    private SWTSkinObject createBrowser(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject) {
        SWTSkinObjectBrowser skinObject = new SWTSkinObjectBrowser(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createClone(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        String[] sCloneParams;
        if (sConfigID.length() == 0) {
            System.err.println("XXXXXXXX " + sID + " has no config ID.." + Debug.getStackTrace(false, false));
        }
        if (typeParams.length > 1) {
            int size = typeParams.length - 1;
            sCloneParams = new String[size];
            System.arraycopy(typeParams, 1, sCloneParams, 0, size);
        } else {
            sCloneParams = properties.getStringArray(sConfigID + ".clone");
            if (sCloneParams == null || sCloneParams.length < 1) {
                return null;
            }
        }
        if (properties instanceof SWTSkinPropertiesClone) {
            properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
        }
        SWTSkinPropertiesClone cloneProperties = new SWTSkinPropertiesClone(properties, sConfigID, sCloneParams);
        return this.linkIDtoParent(cloneProperties, sID, "", parentSkinObject, false, false, null);
    }

    private SWTSkinObject createImageLabel(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        if (typeParams.length > 1) {
            properties.addProperty(sConfigID + ".image", typeParams[1]);
        }
        SWTSkinObjectImage skinObject = new SWTSkinObjectImage(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    private SWTSkinObject createContainer2(SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parentSkinObject, boolean bForceCreate, boolean bPropogate, SWTSkinObject intoSkinObject) {
        SWTSkinObject skinObject;
        String[] sItems = properties.getStringArray(sConfigID + ".widgets");
        if (sItems == null && !bForceCreate) {
            return null;
        }
        if (this.DEBUGLAYOUT) {
            System.out.println("createContainer: " + sID + ";" + properties.getStringValue(sConfigID + ".widgets"));
        }
        if ((skinObject = this.getSkinObjectByID(sID, parentSkinObject)) == null) {
            if (intoSkinObject != null) {
                skinObject = intoSkinObject;
            }
        } else if (!(skinObject instanceof SWTSkinObjectContainer)) {
            return skinObject;
        }
        if (!bPropogate) {
            boolean bl = bPropogate = properties.getIntValue(sConfigID + ".propogate", 0) == 1;
        }
        if (!bPropogate && parentSkinObject instanceof SWTSkinObjectContainer) {
            bPropogate = ((SWTSkinObjectContainer)parentSkinObject).getPropogation();
        }
        if (bPropogate && skinObject != null) {
            ((SWTSkinObjectContainer)skinObject).setPropogation(true);
        }
        if (sItems != null) {
            String[] paramValues = null;
            if (properties instanceof SWTSkinPropertiesParam) {
                paramValues = ((SWTSkinPropertiesParam)properties).getParamValues();
            }
            if (properties instanceof SWTSkinPropertiesClone) {
                properties = ((SWTSkinPropertiesClone)properties).getOriginalProperties();
            }
            if (paramValues != null) {
                properties = new SWTSkinPropertiesParamImpl(properties, paramValues);
            }
            for (int i = 0; i < sItems.length; ++i) {
                String sItemID = sItems[i];
                this.linkIDtoParent(properties, sItemID, sItemID, skinObject, false, true, null);
            }
        }
        return skinObject;
    }

    private SWTSkinObject createImageLabel2(SWTSkinProperties properties, final String sConfigID, SWTSkinObject parentSkinObject) {
        Composite createOn = parentSkinObject == null ? this.skinComposite : (Composite)parentSkinObject.getControl();
        Canvas drawable = new Canvas(createOn, 262144);
        drawable.setVisible(false);
        final ImageLoader imageLoader = this.getImageLoader(properties);
        Image image = imageLoader.getImage(sConfigID);
        if (ImageLoader.isRealImage(image)) {
            imageLoader.releaseImage(sConfigID);
            image = imageLoader.getImage(sConfigID + ".image");
            drawable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imageLoader.releaseImage(sConfigID + ".image");
                }
            });
        } else {
            drawable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imageLoader.releaseImage(sConfigID);
                }
            });
        }
        drawable.setData("image", (Object)image);
        SWTSkinObjectBasic skinObject = new SWTSkinObjectBasic(this, properties, (Control)drawable, sConfigID, sConfigID, "image", parentSkinObject);
        this.addToControlMap(skinObject);
        this.ontopImages.add(skinObject);
        return skinObject;
    }

    private SWTSkinObject createSeparator(SWTSkinProperties properties, String sID, String sConfigID, String[] typeParams, SWTSkinObject parentSkinObject) {
        SWTSkinObjectSeparator skinObject = new SWTSkinObjectSeparator(this, properties, sID, sConfigID, parentSkinObject);
        this.addToControlMap(skinObject);
        return skinObject;
    }

    public SWTSkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String viewID, SWTSkinObjectListener listener) {
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            ArrayList<SWTSkinObjectListener> list = this.mapPublicViewIDsToListeners.get(viewID);
            if (list != null) {
                list.add(listener);
            } else {
                list = new ArrayList();
                list.add(listener);
                this.mapPublicViewIDsToListeners.put(viewID, list);
            }
            Object var5_4 = null;
            this.mapPublicViewIDsToListeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mapPublicViewIDsToListeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String viewID, SWTSkinObjectListener listener) {
        this.mapPublicViewIDsToListeners_mon.enter();
        try {
            List list = this.mapPublicViewIDsToListeners.get(viewID);
            if (list != null) {
                list.remove(listener);
            }
            Object var5_4 = null;
            this.mapPublicViewIDsToListeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.mapPublicViewIDsToListeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWTSkinObjectListener[] getSkinObjectListeners(String viewID) {
        block4: {
            if (viewID == null) {
                return NOLISTENERS;
            }
            this.mapPublicViewIDsToListeners_mon.enter();
            try {
                ArrayList<SWTSkinObjectListener> existing = this.mapPublicViewIDsToListeners.get(viewID);
                if (existing == null) break block4;
                SWTSkinObjectListener[] sWTSkinObjectListenerArray = existing.toArray(NOLISTENERS);
                Object var5_5 = null;
                this.mapPublicViewIDsToListeners_mon.exit();
                return sWTSkinObjectListenerArray;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.mapPublicViewIDsToListeners_mon.exit();
                throw throwable;
            }
        }
        SWTSkinObjectListener[] sWTSkinObjectListenerArray = NOLISTENERS;
        Object var5_6 = null;
        this.mapPublicViewIDsToListeners_mon.exit();
        return sWTSkinObjectListenerArray;
    }

    public boolean isLayoutComplete() {
        return this.bLayoutComplete;
    }

    public void addListener(SWTSkinLayoutCompleteListener l) {
        if (!this.listenersLayoutComplete.contains(l)) {
            this.listenersLayoutComplete.add(l);
        }
    }

    public static void main(String[] args) {
        Date d = new Date();
        long t = d.getTime();
        t -= 99878400000L;
        t -= 21600000L;
        Date then = new Date(t -= 1020000L);
        System.out.println(d + ";" + then);
    }

    public boolean isCreatingSO() {
        return this.currentSkinObjectcreationCount > 0;
    }

    public void triggerLanguageChange() {
        Object[] values = this.mapIDsToSOs.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            SWTSkinObject[] skinObjects = (SWTSkinObject[])values[i];
            if (skinObjects == null) continue;
            for (int j = 0; j < skinObjects.length; ++j) {
                SWTSkinObject so = skinObjects[j];
                so.triggerListeners(6);
            }
        }
    }

    public void setAutoSizeOnLayout(boolean autoSizeOnLayout) {
        this.autoSizeOnLayout = autoSizeOnLayout;
    }

    public boolean isAutoSizeOnLayout() {
        return this.autoSizeOnLayout;
    }
}

