/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinToggleListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectToggle
extends SWTSkinObjectBasic {
    private Button button;
    private boolean isToggled;
    private List<SWTSkinToggleListener> buttonListeners = new CopyOnWriteArrayList<SWTSkinToggleListener>();

    public SWTSkinObjectToggle(SWTSkin skin, SWTSkinProperties properties, String id, String configID, SWTSkinObject parentSkinObject) {
        super(skin, properties, id, configID, "toggle", parentSkinObject);
        Composite createOn = this.parent == null ? skin.getShell() : (Composite)this.parent.getControl();
        createOn.setBackgroundMode(2);
        this.button = new Button(createOn, 2);
        this.isToggled = false;
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SWTSkinObjectToggle.this.isToggled = SWTSkinObjectToggle.this.button.getSelection();
                for (SWTSkinToggleListener l : SWTSkinObjectToggle.this.buttonListeners) {
                    try {
                        l.toggleChanged(SWTSkinObjectToggle.this, SWTSkinObjectToggle.this.isToggled);
                    }
                    catch (Exception ex) {
                        Debug.out(ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.button);
    }

    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        if ((suffix = super.switchSuffix(suffix, level, walkUp, walkDown)) == null) {
            return null;
        }
        String sPrefix = this.sConfigID + ".text";
        String text = this.properties.getStringValue(sPrefix + suffix);
        if (text != null) {
            this.setText(text);
        }
        return suffix;
    }

    public void addSelectionListener(SWTSkinToggleListener listener) {
        if (this.buttonListeners.contains(listener)) {
            return;
        }
        this.buttonListeners.add(listener);
    }

    public void setText(final String text) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectToggle.this.button != null && !SWTSkinObjectToggle.this.button.isDisposed()) {
                    SWTSkinObjectToggle.this.button.setText(text);
                }
            }
        });
    }

    public boolean isToggled() {
        return this.isToggled;
    }

    public void setToggled(boolean b) {
        this.isToggled = b;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectToggle.this.button != null && !SWTSkinObjectToggle.this.button.isDisposed()) {
                    SWTSkinObjectToggle.this.button.setSelection(SWTSkinObjectToggle.this.isToggled);
                }
            }
        });
    }
}

