/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.skin.SkinPropertiesImpl;
import com.aelitis.azureus.ui.swt.skin.SWTColorWithAlpha;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinPropertiesImpl
extends SkinPropertiesImpl
implements SWTSkinProperties {
    private static Map<String, SWTColorWithAlpha> colorMap = new LightHashMap<String, SWTColorWithAlpha>();

    public SWTSkinPropertiesImpl(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        super(classLoader, skinPath, mainSkinFile);
        this.setEmHeight();
    }

    private void setEmHeight() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinPropertiesImpl.this.setEmHeightPX(FontUtils.getFontHeightInPX(Display.getDefault().getSystemFont()));
            }
        });
    }

    public SWTSkinPropertiesImpl() {
        this.setEmHeight();
    }

    public Color getColor(String sID) {
        return this.getColorWithAlpha((String)sID).color;
    }

    public SWTColorWithAlpha getColorWithAlpha(String sID) {
        Color color;
        if (colorMap.containsKey(sID)) {
            return colorMap.get(sID);
        }
        int alpha = 255;
        try {
            int[] rgb = this.getColorValue(sID);
            if (rgb[0] > -1) {
                color = ColorCache.getSchemedColor((Device)Utils.getDisplay(), rgb[0], rgb[1], rgb[2]);
                if (rgb.length > 3) {
                    alpha = rgb[3];
                }
            } else {
                color = ColorCache.getColor((Device)Utils.getDisplay(), this.getStringValue(sID));
            }
        }
        catch (Exception e) {
            color = null;
        }
        SWTColorWithAlpha colorInfo = new SWTColorWithAlpha(color, alpha);
        colorMap.put(sID, colorInfo);
        return colorInfo;
    }

    public void clearCache() {
        super.clearCache();
        colorMap.clear();
    }

    public Color getColor(String name, Color def) {
        Color color = this.getColor(name);
        if (color == null) {
            return def;
        }
        return color;
    }

    public int getPxValue(String name, int def) {
        String value = this.getValue(name, null);
        if (value == null) {
            return def;
        }
        int result = def;
        try {
            if (value.endsWith("rem")) {
                float em = Float.parseFloat(value.substring(0, value.length() - 3));
                result = (int)((float)this.getEmHeightPX() * em);
            } else {
                result = Integer.parseInt(value);
                result = Utils.adjustPXForDPI(result);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }
}

