/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.core.subs.SubscriptionUtils;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImageListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionListWindow;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionMDIEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionWizard;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionsView;
import com.aelitis.azureus.ui.swt.utils.TagUIUtilsV3;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class SubscriptionManagerUI {
    private static final String CONFIG_SECTION_ID = "Subscriptions";
    public static final Object SUB_ENTRYINFO_KEY = new Object();
    public static final Object SUB_EDIT_MODE_KEY = new Object();
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    static final String EDIT_MODE_MARKER = "&editMode=1";
    private Graphic icon_rss_big;
    private Graphic icon_rss_small;
    private Graphic icon_rss_all_add_small;
    private Graphic icon_rss_all_add_big;
    private Graphic icon_rss_some_add_small;
    private Graphic icon_rss_some_add_big;
    private List<Graphic> icon_list = new ArrayList<Graphic>();
    private List<TableColumn> columns = new ArrayList<TableColumn>();
    protected UISWTInstance swt;
    private UIManager ui_manager;
    private PluginInterface default_pi = PluginInitializer.getDefaultInterface();
    private MdiEntry mdiEntryOverview;
    private boolean sidebar_setup_done;

    public SubscriptionManagerUI() {
        TableManager table_manager = this.default_pi.getUIManager().getTableManager();
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                SubscriptionManagerFactory.getSingleton();
            }
        });
        if (Constants.isCVSVersion()) {
            TableContextMenuItem menu_item_itorrents = table_manager.addContextMenuItem("MyTorrents", "azsubs.contextmenu.lookupassoc");
            TableContextMenuItem menu_item_ctorrents = table_manager.addContextMenuItem("MySeeders", "azsubs.contextmenu.lookupassoc");
            menu_item_itorrents.setStyle(1);
            menu_item_ctorrents.setStyle(1);
            MenuItemListener listener = new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    TableRow[] rows = (TableRow[])target;
                    if (rows.length > 0) {
                        Download download = (Download)rows[0].getDataSource();
                        new SubscriptionListWindow(PluginCoreUtils.unwrap(download), false);
                    }
                }
            };
            menu_item_itorrents.addMultiListener(listener);
            menu_item_ctorrents.addMultiListener(listener);
        }
        this.createSubsColumns(table_manager);
        this.ui_manager = this.default_pi.getUIManager();
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (!(instance instanceof UISWTInstance)) {
                    return;
                }
                SubscriptionManagerUI.this.swt = (UISWTInstance)instance;
                SubscriptionManagerUI.this.uiQuickInit();
                Utilities utilities = SubscriptionManagerUI.this.default_pi.getUtilities();
                DelayedTask dt = utilities.createDelayedTask(new Runnable(){

                    public void run() {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                SubscriptionManagerUI.this.delayedInit();
                            }
                        });
                    }
                });
                dt.queue();
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    void uiQuickInit() {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        this.icon_rss_big = this.icon_rss_small = this.loadGraphic(this.swt, "subscription_icon.png");
        this.icon_rss_all_add_big = this.icon_rss_all_add_small = this.loadGraphic(this.swt, "subscription_icon_inactive.png");
        this.icon_rss_some_add_big = this.icon_rss_some_add_small = this.icon_rss_all_add_small;
        mdi.registerEntry(CONFIG_SECTION_ID, new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                SubscriptionManagerUI.this.setupSideBar(SubscriptionManagerUI.this.swt);
                return SubscriptionManagerUI.this.mdiEntryOverview;
            }
        });
        mdi.registerEntry("Subscription_.*", new MdiEntryCreationListener2(){

            @Override
            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                Subscription sub = null;
                if (datasource instanceof Subscription) {
                    sub = (Subscription)datasource;
                } else if (id.length() > 13) {
                    Subscription[] subscriptions;
                    String publicKey = id.substring(13);
                    byte[] decodedPublicKey = ByteFormatter.decodeString(publicKey);
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    for (Subscription subscription : subscriptions = subs_man.getSubscriptions()) {
                        if (!Arrays.equals(subscription.getPublicKey(), decodedPublicKey)) continue;
                        sub = subscription;
                        break;
                    }
                }
                if (sub != null && sub.isSearchTemplate()) {
                    return null;
                }
                return sub == null ? null : SubscriptionManagerUI.this.createSubscriptionMdiEntry(sub);
            }
        });
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        subs_man.addListener(new SubscriptionManagerListener(){

            @Override
            public void subscriptionAdded(Subscription subscription) {
            }

            @Override
            public void subscriptionChanged(Subscription sub) {
                SubscriptionManagerUI.this.changeSubscription(sub);
            }

            @Override
            public void subscriptionSelected(Subscription sub) {
                String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    mdi.showEntryByID(key, sub);
                }
            }

            @Override
            public void subscriptionRemoved(Subscription subscription) {
                SubscriptionManagerUI.this.removeSubscription(subscription);
            }

            @Override
            public void associationsChanged(byte[] association_hash) {
            }

            @Override
            public void subscriptionRequested(URL url, Map<String, Object> options) {
            }
        });
    }

    void delayedInit() {
        if (this.swt == null) {
            return;
        }
        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        subs_man.addListener(new SubscriptionManagerListener(){

            @Override
            public void subscriptionAdded(Subscription subscription) {
            }

            @Override
            public void subscriptionChanged(Subscription subscription) {
            }

            @Override
            public void subscriptionSelected(Subscription subscription) {
            }

            @Override
            public void subscriptionRemoved(Subscription subscription) {
            }

            @Override
            public void associationsChanged(byte[] hash) {
                SubscriptionManagerUI.this.refreshColumns();
            }

            @Override
            public void subscriptionRequested(final URL url, final Map<String, Object> options) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        new SubscriptionWizard(url, options);
                    }
                });
            }
        });
        this.createConfigModel();
    }

    private void createConfigModel() {
        final SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", CONFIG_SECTION_ID);
        final IntParameter max_results = configModel.addIntParameter2("subscriptions.config.maxresults", "subscriptions.config.maxresults", subs_man.getMaxNonDeletedResults());
        final BooleanParameter search_enable = configModel.addBooleanParameter2("subscriptions.search.enable", "subscriptions.search.enable", subs_man.isSearchEnabled());
        search_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setSearchEnabled(search_enable.getValue());
            }
        });
        final BooleanParameter download_subs_enable = configModel.addBooleanParameter2("subscriptions.dl_subs.enable", "subscriptions.dl_subs.enable", subs_man.isSubsDownloadEnabled());
        download_subs_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setSubsDownloadEnabled(download_subs_enable.getValue());
            }
        });
        final BooleanParameter activate_subs_enable = configModel.addBooleanParameter2("subscriptions.activate.on.change.enable", "subscriptions.activate.on.change.enable", subs_man.getActivateSubscriptionOnChange());
        activate_subs_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setActivateSubscriptionOnChange(activate_subs_enable.getValue());
            }
        });
        final StringParameter rate_limits = configModel.addStringParameter2("subscriptions.config.ratelimits", "subscriptions.config.ratelimits", subs_man.getRateLimits());
        rate_limits.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setRateLimits(rate_limits.getValue());
            }
        });
        final BooleanParameter auto_start = configModel.addBooleanParameter2("subscriptions.config.autostartdls", "subscriptions.config.autostartdls", subs_man.getAutoStartDownloads());
        auto_start.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setAutoStartDownloads(auto_start.getValue());
            }
        });
        final IntParameter min_auto_start_size = configModel.addIntParameter2("subscriptions.config.autostart.min", "subscriptions.config.autostart.min", subs_man.getAutoStartMinMB());
        final IntParameter max_auto_start_size = configModel.addIntParameter2("subscriptions.config.autostart.max", "subscriptions.config.autostart.max", subs_man.getAutoStartMaxMB());
        auto_start.addEnabledOnSelection(min_auto_start_size);
        auto_start.addEnabledOnSelection(max_auto_start_size);
        final IntParameter mark_as_read_after = configModel.addIntParameter2("subscriptions.config.mark.read.after", "subscriptions.config.mark.read.after", subs_man.getAutoDownloadMarkReadAfterDays());
        configModel.createGroup("subscriptions.config.auto", new Parameter[]{auto_start, min_auto_start_size, max_auto_start_size, mark_as_read_after});
        this.default_pi.getPluginconfig().addListener(new PluginConfigListener(){

            public void configSaved() {
                subs_man.setMaxNonDeletedResults(max_results.getValue());
                subs_man.setAutoStartMinMB(min_auto_start_size.getValue());
                subs_man.setAutoStartMaxMB(max_auto_start_size.getValue());
                subs_man.setAutoDownloadMarkReadAfterDays(mark_as_read_after.getValue());
            }
        });
        final BooleanParameter rss_enable = configModel.addBooleanParameter2("subscriptions.rss.enable", "subscriptions.rss.enable", subs_man.isRSSPublishEnabled());
        rss_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                subs_man.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        HyperlinkParameter rss_view = configModel.addHyperlinkParameter2("device.rss.view", subs_man.getRSSLink());
        rss_enable.addEnabledOnSelection(rss_view);
        configModel.createGroup("device.rss.group", new Parameter[]{rss_enable, rss_view});
    }

    private void createSubsColumns(TableManager table_manager) {
        final TableCellRefreshListener subs_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    String tooltip;
                    Graphic graphic;
                    Subscription[] subs = subs_man.getKnownSubscriptions(torrent.getHash());
                    int num_subscribed = 0;
                    int num_unsubscribed = 0;
                    for (int i = 0; i < subs.length; ++i) {
                        if (subs[i].isSubscribed()) {
                            ++num_subscribed;
                            continue;
                        }
                        ++num_unsubscribed;
                    }
                    int height = cell.getHeight();
                    int sort_order = 0;
                    if (subs.length == 0) {
                        graphic = null;
                        tooltip = null;
                    } else if (num_subscribed == subs.length) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_all_add_big : SubscriptionManagerUI.this.icon_rss_all_add_small;
                        tooltip = MessageText.getString("subscript.all.subscribed");
                    } else if (num_subscribed > 0) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_some_add_big : SubscriptionManagerUI.this.icon_rss_some_add_small;
                        tooltip = MessageText.getString("subscript.some.subscribed");
                        sort_order = 10000;
                    } else {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_big : SubscriptionManagerUI.this.icon_rss_small;
                        tooltip = MessageText.getString("subscript.none.subscribed");
                        sort_order = 1000000;
                    }
                    cell.setMarginHeight(0);
                    cell.setGraphic(graphic);
                    cell.setToolTip(tooltip);
                    cell.setSortValue(sort_order += 1000 * num_unsubscribed + num_subscribed);
                    cell.setCursorID(graphic == null ? 0 : 21);
                } else {
                    cell.setCursorID(0);
                    cell.setSortValue(0L);
                }
            }
        };
        final TableCellMouseListener subs_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                SubscriptionManager subs_man;
                Subscription[] subs;
                TableCell cell;
                Download dl;
                Torrent torrent;
                if (event2.eventType == 0 && (torrent = (dl = (Download)(cell = event2.cell).getDataSource()).getTorrent()) != null && (subs = (subs_man = SubscriptionManagerFactory.getSingleton()).getKnownSubscriptions(torrent.getHash())).length > 0) {
                    event2.skipCoreFunctionality = true;
                    new SubscriptionWizard(PluginCoreUtils.unwrap(dl));
                    COConfigurationManager.setParameter("subscriptions.wizard.shown", true);
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs", new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(3);
                result.setPosition(-2);
                result.setWidth(32);
                result.setRefreshInterval(-3);
                result.setType(2);
                result.addCellRefreshListener(subs_refresh_listener);
                result.addCellMouseListener(subs_mouse_listener);
                result.setIconReference("image.subscription.column", true);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        });
        final TableCellRefreshListener link_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                String str = "";
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    byte[] hash = torrent.getHash();
                    Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                    for (int i = 0; i < subs.length; ++i) {
                        Subscription sub = subs[i];
                        if (!sub.hasAssociation(hash)) continue;
                        str = str + (str.length() == 0 ? "" : "; ") + sub.getName();
                    }
                }
                cell.setCursorID(str.length() > 0 ? 21 : 0);
                cell.setText(str);
            }
        };
        final TableCellMouseListener link_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                if (event2.eventType == 0) {
                    TableCell cell = event2.cell;
                    Download dl = (Download)cell.getDataSource();
                    Torrent torrent = dl.getTorrent();
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    if (torrent != null) {
                        byte[] hash = torrent.getHash();
                        Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                        for (int i = 0; i < subs.length; ++i) {
                            Subscription sub = subs[i];
                            if (!sub.hasAssociation(hash)) continue;
                            String key = "Subscription_" + ByteFormatter.encodeString(sub.getPublicKey());
                            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                            if (mdi == null) break;
                            mdi.showEntryByID(key, sub);
                            break;
                        }
                    }
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs_link", new TableColumnCreationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(1);
                result.setPosition(-1);
                result.setWidth(85);
                result.setRefreshInterval(-3);
                result.setType(3);
                result.addCellRefreshListener(link_refresh_listener);
                result.addCellMouseListener(link_mouse_listener);
                result.setMinimumRequiredUserMode(1);
                List list = SubscriptionManagerUI.this.columns;
                synchronized (list) {
                    SubscriptionManagerUI.this.columns.add(result);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSideBar(UISWTInstance swt_ui) {
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return;
        }
        this.mdiEntryOverview = mdi.createEntryFromEventListener("header.discovery", new UISWTViewEventListenerHolder(CONFIG_SECTION_ID, SubscriptionsView.class, null, null), CONFIG_SECTION_ID, false, null, null);
        if (this.mdiEntryOverview == null) {
            return;
        }
        this.mdiEntryOverview.setDefaultExpanded(true);
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            if (this.sidebar_setup_done) {
                return;
            }
            this.sidebar_setup_done = true;
        }
        this.mdiEntryOverview.setImageLeftID("image.sidebar.subscriptions");
        this.setupHeader(mdi, this.mdiEntryOverview);
        String parentID = "sidebar.header.discovery";
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        MenuItem mi = menu_manager.addMenuItem(parentID, "MainWindow.menu.view.configuration");
        mi.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", SubscriptionManagerUI.CONFIG_SECTION_ID);
                }
            }
        });
    }

    private void setupHeader(MultipleDocumentInterface mdi, MdiEntry headerEntry) {
        MdiEntryVitalityImage infoSub;
        MdiEntryVitalityImage warnSub;
        MdiEntryVitalityImage addSub = headerEntry.addVitalityImage("image.sidebar.subs.add");
        if (addSub != null) {
            addSub.setToolTip(MessageText.getString("subscriptions.add.tooltip"));
            addSub.addListener(new MdiEntryVitalityImageListener(){

                public void mdiEntryVitalityImage_clicked(int x, int y) {
                    new SubscriptionWizard();
                    COConfigurationManager.setParameter("subscriptions.wizard.shown", true);
                    SubscriptionManagerUI.this.refreshTitles(SubscriptionManagerUI.this.mdiEntryOverview);
                }
            });
        }
        if ((warnSub = headerEntry.addVitalityImage(ALERT_IMAGE_ID)) != null) {
            warnSub.setVisible(false);
        }
        if ((infoSub = headerEntry.addVitalityImage(INFO_IMAGE_ID)) != null) {
            infoSub.setVisible(false);
        }
        headerEntry.setViewTitleInfo(new ViewTitleInfo(){
            private long last_avail_calc = -1L;
            private int last_avail;

            public Object getTitleInfoProperty(int propertyID) {
                String result = null;
                if (propertyID == 0) {
                    boolean expanded = false;
                    SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                    Subscription[] subs = subs_man.getSubscriptions(true);
                    if (expanded) {
                        if (warnSub != null) {
                            warnSub.setVisible(false);
                        }
                    } else {
                        int total = 0;
                        boolean warn = false;
                        String error_str = "";
                        for (Subscription s : subs) {
                            SubscriptionHistory history = s.getHistory();
                            total += history.getNumUnread();
                            String last_error = history.getLastError();
                            if (last_error == null || last_error.length() <= 0) continue;
                            boolean auth_fail = history.isAuthFail();
                            if (history.getConsecFails() < 3 && !auth_fail) continue;
                            warn = true;
                            if (error_str.length() > 128) {
                                if (error_str.endsWith(", ...")) continue;
                                error_str = error_str + ", ...";
                                continue;
                            }
                            error_str = error_str + (error_str.length() == 0 ? "" : ", ") + last_error;
                        }
                        if (warnSub != null) {
                            warnSub.setVisible(warn);
                            warnSub.setToolTip(error_str);
                        }
                        if (total > 0) {
                            result = String.valueOf(total);
                        }
                    }
                    if (infoSub != null) {
                        if (subs.length == 0 && !COConfigurationManager.getBooleanParameter("subscriptions.wizard.shown", false)) {
                            long now = SystemTime.getMonotonousTime();
                            if (this.last_avail_calc == -1L || now - this.last_avail_calc > 60000L) {
                                this.last_avail = subs_man.getKnownSubscriptionCount();
                                this.last_avail_calc = now;
                            }
                            if (this.last_avail > 0) {
                                infoSub.setVisible(true);
                                infoSub.setToolTip(MessageText.getString("subscriptions.info.avail", new String[]{String.valueOf(this.last_avail)}));
                            }
                        } else {
                            infoSub.setVisible(false);
                        }
                    }
                }
                return result;
            }
        });
    }

    protected void changeSubscription(Subscription subs) {
        this.refreshTitles(this.mdiEntryOverview);
        if (subs.isSubscribed()) {
            if (SubscriptionManagerFactory.getSingleton().getActivateSubscriptionOnChange()) {
                String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    mdi.loadEntryByID(key, true, true, subs);
                }
            }
        } else {
            this.removeSubscription(subs);
        }
    }

    private MdiEntry createSubscriptionMdiEntry(Subscription subs) {
        String this_id;
        MdiEntry[] existing;
        if (!subs.isSubscribed()) {
            return null;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi == null) {
            return null;
        }
        String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        String subs_name = subs.getName();
        TreeMap<String, String> name_map = new TreeMap<String, String>(new FormattersImpl().getAlphanumericComparator(true));
        name_map.put(subs_name, key);
        for (MdiEntry e : existing = mdi.getEntries()) {
            String id = e.getId();
            if (!id.startsWith("Subscription_")) continue;
            name_map.put(e.getTitle(), id);
        }
        String prev_id = null;
        Iterator i$ = name_map.values().iterator();
        while (i$.hasNext() && (this_id = (String)i$.next()) != key) {
            prev_id = this_id;
        }
        if (prev_id == null && name_map.size() > 1) {
            Iterator it = name_map.values().iterator();
            it.next();
            prev_id = "~" + (String)it.next();
        }
        MdiEntry entry = mdi.createEntryFromEventListener(CONFIG_SECTION_ID, new UISWTViewEventListenerHolder(key, SubscriptionView.class, subs, null), key, true, (Object)subs, prev_id);
        SubscriptionMDIEntry entryInfo = new SubscriptionMDIEntry(subs, entry);
        subs.setUserData(SUB_ENTRYINFO_KEY, entryInfo);
        return entry;
    }

    protected void refreshTitles(MdiEntry entry) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        while (entry != null) {
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
            String key = entry.getParentID();
            if (key == null) {
                return;
            }
            entry = mdi.getEntry(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(Subscription subs) {
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                mdi.closeEntry(key);
            }
        }
        this.refreshColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshColumns() {
        List<TableColumn> list = this.columns;
        synchronized (list) {
            for (TableColumn column : this.columns) {
                column.invalidateCells();
            }
        }
    }

    protected Graphic loadGraphic(UISWTInstance swt, String name) {
        Image image = swt.loadImage("com/aelitis/azureus/ui/images/" + name);
        UISWTGraphic graphic = swt.createGraphic(image);
        this.icon_list.add(graphic);
        return graphic;
    }

    protected static void createMenus(final MenuManager menu_manager, final MenuCreator menu_creator, final Subscription subs) {
        Engine engine;
        MenuItem menuItem;
        boolean is_search_template = subs.isSearchTemplate();
        if (!is_search_template) {
            menuItem = menu_creator.createMenu("Subscription.menu.forcecheck");
            menuItem.setText(MessageText.getString("Subscription.menu.forcecheck"));
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    try {
                        subs.getManager().getScheduler().downloadAsync(subs, true);
                    }
                    catch (SubscriptionException e) {
                        Debug.out(e);
                    }
                }
            });
            menuItem = menu_creator.createMenu("Subscription.menu.clearall");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    subs.getHistory().markAllResultsRead();
                    menu_creator.refreshView();
                }
            });
            menuItem = menu_creator.createMenu("Subscription.menu.dirtyall");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    subs.getHistory().markAllResultsUnread();
                    menu_creator.refreshView();
                }
            });
            menuItem = menu_creator.createMenu("Subscription.menu.deleteall");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    subs.getHistory().deleteAllResults();
                    menu_creator.refreshView();
                }
            });
            menuItem = menu_creator.createMenu("Subscription.menu.reset");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    subs.getHistory().reset();
                    try {
                        subs.getEngine().reset();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    try {
                        subs.getManager().getScheduler().downloadAsync(subs, true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
            try {
                engine = subs.getEngine();
                if (engine instanceof WebEngine && ((WebEngine)engine).isNeedsAuth()) {
                    menuItem = menu_creator.createMenu("Subscription.menu.resetauth");
                    menuItem.addListener(new SubsMenuItemListener(){

                        public void selected(Subscription subs) {
                            try {
                                Engine engine = subs.getEngine();
                                if (engine instanceof WebEngine) {
                                    ((WebEngine)engine).setCookies(null);
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            try {
                                subs.getManager().getScheduler().downloadAsync(subs, true);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                    menuItem = menu_creator.createMenu("Subscription.menu.setcookies");
                    menuItem.addListener(new SubsMenuItemListener(){

                        public void selected(final Subscription subs) {
                            try {
                                Engine engine = subs.getEngine();
                                if (engine instanceof WebEngine) {
                                    final WebEngine we = (WebEngine)engine;
                                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                                    String[] req = we.getRequiredCookies();
                                    String req_str = "";
                                    for (String r : req) {
                                        req_str = req_str + (req_str.length() == 0 ? "" : ";") + r + "=?";
                                    }
                                    entry.setPreenteredText(req_str, true);
                                    entry.maintainWhitespace(false);
                                    entry.allowEmptyInput(false);
                                    entry.setTitle("general.enter.cookies");
                                    entry.prompt(new UIInputReceiverListener(){

                                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                                            if (!entry.hasSubmittedInput()) {
                                                return;
                                            }
                                            try {
                                                String input = entry.getSubmittedInput().trim();
                                                if (input.length() > 0) {
                                                    we.setCookies(input);
                                                    subs.getManager().getScheduler().downloadAsync(subs, true);
                                                }
                                            }
                                            catch (Throwable e) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                    });
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            menu_creator.createMenu("s1").setStyle(4);
            menuItem = menu_creator.createMenu("MyTorrentsView.menu.setCategory");
            menuItem.setStyle(5);
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    SubscriptionManagerUI.addCategorySubMenu(menu_manager, menu, subs);
                }
            });
            menuItem = menu_creator.createMenu("label.tag");
            menuItem.setStyle(5);
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    SubscriptionManagerUI.addTagSubMenu(menu_manager, menu, subs);
                }
            });
            final String key = SubscriptionUtils.getSubscriptionChatKey(subs);
            if (key != null) {
                menuItem = menu_creator.createMenu("label.chat");
                MenuBuildUtils.addChatMenu(menu_manager, menuItem, new MenuBuildUtils.ChatKeyResolver(){

                    public String getChatKey(Object object) {
                        return key;
                    }
                });
            }
            if (subs.isUpdateable()) {
                menuItem = menu_creator.createMenu("MyTorrentsView.menu.rename");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(final Subscription subs) {
                        SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                        entry.setPreenteredText(subs.getName(), false);
                        entry.maintainWhitespace(false);
                        entry.allowEmptyInput(false);
                        entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{subs.getName()}));
                        entry.prompt(new UIInputReceiverListener(){

                            public void UIInputReceiverClosed(UIInputReceiver entry) {
                                if (!entry.hasSubmittedInput()) {
                                    return;
                                }
                                String input = entry.getSubmittedInput().trim();
                                if (input.length() > 0) {
                                    try {
                                        subs.setName(input);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                            }
                        });
                    }
                });
            }
            menuItem = menu_creator.createMenu("Subscription.menu.upgrade");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    subs.resetHighestVersion();
                }
            });
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    menu.setVisible(subs.getHighestVersion() > subs.getVersion());
                }
            });
        }
        menuItem = menu_creator.createMenu("label.copy.uri.to.clip");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(Subscription subs) {
                ClipboardCopy.copyToClipBoard(subs.getURI());
            }
        });
        menuItem = menu_creator.createMenu("Subscription.menu.export");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(Subscription subs) {
                SubscriptionManagerUI.export(subs);
            }
        });
        menu_creator.createMenu("s2").setStyle(4);
        if (!is_search_template) {
            try {
                engine = subs.getEngine();
                if (engine instanceof WebEngine) {
                    menuItem = menu_creator.createMenu("menu.change.url");
                    menuItem.addListener(new SubsMenuItemListener(){

                        public void selected(final Subscription subs) {
                            SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                            try {
                                WebEngine web_engine = (WebEngine)subs.getEngine();
                                entry.setPreenteredText(web_engine.getSearchUrl(true), false);
                                entry.maintainWhitespace(false);
                                entry.allowEmptyInput(false);
                                entry.setLocalisedTitle(MessageText.getString("change.url.msg.title", new String[]{subs.getName()}));
                                entry.setMessage("change.url.msg.desc");
                                entry.prompt(new UIInputReceiverListener(){

                                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                                        if (!entry.hasSubmittedInput()) {
                                            return;
                                        }
                                        String input = entry.getSubmittedInput().trim();
                                        if (input.length() > 0) {
                                            try {
                                                WebEngine web_engine = (WebEngine)subs.getEngine();
                                                web_engine.setSearchUrl(input);
                                                subs.cloneWithNewEngine(web_engine);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            menuItem = menu_creator.createMenu("subs.prop.is_public");
            menuItem.setStyle(2);
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    menu.setData(subs.isPublic());
                }
            });
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    try {
                        subs.setPublic(!subs.isPublic());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
            if (subs.isAutoDownloadSupported()) {
                menuItem = menu_creator.createMenu("subs.prop.is_auto");
                menuItem.setStyle(2);
                menuItem.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        menu.setData(subs.getHistory().isAutoDownload());
                    }
                });
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(Subscription subs) {
                        try {
                            subs.getHistory().setAutoDownload(!subs.getHistory().isAutoDownload());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
            menuItem = menu_creator.createMenu("subs.prop.update_period");
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    int check_freq = subs.getHistory().getCheckFrequencyMins();
                    String text = MessageText.getString("subs.prop.update_period");
                    if (check_freq != Integer.MAX_VALUE) {
                        text = text + " (" + check_freq + " " + MessageText.getString("ConfigView.text.minutes") + ")";
                    }
                    menu.setText(text + "...");
                }
            });
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(final Subscription subs) {
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    int check_freq = subs.getHistory().getCheckFrequencyMins();
                    entry.setPreenteredText(check_freq == Integer.MAX_VALUE ? "" : String.valueOf(check_freq), false);
                    entry.setLocalisedTitle(MessageText.getString("subscriptions.enter.freq"));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                try {
                                    subs.getHistory().setCheckFrequencyMins(Integer.parseInt(input));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
            });
            menuItem = menu_creator.createMenu("subs.prop.is_dl_anon");
            menuItem.setStyle(2);
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    menu.setData(subs.getHistory().getDownloadNetworks() != null);
                }
            });
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(Subscription subs) {
                    try {
                        boolean is_anon = subs.getHistory().getDownloadNetworks() != null;
                        subs.getHistory().setDownloadNetworks(is_anon ? null : AENetworkClassifier.AT_NON_PUBLIC);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
            menuItem = menu_creator.createMenu("label.set.max.results");
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    int max_results = subs.getHistory().getMaxNonDeletedResults();
                    if (max_results < 0) {
                        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                        max_results = subs_man.getMaxNonDeletedResults();
                    }
                    String max_results_str = max_results == 0 ? MessageText.getString("ConfigView.unlimited") : String.valueOf(max_results);
                    String text = MessageText.getString("label.set.max.results");
                    text = text + " (" + max_results_str + ")";
                    menu.setText(text + "...");
                }
            });
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(final Subscription subs) {
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(true);
                    int max_results = subs.getHistory().getMaxNonDeletedResults();
                    if (max_results < 0) {
                        SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                        max_results = subs_man.getMaxNonDeletedResults();
                    }
                    if (max_results > 0) {
                        entry.setPreenteredText(String.valueOf(max_results), false);
                    }
                    entry.setLocalisedTitle(MessageText.getString("subscriptions.enter.max.results"));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            try {
                                subs.getHistory().setMaxNonDeletedResults(input.length() == 0 ? -1 : Math.abs(Integer.parseInt(input)));
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
            });
            menuItem = menu_creator.createMenu("MyTorrentsView.menu.rename");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(final Subscription subs) {
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setPreenteredText(subs.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{subs.getName()}));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                subs.setLocalName(input);
                            }
                        }
                    });
                }
            });
        }
        menuItem = menu_creator.createMenu("Subscription.menu.remove");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(Subscription subs) {
                SubscriptionManagerUI.removeWithConfirm(subs);
            }
        });
        menu_creator.createMenu("s3").setStyle(4);
        menuItem = menu_creator.createMenu("Subscription.menu.properties");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(Subscription subs) {
                SubscriptionManagerUI.showProperties(subs);
            }
        });
    }

    private static void addCategorySubMenu(MenuManager menu_manager, MenuItem menu, final Subscription subs) {
        MenuItem m;
        menu.removeAllChildItems();
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            String assigned_category = subs.getCategory();
            final Category uncat = CategoryManager.getCategory(2);
            if (uncat != null) {
                m = menu_manager.addMenuItem(menu, uncat.getName());
                m.setStyle(3);
                m.setData(new Boolean(assigned_category == null));
                m.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionManagerUI.assignSelectedToCategory(subs, uncat);
                    }
                });
                m = menu_manager.addMenuItem(menu, "sep1");
                m.setStyle(4);
            }
            for (int i = 0; i < categories.length; ++i) {
                Object cat = categories[i];
                if (cat.getType() != 0) continue;
                m = menu_manager.addMenuItem(menu, "!" + cat.getName() + "!");
                m.setStyle(3);
                m.setData(new Boolean(assigned_category != null && assigned_category.equals(cat.getName())));
                m.addListener(new MenuItemListener((Category)cat){
                    final /* synthetic */ Category val$cat;
                    {
                        this.val$cat = category;
                    }

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionManagerUI.assignSelectedToCategory(subs, this.val$cat);
                    }
                });
            }
            m = menu_manager.addMenuItem(menu, "sep2");
            m.setStyle(4);
        }
        m = menu_manager.addMenuItem(menu, "MyTorrentsView.menu.setCategory.add");
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionManagerUI.addCategory(subs);
            }
        });
    }

    private static void addCategory(Subscription subs) {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            SubscriptionManagerUI.assignSelectedToCategory(subs, newCategory);
        }
    }

    private static void assignSelectedToCategory(Subscription subs, Category category) {
        if (category.getType() == 2) {
            subs.setCategory(null);
        } else {
            subs.setCategory(category.getName());
        }
    }

    private static void addTagSubMenu(MenuManager menu_manager, MenuItem menu, final Subscription subs) {
        menu.removeAllChildItems();
        TagManager tm = TagManagerFactory.getTagManager();
        List<Tag> tags = tm.getTagType(3).getTags();
        tags = TagUIUtils.sortTags(tags);
        long tag_id = subs.getTagID();
        Tag assigned_tag = tm.lookupTagByUID(tag_id);
        MenuItem m = menu_manager.addMenuItem(menu, "label.no.tag");
        m.setStyle(3);
        m.setData(new Boolean(assigned_tag == null));
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                subs.setTagID(-1L);
            }
        });
        m = menu_manager.addMenuItem(menu, "sep1");
        m.setStyle(4);
        ArrayList<String> menu_names = new ArrayList<String>();
        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
        for (Tag t : tags) {
            if (t.isTagAuto()) continue;
            String name = t.getTagName(true);
            menu_names.add(name);
            menu_name_map.put(name, t);
        }
        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
        for (Object obj : menu_structure) {
            MenuItem parent_menu;
            ArrayList<Object> bucket_tags = new ArrayList<Object>();
            if (obj instanceof String) {
                parent_menu = menu;
                bucket_tags.add(menu_name_map.get((String)obj));
            } else {
                Object[] entry = (Object[])obj;
                List list = (List)entry[1];
                boolean has_selected = false;
                for (String name : list) {
                    Tag tag = (Tag)menu_name_map.get(name);
                    bucket_tags.add(tag);
                    if (assigned_tag != tag) continue;
                    has_selected = true;
                }
                parent_menu = menu_manager.addMenuItem(menu, "!" + (String)entry[0] + (has_selected ? " (*)" : "") + "!");
                parent_menu.setStyle(5);
            }
            for (final Tag tag : bucket_tags) {
                m = menu_manager.addMenuItem(parent_menu, tag.getTagName(false));
                m.setStyle(3);
                m.setData(new Boolean(assigned_tag == tag));
                m.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        subs.setTagID(tag.getTagUID());
                    }
                });
            }
        }
        m = menu_manager.addMenuItem(menu, "sep2");
        m.setStyle(4);
        m = menu_manager.addMenuItem(menu, "label.add.tag");
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionManagerUI.addTag(subs);
            }
        });
    }

    private static void addTag(final Subscription subs) {
        TagUIUtilsV3.showCreateTagDialog(new UIFunctions.TagReturner(){

            public void returnedTags(Tag[] tags) {
                if (tags != null) {
                    for (Tag new_tag : tags) {
                        subs.setTagID(new_tag.getTagUID());
                    }
                }
            }
        });
    }

    protected static void export(final Subscription subs) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("subscript.export.select.template.file"));
                dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    String lc = path.toLowerCase();
                    if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                        path = path + ".vuze";
                    }
                    try {
                        VuzeFile vf = subs.getVuzeFile();
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected static void removeWithConfirm(final Subscription subs) {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{subs.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        mb.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 0) {
                    subs.setSubscribed(false);
                }
            }
        });
    }

    protected static void showProperties(Subscription subs) {
        String engine_str;
        SubscriptionHistory history = subs.getHistory();
        SimpleDateFormat df = new SimpleDateFormat();
        String last_error = history.getLastError();
        if (last_error == null) {
            last_error = "";
        }
        String auth_str = String.valueOf(false);
        try {
            WebEngine web_engine;
            Engine engine = subs.getEngine();
            engine_str = engine.getNameEx();
            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                auth_str = String.valueOf(true) + ": cookies=" + SubscriptionManagerUI.toString(web_engine.getRequiredCookies());
            }
            engine_str = engine_str + ", eid=" + engine.getId();
        }
        catch (Throwable e) {
            engine_str = "Unknown";
            auth_str = "";
        }
        String[] keys = new String[]{"subs.prop.enabled", "subs.prop.is_public", "subs.prop.is_auto", "subs.prop.is_auto_ok", "subs.prop.is_dl_anon", "subs.prop.update_period", "subs.prop.last_scan", "subs.prop.last_result", "subs.prop.next_scan", "subs.prop.last_error", "subs.prop.num_read", "subs.prop.num_unread", "label.max.results", "subs.prop.assoc", "subs.prop.version", "subs.prop.high_version", "subscriptions.listwindow.popularity", "subs.prop.template", "subs.prop.auth", "TableColumn.header.category", "TableColumn.header.tag.name"};
        String category = subs.getCategory();
        String category_str = category == null ? MessageText.getString("Categories.uncategorized") : category;
        Tag tag = TagManagerFactory.getTagManager().lookupTagByUID(subs.getTagID());
        String tag_str = tag == null ? "" : tag.getTagName(true);
        int check_freq = history.getCheckFrequencyMins();
        long last_new_result = history.getLastNewResultTime();
        long next_scan = history.getNextScanTime();
        int max_results = history.getMaxNonDeletedResults();
        if (max_results < 0) {
            SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
            max_results = subs_man.getMaxNonDeletedResults();
        }
        String max_results_str = max_results == 0 ? MessageText.getString("ConfigView.unlimited") : String.valueOf(max_results);
        String[] values = new String[]{String.valueOf(history.isEnabled()), String.valueOf(subs.isPublic()) + "/" + !subs.isAnonymous(), String.valueOf(history.isAutoDownload()), String.valueOf(subs.isAutoDownloadSupported()), String.valueOf(history.getDownloadNetworks() != null), check_freq == Integer.MAX_VALUE ? "" : String.valueOf(history.getCheckFrequencyMins() + " " + MessageText.getString("ConfigView.text.minutes")), df.format(new Date(history.getLastScanTime())), last_new_result == 0L ? "" : df.format(new Date(last_new_result)), next_scan == Long.MAX_VALUE ? "" : df.format(new Date(next_scan)), last_error.length() == 0 ? MessageText.getString("PeersView.uniquepiece.none") : last_error, String.valueOf(history.getNumRead()), String.valueOf(history.getNumUnread()), max_results_str, String.valueOf(subs.getAssociationCount()), String.valueOf(subs.getVersion()), subs.getHighestVersion() > subs.getVersion() ? String.valueOf(subs.getHighestVersion()) : null, subs.getCachedPopularity() <= 1L ? "-" : String.valueOf(subs.getCachedPopularity()), engine_str + ", sid=" + subs.getID(), auth_str, category_str, tag_str};
        final PropertiesWindow pw = new PropertiesWindow(subs.getName(), keys, values);
        try {
            subs.getPopularity(new SubscriptionPopularityListener(){

                public void gotPopularity(long popularity) {
                    pw.updateProperty("subscriptions.listwindow.popularity", String.valueOf(popularity));
                }

                public void failed(SubscriptionException error) {
                }
            });
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private static String toString(String[] strs) {
        String res = "";
        for (int i = 0; i < strs.length; ++i) {
            res = res + (i == 0 ? "" : ",") + strs[i];
        }
        return res;
    }

    protected static interface MenuCreator {
        public MenuItem createMenu(String var1);

        public void refreshView();
    }

    private static abstract class SubsMenuItemListener
    implements MenuItemListener {
        private SubsMenuItemListener() {
        }

        public final void selected(MenuItem menu, Object target) {
            Object ds;
            if (target instanceof MdiEntry) {
                MdiEntry info = (MdiEntry)target;
                Subscription subs = (Subscription)info.getDatasource();
                try {
                    this.selected(subs);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            } else if (target instanceof TableRow && (ds = ((TableRow)target).getDataSource()) instanceof Subscription) {
                try {
                    this.selected((Subscription)ds);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }

        public abstract void selected(Subscription var1);
    }
}

