/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionWizard {
    private static final int MODE_OPT_IN = 1;
    private static final int MODE_SUBSCRIBE = 2;
    private static final int MODE_CREATE_SEARCH = 3;
    private static final int MODE_CREATE_RSS = 4;
    private static final int RANK_COLUMN_WIDTH = 85;
    private static final String TABLE_SUB_WIZ = "SubscriptionWizard";
    private final String TITLE_OPT_IN = MessageText.getString("Wizard.Subscription.optin.title");
    private final String TITLE_SUBSCRIBE = MessageText.getString("Wizard.Subscription.subscribe.title");
    private final String TITLE_CREATE = MessageText.getString("Wizard.Subscription.create.title");
    Display display;
    Shell shell;
    Image rankingBars;
    Color rankingBorderColor;
    Label title;
    Button cancelButton;
    Button searchButton;
    Button saveButton;
    Button yesButton;
    Button addButton;
    Button availableButton;
    Button createButton;
    Font boldFont;
    Font titleFont;
    Font subTitleFont;
    Font textInputFont;
    Composite main;
    StackLayout mainLayout;
    Composite optinComposite;
    Composite createComposite;
    TabFolder createTabFolder;
    TabItem createRSSTabItem;
    TabItem createSearchTabItem;
    Composite availableSubscriptionComposite;
    Table libraryTable;
    Listener rssSaveListener;
    Listener searchListener;
    Text searchInput;
    Text feedUrl;
    Text subsName;
    Button anonCheck;
    String subs_name_default;
    SubscriptionUtils.SubscriptionDownloadDetails[] availableSubscriptions;
    Subscription[] subscriptions;
    DownloadManager download;
    URL rss_feed_url;
    boolean anon_default = false;
    private ImageLoader imageLoader;
    private TableViewSWT<Subscription> tvSubscriptions;
    private static boolean columnsAdded = false;

    public SubscriptionWizard() {
        this.init();
    }

    public SubscriptionWizard(URL url, Map<String, Object> options) {
        this.rss_feed_url = url;
        Boolean anon = (Boolean)options.get("_anonymous_");
        this.anon_default = anon != null && anon != false;
        this.subs_name_default = (String)options.get("t");
        this.init();
    }

    public SubscriptionWizard(DownloadManager _download) {
        this.download = _download;
        this.init();
    }

    protected void init() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SubscriptionWizard.this.init(core);
            }
        });
    }

    protected void init(AzureusCore core) {
        this.imageLoader = ImageLoader.getInstance();
        this.availableSubscriptions = SubscriptionUtils.getAllCachedDownloadDetails(core);
        Arrays.sort(this.availableSubscriptions, new Comparator<SubscriptionUtils.SubscriptionDownloadDetails>(){

            @Override
            public int compare(SubscriptionUtils.SubscriptionDownloadDetails o1, SubscriptionUtils.SubscriptionDownloadDetails o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getDownload().getDisplayName().compareTo(o2.getDownload().getDisplayName());
            }
        });
        this.shell = ShellFactory.createMainShell(112);
        this.shell.setSize(650, 400);
        Utils.centreWindow(this.shell);
        this.shell.setMinimumSize(550, 400);
        this.display = this.shell.getDisplay();
        Utils.setShellIcon(this.shell);
        this.rankingBars = this.imageLoader.getImage("ranking_bars");
        this.rankingBorderColor = new Color((Device)this.display, 200, 200, 200);
        this.createFonts();
        this.shell.setText(MessageText.getString("Wizard.Subscription.title"));
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                SubscriptionWizard.this.imageLoader.releaseImage("ranking_bars");
                SubscriptionWizard.this.imageLoader.releaseImage("wizard_header_bg");
                SubscriptionWizard.this.imageLoader.releaseImage("icon_rss");
                if (SubscriptionWizard.this.titleFont != null && !SubscriptionWizard.this.titleFont.isDisposed()) {
                    SubscriptionWizard.this.titleFont.dispose();
                }
                if (SubscriptionWizard.this.textInputFont != null && !SubscriptionWizard.this.textInputFont.isDisposed()) {
                    SubscriptionWizard.this.textInputFont.dispose();
                }
                if (SubscriptionWizard.this.boldFont != null && !SubscriptionWizard.this.boldFont.isDisposed()) {
                    SubscriptionWizard.this.boldFont.dispose();
                }
                if (SubscriptionWizard.this.subTitleFont != null && !SubscriptionWizard.this.subTitleFont.isDisposed()) {
                    SubscriptionWizard.this.subTitleFont.dispose();
                }
                if (SubscriptionWizard.this.rankingBorderColor != null && !SubscriptionWizard.this.rankingBorderColor.isDisposed()) {
                    SubscriptionWizard.this.rankingBorderColor.dispose();
                }
            }
        });
        Composite header = new Composite((Composite)this.shell, 0);
        header.setBackgroundMode(1);
        header.setBackgroundImage(this.imageLoader.getImage("wizard_header_bg"));
        Label topSeparator = new Label((Composite)this.shell, 258);
        this.main = new Composite((Composite)this.shell, 0);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        Composite footer = new Composite((Composite)this.shell, 0);
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        header.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)topSeparator, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)bottomSeparator, 0);
        this.main.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)footer, 0);
        bottomSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        footer.setLayoutData((Object)data);
        this.populateHeader(header);
        this.populateFooter(footer);
        this.mainLayout = new StackLayout();
        this.main.setLayout((Layout)this.mainLayout);
        this.optinComposite = this.createOptInComposite(this.main);
        this.createComposite = this.createCreateComposite(this.main);
        this.availableSubscriptionComposite = this.createAvailableSubscriptionComposite(this.main);
        this.setDefaultAvailableMode();
        this.shell.layout();
        this.shell.open();
        this.setInitialViews();
    }

    protected void setInitialViews() {
        if (this.availableSubscriptions != null) {
            for (int i = 0; i < this.availableSubscriptions.length; ++i) {
                SubscriptionUtils.SubscriptionDownloadDetails details = this.availableSubscriptions[i];
                if (details.getDownload() != this.download) continue;
                final int f_i = i;
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        SubscriptionWizard.this.libraryTable.setTopIndex(f_i);
                    }
                });
            }
        }
    }

    private void populateHeader(Composite header) {
        header.setBackground(this.display.getSystemColor(1));
        this.title = new Label(header, 64);
        this.title.setFont(this.titleFont);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        header.setLayout((Layout)layout);
    }

    private Composite createOptInComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        Label description = new Label(composite, 64);
        description.setFont(this.boldFont);
        description.setText(MessageText.getString("Wizard.Subscription.optin.description"));
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 40);
        data.left = new FormAttachment(0, 50);
        data.right = new FormAttachment(100, -50);
        description.setLayoutData((Object)data);
        return composite;
    }

    private Composite createCreateComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        this.createTabFolder = new TabFolder(composite, 0);
        this.createTabFolder.setFont(this.subTitleFont);
        this.createSearchTabItem = new TabItem(this.createTabFolder, 0);
        this.createSearchTabItem.setText(MessageText.getString("Wizard.Subscription.create.search"));
        this.createSearchTabItem.setControl((Control)this.createCreateSearchComposite((Composite)this.createTabFolder));
        this.createRSSTabItem = new TabItem(this.createTabFolder, 0);
        this.createRSSTabItem.setText("  " + MessageText.getString("Wizard.Subscription.create.rss"));
        this.createRSSTabItem.setControl((Control)this.createCreateRSSComposite((Composite)this.createTabFolder));
        this.createTabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TabItem[] selectedItems = SubscriptionWizard.this.createTabFolder.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                TabItem selectedItem = selectedItems[0];
                if (selectedItem == SubscriptionWizard.this.createRSSTabItem) {
                    SubscriptionWizard.this.setMode(4);
                } else {
                    SubscriptionWizard.this.setMode(3);
                }
            }
        });
        return composite;
    }

    private Composite createCreateRSSComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label subTitle1 = new Label(composite, 64);
        subTitle1.setFont(this.subTitleFont);
        subTitle1.setText(MessageText.getString("Wizard.Subscription.rss.subtitle1"));
        Composite cSearchInput = new Composite(composite, 0);
        cSearchInput.setLayout((Layout)new FormLayout());
        this.imageLoader.setBackgroundImage((Control)cSearchInput, "search_bg");
        Rectangle imageBounds = cSearchInput.getBackgroundImage().getBounds();
        this.feedUrl = new Text(cSearchInput, 4);
        this.feedUrl.setFont(this.textInputFont);
        this.feedUrl.setText("http://");
        this.feedUrl.addListener(14, this.rssSaveListener);
        this.feedUrl.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                boolean valid_url = false;
                try {
                    URL url = new URL(SubscriptionWizard.this.feedUrl.getText());
                    String protocol = url.getProtocol().toLowerCase();
                    valid_url = protocol.equals("azplug") || protocol.equals("file") || url.getHost().trim().length() > 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SubscriptionWizard.this.saveButton.setEnabled(valid_url);
            }
        });
        Label subTitle2 = new Label(composite, 64);
        subTitle2.setText(MessageText.getString("Wizard.Subscription.rss.subtitle2"));
        Label rssBullet = new Label(composite, 0);
        this.imageLoader.setLabelImage(rssBullet, "rss");
        Label subsNameText = new Label(composite, 64);
        subsNameText.setText(MessageText.getString("TableColumn.header.name"));
        this.subsName = new Text(composite, 2048);
        this.subsName.setFont(this.textInputFont);
        if (this.subs_name_default != null) {
            this.subsName.setText(this.subs_name_default);
        }
        this.anonCheck = new Button(composite, 32);
        Label anonMsg = new Label(composite, 64);
        anonMsg.setText(MessageText.getString("label.anon"));
        this.anonCheck.setSelection(this.anon_default);
        Label subTitle3 = new Label(composite, 64);
        subTitle3.setFont(this.subTitleFont);
        subTitle3.setText(MessageText.getString("Wizard.Subscription.rss.subtitle3"));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 50;
        layout.marginTop = 25;
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)subTitle1, 5);
        data.left = new FormAttachment(50, -imageBounds.width / 2);
        data.width = imageBounds.width;
        data.height = imageBounds.height;
        cSearchInput.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.left = new FormAttachment(0, 45);
        data.right = new FormAttachment(100, -8);
        this.feedUrl.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)cSearchInput, 15);
        data.left = new FormAttachment(0);
        rssBullet.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)rssBullet, -3, 128);
        data.left = new FormAttachment((Control)rssBullet, 5);
        data.right = new FormAttachment(100);
        subTitle2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)rssBullet, 20);
        data.left = new FormAttachment((Control)subTitle2, 0, 16384);
        subsNameText.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)subsNameText, 0, 1024);
        data.left = new FormAttachment((Control)subsNameText, 5, 131072);
        data.right = new FormAttachment(50);
        this.subsName.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)subsNameText, 0, 1024);
        data.left = new FormAttachment((Control)this.subsName, 5, 131072);
        this.anonCheck.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)subsNameText, 0, 1024);
        data.left = new FormAttachment((Control)this.anonCheck, 5, 131072);
        data.right = new FormAttachment(100);
        anonMsg.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.subsName, 20);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle3.setLayoutData((Object)data);
        return composite;
    }

    private Composite createCreateSearchComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label subTitle1 = new Label(composite, 64);
        subTitle1.setFont(this.subTitleFont);
        subTitle1.setText(MessageText.getString("Wizard.Subscription.search.subtitle1"));
        Composite cSearchInput = new Composite(composite, 0);
        cSearchInput.setLayout((Layout)new FormLayout());
        this.imageLoader.setBackgroundImage((Control)cSearchInput, "search_bg");
        Rectangle imageBounds = cSearchInput.getBackgroundImage().getBounds();
        this.searchInput = new Text(cSearchInput, 4);
        this.searchInput.setFont(this.textInputFont);
        this.searchInput.addListener(14, this.searchListener);
        Label subTitle2 = new Label(composite, 64);
        subTitle2.setFont(this.subTitleFont);
        subTitle2.setText(MessageText.getString("Wizard.Subscription.search.subtitle2"));
        Label checkBullet1 = new Label(composite, 0);
        this.imageLoader.setLabelImage(checkBullet1, "icon_check");
        Label checkBullet2 = new Label(composite, 0);
        this.imageLoader.setLabelImage(checkBullet2, "icon_check");
        Label description1 = new Label(composite, 0);
        description1.setText(MessageText.getString("Wizard.Subscription.search.subtitle2.sub1"));
        Label description2 = new Label(composite, 0);
        description2.setText(MessageText.getString("Wizard.Subscription.search.subtitle2.sub2"));
        Label subTitle3 = new Label(composite, 64);
        subTitle3.setFont(this.subTitleFont);
        subTitle3.setText(MessageText.getString("Wizard.Subscription.search.subtitle3"));
        FormLayout layout = new FormLayout();
        layout.marginLeft = 50;
        layout.marginRight = 50;
        layout.marginTop = 25;
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)subTitle1, 5);
        data.left = new FormAttachment(50, -imageBounds.width / 2);
        data.width = imageBounds.width;
        data.height = imageBounds.height;
        cSearchInput.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 7);
        data.left = new FormAttachment(0, 45);
        data.right = new FormAttachment(100, -8);
        this.searchInput.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)cSearchInput, 15);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)subTitle2, 5);
        data.left = new FormAttachment(0);
        checkBullet1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)checkBullet1, 5);
        data.left = new FormAttachment(0);
        checkBullet2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)checkBullet1, 0, 128);
        data.left = new FormAttachment((Control)checkBullet1, 5);
        description1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)checkBullet2, 0, 128);
        data.left = new FormAttachment((Control)checkBullet2, 5);
        description2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)checkBullet2, 15);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle3.setLayoutData((Object)data);
        return composite;
    }

    private Composite createAvailableSubscriptionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label hsep1 = new Label(composite, 258);
        Label hsep2 = new Label(composite, 258);
        Label vsep = new Label(composite, 514);
        Label subtitle1 = new Label(composite, 0);
        Label subtitle2 = new Label(composite, 0);
        subtitle1.setFont(this.subTitleFont);
        subtitle2.setFont(this.subTitleFont);
        subtitle1.setText(MessageText.getString("Wizard.Subscription.subscribe.library"));
        subtitle2.setText(MessageText.getString("Wizard.Subscription.subscribe.subscriptions"));
        this.libraryTable = new Table(composite, 268501508);
        TableColumn torrentColumn = new TableColumn(this.libraryTable, 0);
        torrentColumn.setWidth(Utils.adjustPXForDPI(50));
        Composite compEmpty = new Composite(composite, 0);
        compEmpty.setBackground(this.display.getSystemColor(1));
        compEmpty.setBackgroundMode(1);
        FillLayout fl = new FillLayout();
        fl.marginHeight = 15;
        fl.marginWidth = 15;
        compEmpty.setLayout((Layout)fl);
        compEmpty.setVisible(false);
        Link labelEmpty = new Link(compEmpty, 64);
        labelEmpty.setText(MessageText.getString("Wizard.Subscription.subscribe.library.empty"));
        labelEmpty.setFont(this.subTitleFont);
        labelEmpty.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        labelEmpty.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                    Utils.launch(event2.text);
                }
            }
        });
        SubscriptionWizard.initColumns();
        Composite cTV = new Composite(composite, 0);
        cTV.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cTV.setLayout((Layout)layout);
        this.tvSubscriptions = TableViewFactory.createTableViewSWT(Subscription.class, TABLE_SUB_WIZ, TABLE_SUB_WIZ, new TableColumnCore[0], "SubWizRank", 268501508);
        this.tvSubscriptions.setMenuEnabled(false);
        this.tvSubscriptions.setHeaderVisible(false);
        this.tvSubscriptions.setRowDefaultHeightEM(1.4f);
        this.tvSubscriptions.initialize(cTV);
        this.tvSubscriptions.getComposite().addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                org.gudy.azureus2.plugins.ui.tables.TableColumn tcName = SubscriptionWizard.this.tvSubscriptions.getTableColumn("SubWizName");
                org.gudy.azureus2.plugins.ui.tables.TableColumn tcRank = SubscriptionWizard.this.tvSubscriptions.getTableColumn("SubWizRank");
                Rectangle clientArea = ((Composite)event2.widget).getClientArea();
                tcName.setWidthPX(clientArea.width - tcRank.getWidth() - 1);
            }
        });
        this.tvSubscriptions.addSelectionListener(new TableSelectionListener(){

            public void selected(TableRowCore[] row) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SubscriptionWizard.this.tvSubscriptions.getSelectedRowsSize() == 0) {
                            SubscriptionWizard.this.addButton.setEnabled(false);
                        } else {
                            SubscriptionWizard.this.addButton.setEnabled(true);
                            TableRowCore[] rows = SubscriptionWizard.this.tvSubscriptions.getSelectedRows();
                            Subscription subscription = (Subscription)rows[0].getDataSource();
                            if (subscription.isSubscribed()) {
                                SubscriptionWizard.this.addButton.setEnabled(false);
                            } else {
                                SubscriptionWizard.this.addButton.setEnabled(true);
                            }
                            SubscriptionWizard.this.addButton.setData("subscription", (Object)subscription);
                        }
                    }
                });
            }

            public void mouseExit(TableRowCore row) {
            }

            public void mouseEnter(TableRowCore row) {
            }

            public void focusChanged(TableRowCore focus) {
            }

            public void deselected(TableRowCore[] rows) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SubscriptionWizard.this.tvSubscriptions.getSelectedRowsSize() == 0) {
                            SubscriptionWizard.this.addButton.setEnabled(false);
                        }
                    }
                });
            }

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
            }
        }, false);
        UIUpdaterSWT.getInstance().addUpdater(new UIUpdatable(){

            public void updateUI() {
                if (SubscriptionWizard.this.tvSubscriptions != null) {
                    SubscriptionWizard.this.tvSubscriptions.refreshTable(false);
                }
            }

            public String getUpdateUIName() {
                return "SubWiz";
            }
        });
        Listener resizeListener = new Listener(){
            int last_width;

            public void handleEvent(Event event2) {
                Table table = (Table)event2.widget;
                Rectangle rect = table.getClientArea();
                int width = rect.width - 3;
                if (width == this.last_width) {
                    return;
                }
                this.last_width = width;
                int nbColumns = table.getColumnCount();
                if (nbColumns == 1) {
                    table.getColumns()[0].setWidth(width);
                }
                ((Table)event2.widget).update();
            }
        };
        this.libraryTable.addListener(11, resizeListener);
        final Listener selectionListener = new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore row;
                TableItem item = (TableItem)event2.item;
                SubscriptionWizard.this.subscriptions = (Subscription[])item.getData("subscriptions");
                SubscriptionWizard.this.tvSubscriptions.removeDataSources(SubscriptionWizard.this.tvSubscriptions.getDataSources().toArray(new Subscription[0]));
                if (SubscriptionWizard.this.subscriptions != null) {
                    SubscriptionWizard.this.tvSubscriptions.addDataSources(SubscriptionWizard.this.subscriptions);
                }
                SubscriptionWizard.this.tvSubscriptions.processDataSourceQueueSync();
                SubscriptionWizard.this.addButton.setEnabled(false);
                SubscriptionWizard.this.addButton.setData("subscription", null);
                SubscriptionWizard.this.tvSubscriptions.setSelectedRows(new TableRowCore[0]);
                if (SubscriptionWizard.this.subscriptions != null && SubscriptionWizard.this.subscriptions.length > 0 && (row = SubscriptionWizard.this.tvSubscriptions.getRow(SubscriptionWizard.this.subscriptions[0])) != null) {
                    row.setSelected(true);
                }
            }
        };
        this.libraryTable.addListener(13, selectionListener);
        if (this.availableSubscriptions != null) {
            this.libraryTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = SubscriptionWizard.this.libraryTable.indexOf(item);
                    SubscriptionUtils.SubscriptionDownloadDetails subInfo = SubscriptionWizard.this.availableSubscriptions[index];
                    item.setText(subInfo.getDownload().getDisplayName());
                    item.setData("subscriptions", (Object)subInfo.getSubscriptions());
                    boolean isSubscribed = false;
                    Subscription[] subs = subInfo.getSubscriptions();
                    for (int i = 0; i < subs.length; ++i) {
                        if (!subs[i].isSubscribed()) continue;
                        isSubscribed = true;
                    }
                    if (isSubscribed) {
                        item.setForeground(SubscriptionWizard.this.display.getSystemColor(15));
                    }
                    if (subInfo.getDownload() == SubscriptionWizard.this.download) {
                        SubscriptionWizard.this.libraryTable.setSelection(item);
                        selectionListener.handleEvent(event2);
                    }
                    if (index == 0 && SubscriptionWizard.this.download == null) {
                        SubscriptionWizard.this.libraryTable.setSelection(item);
                        selectionListener.handleEvent(event2);
                    }
                    if (SubscriptionWizard.this.libraryTable.getSelectionIndex() == index) {
                        selectionListener.handleEvent(event2);
                    }
                }
            });
            this.libraryTable.setItemCount(this.availableSubscriptions.length);
            if (this.availableSubscriptions.length == 0) {
                this.libraryTable.setVisible(false);
                compEmpty.setVisible(true);
            }
        } else {
            this.libraryTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = SubscriptionWizard.this.libraryTable.indexOf(item);
                    item.setText("test " + index);
                }
            });
            this.libraryTable.setItemCount(20);
        }
        this.addButton.setEnabled(false);
        this.addButton.setData("subscription", null);
        this.libraryTable.addListener(41, new Listener(){

            public void handleEvent(Event event2) {
                event2.height = 20;
            }
        });
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(40, 0);
        data.bottom = new FormAttachment(100, 0);
        vsep.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)vsep, 0);
        data.left = new FormAttachment(0, 5);
        subtitle1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)vsep, 5);
        data.right = new FormAttachment(100, 0);
        subtitle2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)subtitle1, 5);
        data.right = new FormAttachment((Control)vsep, 0);
        data.left = new FormAttachment(0, 0);
        hsep1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)subtitle2, 5);
        data.left = new FormAttachment((Control)vsep, -1);
        data.right = new FormAttachment(100, 0);
        hsep2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)hsep1, 0);
        data.right = new FormAttachment((Control)vsep, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        if (this.availableSubscriptions != null && this.availableSubscriptions.length > 0) {
            this.libraryTable.setLayoutData((Object)data);
        } else {
            this.libraryTable.dispose();
            this.cancelButton.setFocus();
            this.shell.setDefaultButton(this.cancelButton);
            compEmpty.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)hsep2, 0);
        data.left = new FormAttachment((Control)vsep, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        cTV.setLayoutData((Object)data);
        return composite;
    }

    private static void initColumns() {
        if (columnsAdded) {
            return;
        }
        columnsAdded = true;
        UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
        TableManager tableManager = uiManager.getTableManager();
        tableManager.registerColumn(Subscription.class, "SubWizName", new TableColumnCreationListener(){
            private Image rssIcon;

            public void tableColumnCreated(org.gudy.azureus2.plugins.ui.tables.TableColumn column) {
                column.setVisible(column.getTableID().equals(SubscriptionWizard.TABLE_SUB_WIZ));
                ImageLoader imageLoader = ImageLoader.getInstance();
                this.rssIcon = imageLoader.getImage("icon_rss");
                column.addCellAddedListener(new TableCellAddedListener(){

                    public void cellAdded(TableCell cell) {
                        Subscription sub = (Subscription)cell.getDataSource();
                        if (sub.isSubscribed()) {
                            cell.setForeground(160, 160, 160);
                        }
                        cell.setText(sub.getName());
                        ((TableCellSWT)cell).setIcon(rssIcon);
                        cell.setToolTip(sub.getNameEx());
                    }
                });
            }
        });
        tableManager.registerColumn(Subscription.class, "SubWizRank", new TableColumnCreationListener(){

            public void tableColumnCreated(org.gudy.azureus2.plugins.ui.tables.TableColumn column) {
                column.setWidthLimits(85, 85);
                column.setVisible(column.getTableID().equals(SubscriptionWizard.TABLE_SUB_WIZ));
                column.addCellRefreshListener(new TableCellRefreshListener(){

                    public void refresh(TableCell cell) {
                        Subscription sub = (Subscription)cell.getDataSource();
                        cell.setSortValue(sub.getCachedPopularity());
                    }
                });
                if (column instanceof TableColumnCore) {
                    TableColumnCore columnCore = (TableColumnCore)column;
                    columnCore.setSortAscending(false);
                    columnCore.addCellOtherListener("SWTPaint", new TableCellSWTPaintListener(){

                        public void cellPaint(GC gc, TableCellSWT cell) {
                            Subscription sub = (Subscription)cell.getDataSource();
                            Rectangle bounds = cell.getBounds();
                            bounds.width -= 5;
                            bounds.height -= 7;
                            bounds.x += 2;
                            bounds.y += 3;
                            gc.setBackground(ColorCache.getColor(gc.getDevice(), 255, 255, 255));
                            gc.fillRectangle(bounds);
                            gc.setForeground(ColorCache.getColor(gc.getDevice(), 200, 200, 200));
                            gc.drawRectangle(bounds);
                            bounds.width -= 2;
                            bounds.height -= 2;
                            ++bounds.x;
                            ++bounds.y;
                            long popularity = sub.getCachedPopularity();
                            int rank = 80 * (int)popularity / 1000;
                            if (rank > 80) {
                                rank = 80;
                            }
                            if (rank < 5) {
                                rank = 5;
                            }
                            Rectangle clipping = gc.getClipping();
                            bounds.width = rank;
                            --bounds.height;
                            ++bounds.x;
                            ++bounds.y;
                            Utils.setClipping(gc, bounds);
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            Image rankingBars = imageLoader.getImage("ranking_bars");
                            gc.drawImage(rankingBars, bounds.x, bounds.y);
                            imageLoader.releaseImage("ranking_bars");
                            Utils.setClipping(gc, clipping);
                        }
                    });
                }
            }
        });
        TableColumnManager tcm = TableColumnManager.getInstance();
        tcm.setDefaultColumnNames(TABLE_SUB_WIZ, new String[]{"SubWizName", "SubWizRank"});
    }

    private void createFonts() {
        int i;
        FontData[] fDatas = this.shell.getFont().getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setStyle(1);
        }
        this.boldFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
                continue;
            }
            fDatas[i].setHeight(10);
        }
        this.subTitleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(17);
                continue;
            }
            fDatas[i].setHeight(14);
        }
        this.titleFont = new Font((Device)this.display, fDatas);
        this.textInputFont = FontUtils.getFontWithHeight(this.shell.getFont(), null, Utils.isGTK3 ? 12 : 14);
    }

    private void populateFooter(Composite footer) {
        this.yesButton = new Button(footer, 8);
        this.yesButton.setText(MessageText.getString("Button.yes"));
        this.yesButton.setFont(this.boldFont);
        this.addButton = new Button(footer, 8);
        this.addButton.setText(MessageText.getString("Button.add"));
        this.addButton.setFont(this.boldFont);
        this.saveButton = new Button(footer, 8);
        this.saveButton.setText(MessageText.getString("Button.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.setFont(this.boldFont);
        this.searchButton = new Button(footer, 8);
        this.searchButton.setText(MessageText.getString("Button.search"));
        this.searchButton.setFont(this.boldFont);
        this.cancelButton = new Button(footer, 8);
        this.createButton = new Button(footer, 8);
        this.createButton.setText(MessageText.getString("Button.createNewSubscription"));
        this.availableButton = new Button(footer, 8);
        this.availableButton.setText(MessageText.getString("Button.availableSubscriptions"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        footer.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        this.yesButton.setLayoutData((Object)data);
        this.addButton.setLayoutData((Object)data);
        this.searchButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        this.saveButton.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.saveButton);
        data.width = 100;
        this.cancelButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.width = 175;
        this.createButton.setLayoutData((Object)data);
        this.availableButton.setLayoutData((Object)data);
        this.yesButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("subscriptions.opted_in", true);
                COConfigurationManager.save();
                SubscriptionWizard.this.setMode(2);
            }
        });
        this.createButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.setMode(3);
            }
        });
        this.availableButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.setDefaultAvailableMode();
            }
        });
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.shell.close();
            }
        });
        this.rssSaveListener = new Listener(){

            public void handleEvent(Event event2) {
                try {
                    String url_str = SubscriptionWizard.this.feedUrl.getText();
                    URL url = new URL(url_str);
                    HashMap<Object, Boolean> user_data = new HashMap<Object, Boolean>();
                    user_data.put(SubscriptionManagerUI.SUB_EDIT_MODE_KEY, new Boolean(true));
                    boolean anonymous = SubscriptionWizard.this.anonCheck.getSelection();
                    String subs_name = SubscriptionWizard.this.subsName.getText().trim();
                    if (subs_name.length() == 0) {
                        subs_name = url_str;
                    }
                    Subscription subRSS = SubscriptionManagerFactory.getSingleton().createRSS(subs_name, url, 120, anonymous, user_data);
                    if (anonymous) {
                        subRSS.getHistory().setDownloadNetworks(new String[]{"I2P"});
                    }
                    SubscriptionWizard.this.shell.close();
                    String key = "Subscription_" + ByteFormatter.encodeString(subRSS.getPublicKey());
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID(key);
                }
                catch (Throwable e) {
                    Utils.reportError(e);
                }
            }
        };
        this.saveButton.addListener(13, this.rssSaveListener);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Subscription subscription = (Subscription)SubscriptionWizard.this.addButton.getData("subscription");
                if (subscription != null) {
                    subscription.setSubscribed(true);
                    SubscriptionWizard.this.shell.close();
                }
            }
        });
        this.searchListener = new Listener(){

            public void handleEvent(Event event2) {
                UIFunctionsManager.getUIFunctions().doSearch(SubscriptionWizard.this.searchInput.getText(), true);
                SubscriptionWizard.this.shell.close();
            }
        };
        this.searchButton.addListener(13, this.searchListener);
    }

    private void setDefaultAvailableMode() {
        boolean opted_in = COConfigurationManager.getBooleanParameter("subscriptions.opted_in");
        if (!opted_in) {
            this.setMode(1);
        } else {
            this.setMode(2);
        }
    }

    private void setMode(int mode) {
        this.addButton.setVisible(false);
        this.searchButton.setVisible(false);
        this.saveButton.setVisible(false);
        this.yesButton.setVisible(false);
        this.createButton.setVisible(false);
        this.availableButton.setVisible(false);
        this.cancelButton.setText(MessageText.getString("Button.cancel"));
        String titleText = this.TITLE_OPT_IN;
        if (mode != 1 && this.rss_feed_url != null) {
            mode = 4;
            this.feedUrl.setText(this.rss_feed_url.toExternalForm());
            this.rss_feed_url = null;
        }
        switch (mode) {
            case 2: {
                this.mainLayout.topControl = this.availableSubscriptionComposite;
                titleText = this.TITLE_SUBSCRIBE;
                this.createButton.setVisible(true);
                this.addButton.setVisible(true);
                this.shell.setDefaultButton(this.addButton);
                break;
            }
            case 4: {
                this.mainLayout.topControl = this.createComposite;
                this.createTabFolder.setSelection(this.createRSSTabItem);
                titleText = this.TITLE_CREATE;
                this.availableButton.setVisible(true);
                this.saveButton.setVisible(true);
                this.shell.setDefaultButton(this.saveButton);
                break;
            }
            case 3: {
                this.mainLayout.topControl = this.createComposite;
                this.createTabFolder.setSelection(this.createSearchTabItem);
                titleText = this.TITLE_CREATE;
                this.availableButton.setVisible(true);
                this.searchButton.setVisible(true);
                this.shell.setDefaultButton(this.searchButton);
                break;
            }
            default: {
                this.mainLayout.topControl = this.optinComposite;
                this.cancelButton.setText(MessageText.getString("Button.no"));
                this.createButton.setVisible(true);
                this.yesButton.setVisible(true);
                this.shell.setDefaultButton(this.yesButton);
            }
        }
        this.main.layout(true, true);
        this.title.setText(titleText);
    }

    public static void main(String[] args) {
        SubscriptionWizard sw = new SubscriptionWizard();
        while (!sw.shell.isDisposed()) {
            if (sw.display.readAndDispatch()) continue;
            sw.display.sleep();
        }
        sw.display.dispose();
    }
}

