/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.gudy.azureus2.core3.util.Debug;

public class ColorCache2 {
    private static Map<RGB, CachedColorManaged> color_map = new HashMap<RGB, CachedColorManaged>();

    public static CachedColor getColor(Color c) {
        return new CachedColorUnmanaged(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedColor getColor(Device device, RGB rgb) {
        Map<RGB, CachedColorManaged> map = color_map;
        synchronized (map) {
            CachedColorManaged entry = color_map.get(rgb);
            if (entry == null) {
                entry = new CachedColorManaged(new Color(device, rgb));
                color_map.put(rgb, entry);
            } else {
                entry.addRef();
            }
            return new CachedColorManagedFacade(entry);
        }
    }

    public static interface CachedColor {
        public Color getColor();

        public boolean isDisposed();

        public void dispose();
    }

    private static class CachedColorManaged {
        private Color color;
        private int ref_count;

        private CachedColorManaged(Color _color) {
            this.color = _color;
            this.ref_count = 1;
        }

        public Color getColor() {
            return this.color;
        }

        private void addRef() {
            ++this.ref_count;
        }

        private void dispose() {
            --this.ref_count;
            if (this.ref_count == 0) {
                color_map.remove(this.color.getRGB());
                this.color.dispose();
            } else if (this.ref_count < 0) {
                Debug.out("already disposed");
            }
        }
    }

    private static class CachedColorManagedFacade
    implements CachedColor {
        private CachedColorManaged delegate;
        private boolean disposed;

        private CachedColorManagedFacade(CachedColorManaged _delegate) {
            this.delegate = _delegate;
        }

        public Color getColor() {
            return this.delegate.getColor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisposed() {
            Map map = color_map;
            synchronized (map) {
                return this.disposed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Map map = color_map;
            synchronized (map) {
                if (!this.disposed) {
                    this.disposed = true;
                    this.delegate.dispose();
                }
            }
        }
    }

    private static class CachedColorUnmanaged
    implements CachedColor {
        private Color color;

        private CachedColorUnmanaged(Color _color) {
            this.color = _color;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isDisposed() {
            return this.color.isDisposed();
        }

        public void dispose() {
            this.color.dispose();
        }
    }
}

