/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import java.net.InetAddress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class ViewQuickNetInfo
implements UISWTViewCoreEventListener {
    private UISWTView swtView;
    private Composite composite;
    private BufferedLabel asn;
    private BufferedLabel current_ip;
    private SpeedManager speed_manager;

    public ViewQuickNetInfo() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                ViewQuickNetInfo.this.speed_manager = core.getSpeedManager();
            }
        });
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.composite = new Composite(parent, 2048);
        GridData gridData = new GridData(1808);
        Utils.setLayoutData((Control)this.composite, gridData);
        GridLayout layout = new GridLayout(4, false);
        this.composite.setLayout((Layout)layout);
        Label label = new Label(this.composite, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.asn");
        this.asn = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        Utils.setLayoutData(this.asn, gridData);
        label = new Label(this.composite, 0);
        Messages.setLanguageText((Widget)label, "label.current_ip");
        this.current_ip = new BufferedLabel(this.composite, 0);
        gridData = new GridData(768);
        Utils.setLayoutData(this.current_ip, gridData);
    }

    private void delete() {
        Utils.disposeComposite(this.composite);
    }

    private String getFullTitle() {
        return MessageText.getString("label.quick.net.info");
    }

    private Composite getComposite() {
        return this.composite;
    }

    private void refresh() {
        InetAddress ip;
        if (this.speed_manager != null) {
            this.asn.setText(this.speed_manager.getASN());
        }
        this.current_ip.setText((ip = NetworkAdmin.getSingleton().getDefaultPublicAddress()) == null ? "" : ip.getHostAddress());
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 3: {
                this.composite.traverse(16);
            }
        }
        return true;
    }
}

