/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.views.skin.SBC_LibraryTableView;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;

public class MyTorrentsView_Big
extends MyTorrentsView {
    private final int torrentFilterMode;
    private int defaultRowHeight = Utils.adjustPXForDPI(40);

    public MyTorrentsView_Big(AzureusCore _azureus_core, int torrentFilterMode, TableColumnCore[] basicItems, Text txtFilter, Composite cCatsTags) {
        super(true);
        Class forDataSourceType;
        this.torrentFilterMode = torrentFilterMode;
        this.txtFilter = txtFilter;
        this.cCategoriesAndTags = cCatsTags;
        switch (torrentFilterMode) {
            case 1: 
            case 3: {
                forDataSourceType = DownloadTypeComplete.class;
                break;
            }
            case 2: {
                forDataSourceType = DownloadTypeIncomplete.class;
                break;
            }
            default: {
                forDataSourceType = Download.class;
            }
        }
        this.init(_azureus_core, SB_Transfers.getTableIdFromFilterMode(torrentFilterMode, true), forDataSourceType, basicItems);
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        if (PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
            return false;
        }
        if (this.torrentFilterMode == 3) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                return false;
            }
        } else if (this.torrentFilterMode == 0) {
            if (!this.isInCurrentTag(dm)) {
                return false;
            }
            return this.isInCurrentTag(dm);
        }
        return super.isOurDownloadManager(dm);
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        boolean neverPlay = DownloadTypeIncomplete.class.equals(this.getForDataSourceType());
        SBC_LibraryTableView.doDefaultClick(rows, stateMask, neverPlay);
    }

    protected int getRowDefaultHeight() {
        return this.defaultRowHeight;
    }
}

