/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.MyTorrentsView_Big;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_LibraryTableView
extends SkinView
implements UIUpdatable,
ObfusticateImage,
UIPluginViewToolBarListener {
    private static final String ID = "SBC_LibraryTableView";
    private Composite viewComposite;
    private TableViewSWT<?> tv;
    protected int torrentFilterMode = 0;
    private SWTSkinObject soParent;
    private MyTorrentsView torrentView;
    private UISWTViewEventListener swtViewListener;
    private UISWTViewImpl view;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.soParent = skinObject.getParent();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (SBC_LibraryTableView.this.soParent == null || SBC_LibraryTableView.this.soParent.isDisposed()) {
                            return;
                        }
                        SBC_LibraryTableView.this.initShow(core);
                    }
                });
            }
        });
        return null;
    }

    public void initShow(AzureusCore core) {
        TableColumnCore[] columns;
        Object data = this.soParent.getControl().getData("TorrentFilterMode");
        if (data instanceof Long) {
            this.torrentFilterMode = (int)((Long)data).longValue();
        }
        data = this.soParent.getControl().getData("DataSource");
        boolean useBigTable = this.useBigTable();
        SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.skin.getSkinObject("library-filter", this.soParent.getParent());
        Text txtFilter = soFilter == null ? null : soFilter.getTextControl();
        SWTSkinObjectContainer soCats = (SWTSkinObjectContainer)this.skin.getSkinObject("library-categories", this.soParent.getParent());
        Composite cCats = soCats == null ? null : soCats.getComposite();
        Object object = columns = useBigTable || this.torrentFilterMode != 0 ? this.getColumns() : null;
        if (null != columns) {
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.addColumns(columns);
        }
        if (useBigTable) {
            if (this.torrentFilterMode == 1 || this.torrentFilterMode == 2 || this.torrentFilterMode == 3) {
                this.torrentView = new MyTorrentsView_Big(core, this.torrentFilterMode, columns, txtFilter, cCats);
                this.swtViewListener = this.torrentView;
            } else {
                this.torrentView = new MyTorrentsView_Big(core, this.torrentFilterMode, columns, txtFilter, cCats);
                this.swtViewListener = this.torrentView;
            }
        } else {
            String tableID = SB_Transfers.getTableIdFromFilterMode(this.torrentFilterMode, false);
            if (this.torrentFilterMode == 1) {
                this.torrentView = new MyTorrentsView(core, tableID, true, columns, txtFilter, cCats, true);
                this.swtViewListener = this.torrentView;
            } else if (this.torrentFilterMode == 2) {
                this.torrentView = new MyTorrentsView(core, tableID, false, columns, txtFilter, cCats, true);
                this.swtViewListener = this.torrentView;
            } else if (this.torrentFilterMode == 3) {
                this.torrentView = new MyTorrentsView(core, tableID, true, columns, txtFilter, cCats, true){

                    public boolean isOurDownloadManager(DownloadManager dm) {
                        if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                            return false;
                        }
                        return super.isOurDownloadManager(dm);
                    }
                };
                this.swtViewListener = this.torrentView;
            } else {
                this.swtViewListener = new MyTorrentsSuperView(txtFilter, cCats){

                    public void initializeDone() {
                        MyTorrentsView seedingview = this.getSeedingview();
                        if (seedingview != null) {
                            seedingview.overrideDefaultSelected(new TableSelectionAdapter(){

                                public void defaultSelected(TableRowCore[] rows, int stateMask) {
                                    SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                                }
                            });
                            MyTorrentsView torrentview = this.getTorrentview();
                            if (torrentview != null) {
                                torrentview.overrideDefaultSelected(new TableSelectionAdapter(){

                                    public void defaultSelected(TableRowCore[] rows, int stateMask) {
                                        SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                                    }
                                });
                            }
                        }
                    }
                };
            }
            if (this.torrentView != null) {
                this.torrentView.overrideDefaultSelected(new TableSelectionAdapter(){

                    public void defaultSelected(TableRowCore[] rows, int stateMask) {
                        SBC_LibraryTableView.doDefaultClick(rows, stateMask, false);
                    }
                });
            }
        }
        if (this.torrentView != null) {
            this.tv = this.torrentView.getTableView();
            if (this.torrentFilterMode == 3) {
                this.torrentView.setRebuildListOnFocusGain(true);
            }
        }
        try {
            this.view = new UISWTViewImpl(ID + this.torrentFilterMode, "Main", false);
            this.view.setDatasource(data);
            this.view.setEventListener(this.swtViewListener, true);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout((Layout)gridLayout);
        this.view.initialize(this.viewComposite);
        SWTSkinObject soSizeSlider = this.skin.getSkinObject("table-size-slider", this.soParent.getParent());
        if (soSizeSlider instanceof SWTSkinObjectContainer) {
            SWTSkinObjectContainer so = (SWTSkinObjectContainer)soSizeSlider;
            if (this.tv != null && !this.tv.enableSizeSlider(so.getComposite(), 16, 100)) {
                so.setVisible(false);
            }
        }
        if (this.torrentFilterMode == 0 && this.tv != null) {
            this.tv.addRefreshListener(new TableRowRefreshListener(){

                public void rowRefresh(TableRow row) {
                    TableRowSWT rowCore = (TableRowSWT)row;
                    Object ds = rowCore.getDataSource(true);
                    if (!(ds instanceof DownloadManager)) {
                        return;
                    }
                    DownloadManager dm = (DownloadManager)ds;
                    boolean changed = false;
                    boolean assumedComplete = dm.getAssumedComplete();
                    changed = !assumedComplete ? (changed |= rowCore.setAlpha(160)) : (!PlatformTorrentUtils.getHasBeenOpened(dm) ? (changed |= rowCore.setAlpha(255)) : (changed |= rowCore.setAlpha(255)));
                }
            });
        }
        this.viewComposite.getParent().layout(true);
    }

    public static void doDefaultClick(TableRowCore[] rows, int stateMask, boolean neverPlay) {
        DownloadManager dmFile;
        DownloadManager dm;
        DiskManagerFileInfo file;
        if (rows == null || rows.length != 1) {
            return;
        }
        Object ds = rows[0].getDataSource(true);
        String mode = COConfigurationManager.getStringParameter("list.dm.dblclick");
        if (mode.equals("1")) {
            if (UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("DMDetails", ds)) {
                return;
            }
        } else if (mode.equals("2")) {
            boolean openMode = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            file = DataSourceUtils.getFileInfo(ds);
            if (file != null) {
                ManagerUtils.open(file, openMode);
                return;
            }
            dm = DataSourceUtils.getDM(ds);
            if (dm != null) {
                ManagerUtils.open(dm, openMode);
                return;
            }
        } else {
            DiskManagerFileInfo fileInfo2;
            boolean webInBrowser = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowser");
            if (webInBrowser && ((fileInfo2 = DataSourceUtils.getFileInfo(ds)) != null ? ManagerUtils.browseWebsite(fileInfo2) : (dm = DataSourceUtils.getDM(ds)) != null && ManagerUtils.browseWebsite(dm))) {
                return;
            }
            if (mode.equals("3") || mode.equals("4")) {
                file = DataSourceUtils.getFileInfo(ds);
                if (file != null) {
                    if (mode.equals("4") && file.getDownloaded() == file.getLength() && Utils.isQuickViewSupported(file)) {
                        Utils.setQuickViewActive(file, true);
                    } else {
                        TorrentUtil.runDataSources(new Object[]{file});
                    }
                    return;
                }
                dm = DataSourceUtils.getDM(ds);
                if (dm != null) {
                    TorrentUtil.runDataSources(new Object[]{dm});
                    return;
                }
            } else if (mode.equals("5")) {
                fileInfo2 = DataSourceUtils.getFileInfo(ds);
                if (fileInfo2 != null) {
                    ManagerUtils.browse(fileInfo2);
                    return;
                }
                dm = DataSourceUtils.getDM(ds);
                if (dm != null) {
                    ManagerUtils.browse(dm);
                    return;
                }
            }
        }
        if (neverPlay) {
            return;
        }
        if (PlayUtils.canPlayDS(ds, -1, true) || (stateMask & 0x40000) != 0) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "dblclick", false, true);
            return;
        }
        if (PlayUtils.canStreamDS(ds, -1, true)) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "dblclick", true, false);
            return;
        }
        DownloadManager dm2 = DataSourceUtils.getDM(ds);
        file = DataSourceUtils.getFileInfo(ds);
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent == null && file != null && (dmFile = file.getDownloadManager()) != null) {
            torrent = dmFile.getTorrent();
        }
        if (file != null && file.getDownloaded() == file.getLength()) {
            TorrentUtil.runDataSources(new Object[]{file});
        } else if (dm2 != null) {
            TorrentUtil.runDataSources(new Object[]{dm2});
        }
    }

    @Override
    public String getUpdateUIName() {
        return ID;
    }

    @Override
    public void updateUI() {
        if (this.viewComposite == null || this.viewComposite.isDisposed() || !this.viewComposite.isVisible() || this.view == null) {
            return;
        }
        this.view.triggerEvent(5, null);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        if (this.view != null) {
            this.view.triggerEvent(3, null);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SBC_LibraryTableView.this.updateUI();
            }
        });
        return null;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.triggerEvent(4, null);
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (!this.isVisible()) {
            return;
        }
        if (this.view != null) {
            this.view.refreshToolBarItems(list);
        }
        if (this.tv == null) {
            return;
        }
        ISelectedContent[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
        boolean has1Selection = currentContent.length == 1;
        list.put("play", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex(), false) ? 1L : 0L);
        list.put("stream", has1Selection && !(currentContent[0] instanceof ISelectedVuzeFileContent) && PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex(), false) ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.isVisible() && this.view != null) {
            return this.view.toolBarItemActivated(item, activationType, datasource);
        }
        return false;
    }

    protected int getTableMode() {
        return 1;
    }

    protected boolean useBigTable() {
        return false;
    }

    protected TableColumnCore[] getColumns() {
        if (this.torrentFilterMode == 1) {
            return TableColumnCreator.createCompleteDM("MySeeders");
        }
        if (this.torrentFilterMode == 2) {
            return TableColumnCreator.createIncompleteDM("MyTorrents");
        }
        if (this.torrentFilterMode == 3) {
            return TableColumnCreatorV3.createUnopenedDM("Unopened", false);
        }
        if (this.torrentFilterMode == 0) {
            return TableColumnCreator.createCompleteDM("MyLibrary.big");
        }
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.triggerEvent(7, null);
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Image obfusticatedImage(Image image) {
        if (this.view instanceof ObfusticateImage) {
            ObfusticateImage oi = (ObfusticateImage)((Object)this.view);
            return oi.obfusticatedImage(image);
        }
        return image;
    }
}

