/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryDatasourceListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiInterface;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.DataSourceUtils;
import java.util.Map;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_TorrentDetailsView
extends SkinView
implements DownloadManagerListener,
UIPluginViewToolBarListener,
SelectedContentListener {
    private DownloadManager manager;
    private TabbedMdiInterface tabbedMDI;
    private Composite parent;
    private MdiEntrySWT mdi_entry;
    private Object dataSource;

    private void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        this.manager = DataSourceUtils.getDM(newDataSource);
        if (this.tabbedMDI != null && newDataSource instanceof Object[] && ((Object[])newDataSource)[0] instanceof PEPeer) {
            this.tabbedMDI.showEntryByID("PeersView");
        }
        if (this.manager != null) {
            this.manager.addListener(this);
        }
        if (this.tabbedMDI != null) {
            MdiEntry[] entries;
            for (MdiEntry entry : entries = this.tabbedMDI.getEntries()) {
                entry.setDatasource(newDataSource);
            }
        }
    }

    private void delete() {
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        Utils.disposeSWTObjects(new Object[]{this.parent});
    }

    private void initialize(Composite composite) {
        UISWTInstance pluginUI;
        Composite main_area = new Composite(composite, 0);
        main_area.setLayout((Layout)new FormLayout());
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        this.parent = composite;
        if (this.tabbedMDI == null) {
            this.tabbedMDI = uiFunctions.createTabbedMDI(main_area, "detailsview");
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        if (composite.getLayout() instanceof FormLayout) {
            main_area.setLayoutData((Object)Utils.getFilledFormData());
        } else if (composite.getLayout() instanceof GridLayout) {
            main_area.setLayoutData((Object)new GridData(1808));
        }
        composite.layout();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null) {
            MyTorrentsView.registerPluginViews(pluginUI);
            for (String id : new String[]{"MyTorrents", "TorrentDetailsView"}) {
                UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews;
                for (UISWTInstance.UISWTViewEventListenerWrapper l : pluginViews = pluginUI.getViewListeners(id)) {
                    if (id == "MyTorrents" && l.getViewID() == "PieceInfoView" || l == null) continue;
                    try {
                        this.tabbedMDI.createEntryFromEventListener(null, "TorrentDetailsView", l, l.getViewID(), false, this.manager, null);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        this.tabbedMDI.addListener(new MdiSWTMenuHackListener(){

            public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                menuTree.setData("downloads", (Object)new DownloadManager[]{SBC_TorrentDetailsView.this.manager});
                menuTree.setData("is_detailed_view", (Object)true);
                MenuFactory.buildTorrentMenu(menuTree);
            }
        });
        if (this.dataSource instanceof Object[] && ((Object[])this.dataSource)[0] instanceof PEPeer) {
            this.tabbedMDI.showEntryByID("PeersView");
        } else {
            MdiEntry[] entries = this.tabbedMDI.getEntries();
            if (entries.length > 0) {
                this.tabbedMDI.showEntry(entries[0]);
            }
        }
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
    }

    private void refresh() {
        this.tabbedMDI.updateUI();
    }

    protected static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        BaseMdiEntry activeView = this.getActiveView();
        if (activeView == null) {
            return;
        }
        activeView.refreshToolBarItems(list);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        BaseMdiEntry activeView = this.getActiveView();
        if (activeView == null) {
            return false;
        }
        return activeView.toolBarItemActivated(item, activationType, datasource);
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        });
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public DownloadManager getDownload() {
        return this.manager;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public String getUpdateUIName() {
        return "DMDetails";
    }

    public void updateUI() {
        this.refresh();
    }

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SWTSkinObject soListArea = this.getSkinObject("torrentdetails-list-area");
        if (soListArea == null) {
            return null;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            this.mdi_entry = mdi.getEntryFromSkinObject(skinObject);
            if (this.mdi_entry == null) {
                Debug.out("Failed to get MDI entry from skin object, reverting to using 'current'");
                this.mdi_entry = mdi.getCurrentEntrySWT();
            }
        }
        this.initialize((Composite)soListArea.getControl());
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.delete();
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        this.dataSourceChanged(params);
        return null;
    }

    private BaseMdiEntry getActiveView() {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return null;
        }
        return (BaseMdiEntry)this.tabbedMDI.getCurrentEntrySWT();
    }

    public static class TorrentDetailMdiEntry
    implements MdiSWTMenuHackListener,
    MdiCloseListener,
    MdiEntryDatasourceListener,
    UIUpdatable,
    ViewTitleInfo,
    ObfusticateTab {
        int lastCompleted = -1;
        protected GlobalManagerAdapter gmListener;
        private BaseMdiEntry entry;

        public static void register(MultipleDocumentInterfaceSWT mdi) {
            mdi.registerEntry("DMDetails.*", new MdiEntryCreationListener2(){

                @Override
                public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                    String hash = DataSourceUtils.getHash(datasource);
                    if (hash != null) {
                        id = "DMDetails_" + hash;
                    }
                    return new TorrentDetailMdiEntry().createTorrentDetailEntry(mdi, id, datasource);
                }
            });
        }

        public MdiEntry createTorrentDetailEntry(MultipleDocumentInterface mdi, String id, Object ds) {
            if (ds == null) {
                return null;
            }
            this.entry = (BaseMdiEntry)mdi.createEntryFromSkinRef("header.transfers", id, "torrentdetails", "", null, ds, true, null);
            this.entry.addListeners(this);
            this.entry.setViewTitleInfo(this);
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    TorrentDetailMdiEntry.this.gmListener = new GlobalManagerAdapter(){

                        public void downloadManagerRemoved(DownloadManager dm) {
                            Object ds = TorrentDetailMdiEntry.this.entry.getDatasourceCore();
                            DownloadManager manager = DataSourceUtils.getDM(ds);
                            if (dm.equals(manager)) {
                                Utils.execSWTThread(new AERunnable(){

                                    public void runSupport() {
                                        TorrentDetailMdiEntry.this.entry.closeView();
                                    }
                                });
                            }
                        }
                    };
                    gm.addListener(TorrentDetailMdiEntry.this.gmListener, false);
                }
            });
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
            return this.entry;
        }

        public Object getTitleInfoProperty(int propertyID) {
            Object ds = this.entry.getDatasourceCore();
            if (propertyID == 10) {
                return DataSourceUtils.getHash(ds);
            }
            if (propertyID == 7) {
                return "DMDetails";
            }
            if (propertyID == 2) {
                return "image.sidebar.details";
            }
            DownloadManager manager = DataSourceUtils.getDM(ds);
            if (manager == null) {
                return null;
            }
            if (propertyID == 5) {
                return manager.getDisplayName();
            }
            if (propertyID == 0) {
                int completed = manager.getStats().getPercentDoneExcludingDND();
                if (completed != 1000) {
                    return completed / 10 + "%";
                }
            } else if (propertyID == 1) {
                String eta;
                String s = "";
                int completed = manager.getStats().getPercentDoneExcludingDND();
                if (completed != 1000) {
                    s = completed / 10 + "% Complete\n";
                }
                if ((eta = DisplayFormatters.formatETA(manager.getStats().getSmoothedETA())).length() > 0) {
                    s = s + MessageText.getString("TableColumn.header.eta") + ": " + eta + "\n";
                }
                return manager.getDisplayName() + (s.length() == 0 ? "" : ": " + s);
            }
            return null;
        }

        public void updateUI() {
            int completed;
            DownloadManager manager = DataSourceUtils.getDM(this.entry.getDatasourceCore());
            int n = completed = manager == null ? -1 : manager.getStats().getPercentDoneExcludingDND();
            if (this.lastCompleted != completed) {
                ViewTitleInfoManager.refreshTitleInfo(this);
                this.lastCompleted = completed;
            }
        }

        public String getUpdateUIName() {
            return this.entry == null ? "DMD" : this.entry.getId();
        }

        public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
            UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
            try {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                gm.removeListener(this.gmListener);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }

        public void mdiEntryDatasourceChanged(final MdiEntry entry) {
            Object newDataSource = ((BaseMdiEntry)entry).getDatasourceCore();
            if (newDataSource instanceof String) {
                final String s = (String)newDataSource;
                if (!AzureusCoreFactory.isCoreRunning()) {
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            entry.setDatasource(DataSourceUtils.getDM(s));
                        }
                    });
                }
            }
            ViewTitleInfoManager.refreshTitleInfo(this);
        }

        public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
            TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
            menuTree.setData("TableView", (Object)tv);
            DownloadManager manager = DataSourceUtils.getDM(((BaseMdiEntry)entry).getDatasourceCore());
            if (manager != null) {
                menuTree.setData("downloads", (Object)new DownloadManager[]{manager});
            }
            menuTree.setData("is_detailed_view", (Object)new Boolean(true));
            MenuFactory.buildTorrentMenu(menuTree);
        }

        public String getObfusticatedHeader() {
            Object ds = this.entry.getDatasourceCore();
            DownloadManager manager = DataSourceUtils.getDM(ds);
            if (manager == null) {
                return null;
            }
            int completed = manager.getStats().getCompleted();
            return DisplayFormatters.formatPercentFromThousands(completed) + " : " + manager.toString().replaceFirst("DownloadManagerImpl", "DM");
        }
    }
}

