/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;

public abstract class StandardButtonsArea {
    private Button def_button;
    private Button[] buttons;
    private Map<Integer, Boolean> buttonsEnabled = new HashMap<Integer, Boolean>();
    private static final int BUTTON_PADDING = 2;
    private static final int MIN_BUTTON_WIDTH = 75;
    private String[] buttonIDs;
    private Integer[] buttonVals;
    private int defaultButtonPos;

    public void setButtonIDs(String[] buttons) {
        this.buttonIDs = buttons == null ? new String[]{} : buttons;
    }

    public void setButtonVals(Integer[] buttonVals) {
        this.buttonVals = buttonVals;
        int cancelPos = -1;
        for (int i = 0; i < buttonVals.length; ++i) {
            Integer val = buttonVals[i];
            if (val != 256) continue;
            cancelPos = i;
            break;
        }
        if (cancelPos >= 0 && Constants.isOSX && cancelPos != 0) {
            String cancelButton = this.buttonIDs[cancelPos];
            for (int i = cancelPos; i > 0; --i) {
                if (this.defaultButtonPos == i) {
                    this.defaultButtonPos = i - 1;
                }
                this.buttonIDs[i] = this.buttonIDs[i - 1];
                this.buttonVals[i] = this.buttonVals[i - 1];
            }
            if (this.defaultButtonPos == 0) {
                this.defaultButtonPos = 1;
            }
            this.buttonIDs[0] = cancelButton;
            buttonVals[0] = 256;
        }
    }

    public void setDefaultButtonPos(int defaultOption) {
        this.defaultButtonPos = defaultOption;
    }

    public int getButtonVal(int buttonPos) {
        if (this.buttonVals == null) {
            return buttonPos;
        }
        if (buttonPos < 0 || buttonPos >= this.buttonVals.length) {
            return 256;
        }
        return this.buttonVals[buttonPos];
    }

    public int getButtonCount() {
        return this.buttonIDs.length;
    }

    public int getButtonPosFromVal(int buttonVal) {
        int pos = buttonVal;
        if (this.buttonVals != null) {
            for (int i = 0; i < this.buttonVals.length; ++i) {
                int val = this.buttonVals[i];
                if (buttonVal != val) continue;
                pos = i;
                break;
            }
        }
        return pos;
    }

    public void swt_createButtons(Composite cBottomArea) {
        Composite cCenterH = new Composite(cBottomArea, 0);
        FormData fd = new FormData();
        fd.height = 1;
        fd.width = 1;
        fd.left = new FormAttachment(100);
        fd.right = new FormAttachment(0);
        cCenterH.setLayoutData((Object)fd);
        Composite cCenterV = new Composite(cBottomArea, 0);
        fd = new FormData();
        fd.width = 1;
        fd.height = 1;
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        cCenterV.setLayoutData((Object)fd);
        Composite cButtonArea = new Composite(cBottomArea, 0);
        cButtonArea.setBackgroundMode(2);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cCenterV, 0, 0x1000000);
        fd.right = new FormAttachment((Control)cCenterH, 0, 16384);
        cButtonArea.setLayoutData((Object)fd);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.center = true;
        rowLayout.spacing = 8;
        rowLayout.pack = false;
        Utils.setLayout(cButtonArea, rowLayout);
        this.buttons = new Button[this.buttonIDs.length];
        for (int i = 0; i < this.buttonIDs.length; ++i) {
            String buttonText = this.buttonIDs[i];
            if (buttonText == null) continue;
            Button button = this.buttons[i] = new Button(cButtonArea, 8);
            int buttonVal = this.buttonVals == null || i >= this.buttonVals.length ? i : this.buttonVals[i];
            Boolean b = this.buttonsEnabled.get(buttonVal);
            if (b == null) {
                b = Boolean.TRUE;
            }
            button.setEnabled(b.booleanValue());
            button.setText(buttonText);
            RowData rowData = new RowData();
            Point size = button.computeSize(-1, -1);
            size.x += 2;
            int minButtonWidth = Utils.adjustPXForDPI(75);
            if (size.x < minButtonWidth) {
                size.x = minButtonWidth;
            }
            rowData.width = size.x;
            Utils.setLayoutData((Control)button, rowData);
            if (this.defaultButtonPos == i) {
                this.def_button = button;
            }
            button.setData("ButtonNo", (Object)new Integer(i));
            button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    int intValue = ((Number)event2.widget.getData("ButtonNo")).intValue();
                    StandardButtonsArea.this.clicked(StandardButtonsArea.this.getButtonVal(intValue));
                }
            });
        }
        cBottomArea.getParent().layout(true, true);
        cBottomArea.getShell().addShellListener(new ShellListener(){

            public void shellIconified(ShellEvent e) {
            }

            public void shellDeiconified(ShellEvent e) {
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
                if (StandardButtonsArea.this.def_button != null) {
                    StandardButtonsArea.this.def_button.getShell().setDefaultButton(StandardButtonsArea.this.def_button);
                }
            }
        });
    }

    protected abstract void clicked(int var1);

    public void setButtonEnabled(final int buttonVal, final boolean enable) {
        this.buttonsEnabled.put(buttonVal, enable);
        if (this.buttons == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Button button;
                if (StandardButtonsArea.this.buttons == null) {
                    return;
                }
                int pos = StandardButtonsArea.this.getButtonPosFromVal(buttonVal);
                if (pos >= 0 && pos < StandardButtonsArea.this.buttons.length && (button = StandardButtonsArea.this.buttons[pos]) != null && !button.isDisposed()) {
                    button.setEnabled(enable);
                }
            }
        });
    }

    public Button[] getButtons() {
        return this.buttons;
    }
}

