/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.ISelectedVuzeFileContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItemSO;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarActivationListener;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarEnablerBase;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarItemImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerImpl;

public class ToolBarView
extends SkinView
implements SelectedContentListener,
UIToolBarManagerImpl.ToolBarManagerListener,
ToolBarItem.ToolBarItemListener {
    private static boolean DEBUG = false;
    private static toolbarButtonListener buttonListener;
    private Map<UIToolBarItem, ToolBarItemSO> mapToolBarItemToSO = new HashMap<UIToolBarItem, ToolBarItemSO>();
    private boolean showText = true;
    private boolean initComplete = false;
    private boolean showCalled = false;
    private ArrayList<ToolBarViewListener> listeners = new ArrayList(1);
    private UIToolBarManagerCore tbm;
    private boolean firstTimeEver = true;
    private FrequencyLimitedDispatcher refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){
        private AERunnable lock = this;
        private boolean refresh_pending;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            AERunnable aERunnable = this.lock;
            synchronized (aERunnable) {
                if (this.refresh_pending) {
                    return;
                }
                this.refresh_pending = true;
            }
            if (DEBUG) {
                System.out.println("refreshCoreItems via " + Debug.getCompressedStackTrace());
            }
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    AERunnable aERunnable = lock;
                    synchronized (aERunnable) {
                        refresh_pending = false;
                    }
                    ToolBarView.this._refreshCoreToolBarItems();
                }
            });
        }
    }, 250);
    private IdentityHashMap<DownloadManager, DownloadManagerListener> dm_listener_map = new IdentityHashMap();
    private SWTSkinObject soLastGroup;

    public ToolBarView() {
        this.tbm = (UIToolBarManagerCore)UIToolBarManagerImpl.getInstance();
    }

    private ToolBarItem createItem(ToolBarView tbv, String id, String imageid, String textID) {
        UIToolBarItemImpl base = new UIToolBarItemImpl(id);
        base.setImageID(imageid);
        base.setTextID(textID);
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        String[] groupIDs;
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (uiClassic && !"global-toolbar".equals(skinObject.getViewID())) {
            skinObject.setVisible(false);
            return null;
        }
        for (SWTSkinObject temp = skinObject; temp != null; temp = temp.getParent()) {
            int visible = temp.getSkin().getSkinProperties().getIntValue("mdientry.toolbar.visible", 1);
            if (visible != 0) continue;
            skinObject.setVisible(false);
            return null;
        }
        buttonListener = new toolbarButtonListener();
        if (this.firstTimeEver) {
            this.firstTimeEver = false;
            this.setupToolBarItems(uiClassic);
        }
        this.tbm.addListener(this);
        if (uiClassic) {
            this.bulkSetupItems("classic", "toolbar.area.sitem");
        }
        this.bulkSetupItems("main", "toolbar.area.sitem");
        this.bulkSetupItems("views", "toolbar.area.vitem");
        for (String groupID : groupIDs = this.tbm.getGroupIDs()) {
            if ("classic".equals(groupID) || "main".equals(groupID) || "views".equals(groupID)) continue;
            this.bulkSetupItems(groupID, "toolbar.area.sitem");
        }
        this.initComplete = true;
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (ToolBarViewListener l : this.listeners) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
        return null;
    }

    private void setupToolBarItems(boolean uiClassic) {
        ToolBarItem item;
        if (uiClassic) {
            item = this.createItem(this, "open", "image.toolbar.open", "Button.add");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                    return true;
                }
            });
            item.setAlwaysAvailable(true);
            item.setGroupID("classic");
            this.tbm.addToolBarItem(item, false);
            item = this.createItem(this, "search", "search", "Button.search");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    UIFunctionsManagerSWT.getUIFunctionsSWT().promptForSearch();
                    return true;
                }
            });
            item.setAlwaysAvailable(true);
            item.setGroupID("classic");
            this.tbm.addToolBarItem(item, false);
        }
        if (!uiClassic) {
            item = this.createItem(this, "play", "image.button.play", "iconBar.play");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
                    if (sc != null && sc.length > 0) {
                        if (PlayUtils.canStreamDS(sc[0], sc[0].getFileIndex(), true)) {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", true, false);
                        } else {
                            TorrentListViewsUtils.playOrStreamDataSource(sc[0], "toolbar", false, true);
                        }
                    }
                    return false;
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "run", "image.toolbar.run", "iconBar.run");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType != 0L) {
                    return false;
                }
                TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                Object[] ds = tv != null ? tv.getSelectedDataSources().toArray() : SelectedContentManager.getDMSFromSelectedContent();
                if (ds != null) {
                    TorrentUtil.runDataSources(ds);
                    return true;
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (uiClassic) {
            item = this.createItem(this, "top", "image.toolbar.top", "iconBar.top");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType == 0L) {
                        return ToolBarView.this.moveTop();
                    }
                    return false;
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "up", "image.toolbar.up", "v3.iconBar.up");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return false;
                    }
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return a.getPosition() - b.getPosition();
                            }
                        });
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableUp(dm)) continue;
                            gm.moveUp(dm);
                        }
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveTop();
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "down", "image.toolbar.down", "v3.iconBar.down");
        item.setDefaultActivationListener(new UIToolBarActivationListener(){

            public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                if (activationType == 0L) {
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        return false;
                    }
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
                    if (dms != null) {
                        Arrays.sort(dms, new Comparator<DownloadManager>(){

                            @Override
                            public int compare(DownloadManager a, DownloadManager b) {
                                return b.getPosition() - a.getPosition();
                            }
                        });
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = dms[i];
                            if (!gm.isMoveableDown(dm)) continue;
                            gm.moveDown(dm);
                        }
                        return true;
                    }
                } else if (activationType == 1L) {
                    return ToolBarView.this.moveBottom();
                }
                return false;
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (uiClassic) {
            item = this.createItem(this, "bottom", "image.toolbar.bottom", "iconBar.bottom");
            item.setDefaultActivationListener(new UIToolBarActivationListener(){

                public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
                    if (activationType != 0L) {
                        return false;
                    }
                    return ToolBarView.this.moveBottom();
                }
            });
            this.tbm.addToolBarItem(item, false);
        }
        item = this.createItem(this, "startstop", "image.toolbar.startstop.start", "iconBar.startstop");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(0L){

            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.stopOrStartDataSources(selected);
            }
        });
        this.tbm.addToolBarItem(item, false);
        item = this.createItem(this, "remove", "image.toolbar.remove", "iconBar.remove");
        item.setDefaultActivationListener(new UIToolBarActivationListener_OffSWT(0L){

            public void toolBarItemActivated_OffSWT(ToolBarItem item, long activationType, Object datasource) {
                Object[] selected = SelectedContentManager.getCurrentlySelectedContent();
                TorrentUtil.removeDataSources(selected);
            }
        });
        this.tbm.addToolBarItem(item, false);
        if (COConfigurationManager.getBooleanParameter("Library.EnableSimpleView")) {
            item = this.createItem(this, "modeBig", "image.toolbar.table_large", "v3.iconBar.view.big");
            item.setGroupID("views");
            this.tbm.addToolBarItem(item, false);
            item = this.createItem(this, "modeSmall", "image.toolbar.table_normal", "v3.iconBar.view.small");
            item.setGroupID("views");
            this.tbm.addToolBarItem(item, false);
        }
    }

    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
        this.refreshCoreToolBarItems();
        UIFunctionsManagerSWT.getUIFunctionsSWT().refreshTorrentMenu();
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        if (this.showCalled) {
            return null;
        }
        this.showCalled = true;
        Object object = super.skinObjectShown(skinObject, params);
        ToolBarItem[] allToolBarItems = this.tbm.getAllSWTToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            ToolBarItem toolBarItem = allToolBarItems[i];
            toolBarItem.addToolBarItemListener(this);
            this.uiFieldChanged(toolBarItem);
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        return object;
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        this.showCalled = false;
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        ToolBarItem[] allToolBarItems = this.tbm.getAllSWTToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            ToolBarItem toolBarItem = allToolBarItems[i];
            toolBarItem.removeToolBarItemListener(this);
        }
        return super.skinObjectHidden(skinObject, params);
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        this.tbm.removeListener(this);
        return super.skinObjectDestroyed(skinObject, params);
    }

    public boolean triggerToolBarItem(ToolBarItem item, long activationType, Object datasource) {
        if (!this.isVisible()) {
            if (DEBUG) {
                Debug.out("Trying to triggerToolBarItem when toolbar is not visible");
            }
            return false;
        }
        if (this.triggerViewToolBar(item, activationType, datasource)) {
            return true;
        }
        UIToolBarActivationListener defaultActivation = item.getDefaultActivationListener();
        if (defaultActivation != null) {
            return defaultActivation.toolBarItemActivated(item, activationType, datasource);
        }
        if (DEBUG) {
            String viewID = SelectedContentManager.getCurrentySelectedViewID();
            System.out.println("Warning: Fallback of toolbar button " + item.getID() + " via " + viewID + " view");
        }
        return false;
    }

    protected boolean moveBottom() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveEnd(dms);
        }
        return true;
    }

    protected boolean moveTop() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return false;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        DownloadManager[] dms = SelectedContentManager.getDMSFromSelectedContent();
        if (dms != null) {
            gm.moveTop(dms);
        }
        return true;
    }

    public void refreshCoreToolBarItems() {
        if (DEBUG) {
            System.out.println("refreshCoreItems Start via " + Debug.getCompressedStackTrace());
        }
        this.refresh_limiter.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _refreshCoreToolBarItems() {
        MultipleDocumentInterfaceSWT mdi;
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to refresh core toolbar items when toolbar is not visible " + this + this.getMainSkinObject());
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null) {
            String[] TBKEYS;
            UIToolBarItem uIToolBarItem;
            UIToolBarItem[] allToolBarItems = this.tbm.getAllToolBarItems();
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            HashMap<String, Long> mapStates = new HashMap<String, Long>();
            if (entry != null) {
                UIToolBarEnablerBase[] enablers;
                for (UIToolBarEnablerBase enabler : enablers = entry.getToolbarEnablers()) {
                    if (!(enabler instanceof UIPluginViewToolBarListener)) continue;
                    try {
                        ((UIPluginViewToolBarListener)enabler).refreshToolBarItems(mapStates);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            Object[] currentContent = SelectedContentManager.getCurrentlySelectedContent();
            IdentityHashMap<DownloadManager, DownloadManagerListener> identityHashMap = this.dm_listener_map;
            synchronized (identityHashMap) {
                IdentityHashMap<DownloadManager, DownloadManagerListener> copy = new IdentityHashMap<DownloadManager, DownloadManagerListener>(this.dm_listener_map);
                for (ISelectedContent iSelectedContent : currentContent) {
                    DownloadManager dm = iSelectedContent.getDownloadManager();
                    if (dm == null) continue;
                    copy.remove(dm);
                    if (this.dm_listener_map.containsKey(dm)) continue;
                    DownloadManagerListener l = new DownloadManagerListener(){

                        public void stateChanged(DownloadManager manager, int state) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void downloadComplete(DownloadManager manager) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void completionChanged(DownloadManager manager, boolean bCompleted) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }

                        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
                            ToolBarView.this.refreshCoreToolBarItems();
                        }
                    };
                    dm.addListener(l, false);
                    this.dm_listener_map.put(dm, l);
                }
                for (Map.Entry e : copy.entrySet()) {
                    DownloadManager dm = (DownloadManager)e.getKey();
                    dm.removeListener((DownloadManagerListener)e.getValue());
                    this.dm_listener_map.remove(dm);
                }
            }
            boolean bl = currentContent.length == 1;
            boolean can_play = false;
            boolean can_stream = false;
            boolean stream_permitted = false;
            if (bl && !(currentContent[0] instanceof ISelectedVuzeFileContent)) {
                can_play = PlayUtils.canPlayDS(currentContent[0], currentContent[0].getFileIndex(), false);
                can_stream = PlayUtils.canStreamDS(currentContent[0], currentContent[0].getFileIndex(), false);
                if (can_stream) {
                    stream_permitted = PlayUtils.isStreamPermitted();
                }
            }
            if (mapStates.containsKey("play")) {
                can_play |= ((Long)mapStates.get("play") & 1L) > 0L;
            }
            if (mapStates.containsKey("stream")) {
                can_stream |= ((Long)mapStates.get("stream") & 1L) > 0L;
            }
            mapStates.put("play", can_play | can_stream ? 1L : 0L);
            UIToolBarItem pitem = this.tbm.getToolBarItem("play");
            if (pitem != null) {
                if (can_stream) {
                    pitem.setImageID(stream_permitted ? "image.button.stream" : "image.button.pstream");
                    pitem.setTextID(stream_permitted ? "iconBar.stream" : "iconBar.pstream");
                } else {
                    pitem.setImageID("image.button.play");
                    pitem.setTextID("iconBar.play");
                }
            }
            if ((uIToolBarItem = this.tbm.getToolBarItem("startstop")) != null) {
                boolean shouldStopGroup = currentContent.length == 0 && mapStates.containsKey("start") && (!mapStates.containsKey("stop") || ((Long)mapStates.get("stop") & 1L) == 0L) && ((Long)mapStates.get("start") & 1L) > 0L ? false : TorrentUtil.shouldStopGroup(currentContent);
                uIToolBarItem.setTextID(shouldStopGroup ? "iconBar.stop" : "iconBar.start");
                uIToolBarItem.setImageID("image.toolbar.startstop." + (shouldStopGroup ? "stop" : "start"));
                if (currentContent.length == 0 && !mapStates.containsKey("startstop")) {
                    boolean can_start;
                    boolean can_stop = mapStates.containsKey("stop") && ((Long)mapStates.get("stop") & 1L) > 0L;
                    boolean bl2 = can_start = mapStates.containsKey("start") && ((Long)mapStates.get("start") & 1L) > 0L;
                    if (can_start && can_stop) {
                        can_stop = false;
                    }
                    if (can_start || can_stop) {
                        uIToolBarItem.setTextID(can_stop ? "iconBar.stop" : "iconBar.start");
                        uIToolBarItem.setImageID("image.toolbar.startstop." + (can_stop ? "stop" : "start"));
                        mapStates.put("startstop", 1L);
                    }
                }
            }
            Map<String, Long> fallBackStates = TorrentUtil.calculateToolbarStates((ISelectedContent[])currentContent, null);
            for (String key : fallBackStates.keySet()) {
                if (mapStates.containsKey(key)) continue;
                mapStates.put(key, fallBackStates.get(key));
            }
            for (String key : TBKEYS = new String[]{"play", "run", "top", "up", "down", "bottom", "start", "stop", "startstop", "remove"}) {
                if (mapStates.containsKey(key)) continue;
                mapStates.put(key, 0L);
            }
            for (int i = 0; i < allToolBarItems.length; ++i) {
                UIToolBarItem toolBarItem = allToolBarItems[i];
                Long state = (Long)mapStates.get(toolBarItem.getID());
                if (state == null) continue;
                toolBarItem.setState(state);
            }
        }
    }

    private boolean triggerViewToolBar(ToolBarItem item, long activationType, Object datasource) {
        if (DEBUG && !this.isVisible()) {
            Debug.out("Trying to triggerViewToolBar when toolbar is not visible");
            return false;
        }
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null) {
            UIToolBarEnablerBase[] enablers;
            MdiEntrySWT entry = mdi.getCurrentEntrySWT();
            for (UIToolBarEnablerBase enabler : enablers = entry.getToolbarEnablers()) {
                if (!(enabler instanceof UIPluginViewToolBarListener) || !((UIPluginViewToolBarListener)enabler).toolBarItemActivated(item, activationType, datasource)) continue;
                return true;
            }
        }
        return false;
    }

    private void bulkSetupItems(String groupID, String templatePrefix) {
        SWTSkinObject[] children;
        String[] idsByGroup = this.tbm.getToolBarIDsByGroup(groupID);
        SWTSkinObjectContainer groupSO = this.getGroupSO(groupID);
        for (SWTSkinObject so : children = groupSO.getChildren()) {
            so.dispose();
        }
        for (int i = 0; i < idsByGroup.length; ++i) {
            String itemID = idsByGroup[i];
            UIToolBarItem item = this.tbm.getToolBarItem(itemID);
            if (!(item instanceof ToolBarItem)) continue;
            int position = 0;
            int size = idsByGroup.length;
            if (size == 1) {
                position = 4;
            } else if (i == 0) {
                position = 16384;
            } else if (i == size - 1) {
                this.addSeperator(groupID);
                position = 131072;
            } else {
                this.addSeperator(groupID);
            }
            this.createItemSO((ToolBarItem)item, templatePrefix, position);
        }
        this.addNonToolBar("toolbar.area.sitem.left2", groupID);
    }

    private Control getLastControl(String groupID) {
        SWTSkinObjectContainer groupSO = this.getGroupSO(groupID);
        SWTSkinObject[] children = groupSO.getChildren();
        if (children == null || children.length == 0) {
            return null;
        }
        return children[children.length - 1].getControl();
    }

    private void createItemSO(ToolBarItem item, String templatePrefix, int position) {
        SWTSkinObject so;
        ToolBarItemSO existingItemSO = this.mapToolBarItemToSO.get(item);
        if (existingItemSO != null && (so = existingItemSO.getSO()) != null) {
            so.dispose();
        }
        String templateID = templatePrefix;
        if (position == 131072) {
            templateID = templateID + ".right";
        } else if (position == 16384) {
            templateID = templateID + ".left";
        } else if (position == 4) {
            templateID = templateID + ".lr";
        }
        Control attachToControl = this.getLastControl(item.getGroupID());
        String id = "toolbar:" + item.getID();
        SWTSkinObject so2 = this.skin.createSkinObject(id, templateID, this.getGroupSO(item.getGroupID()));
        if (so2 != null) {
            ToolBarItemSO itemSO = new ToolBarItemSO((UIToolBarItemImpl)item, so2);
            if (attachToControl != null) {
                FormData fd = (FormData)so2.getControl().getLayoutData();
                fd.left = new FormAttachment(attachToControl);
            }
            this.initSO(so2, itemSO);
            if (this.initComplete) {
                Utils.relayout((Control)so2.getControl().getParent());
            }
        }
    }

    private SWTSkinObjectContainer getGroupSO(String groupID) {
        String soID = "toolbar-group-" + groupID;
        SWTSkinObjectContainer soGroup = (SWTSkinObjectContainer)this.skin.getSkinObjectByID(soID, this.soMain);
        if (soGroup == null) {
            soGroup = (SWTSkinObjectContainer)this.skin.createSkinObject(soID, "toolbar.group", this.soMain);
            FormData fd = (FormData)soGroup.getControl().getLayoutData();
            fd.left = this.soLastGroup != null ? new FormAttachment(this.soLastGroup.getControl(), 0, 131072) : new FormAttachment(0, 2);
        }
        this.soLastGroup = soGroup;
        return soGroup;
    }

    private void initSO(SWTSkinObject so, ToolBarItemSO itemSO) {
        ToolBarItem item = itemSO.getBase();
        itemSO.setSO(so);
        String toolTip = item.getToolTip();
        if (toolTip != null) {
            so.setTooltipID("!" + toolTip + "!");
        } else {
            so.setTooltipID(item.getTooltipID());
        }
        so.setData("toolbaritem", item);
        SWTSkinButtonUtility btn = (SWTSkinButtonUtility)so.getData("btn");
        if (btn == null) {
            btn = new SWTSkinButtonUtility(so, "toolbar-item-image");
            so.setData("btn", btn);
        }
        btn.setImage(item.getImageID());
        btn.addSelectionListener(buttonListener);
        itemSO.setSkinButton(btn);
        SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
        if (soTitle instanceof SWTSkinObjectText) {
            ((SWTSkinObjectText)soTitle).setTextID(item.getTextID());
            itemSO.setSkinTitle((SWTSkinObjectText)soTitle);
        }
        this.mapToolBarItemToSO.put(item, itemSO);
    }

    public void uiFieldChanged(ToolBarItem item) {
        ToolBarItemSO itemSO = this.mapToolBarItemToSO.get(item);
        if (itemSO != null) {
            itemSO.updateUI();
        }
    }

    private void addSeperator(String groupID) {
        this.addSeperator("toolbar.area.sitem.sep", groupID);
    }

    private void addSeperator(String id, String groupID) {
        SWTSkinObjectContainer soGroup = this.getGroupSO(groupID);
        Control lastControl = this.getLastControl(groupID);
        SWTSkinObject so = this.skin.createSkinObject("toolbar_sep" + Math.random(), id, soGroup);
        if (so != null && lastControl != null) {
            FormData fd = (FormData)so.getControl().getLayoutData();
            fd.left = new FormAttachment(lastControl, fd.left == null ? 0 : fd.left.offset);
        }
    }

    private void addNonToolBar(String skinid, String groupID) {
        SWTSkinObjectContainer soGroup = this.getGroupSO(groupID);
        Control lastControl = this.getLastControl(groupID);
        SWTSkinObject so = this.skin.createSkinObject("toolbar_d" + Math.random(), skinid, soGroup);
        if (so != null && lastControl != null) {
            FormData fd = (FormData)so.getControl().getLayoutData();
            fd.left = new FormAttachment(lastControl, fd.left == null ? 0 : fd.left.offset);
        }
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        UIToolBarItem[] allToolBarItems = this.tbm.getAllToolBarItems();
        for (int i = 0; i < allToolBarItems.length; ++i) {
            UIToolBarItem tbi = allToolBarItems[i];
            SWTSkinObject so = ((ToolBarItemSO)((Object)tbi)).getSkinButton().getSkinObject();
            SWTSkinObject soTitle = this.skin.getSkinObject("toolbar-item-title", so);
            if (soTitle == null) continue;
            soTitle.setVisible(showText);
        }
    }

    public boolean getShowText() {
        return this.showText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(l);
            if (this.initComplete) {
                try {
                    l.toolbarViewInitialized(this);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ToolBarViewListener l) {
        ArrayList<ToolBarViewListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(l);
        }
    }

    public void toolbarItemRemoved(final UIToolBarItem toolBarItem) {
        ToolBarItemSO itemSO = this.mapToolBarItemToSO.get(toolBarItem);
        if (itemSO == null) {
            return;
        }
        itemSO.dispose();
        final SWTSkinObject so = itemSO.getSO();
        if (so != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    String groupID = toolBarItem.getGroupID();
                    String[] idsByGroup = ToolBarView.this.tbm.getToolBarIDsByGroup(groupID);
                    if (idsByGroup.length <= 1) {
                        boolean b = ToolBarView.this.initComplete;
                        ToolBarView.this.initComplete = false;
                        ToolBarView.this.bulkSetupItems(groupID, "toolbar.area.sitem");
                        ToolBarView.this.initComplete = b;
                        so.getParent().relayout();
                        return;
                    }
                    int posToolBarItem = -1;
                    String id = toolBarItem.getID();
                    Control soControl = so.getControl();
                    SWTSkinObject middleSO = ((ToolBarItemSO)ToolBarView.this.mapToolBarItemToSO.get(ToolBarView.this.tbm.getToolBarItem(idsByGroup[idsByGroup.length / 2]))).getSO();
                    SWTSkinObject[] children = ((SWTSkinObjectContainer)so.getParent()).getChildren();
                    int middle = -1;
                    for (int i = 0; i < children.length; ++i) {
                        if (children[i] != middleSO) continue;
                        middle = i;
                        break;
                    }
                    if (middle == -1) {
                        return;
                    }
                    children[middle].dispose();
                    children[middle + 1].dispose();
                    Control controlLeft = children[middle - 1].getControl();
                    FormData fd = (FormData)children[middle + 2].getControl().getLayoutData();
                    fd.left.control = controlLeft;
                    Utils.relayout(children[middle + 2].getControl());
                    int positionInGroup = 0;
                    UIToolBarItem curItem = ToolBarView.this.tbm.getToolBarItem(idsByGroup[positionInGroup]);
                    children = ((SWTSkinObjectContainer)so.getParent()).getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        SWTSkinObject child = children[i];
                        ToolBarItem item = (ToolBarItem)child.getData("toolbaritem");
                        if (item == null || !item.getGroupID().equals(groupID)) continue;
                        ToolBarItemSO toolBarItemSO = (ToolBarItemSO)ToolBarView.this.mapToolBarItemToSO.get(curItem);
                        ToolBarView.this.initSO(child, toolBarItemSO);
                        if (++positionInGroup >= idsByGroup.length) break;
                        curItem = ToolBarView.this.tbm.getToolBarItem(idsByGroup[positionInGroup]);
                    }
                    so.getParent().relayout();
                }
            });
        }
        this.mapToolBarItemToSO.remove(toolBarItem);
    }

    public void toolbarItemAdded(final UIToolBarItem item) {
        if (this.isVisible() && item instanceof ToolBarItem) {
            ToolBarItem toolBarItem = (ToolBarItem)item;
            toolBarItem.addToolBarItemListener(this);
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                boolean b = ToolBarView.this.initComplete;
                ToolBarView.this.initComplete = false;
                ToolBarView.this.bulkSetupItems(item.getGroupID(), "toolbar.area.sitem");
                ToolBarView.this.initComplete = b;
                Utils.execSWTThreadLater(0, new Runnable(){

                    public void run() {
                        Utils.relayout(ToolBarView.this.soMain.getControl());
                    }
                });
            }
        });
    }

    public static interface ToolBarViewListener {
        public void toolbarViewInitialized(ToolBarView var1);
    }

    public abstract class UIToolBarActivationListener_OffSWT
    implements UIToolBarActivationListener {
        private long onlyOnActivationType;

        public UIToolBarActivationListener_OffSWT(long onlyOnActivationType) {
            this.onlyOnActivationType = onlyOnActivationType;
        }

        public UIToolBarActivationListener_OffSWT() {
            this.onlyOnActivationType = -1L;
        }

        public final boolean toolBarItemActivated(final ToolBarItem item, final long activationType, final Object datasource) {
            if (this.onlyOnActivationType >= 0L && activationType != this.onlyOnActivationType) {
                return false;
            }
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    UIToolBarActivationListener_OffSWT.this.toolBarItemActivated_OffSWT(item, activationType, datasource);
                }
            });
            return true;
        }

        public abstract void toolBarItemActivated_OffSWT(ToolBarItem var1, long var2, Object var4);
    }

    private static class toolbarButtonListener
    extends SWTSkinButtonUtility.ButtonListenerAdapter {
        private toolbarButtonListener() {
        }

        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            boolean rightClick = (stateMask & (0x200000 | SWT.MOD4)) > 0;
            Object o = SelectedContentManager.convertSelectedContentToObject(null);
            item.triggerToolBarItem(rightClick ? 2L : 0L, o);
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            ToolBarItem item = (ToolBarItem)buttonUtility.getSkinObject().getData("toolbaritem");
            buttonUtility.getSkinObject().switchSuffix("", 0, false, true);
            Object o = SelectedContentManager.convertSelectedContentToObject(null);
            boolean triggerToolBarItemHold = item.triggerToolBarItem(1L, o);
            return triggerToolBarItemHold;
        }
    }
}

